/****************************************************************************
**
** Copyright (C) 2014-2020 Jolla Ltd.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
****************************************************************************/

#include "dbustypes_p.h"

namespace QOfonoDbus {
    const QString Service(QLatin1String("org.ofono"));
}

QDBusArgument &operator<<(QDBusArgument &arg, const ObjectPathProperties &props)
{
    arg.beginStructure();
    arg << props.path << props.properties;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, ObjectPathProperties &props)
{
    arg.beginStructure();
    arg >> props.path >> props.properties;
    arg.endStructure();
    return arg;
}

QDBusArgument &operator<<(QDBusArgument &arg, const OfonoPathProps &props)
{
    arg.beginStructure();
    arg << props.path << props.properties;
    arg.endStructure();
    return arg;
}

const QDBusArgument &operator>>(const QDBusArgument &arg, OfonoPathProps &props)
{
    arg.beginStructure();
    arg >> props.path >> props.properties;
    arg.endStructure();
    return arg;
}

void QOfonoDbusTypes::registerObjectPathProperties()
{
    qDBusRegisterMetaType<ObjectPathProperties>();
    qDBusRegisterMetaType<ObjectPathPropertiesList>();
    qRegisterMetaType<ObjectPathProperties>("ObjectPathProperties");
    qRegisterMetaType<ObjectPathPropertiesList>("ObjectPathPropertiesList");

    qDBusRegisterMetaType<OfonoPathProps>();
    qDBusRegisterMetaType<QArrayOfPathProps>();
}
