/* file.hh - files with fd
 * Copyright 2003 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SHEVEK_FILE_HH
#define SHEVEK_FILE_HH

#include "fd.hh"

namespace shevek
{
  /// Use normal files with the fd class.
  class file : public fd
  {
    file (Glib::RefPtr <Glib::MainContext> main);
    virtual ~file ();
  public:
    /// Create a new file object.
    static Glib::RefPtr <file> create (Glib::RefPtr <Glib::MainContext> main
				       = Glib::MainContext::get_default () );
    /// Open a new file in the object.
    void open (std::string name, bool read, bool write);
    /// Close the file.
    void close ();
  };
}

#endif
