//
//  Extension_Banks.cpp
//  
//
//  Created by Pierre Peterlongo on 22/10/2012
//


#ifndef ASSERTS
#define NDEBUG // disable asserts, they're computationnally intensive
#endif

using namespace std;
#include "Extension_Bank.h"


bool operator==(Extension a, Extension b){
  return a.starting_kmer.compare(b.starting_kmer) == 0;
  //  return a.starting_kmer==b.starting_kmer;
}

bool operator!=(Extension a, Extension b){
  return !(a==b);
}

  // returns the id of the position of the kmer in the set of kmers to be extended (maybe it was alread present, maybe its a new one).
//vector<Extension>::iterator Extension_Bank:: maybe_add_a_new_extension(const char * kmer){}
int Extension_Bank:: maybe_add_a_new_extension(const char * kmer, const string direction ){
//    printf("maybe add %s, direction %s\n", kmer, direction.c_str());
  int i;
  for(i=0;i<all_extensions.size();i++){
    if(all_extensions[i].starting_kmer.compare(kmer)==0) return i;
  };
  all_extensions.push_back(*new Extension(kmer, direction.c_str()));
  return i;
}

void Extension_Bank::get_extension_direction(const string direction){
	extension_direction=direction;
}

void Extension_Bank::set_extension_type(const char type){
  extension_type=type;
}

void Extension_Bank:: perform_extensions(const string prefix, int limit){ // TODO: dans main: faire de limit un parametre
  // TODO: mettre un affichage d'avancement.
  //
  for (vector<Extension>::iterator it=all_extensions.begin(); it!= all_extensions.end(); ++it){
    it->perform_extension(prefix, limit, extension_type);
  }
}

