/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File EditorFactory.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef EditorFactory_H
#define EditorFactory_H

#include <string>
using std::string;

#include "mars.h"

class Editor;
class IconClass;

class EditorFactory {
public:

// -- Exceptions
	// None

// -- Contructors

	EditorFactory(const string& name);

// -- Destructor

	virtual ~EditorFactory(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual Editor* make(const IconClass&) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static Editor* find(const IconClass& name);
	static Editor* find(const IconClass& name,const string& type);

protected:

// -- Members

	string name_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	EditorFactory(const EditorFactory&);
	EditorFactory& operator=(const EditorFactory&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const EditorFactory& p)
	//	{ p.print(s); return s; }

};

template<class T>
class EditorMaker : public EditorFactory {
	Editor* make(const IconClass& n) { return new T(n,name_); }
public:
	EditorMaker(const string& name) : EditorFactory(name) {}
};


#endif
