/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FamilyEditor_H
#define FamilyEditor_H

#include "MvQEditor.h"

#include "RequestPanel.h"
#include "MvIconLanguage.h"

class QComboBox;
class QStackedWidget;
class QVBoxLayout;

class IconObject;
class FamilyScanner;
class RequestPanel;
class FamilyEditorObserver;

class FamilyEditor : public MvQEditor
{
    Q_OBJECT
public:
    FamilyEditor(const IconClass&, const string&);
    virtual ~FamilyEditor();

    //Request currentRequest(long custom_expand=0);

    virtual void replace(IconObjectH);
    virtual void merge(IconObjectH);

public slots:
    void slotChangePage(int);
    void slotIconDropped(IconObject*);

protected slots:
    void slotShowDisabled(bool) {}

protected:
    void readSettings(QSettings&) {}
    void writeSettings(QSettings&) {}

private:
    FamilyEditor(const FamilyEditor&);
    FamilyEditor& operator=(const FamilyEditor&);

    void setStartPage();
    void makePages(int, Request& r);
    void keyValues(map<string, string>&);

    virtual void apply();
    virtual void reset();
    virtual void close();
    virtual void edit();

    virtual IconObject* copy(const string&);

    FamilyScanner& scanner_;
    QList<QComboBox*> combos_;
    QGridLayout* comboLayout_;

    QStackedWidget* page_;
    vector<RequestPanel*> panels_;
    vector<IconObjectH> objects_;
};

inline void destroy(FamilyEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FamilyEditor);
//#endif

#endif
