#ifndef stypes_H
#define stypes_H

#include <gdefines.h>

#define EXTCF(rtn, args) \
    extern "C" {         \
    rtn args;            \
    }

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef MAXFLOAT
const float MAXFLOAT = 3.4E37;
#endif

const short PROJNONE           = 0;
const short PROJUTM            = 2;
const short PROJMERCATOR       = 3;
const short PROJGAUSS          = 4;
const short PROJLAMBERTMILLION = 5;
const short PROJLAMBERT        = 6;
const short PROJPOLYCONIC      = 7;
const short PROJCYLINDRICAL    = 0;
const short PROJPOLAR          = 9;
const short PROJBIPOLAR        = 10;
const short PROJALBERS         = 11;
const short PROJMILLER         = 12;
const short PROJSATELLITE      = 90;
const short PROJPOLY           = 254;
const short GENERALPROJ        = 255;

// Classes

class SProjection;
class Box;
class Point;
class GribData;
class GribFile;

#endif
