/*
* This file is part of the MicroPython project, http://micropython.org/
*
* The MIT License (MIT)
*
* Copyright (c) 2015 Damien P. George
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/
#ifndef MICROPY_INCLUDED_WINDOWS_MSVC_DIRENT_H
#define MICROPY_INCLUDED_WINDOWS_MSVC_DIRENT_H

// dirent.h implementation for msvc

// for ino_t
#include <sys/types.h>

#define _DIRENT_HAVE_D_TYPE (1)
#define DTTOIF dttoif

// opaque DIR structure
typedef struct DIR DIR;

// the dirent structure
// d_ino is always 0 - if ever needed use GetFileInformationByHandle
// d_type can be converted using DTTOIF, into 0 (unknown) or MP_S_IFDIR or MP_S_IFREG
typedef struct dirent {
    ino_t d_ino;
    int d_type;
    char *d_name;
} dirent;

DIR *opendir(const char *name);
int closedir(DIR *dir);
struct dirent *readdir(DIR *dir);
int dttoif(int d_type);

#endif // MICROPY_INCLUDED_WINDOWS_MSVC_DIRENT_H
