//
// ccsdt_t2.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/ccsdt_t2.h>
#include <chemistry/qc/ccr12/tensor.h>
using namespace sc;
  
  
CCSDT_T2::CCSDT_T2(CCR12_Info* info):z(info){};
CCSDT_T2::~CCSDT_T2(){};
  
  
  
void CCSDT_T2::compute_amp(Ref<Tensor>& out){ //k_i0_offset,z->f1(),z->in.at(0),z->t1(),z->t2(),z->t3()=>z->v2()
  
in.resize(8);
  
in.at(1)=new Tensor("ccsdt_t2_1_0",z->mem());
offset_smith_0_1();
smith_0_1_0(); //z->f1()=>in.at(1)
in.at(2)=new Tensor("ccsdt_t2_2_0",z->mem());
offset_smith_1_3();
smith_1_3_0(); //z->f1()=>in.at(2)
smith_2_26(); //z->t1(),z->v2()=>in.at(2)
smith_1_3(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_17(); //z->t1(),z->v2()=>in.at(1)
smith_1_34(); //z->t2(),z->v2()=>in.at(1)
smith_0_1(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdt_t2_1_1",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->f1()=>in.at(1)
smith_1_19(); //z->t1(),z->v2()=>in.at(1)
smith_1_32(); //z->t2(),z->v2()=>in.at(1)
smith_0_2(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdt_t2_1_2",z->mem());
offset_smith_0_4();
smith_0_4_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdt_t2_2_0",z->mem());
offset_smith_1_4();
smith_1_4_0(); //z->f1()=>in.at(2)
smith_2_28(); //z->t1(),z->v2()=>in.at(2)
smith_1_4(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdt_t2_2_1",z->mem());
offset_smith_1_9();
smith_1_9_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsdt_t2_3_0",z->mem());
offset_smith_2_15();
smith_2_15_0(); //z->v2()=>in.at(3)
smith_3_25(); //z->t1(),z->v2()=>in.at(3)
smith_2_15(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_30(); //z->t2(),z->v2()=>in.at(2)
smith_1_9(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdt_t2_2_2",z->mem());
offset_smith_1_10();
smith_1_10_0(); //z->v2()=>in.at(2)
smith_2_16(); //z->t1(),z->v2()=>in.at(2)
smith_1_10(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdt_t2_2_3",z->mem());
offset_smith_1_20();
smith_1_20_0(); //z->v2()=>in.at(2)
smith_2_29(); //z->t1(),z->v2()=>in.at(2)
smith_1_20(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_22(); //z->t2(),z->v2()=>in.at(1)
smith_1_35(); //z->t3(),z->v2()=>in.at(1)
smith_0_4(out); //z->t1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdt_t2_1_3",z->mem());
offset_smith_0_5();
smith_0_5_0(); //z->f1()=>in.at(1)
smith_1_37(); //z->t1(),z->v2()=>in.at(1)
smith_0_5(out); //z->t3(),in.at(1)=>out
delete in.at(1);
smith_0_6(out); //z->v2()=>out
in.at(1)=new Tensor("ccsdt_t2_1_4",z->mem());
offset_smith_0_8();
smith_0_8_0(); //z->v2()=>in.at(1)
smith_1_11(); //z->t1(),z->v2()=>in.at(1)
smith_0_8(out); //z->t1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdt_t2_1_5",z->mem());
offset_smith_0_12();
smith_0_12_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdt_t2_2_0",z->mem());
offset_smith_1_18();
smith_1_18_0(); //z->v2()=>in.at(2)
smith_2_27(); //z->t1(),z->v2()=>in.at(2)
smith_1_18(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_33(); //z->t2(),z->v2()=>in.at(1)
smith_0_12(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdt_t2_1_6",z->mem());
offset_smith_0_13();
smith_0_13_0(); //z->v2()=>in.at(1)
smith_1_21(); //z->t1(),z->v2()=>in.at(1)
smith_1_31(); //z->t2(),z->v2()=>in.at(1)
smith_0_13(out); //z->t2(),in.at(1)=>out
delete in.at(1);
smith_0_14(out); //z->t2(),z->v2()=>out
in.at(1)=new Tensor("ccsdt_t2_1_7",z->mem());
offset_smith_0_23();
smith_0_23_0(); //z->v2()=>in.at(1)
smith_1_36(); //z->t1(),z->v2()=>in.at(1)
smith_0_23(out); //z->t3(),in.at(1)=>out
delete in.at(1);
smith_0_24(out); //z->t3(),z->v2()=>out
  
}
  
void CCSDT_T2::smith_0_1(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h5b)) { 
          if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h5b))))==z->irrep_t()) { 
           long p3b_0,p4b_0,h1b_0,h5b_0; 
           z->restricted_4(p3b,p4b,h1b,h5b,p3b_0,p4b_0,h1b_0,h5b_0); 
           long h5b_1,h2b_1; 
           z->restricted_2(h5b,h2b,h5b_1,h2b_1); 
           long dim_common=z->get_range(h5b); 
           long dima0_sort=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           if (h1b<h5b) { 
            z->t2()->get_block(h5b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h1b),z->get_range(h5b),2,1,0,3,+1.0); 
           } 
           else if (h5b<=h1b) { 
            z->t2()->get_block(h1b_0+z->noab()*(h5b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h5b),z->get_range(h1b),3,1,0,2,-1.0); 
           } 
           in[1]->get_block(h2b_1+z->noab()*(h5b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h2b),1,0,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),3,2,1,0,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),3,2,0,1,-1.0); 
         out->add_block(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_12(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         for (long h6b=h5b;h6b<z->noab();++h6b) { 
          if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h5b)+z->get_spin(h6b)) { 
           if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h5b)^z->get_sym(h6b))))==z->irrep_t()) { 
            long p3b_0,p4b_0,h5b_0,h6b_0; 
            z->restricted_4(p3b,p4b,h5b,h6b,p3b_0,p4b_0,h5b_0,h6b_0); 
            long h5b_1,h6b_1,h1b_1,h2b_1; 
            z->restricted_4(h5b,h6b,h1b,h2b,h5b_1,h6b_1,h1b_1,h2b_1); 
            long dim_common=z->get_range(h5b)*z->get_range(h6b); 
            long dima0_sort=z->get_range(p3b)*z->get_range(p4b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h6b_0+z->noab()*(h5b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h5b),z->get_range(h6b),1,0,3,2,+1.0); 
            in[1]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            double factor=1.0; 
            if (h5b==h6b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),3,2,1,0,+0.5/0.5); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_12_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_v()) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h5b_0,h6b_0,h1b_0,h2b_0; 
        z->restricted_4(h5b,h6b,h1b,h2b,h5b_0,h6b_0,h1b_0,h2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h2b_0+(z->nab())*(h1b_0+(z->nab())*(h6b_0+(z->nab())*(h5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_12(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[1]->input_offset(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_13(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (p3b<p4b && h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (p3b<p4b && h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (p4b<=p3b && h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab())))); 
    } 
    else if (p4b<=p3b && h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab())))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
          if (z->get_spin(p3b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h6b)) { 
           if ((z->get_sym(p3b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h6b))))==z->irrep_t()) { 
            long p3b_0,p5b_0,h1b_0,h6b_0; 
            z->restricted_4(p3b,p5b,h1b,h6b,p3b_0,p5b_0,h1b_0,h6b_0); 
            long h6b_1,p4b_1,h2b_1,p5b_1; 
            z->restricted_4(h6b,p4b,h2b,p5b,h6b_1,p4b_1,h2b_1,p5b_1); 
            long dim_common=z->get_range(h6b)*z->get_range(p5b); 
            long dima0_sort=z->get_range(p3b)*z->get_range(h1b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p4b)*z->get_range(h2b); 
            long dima1=dim_common*dima1_sort; 
            if (p3b<p5b && h1b<h6b) { 
             z->t2()->get_block(h6b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(h1b),z->get_range(h6b),2,0,1,3,+1.0); 
            } 
            else if (p3b<p5b && h6b<=h1b) { 
             z->t2()->get_block(h1b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(h6b),z->get_range(h1b),3,0,1,2,-1.0); 
            } 
            else if (p5b<=p3b && h1b<h6b) { 
             z->t2()->get_block(h6b_0+z->noab()*(h1b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(h1b),z->get_range(h6b),2,1,0,3,-1.0); 
            } 
            else if (p5b<=p3b && h6b<=h1b) { 
             z->t2()->get_block(h1b_0+z->noab()*(h6b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(h6b),z->get_range(h1b),3,1,0,2,+1.0); 
            } 
            in[1]->get_block(p5b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(p4b_1-z->noab()+z->nvab()*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p4b),z->get_range(h2b),z->get_range(p5b),2,1,3,0,+1.0); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        if (p4b>=p3b && h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(h1b),z->get_range(p3b),3,1,2,0,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (p4b>=p3b && h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(h1b),z->get_range(p3b),3,1,0,2,-1.0); 
         out->add_block(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (p3b>=p4b && h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(h1b),z->get_range(p3b),1,3,2,0,-1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab()))),k_c); 
        } 
        if (p3b>=p4b && h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(h1b),z->get_range(p3b),1,3,0,2,+1.0); 
         out->add_block(h1b+z->noab()*(h2b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_13_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h6b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h6b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h6b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p5b))))==z->irrep_v()) { 
        long dimc=z->get_range(h6b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h6b_0,p4b_0,h2b_0,p5b_0; 
        z->restricted_4(h6b,p4b,h2b,p5b,h6b_0,p4b_0,h2b_0,p5b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h6b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p5b_0+(z->nab())*(h2b_0+(z->nab())*(p4b_0+(z->nab())*(h6b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(p4b),z->get_range(h2b),z->get_range(p5b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h6b),z->get_range(p4b),z->get_range(h2b),z->get_range(p5b),0,1,2,3,-1.0); 
        in[1]->add_block(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h6b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_13(){ 
 
long size=0L; 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(h6b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
     if ((z->get_sym(h6b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
       in[1]->input_offset(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h6b))),size); 
       size+=z->get_range(h6b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_14(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
            long p5b_0,p6b_0,h1b_0,h2b_0; 
            z->restricted_4(p5b,p6b,h1b,h2b,p5b_0,p6b_0,h1b_0,h2b_0); 
            long p3b_1,p4b_1,p5b_1,p6b_1; 
            z->restricted_4(p3b,p4b,p5b,p6b,p3b_1,p4b_1,p5b_1,p6b_1); 
            long dim_common=z->get_range(p5b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p3b)*z->get_range(p4b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->v2()->get_block(p6b_1+(z->nab())*(p5b_1+(z->nab())*(p4b_1+(z->nab())*(p3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p5b==p6b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(p3b),z->get_range(h2b),z->get_range(h1b),1,0,3,2,+0.5/0.5); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_1_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h2b=0L;h2b<z->noab();++h2b) { 
  long tileoffset; 
  tileoffset=(h2b+z->noab()*(h5b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h2b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^z->get_sym(h2b))==z->irrep_f()) { 
      long dimc=z->get_range(h5b)*z->get_range(h2b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h5b_0,h2b_0; 
      z->restricted_2(h5b,h2b,h5b_0,h2b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h5b)*z->get_range(h2b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(h2b_0+(z->nab())*(h5b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h2b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h5b),z->get_range(h2b),0,1,-1.0); 
      in[1]->add_block(h2b+z->noab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_1(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h2b=0L;h2b<z->noab();++h2b) { 
  if (z->get_spin(h5b)==z->get_spin(h2b)) { 
   if ((z->get_sym(h5b)^z->get_sym(h2b))==(z->irrep_t()^z->irrep_f())) { 
    if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h2b)!=4L) { 
     in[1]->input_offset(h2b+z->noab()*(h5b),size); 
     size+=z->get_range(h5b)*z->get_range(h2b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_2(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (p3b<p4b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (p4b<=p3b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab())))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p3b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
          if ((z->get_sym(p3b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
           long p3b_0,p5b_0,h1b_0,h2b_0; 
           z->restricted_4(p3b,p5b,h1b,h2b,p3b_0,p5b_0,h1b_0,h2b_0); 
           long p4b_1,p5b_1; 
           z->restricted_2(p4b,p5b,p4b_1,p5b_1); 
           long dim_common=z->get_range(p5b); 
           long dima0_sort=z->get_range(p3b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p4b); 
           long dima1=dim_common*dima1_sort; 
           if (p3b<p5b) { 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
           } 
           else if (p5b<=p3b) { 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
           } 
           in[1]->get_block(p5b_1-z->noab()+z->nvab()*(p4b_1-z->noab()),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(p4b),z->get_range(p5b),0,1,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (p4b>=p3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h2b),z->get_range(h1b),z->get_range(p3b),3,0,2,1,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (p3b>=p4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h2b),z->get_range(h1b),z->get_range(p3b),0,3,2,1,-1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_23(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         for (long h7b=h6b;h7b<z->noab();++h7b) { 
          for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
           if (z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h6b)+z->get_spin(h7b)) { 
            if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^(z->get_sym(h6b)^z->get_sym(h7b))))))==z->irrep_t()) { 
             long p3b_0,p4b_0,p5b_0,h1b_0,h6b_0,h7b_0; 
             z->restricted_6(p3b,p4b,p5b,h1b,h6b,h7b,p3b_0,p4b_0,p5b_0,h1b_0,h6b_0,h7b_0); 
             long h6b_1,h7b_1,h2b_1,p5b_1; 
             z->restricted_4(h6b,h7b,h2b,p5b,h6b_1,h7b_1,h2b_1,p5b_1); 
             long dim_common=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
             long dima0_sort=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h2b); 
             long dima1=dim_common*dima1_sort; 
             if (p4b<p5b && h1b<h6b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h6b),z->get_range(h7b),3,1,0,2,5,4,+1.0); 
             } 
             else if (p4b<p5b && h6b<=h1b && h1b<h7b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h1b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h7b),4,1,0,2,5,3,-1.0); 
             } 
             else if (p4b<p5b && h7b<=h1b) { 
              z->t3()->get_block(h1b_0+z->noab()*(h7b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h7b),z->get_range(h1b),5,1,0,2,4,3,+1.0); 
             } 
             else if (p3b<p5b && p5b<=p4b && h1b<h6b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p4b),z->get_range(h1b),z->get_range(h6b),z->get_range(h7b),3,2,0,1,5,4,-1.0); 
             } 
             else if (p3b<p5b && p5b<=p4b && h6b<=h1b && h1b<h7b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h1b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h1b),z->get_range(h7b),4,2,0,1,5,3,+1.0); 
             } 
             else if (p3b<p5b && p5b<=p4b && h7b<=h1b) { 
              z->t3()->get_block(h1b_0+z->noab()*(h7b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h7b),z->get_range(h1b),5,2,0,1,4,3,-1.0); 
             } 
             else if (p5b<=p3b && h1b<h6b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h6b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p4b),z->get_range(h1b),z->get_range(h6b),z->get_range(h7b),3,2,1,0,5,4,+1.0); 
             } 
             else if (p5b<=p3b && h6b<=h1b && h1b<h7b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h1b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p4b),z->get_range(h6b),z->get_range(h1b),z->get_range(h7b),4,2,1,0,5,3,-1.0); 
             } 
             else if (p5b<=p3b && h7b<=h1b) { 
              z->t3()->get_block(h1b_0+z->noab()*(h7b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p4b),z->get_range(h6b),z->get_range(h7b),z->get_range(h1b),5,2,1,0,4,3,+1.0); 
             } 
             in[1]->get_block(p5b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h7b_1+z->noab()*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(h2b),z->get_range(p5b),2,3,1,0,+1.0); 
             double factor=1.0; 
             if (h6b==h7b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
         } 
        } 
        if (h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),3,2,1,0,+0.5/0.5); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),3,2,0,1,-0.5/0.5); 
         out->add_block(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_23_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long h7b=h6b;h7b<z->noab();++h7b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h6b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h2b)^z->get_sym(p5b))))==z->irrep_v()) { 
        long dimc=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p5b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h6b_0,h7b_0,h2b_0,p5b_0; 
        z->restricted_4(h6b,h7b,h2b,p5b,h6b_0,h7b_0,h2b_0,p5b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p5b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p5b_0+(z->nab())*(h2b_0+(z->nab())*(h7b_0+(z->nab())*(h6b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(h2b),z->get_range(p5b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h6b),z->get_range(h7b),z->get_range(h2b),z->get_range(p5b),0,1,2,3,-1.0); 
        in[1]->add_block(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h6b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_23(){ 
 
long size=0L; 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long h7b=h6b;h7b<z->noab();++h7b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
     if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h2b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
       in[1]->input_offset(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h6b))),size); 
       size+=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_24(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (p3b<p4b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (p4b<=p3b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab())))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
          for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
           if (z->get_spin(p3b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h7b)) { 
            if ((z->get_sym(p3b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h7b))))))==z->irrep_t()) { 
             long p3b_0,p5b_0,p6b_0,h1b_0,h2b_0,h7b_0; 
             z->restricted_6(p3b,p5b,p6b,h1b,h2b,h7b,p3b_0,p5b_0,p6b_0,h1b_0,h2b_0,h7b_0); 
             long h7b_1,p4b_1,p5b_1,p6b_1; 
             z->restricted_4(h7b,p4b,p5b,p6b,h7b_1,p4b_1,p5b_1,p6b_1); 
             long dim_common=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b); 
             long dima0_sort=z->get_range(p3b)*z->get_range(h1b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p4b); 
             long dima1=dim_common*dima1_sort; 
             if (p3b<p5b && h2b<h7b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h7b),4,3,0,2,1,5,+1.0); 
             } 
             else if (p3b<p5b && h1b<h7b && h7b<=h2b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h7b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h7b),z->get_range(h2b),5,3,0,2,1,4,-1.0); 
             } 
             else if (p3b<p5b && h7b<=h1b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h1b),z->get_range(h2b),5,4,0,2,1,3,+1.0); 
             } 
             else if (p5b<=p3b && p3b<p6b && h2b<h7b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h7b),4,3,1,2,0,5,-1.0); 
             } 
             else if (p5b<=p3b && p3b<p6b && h1b<h7b && h7b<=h2b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h7b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p6b),z->get_range(h1b),z->get_range(h7b),z->get_range(h2b),5,3,1,2,0,4,+1.0); 
             } 
             else if (p5b<=p3b && p3b<p6b && h7b<=h1b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h1b),z->get_range(h2b),5,4,1,2,0,3,-1.0); 
             } 
             else if (p6b<=p3b && h2b<h7b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p3b),z->get_range(h1b),z->get_range(h2b),z->get_range(h7b),4,3,2,1,0,5,+1.0); 
             } 
             else if (p6b<=p3b && h1b<h7b && h7b<=h2b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h7b_0+z->noab()*(h1b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p3b),z->get_range(h1b),z->get_range(h7b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
             } 
             else if (p6b<=p3b && h7b<=h1b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h7b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p3b),z->get_range(h7b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
             } 
             z->v2()->get_block(p6b_1+(z->nab())*(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),1,3,2,0,+1.0); 
             double factor=1.0; 
             if (p5b==p6b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
         } 
        } 
        if (p4b>=p3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h2b),z->get_range(h1b),z->get_range(p3b),3,0,2,1,-0.5/0.5); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (p3b>=p4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h2b),z->get_range(h1b),z->get_range(p3b),0,3,2,1,+0.5/0.5); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_2_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  long tileoffset; 
  tileoffset=(p5b-z->noab()+z->nvab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(p5b)) { 
     if ((z->get_sym(p4b)^z->get_sym(p5b))==z->irrep_f()) { 
      long dimc=z->get_range(p4b)*z->get_range(p5b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long p4b_0,p5b_0; 
      z->restricted_2(p4b,p5b,p4b_0,p5b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(p4b)*z->get_range(p5b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p5b_0+(z->nab())*(p4b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(p4b),z->get_range(p5b),0,1,+1.0); 
      in[1]->add_block(p5b-z->noab()+z->nvab()*(p4b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_2(){ 
 
long size=0L; 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  if (z->get_spin(p4b)==z->get_spin(p5b)) { 
   if ((z->get_sym(p4b)^z->get_sym(p5b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)!=4L) { 
     in[1]->input_offset(p5b-z->noab()+z->nvab()*(p4b-z->noab()),size); 
     size+=z->get_range(p4b)*z->get_range(p5b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_4(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (p3b<p4b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (p4b<=p3b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab())))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^(z->irrep_t()^z->irrep_f()))) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(p3b)==z->get_spin(h5b)) { 
          if ((z->get_sym(p3b)^z->get_sym(h5b))==z->irrep_t()) { 
           long p3b_0,h5b_0; 
           z->restricted_2(p3b,h5b,p3b_0,h5b_0); 
           long h5b_1,p4b_1,h1b_1,h2b_1; 
           z->restricted_4(h5b,p4b,h1b,h2b,h5b_1,p4b_1,h1b_1,h2b_1); 
           long dim_common=z->get_range(h5b); 
           long dima0_sort=z->get_range(p3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h5b_0+z->noab()*(p3b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(h5b),0,1,+1.0); 
           in[1]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(p4b_1-z->noab()+z->nvab()*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (p4b>=p3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),3,2,1,0,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (p3b>=p4b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),2,3,1,0,-1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p3b-z->noab()+z->nvab()*(p4b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_4_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h5b_0,p4b_0,h1b_0,h2b_0; 
        z->restricted_4(h5b,p4b,h1b,h2b,h5b_0,p4b_0,h1b_0,h2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h2b_0+(z->nab())*(h1b_0+(z->nab())*(p4b_0+(z->nab())*(h5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,-1.0); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_4(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_f())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[1]->input_offset(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_5(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
          if (z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h6b)) { 
           if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h6b))))))==z->irrep_t()) { 
            long p3b_0,p4b_0,p5b_0,h1b_0,h2b_0,h6b_0; 
            z->restricted_6(p3b,p4b,p5b,h1b,h2b,h6b,p3b_0,p4b_0,p5b_0,h1b_0,h2b_0,h6b_0); 
            long h6b_1,p5b_1; 
            z->restricted_2(h6b,p5b,h6b_1,p5b_1); 
            long dim_common=z->get_range(h6b)*z->get_range(p5b); 
            long dima0_sort=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=1L; 
            long dima1=dim_common*dima1_sort; 
            if (p4b<p5b && h2b<h6b) { 
             z->t3()->get_block(h6b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h6b),4,3,1,0,2,5,+1.0); 
            } 
            else if (p4b<p5b && h1b<h6b && h6b<=h2b) { 
             z->t3()->get_block(h2b_0+z->noab()*(h6b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h6b),z->get_range(h2b),5,3,1,0,2,4,-1.0); 
            } 
            else if (p4b<p5b && h6b<=h1b) { 
             z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),5,4,1,0,2,3,+1.0); 
            } 
            else if (p3b<p5b && p5b<=p4b && h2b<h6b) { 
             z->t3()->get_block(h6b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),z->get_range(h6b),4,3,2,0,1,5,-1.0); 
            } 
            else if (p3b<p5b && p5b<=p4b && h1b<h6b && h6b<=h2b) { 
             z->t3()->get_block(h2b_0+z->noab()*(h6b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p4b),z->get_range(h1b),z->get_range(h6b),z->get_range(h2b),5,3,2,0,1,4,+1.0); 
            } 
            else if (p3b<p5b && p5b<=p4b && h6b<=h1b) { 
             z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),5,4,2,0,1,3,-1.0); 
            } 
            else if (p5b<=p3b && h2b<h6b) { 
             z->t3()->get_block(h6b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),z->get_range(h6b),4,3,2,1,0,5,+1.0); 
            } 
            else if (p5b<=p3b && h1b<h6b && h6b<=h2b) { 
             z->t3()->get_block(h2b_0+z->noab()*(h6b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p4b),z->get_range(h1b),z->get_range(h6b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
            } 
            else if (p5b<=p3b && h6b<=h1b) { 
             z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h6b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
             z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p3b),z->get_range(p4b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
            } 
            in[1]->get_block(p5b_1-z->noab()+z->nvab()*(h6b_1),k_a1); 
            z->sort_indices2(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p5b),1,0,+1.0); 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),z->get_range(p3b),3,2,1,0,+1.0); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_5_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  long tileoffset; 
  tileoffset=(p5b-z->noab()+z->nvab()*(h6b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p5b)!=4L) { 
    if (z->get_spin(h6b)==z->get_spin(p5b)) { 
     if ((z->get_sym(h6b)^z->get_sym(p5b))==z->irrep_f()) { 
      long dimc=z->get_range(h6b)*z->get_range(p5b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h6b_0,p5b_0; 
      z->restricted_2(h6b,p5b,h6b_0,p5b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h6b)*z->get_range(p5b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p5b_0+(z->nab())*(h6b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h6b),z->get_range(p5b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h6b),z->get_range(p5b),0,1,+1.0); 
      in[1]->add_block(p5b-z->noab()+z->nvab()*(h6b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_5(){ 
 
long size=0L; 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  if (z->get_spin(h6b)==z->get_spin(p5b)) { 
   if ((z->get_sym(h6b)^z->get_sym(p5b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p5b)!=4L) { 
     in[1]->input_offset(p5b-z->noab()+z->nvab()*(h6b),size); 
     size+=z->get_range(h6b)*z->get_range(p5b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_6(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_v()) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long p3b_0,p4b_0,h1b_0,h2b_0; 
        z->restricted_4(p3b,p4b,h1b,h2b,p3b_0,p4b_0,h1b_0,h2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h2b_0+(z->nab())*(h1b_0+(z->nab())*(p4b_0+(z->nab())*(p3b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(p3b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
        out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_8(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    else if (h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    } 
    if (out->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p5b)==z->get_spin(h1b)) { 
          if ((z->get_sym(p5b)^z->get_sym(h1b))==z->irrep_t()) { 
           long p5b_0,h1b_0; 
           z->restricted_2(p5b,h1b,p5b_0,h1b_0); 
           long p3b_1,p4b_1,h2b_1,p5b_1; 
           z->restricted_4(p3b,p4b,h2b,p5b,p3b_1,p4b_1,h2b_1,p5b_1); 
           long dim_common=z->get_range(p5b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h1b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h1b),1,0,+1.0); 
           in[1]->get_block(p5b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(p4b_1-z->noab()+z->nvab()*(p3b_1-z->noab()))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h2b),z->get_range(p5b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(p3b),z->get_range(h1b),2,1,3,0,+1.0); 
         out->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
        if (h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(p3b),z->get_range(h1b),2,1,0,3,-1.0); 
         out->add_block(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_0_8_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p5b))))==z->irrep_v()) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long p3b_0,p4b_0,h2b_0,p5b_0; 
        z->restricted_4(p3b,p4b,h2b,p5b,p3b_0,p4b_0,h2b_0,p5b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p5b_0+(z->nab())*(h2b_0+(z->nab())*(p4b_0+(z->nab())*(p3b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h2b),z->get_range(p5b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(p3b),z->get_range(p4b),z->get_range(h2b),z->get_range(p5b),0,1,2,3,-1.0); 
        in[1]->add_block(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_0_8(){ 
 
long size=0L; 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
     if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
       in[1]->input_offset(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),size); 
       size+=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_10(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    } 
    else if (h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h1b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h1b))==z->irrep_t()) { 
           long p6b_0,h1b_0; 
           z->restricted_2(p6b,h1b,p6b_0,h1b_0); 
           long h5b_1,p4b_1,h2b_1,p6b_1; 
           z->restricted_4(h5b,p4b,h2b,p6b,h5b_1,p4b_1,h2b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h1b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h1b),1,0,+1.0); 
           in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(p4b_1-z->noab()+z->nvab()*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p4b),z->get_range(h2b),z->get_range(p6b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(h5b),z->get_range(h1b),2,1,3,0,+1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
        } 
        if (h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(p4b),z->get_range(h5b),z->get_range(h1b),2,1,0,3,-1.0); 
         in[1]->add_block(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_10_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p6b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h5b_0,p4b_0,h2b_0,p6b_0; 
        z->restricted_4(h5b,p4b,h2b,p6b,h5b_0,p4b_0,h2b_0,p6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p6b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p6b_0+(z->nab())*(h2b_0+(z->nab())*(p4b_0+(z->nab())*(h5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p4b),z->get_range(h2b),z->get_range(p6b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(p4b),z->get_range(h2b),z->get_range(p6b),0,1,2,3,+1.0); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_1_10(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_11(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
 for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p3b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
       if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p3b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p6b_0,h2b_0; 
           z->restricted_2(p6b,h2b,p6b_0,h2b_0); 
           long p3b_1,p4b_1,p5b_1,p6b_1; 
           z->restricted_4(p3b,p4b,p5b,p6b,p3b_1,p4b_1,p5b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p3b)*z->get_range(p4b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h2b),1,0,+1.0); 
           if (p5b<p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p5b_1+(z->nab())*(p4b_1+(z->nab())*(p3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),2,1,0,3,+1.0); 
           } 
           else if (p6b<=p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p6b_1+(z->nab())*(p4b_1+(z->nab())*(p3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(p6b),z->get_range(p5b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(p4b),z->get_range(p3b),z->get_range(h2b),2,1,3,0,+0.5); 
        in[1]->add_block(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(p3b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_17(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h2b=0L;h2b<z->noab();++h2b) { 
  long tileoffset; 
  tileoffset=(h2b+z->noab()*(h5b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h2b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^z->get_sym(h2b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h5b)*z->get_range(h2b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        if (z->get_spin(p6b)==z->get_spin(h7b)) { 
         if ((z->get_sym(p6b)^z->get_sym(h7b))==z->irrep_t()) { 
          long p6b_0,h7b_0; 
          z->restricted_2(p6b,h7b,p6b_0,h7b_0); 
          long h5b_1,h7b_1,h2b_1,p6b_1; 
          z->restricted_4(h5b,h7b,h2b,p6b,h5b_1,h7b_1,h2b_1,p6b_1); 
          long dim_common=z->get_range(h7b)*z->get_range(p6b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h5b)*z->get_range(h2b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h7b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h7b),0,1,+1.0); 
          if (h5b<h7b) { 
           z->v2()->get_block(p6b_1+(z->nab())*(h2b_1+(z->nab())*(h7b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),2,0,3,1,+1.0); 
          } 
          else if (h7b<=h5b) { 
           z->v2()->get_block(p6b_1+(z->nab())*(h2b_1+(z->nab())*(h5b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h5b),z->get_range(h2b),z->get_range(p6b),2,1,3,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h2b),z->get_range(h5b),1,0,-1.0); 
      in[1]->add_block(h2b+z->noab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_18(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b)))); 
    } 
    else if (h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(h6b+z->noab()*(h5b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h1b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h1b))==z->irrep_t()) { 
           long p7b_0,h1b_0; 
           z->restricted_2(p7b,h1b,p7b_0,h1b_0); 
           long h5b_1,h6b_1,h2b_1,p7b_1; 
           z->restricted_4(h5b,h6b,h2b,p7b,h5b_1,h6b_1,h2b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h1b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h1b),1,0,+1.0); 
           in[2]->get_block(p7b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h2b),z->get_range(p7b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h6b),z->get_range(h5b),z->get_range(h1b),2,1,3,0,+1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
        } 
        if (h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h6b),z->get_range(h5b),z->get_range(h1b),2,1,0,3,-1.0); 
         in[1]->add_block(h1b+z->noab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_18_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h2b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h2b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h2b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h5b_0,h6b_0,h2b_0,p7b_0; 
        z->restricted_4(h5b,h6b,h2b,p7b,h5b_0,h6b_0,h2b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p7b_0+(z->nab())*(h2b_0+(z->nab())*(h6b_0+(z->nab())*(h5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h2b),z->get_range(p7b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(h6b),z->get_range(h2b),z->get_range(p7b),0,1,2,3,-1.0); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_1_18(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h2b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h2b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h2b)+z->get_spin(p7b)!=8L) { 
       in[2]->input_offset(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_19(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  long tileoffset; 
  tileoffset=(p5b-z->noab()+z->nvab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(p5b)) { 
     if ((z->get_sym(p4b)^z->get_sym(p5b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p4b)*z->get_range(p5b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        if (z->get_spin(p6b)==z->get_spin(h7b)) { 
         if ((z->get_sym(p6b)^z->get_sym(h7b))==z->irrep_t()) { 
          long p6b_0,h7b_0; 
          z->restricted_2(p6b,h7b,p6b_0,h7b_0); 
          long h7b_1,p4b_1,p5b_1,p6b_1; 
          z->restricted_4(h7b,p4b,p5b,p6b,h7b_1,p4b_1,p5b_1,p6b_1); 
          long dim_common=z->get_range(h7b)*z->get_range(p6b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p4b)*z->get_range(p5b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h7b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h7b),0,1,+1.0); 
          if (p5b<p6b) { 
           z->v2()->get_block(p6b_1+(z->nab())*(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),2,1,3,0,+1.0); 
          } 
          else if (p6b<=p5b) { 
           z->v2()->get_block(p5b_1+(z->nab())*(p6b_1+(z->nab())*(p4b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p4b),z->get_range(p6b),z->get_range(p5b),3,1,2,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p5b),z->get_range(p4b),1,0,-1.0); 
      in[1]->add_block(p5b-z->noab()+z->nvab()*(p4b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_20(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    } 
    else if (h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h7b=0L;h7b<z->noab();++h7b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          if (z->get_spin(p4b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h7b)) { 
           if ((z->get_sym(p4b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h7b))))==z->irrep_t()) { 
            long p4b_0,p6b_0,h1b_0,h7b_0; 
            z->restricted_4(p4b,p6b,h1b,h7b,p4b_0,p6b_0,h1b_0,h7b_0); 
            long h5b_1,h7b_1,h2b_1,p6b_1; 
            z->restricted_4(h5b,h7b,h2b,p6b,h5b_1,h7b_1,h2b_1,p6b_1); 
            long dim_common=z->get_range(h7b)*z->get_range(p6b); 
            long dima0_sort=z->get_range(p4b)*z->get_range(h1b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h5b)*z->get_range(h2b); 
            long dima1=dim_common*dima1_sort; 
            if (p4b<p6b && h1b<h7b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p6b),z->get_range(h1b),z->get_range(h7b),2,0,1,3,+1.0); 
            } 
            else if (p4b<p6b && h7b<=h1b) { 
             z->t2()->get_block(h1b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p6b),z->get_range(h7b),z->get_range(h1b),3,0,1,2,-1.0); 
            } 
            else if (p6b<=p4b && h1b<h7b) { 
             z->t2()->get_block(h7b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p4b),z->get_range(h1b),z->get_range(h7b),2,1,0,3,-1.0); 
            } 
            else if (p6b<=p4b && h7b<=h1b) { 
             z->t2()->get_block(h1b_0+z->noab()*(h7b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p4b),z->get_range(h7b),z->get_range(h1b),3,1,0,2,+1.0); 
            } 
            if (h5b<h7b) { 
             in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h7b_1+z->noab()*(h5b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),2,0,3,1,+1.0); 
            } 
            else if (h7b<=h5b) { 
             in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h5b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h5b),z->get_range(h2b),z->get_range(p6b),2,1,3,0,-1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        if (h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h5b),z->get_range(h1b),z->get_range(p4b),1,3,2,0,+1.0); 
         in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
        } 
        if (h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h5b),z->get_range(h1b),z->get_range(p4b),1,3,0,2,-1.0); 
         in[1]->add_block(h1b+z->noab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_20_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h7b=h5b;h7b<z->noab();++h7b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h7b)+z->get_spin(h2b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h7b)==z->get_spin(h2b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h7b)^(z->get_sym(h2b)^z->get_sym(p6b))))==z->irrep_v()) { 
        long dimc=z->get_range(h5b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p6b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h5b_0,h7b_0,h2b_0,p6b_0; 
        z->restricted_4(h5b,h7b,h2b,p6b,h5b_0,h7b_0,h2b_0,p6b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p6b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p6b_0+(z->nab())*(h2b_0+(z->nab())*(h7b_0+(z->nab())*(h5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),0,1,2,3,+1.0); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_1_20(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h7b=h5b;h7b<z->noab();++h7b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    if (z->get_spin(h5b)+z->get_spin(h7b)==z->get_spin(h2b)+z->get_spin(p6b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(h7b)^(z->get_sym(h2b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h7b)+z->get_spin(h2b)+z->get_spin(p6b)!=8L) { 
       in[2]->input_offset(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p6b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_21(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h6b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h6b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h6b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h6b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p7b_0,h2b_0; 
           z->restricted_2(p7b,h2b,p7b_0,h2b_0); 
           long h6b_1,p4b_1,p5b_1,p7b_1; 
           z->restricted_4(h6b,p4b,p5b,p7b,h6b_1,p4b_1,p5b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h6b)*z->get_range(p4b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h2b),1,0,+1.0); 
           if (p5b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),2,1,0,3,+1.0); 
           } 
           else if (p7b<=p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p7b_1+(z->nab())*(p4b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(p4b),z->get_range(h6b),z->get_range(h2b),2,1,3,0,+1.0); 
        in[1]->add_block(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h6b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_22(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
          if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
            long p6b_0,p7b_0,h1b_0,h2b_0; 
            z->restricted_4(p6b,p7b,h1b,h2b,p6b_0,p7b_0,h1b_0,h2b_0); 
            long h5b_1,p4b_1,p6b_1,p7b_1; 
            z->restricted_4(h5b,p4b,p6b,p7b,h5b_1,p4b_1,p6b_1,p7b_1); 
            long dim_common=z->get_range(p6b)*z->get_range(p7b); 
            long dima0_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h5b)*z->get_range(p4b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(p4b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p4b),z->get_range(p6b),z->get_range(p7b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p6b==p7b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p4b),z->get_range(h5b),z->get_range(h2b),z->get_range(h1b),1,0,3,2,-0.5/0.5); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_3(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h2b=0L;h2b<z->noab();++h2b) { 
  long tileoffset; 
  tileoffset=(h2b+z->noab()*(h5b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h2b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^z->get_sym(h2b))==(z->irrep_t()^z->irrep_f())) { 
      long dimc=z->get_range(h5b)*z->get_range(h2b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
       if (z->get_spin(p6b)==z->get_spin(h2b)) { 
        if ((z->get_sym(p6b)^z->get_sym(h2b))==z->irrep_t()) { 
         long p6b_0,h2b_0; 
         z->restricted_2(p6b,h2b,p6b_0,h2b_0); 
         long h5b_1,p6b_1; 
         z->restricted_2(h5b,p6b,h5b_1,p6b_1); 
         long dim_common=z->get_range(p6b); 
         long dima0_sort=z->get_range(h2b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h5b); 
         long dima1=dim_common*dima1_sort; 
         z->t1()->get_block(h2b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
         z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h2b),1,0,+1.0); 
         in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h5b_1),k_a1); 
         z->sort_indices2(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p6b),0,1,+1.0); 
         double factor=1.0; 
         z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h5b),z->get_range(h2b),0,1,+1.0); 
      in[1]->add_block(h2b+z->noab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_31(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h6b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h6b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h6b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h6b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p5b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
          if (z->get_spin(p4b)+z->get_spin(p7b)==z->get_spin(h2b)+z->get_spin(h8b)) { 
           if ((z->get_sym(p4b)^(z->get_sym(p7b)^(z->get_sym(h2b)^z->get_sym(h8b))))==z->irrep_t()) { 
            long p4b_0,p7b_0,h2b_0,h8b_0; 
            z->restricted_4(p4b,p7b,h2b,h8b,p4b_0,p7b_0,h2b_0,h8b_0); 
            long h6b_1,h8b_1,p5b_1,p7b_1; 
            z->restricted_4(h6b,h8b,p5b,p7b,h6b_1,h8b_1,p5b_1,p7b_1); 
            long dim_common=z->get_range(h8b)*z->get_range(p7b); 
            long dima0_sort=z->get_range(p4b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h6b)*z->get_range(p5b); 
            long dima1=dim_common*dima1_sort; 
            if (p4b<p7b && h2b<h8b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(h2b),z->get_range(h8b),2,0,1,3,+1.0); 
            } 
            else if (p4b<p7b && h8b<=h2b) { 
             z->t2()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(h8b),z->get_range(h2b),3,0,1,2,-1.0); 
            } 
            else if (p7b<=p4b && h2b<h8b) { 
             z->t2()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(h2b),z->get_range(h8b),2,1,0,3,-1.0); 
            } 
            else if (p7b<=p4b && h8b<=h2b) { 
             z->t2()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(h8b),z->get_range(h2b),3,1,0,2,+1.0); 
            } 
            if (h6b<h8b && p5b<p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p5b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p5b),z->get_range(p7b),2,0,3,1,+1.0); 
            } 
            else if (h6b<h8b && p7b<=p5b) { 
             z->v2()->get_block(p5b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p7b),z->get_range(p5b),3,0,2,1,-1.0); 
            } 
            else if (h8b<=h6b && p5b<p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p5b),z->get_range(p7b),2,1,3,0,-1.0); 
            } 
            else if (h8b<=h6b && p7b<=p5b) { 
             z->v2()->get_block(p5b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p7b),z->get_range(p5b),3,1,2,0,+1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h6b),z->get_range(h2b),z->get_range(p4b),1,3,2,0,+0.5); 
        in[1]->add_block(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h6b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_32(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  long tileoffset; 
  tileoffset=(p5b-z->noab()+z->nvab()*(p4b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)!=4L) { 
    if (z->get_spin(p4b)==z->get_spin(p5b)) { 
     if ((z->get_sym(p4b)^z->get_sym(p5b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p4b)*z->get_range(p5b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h7b=0L;h7b<z->noab();++h7b) { 
       for (long h8b=h7b;h8b<z->noab();++h8b) { 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p4b)+z->get_spin(p6b)==z->get_spin(h7b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p4b)^(z->get_sym(p6b)^(z->get_sym(h7b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p4b_0,p6b_0,h7b_0,h8b_0; 
           z->restricted_4(p4b,p6b,h7b,h8b,p4b_0,p6b_0,h7b_0,h8b_0); 
           long h7b_1,h8b_1,p5b_1,p6b_1; 
           z->restricted_4(h7b,h8b,p5b,p6b,h7b_1,h8b_1,p5b_1,p6b_1); 
           long dim_common=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b); 
           long dima0_sort=z->get_range(p4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           if (p4b<p6b) { 
            z->t2()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p6b),z->get_range(h7b),z->get_range(h8b),0,1,3,2,+1.0); 
           } 
           else if (p6b<=p4b) { 
            z->t2()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p4b),z->get_range(h7b),z->get_range(h8b),1,0,3,2,-1.0); 
           } 
           if (p5b<p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p5b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p5b),z->get_range(p6b),2,3,1,0,+1.0); 
           } 
           else if (p6b<=p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p6b),z->get_range(p5b),3,2,1,0,-1.0); 
           } 
           double factor=1.0; 
           if (h7b==h8b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p5b),z->get_range(p4b),1,0,-0.5/0.5); 
      in[1]->add_block(p5b-z->noab()+z->nvab()*(p4b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_33(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h1b_0,h2b_0; 
            z->restricted_4(p7b,p8b,h1b,h2b,p7b_0,p8b_0,h1b_0,h2b_0); 
            long h5b_1,h6b_1,p7b_1,p8b_1; 
            z->restricted_4(h5b,h6b,p7b,p8b,h5b_1,h6b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(p7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h5b)*z->get_range(h6b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p7b==p8b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h5b),z->get_range(h2b),z->get_range(h1b),1,0,3,2,+0.5/0.5); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_34(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h2b=0L;h2b<z->noab();++h2b) { 
  long tileoffset; 
  tileoffset=(h2b+z->noab()*(h5b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h2b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^z->get_sym(h2b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h5b)*z->get_range(h2b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
        for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h2b)+z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h2b)^z->get_sym(h8b))))==z->irrep_t()) { 
           long p6b_0,p7b_0,h2b_0,h8b_0; 
           z->restricted_4(p6b,p7b,h2b,h8b,p6b_0,p7b_0,h2b_0,h8b_0); 
           long h5b_1,h8b_1,p6b_1,p7b_1; 
           z->restricted_4(h5b,h8b,p6b,p7b,h5b_1,h8b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b); 
           long dima1=dim_common*dima1_sort; 
           if (h2b<h8b) { 
            z->t2()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h2b),z->get_range(h8b),2,1,0,3,+1.0); 
           } 
           else if (h8b<=h2b) { 
            z->t2()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h2b),3,1,0,2,-1.0); 
           } 
           if (h5b<h8b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),0,3,2,1,+1.0); 
           } 
           else if (h8b<=h5b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h5b),z->get_range(p6b),z->get_range(p7b),1,3,2,0,-1.0); 
           } 
           double factor=1.0; 
           if (p6b==p7b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h5b),z->get_range(h2b),0,1,-0.5/0.5); 
      in[1]->add_block(h2b+z->noab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_35(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
          for (long p7b=p6b;p7b<z->noab()+z->nvab();++p7b) { 
           if (z->get_spin(p4b)+z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h8b)) { 
            if ((z->get_sym(p4b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h8b))))))==z->irrep_t()) { 
             long p4b_0,p6b_0,p7b_0,h1b_0,h2b_0,h8b_0; 
             z->restricted_6(p4b,p6b,p7b,h1b,h2b,h8b,p4b_0,p6b_0,p7b_0,h1b_0,h2b_0,h8b_0); 
             long h5b_1,h8b_1,p6b_1,p7b_1; 
             z->restricted_4(h5b,h8b,p6b,p7b,h5b_1,h8b_1,p6b_1,p7b_1); 
             long dim_common=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
             long dima0_sort=z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h5b); 
             long dima1=dim_common*dima1_sort; 
             if (p4b<p6b && h2b<h8b) { 
              z->t3()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),4,3,0,2,1,5,+1.0); 
             } 
             else if (p4b<p6b && h1b<h8b && h8b<=h2b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),5,3,0,2,1,4,-1.0); 
             } 
             else if (p4b<p6b && h8b<=h1b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),5,4,0,2,1,3,+1.0); 
             } 
             else if (p6b<=p4b && p4b<p7b && h2b<h8b) { 
              z->t3()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p4b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),4,3,1,2,0,5,-1.0); 
             } 
             else if (p6b<=p4b && p4b<p7b && h1b<h8b && h8b<=h2b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p4b),z->get_range(p7b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),5,3,1,2,0,4,+1.0); 
             } 
             else if (p6b<=p4b && p4b<p7b && h8b<=h1b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p4b),z->get_range(p7b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),5,4,1,2,0,3,-1.0); 
             } 
             else if (p7b<=p4b && h2b<h8b) { 
              z->t3()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),4,3,2,1,0,5,+1.0); 
             } 
             else if (p7b<=p4b && h1b<h8b && h8b<=h2b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p4b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
             } 
             else if (p7b<=p4b && h8b<=h1b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),z->get_range(p4b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
             } 
             if (h5b<h8b) { 
              z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h5b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),0,3,2,1,+1.0); 
             } 
             else if (h8b<=h5b) { 
              z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h5b),z->get_range(p6b),z->get_range(p7b),1,3,2,0,-1.0); 
             } 
             double factor=1.0; 
             if (p6b==p7b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),0,3,2,1,+0.5/0.5); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_36(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long h7b=h6b;h7b<z->noab();++h7b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
    long tileoffset; 
    tileoffset=(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h6b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h6b)+z->get_spin(h7b)+z->get_spin(h2b)+z->get_spin(p5b)!=8L) { 
      if (z->get_spin(h6b)+z->get_spin(h7b)==z->get_spin(h2b)+z->get_spin(p5b)) { 
       if ((z->get_sym(h6b)^(z->get_sym(h7b)^(z->get_sym(h2b)^z->get_sym(p5b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h6b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p5b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p8b_0,h2b_0; 
           z->restricted_2(p8b,h2b,p8b_0,h2b_0); 
           long h6b_1,h7b_1,p5b_1,p8b_1; 
           z->restricted_4(h6b,h7b,p5b,p8b,h6b_1,h7b_1,p5b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h6b)*z->get_range(h7b)*z->get_range(p5b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h2b),1,0,+1.0); 
           if (p5b<p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p5b_1+(z->nab())*(h7b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p5b),z->get_range(p8b),2,1,0,3,+1.0); 
           } 
           else if (p8b<=p5b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h7b),z->get_range(p8b),z->get_range(p5b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p5b),z->get_range(h7b),z->get_range(h6b),z->get_range(h2b),2,1,3,0,+1.0); 
        in[1]->add_block(p5b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h6b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_37(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h6b=0L;h6b<z->noab();++h6b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  long tileoffset; 
  tileoffset=(p5b-z->noab()+z->nvab()*(h6b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h6b)+z->get_spin(p5b)!=4L) { 
    if (z->get_spin(h6b)==z->get_spin(p5b)) { 
     if ((z->get_sym(h6b)^z->get_sym(p5b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h6b)*z->get_range(p5b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h6b_1,h8b_1,p5b_1,p7b_1; 
          z->restricted_4(h6b,h8b,p5b,p7b,h6b_1,h8b_1,p5b_1,p7b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h6b)*z->get_range(p5b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
          if (h6b<h8b && p5b<p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p5b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p5b),z->get_range(p7b),2,0,3,1,+1.0); 
          } 
          else if (h6b<h8b && p7b<=p5b) { 
           z->v2()->get_block(p5b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h6b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h8b),z->get_range(p7b),z->get_range(p5b),3,0,2,1,-1.0); 
          } 
          else if (h8b<=h6b && p5b<p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p5b),z->get_range(p7b),2,1,3,0,-1.0); 
          } 
          else if (h8b<=h6b && p7b<=p5b) { 
           z->v2()->get_block(p5b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h6b),z->get_range(p7b),z->get_range(p5b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p5b),z->get_range(h6b),1,0,+1.0); 
      in[1]->add_block(p5b-z->noab()+z->nvab()*(h6b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_3_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  long tileoffset; 
  tileoffset=(p6b-z->noab()+z->nvab()*(h5b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p6b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(p6b)) { 
     if ((z->get_sym(h5b)^z->get_sym(p6b))==z->irrep_f()) { 
      long dimc=z->get_range(h5b)*z->get_range(p6b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h5b_0,p6b_0; 
      z->restricted_2(h5b,p6b,h5b_0,p6b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h5b)*z->get_range(p6b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p6b_0+(z->nab())*(h5b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p6b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h5b),z->get_range(p6b),0,1,-1.0); 
      in[2]->add_block(p6b-z->noab()+z->nvab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_1_3(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  if (z->get_spin(h5b)==z->get_spin(p6b)) { 
   if ((z->get_sym(h5b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p6b)!=4L) { 
     in[2]->input_offset(p6b-z->noab()+z->nvab()*(h5b),size); 
     size+=z->get_range(h5b)*z->get_range(p6b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_4(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p4b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
          if ((z->get_sym(p4b)^(z->get_sym(p6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
           long p4b_0,p6b_0,h1b_0,h2b_0; 
           z->restricted_4(p4b,p6b,h1b,h2b,p4b_0,p6b_0,h1b_0,h2b_0); 
           long h5b_1,p6b_1; 
           z->restricted_2(h5b,p6b,h5b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b); 
           long dima1=dim_common*dima1_sort; 
           if (p4b<p6b) { 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
           } 
           else if (p6b<=p4b) { 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
           } 
           in[2]->get_block(p6b_1-z->noab()+z->nvab()*(h5b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p6b),0,1,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),0,3,2,1,+1.0); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_4_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  long tileoffset; 
  tileoffset=(p6b-z->noab()+z->nvab()*(h5b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p6b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(p6b)) { 
     if ((z->get_sym(h5b)^z->get_sym(p6b))==z->irrep_f()) { 
      long dimc=z->get_range(h5b)*z->get_range(p6b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h5b_0,p6b_0; 
      z->restricted_2(h5b,p6b,h5b_0,p6b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h5b)*z->get_range(p6b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p6b_0+(z->nab())*(h5b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(p6b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h5b),z->get_range(p6b),0,1,+1.0); 
      in[2]->add_block(p6b-z->noab()+z->nvab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_1_4(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  if (z->get_spin(h5b)==z->get_spin(p6b)) { 
   if ((z->get_sym(h5b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p6b)!=4L) { 
     in[2]->input_offset(p6b-z->noab()+z->nvab()*(h5b),size); 
     size+=z->get_range(h5b)*z->get_range(p6b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_9(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(p4b)==z->get_spin(h6b)) { 
          if ((z->get_sym(p4b)^z->get_sym(h6b))==z->irrep_t()) { 
           long p4b_0,h6b_0; 
           z->restricted_2(p4b,h6b,p4b_0,h6b_0); 
           long h5b_1,h6b_1,h1b_1,h2b_1; 
           z->restricted_4(h5b,h6b,h1b,h2b,h5b_1,h6b_1,h1b_1,h2b_1); 
           long dim_common=z->get_range(h6b); 
           long dima0_sort=z->get_range(p4b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h1b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h6b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h6b),0,1,+1.0); 
           if (h5b<h6b) { 
            in[2]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
           } 
           else if (h6b<=h5b) { 
            in[2]->get_block(h2b_1+z->noab()*(h1b_1+z->noab()*(h5b_1+z->noab()*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h5b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h1b),z->get_range(h5b),z->get_range(p4b),2,3,1,0,+0.5); 
        in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_1_9_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_v()) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h5b_0,h6b_0,h1b_0,h2b_0; 
        z->restricted_4(h5b,h6b,h1b,h2b,h5b_0,h6b_0,h1b_0,h2b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h2b_0+(z->nab())*(h1b_0+(z->nab())*(h6b_0+(z->nab())*(h5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),z->get_range(h2b),0,1,2,3,+1.0); 
        in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_1_9(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
       in[2]->input_offset(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_15(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=0L;h2b<z->noab();++h2b) { 
    long tileoffset; 
    if (h1b<h2b) { 
     tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b)))); 
    } 
    else if (h2b<=h1b) { 
     tileoffset=(h1b+z->noab()*(h2b+z->noab()*(h6b+z->noab()*(h5b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h1b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h1b))==z->irrep_t()) { 
           long p7b_0,h1b_0; 
           z->restricted_2(p7b,h1b,p7b_0,h1b_0); 
           long h5b_1,h6b_1,h2b_1,p7b_1; 
           z->restricted_4(h5b,h6b,h2b,p7b,h5b_1,h6b_1,h2b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h1b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h1b),1,0,+1.0); 
           in[3]->get_block(p7b_1-z->noab()+z->nvab()*(h2b_1+z->noab()*(h6b_1+z->noab()*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h2b),z->get_range(p7b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h2b>=h1b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h6b),z->get_range(h5b),z->get_range(h1b),2,1,3,0,+1.0); 
         in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
        } 
        if (h1b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h2b),z->get_range(h6b),z->get_range(h5b),z->get_range(h1b),2,1,0,3,-1.0); 
         in[2]->add_block(h1b+z->noab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_15_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h2b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h2b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h2b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h5b_0,h6b_0,h2b_0,p7b_0; 
        z->restricted_4(h5b,h6b,h2b,p7b,h5b_0,h6b_0,h2b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p7b_0+(z->nab())*(h2b_0+(z->nab())*(h6b_0+(z->nab())*(h5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(h2b),z->get_range(p7b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h5b),z->get_range(h6b),z->get_range(h2b),z->get_range(p7b),0,1,2,3,-1.0); 
        in[3]->add_block(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::offset_smith_2_15(){ 
 
long size=0L; 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h2b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h2b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h2b)+z->get_spin(p7b)!=8L) { 
       in[3]->input_offset(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),size); 
       size+=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_16(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p4b)+z->get_spin(h2b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(p4b)==z->get_spin(h2b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(p4b)^(z->get_sym(h2b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(p4b)*z->get_range(h2b)*z->get_range(p6b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         if (z->get_spin(p7b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p7b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p7b_0,h2b_0; 
           z->restricted_2(p7b,h2b,p7b_0,h2b_0); 
           long h5b_1,p4b_1,p6b_1,p7b_1; 
           z->restricted_4(h5b,p4b,p6b,p7b,h5b_1,p4b_1,p6b_1,p7b_1); 
           long dim_common=z->get_range(p7b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(p4b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h2b),1,0,+1.0); 
           if (p6b<p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(p4b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p4b),z->get_range(p6b),z->get_range(p7b),2,1,0,3,+1.0); 
           } 
           else if (p7b<=p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(p4b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p4b),z->get_range(p7b),z->get_range(p6b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(p4b),z->get_range(h5b),z->get_range(h2b),2,1,3,0,-0.5); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(p4b-z->noab()+z->nvab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_26(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  long tileoffset; 
  tileoffset=(p6b-z->noab()+z->nvab()*(h5b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p6b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(p6b)) { 
     if ((z->get_sym(h5b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h5b)*z->get_range(p6b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h5b_1,h8b_1,p6b_1,p7b_1; 
          z->restricted_4(h5b,h8b,p6b,p7b,h5b_1,h8b_1,p6b_1,p7b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h5b)*z->get_range(p6b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
          if (h5b<h8b && p6b<p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),2,0,3,1,+1.0); 
          } 
          else if (h5b<h8b && p7b<=p6b) { 
           z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h8b),z->get_range(p7b),z->get_range(p6b),3,0,2,1,-1.0); 
          } 
          else if (h8b<=h5b && p6b<p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h5b),z->get_range(p6b),z->get_range(p7b),2,1,3,0,-1.0); 
          } 
          else if (h8b<=h5b && p7b<=p6b) { 
           z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h5b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h5b),z->get_range(p7b),z->get_range(p6b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p6b),z->get_range(h5b),1,0,-1.0); 
      in[2]->add_block(p6b-z->noab()+z->nvab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_27(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h2b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h2b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h2b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p8b_0,h2b_0; 
           z->restricted_2(p8b,h2b,p8b_0,h2b_0); 
           long h5b_1,h6b_1,p7b_1,p8b_1; 
           z->restricted_4(h5b,h6b,p7b,p8b,h5b_1,h6b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h2b),1,0,+1.0); 
           if (p7b<p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
           } 
           else if (p8b<=p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h6b),z->get_range(h5b),z->get_range(h2b),2,1,3,0,+0.5); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_28(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  long tileoffset; 
  tileoffset=(p6b-z->noab()+z->nvab()*(h5b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h5b)+z->get_spin(p6b)!=4L) { 
    if (z->get_spin(h5b)==z->get_spin(p6b)) { 
     if ((z->get_sym(h5b)^z->get_sym(p6b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h5b)*z->get_range(p6b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h8b=0L;h8b<z->noab();++h8b) { 
       for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
        if (z->get_spin(p7b)==z->get_spin(h8b)) { 
         if ((z->get_sym(p7b)^z->get_sym(h8b))==z->irrep_t()) { 
          long p7b_0,h8b_0; 
          z->restricted_2(p7b,h8b,p7b_0,h8b_0); 
          long h5b_1,h8b_1,p6b_1,p7b_1; 
          z->restricted_4(h5b,h8b,p6b,p7b,h5b_1,h8b_1,p6b_1,p7b_1); 
          long dim_common=z->get_range(h8b)*z->get_range(p7b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h5b)*z->get_range(p6b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h8b_0+z->noab()*(p7b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(h8b),0,1,+1.0); 
          if (h5b<h8b && p6b<p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),2,0,3,1,+1.0); 
          } 
          else if (h5b<h8b && p7b<=p6b) { 
           z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h8b),z->get_range(p7b),z->get_range(p6b),3,0,2,1,-1.0); 
          } 
          else if (h8b<=h5b && p6b<p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h5b),z->get_range(p6b),z->get_range(p7b),2,1,3,0,-1.0); 
          } 
          else if (h8b<=h5b && p7b<=p6b) { 
           z->v2()->get_block(p6b_1+(z->nab())*(p7b_1+(z->nab())*(h5b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h5b),z->get_range(p7b),z->get_range(p6b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p6b),z->get_range(h5b),1,0,+1.0); 
      in[2]->add_block(p6b-z->noab()+z->nvab()*(h5b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_29(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h7b=h5b;h7b<z->noab();++h7b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
    long tileoffset; 
    tileoffset=(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h7b)+z->get_spin(h2b)+z->get_spin(p6b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h7b)==z->get_spin(h2b)+z->get_spin(p6b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h7b)^(z->get_sym(h2b)^z->get_sym(p6b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h7b)*z->get_range(h2b)*z->get_range(p6b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p8b_0,h2b_0; 
           z->restricted_2(p8b,h2b,p8b_0,h2b_0); 
           long h5b_1,h7b_1,p6b_1,p8b_1; 
           z->restricted_4(h5b,h7b,p6b,p8b,h5b_1,h7b_1,p6b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h7b)*z->get_range(p6b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h2b),1,0,+1.0); 
           if (p6b<p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),2,1,0,3,+1.0); 
           } 
           else if (p8b<=p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h7b),z->get_range(p8b),z->get_range(p6b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h5b),z->get_range(h2b),2,1,3,0,-1.0); 
        in[2]->add_block(p6b-z->noab()+z->nvab()*(h2b+z->noab()*(h7b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_2_30(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long h2b=h1b;h2b<z->noab();++h2b) { 
    long tileoffset; 
    tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h1b)+z->get_spin(h2b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h1b)^z->get_sym(h2b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h1b)*z->get_range(h2b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
         for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
           if ((z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
            long p7b_0,p8b_0,h1b_0,h2b_0; 
            z->restricted_4(p7b,p8b,h1b,h2b,p7b_0,p8b_0,h1b_0,h2b_0); 
            long h5b_1,h6b_1,p7b_1,p8b_1; 
            z->restricted_4(h5b,h6b,p7b,p8b,h5b_1,h6b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(p7b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(h1b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h5b)*z->get_range(h6b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,+1.0); 
            z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p7b==p8b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h6b),z->get_range(h5b),z->get_range(h2b),z->get_range(h1b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDT_T2::smith_3_25(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h5b=0L;h5b<z->noab();++h5b) { 
 for (long h6b=h5b;h6b<z->noab();++h6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h5b)+z->get_spin(h6b)+z->get_spin(h2b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h5b)+z->get_spin(h6b)==z->get_spin(h2b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h5b)^(z->get_sym(h6b)^(z->get_sym(h2b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h5b)*z->get_range(h6b)*z->get_range(h2b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p8b_0,h2b_0; 
           z->restricted_2(p8b,h2b,p8b_0,h2b_0); 
           long h5b_1,h6b_1,p7b_1,p8b_1; 
           z->restricted_4(h5b,h6b,p7b,p8b,h5b_1,h6b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h5b)*z->get_range(h6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h2b),1,0,+1.0); 
           if (p7b<p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
           } 
           else if (p8b<=p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(h6b_1+(z->nab())*(h5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h6b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h6b),z->get_range(h5b),z->get_range(h2b),2,1,3,0,+0.5); 
        in[3]->add_block(p7b-z->noab()+z->nvab()*(h2b+z->noab()*(h6b+z->noab()*(h5b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
