"""Manages loadable plugins

Plugins should be loaded via load_plugin(), even from other plugins
(using 'import' is discouraged, as it might not work).

Plugins are stored in a separate dictionary from modules, in order to
prevent plugins from accidentally (or intentionally) overriding modules
in musiclibrarian, or even core Python modules.  It's basically a matter
of namespace separation.

When this module is initially imported, it will load all the plugins
it can find in the standard locations."""

import imp
import os
import string
import sys

plugins={}

plugin_path=[os.path.expanduser('~/.musiclibrarian/plugins'),
             os.path.join(os.path.dirname(sys.argv[0]),
                          'musiclibrarian-plugins'),
             os.path.join(sys.prefix, 'lib/musiclibrarian/plugins'),
             os.path.join(sys.prefix, 'share/musiclibrarian/plugins')]

# Load one level of hierarchy of a plugin
def load_plugin_step(fqname, namepart, path):
    if plugins.has_key(fqname):
        return plugins[fqname]

    file, pathname, description = imp.find_module(namepart, path)

    try:
        rval=imp.load_module('musiclibrarian.plugins.'+fqname,
                             file,
                             pathname,
                             description)
        plugins[fqname]=rval

        return rval
    finally:
        if file:
            file.close()

def load_plugin(name):
    parts=name.split('.')
    path=plugin_path
    fqname=''
    m=None

    for part in parts:
        if fqname <> '' and part <> '':
            fqname='%s.%s'%(fqname,part)
        else:
            fqname=fqname+part

        try:
            m=load_plugin_step(fqname, part, path)
        except:
            print 'Failed to load plugin %s:'%name
            apply(sys.excepthook, sys.exc_info())
            return None
        # Be sure to bomb out if the user tries to hierarchically load
        # a non-package.
        path=getattr(m, '__path__', '')

    return m

# Load all plugins:
def load_all_plugins():
    for dir in plugin_path:
        if os.path.isdir(dir):
            for fn in os.listdir(dir):
                if (os.path.isdir(os.path.join(dir, fn)) and
                    os.path.isfile(os.path.join(dir, fn, '__init__.py'))):
                    load_plugin(fn)
                elif (os.path.isfile(os.path.join(dir, fn)) and
                      fn.endswith('.py')):
                    load_plugin(fn[:-3])
