
#include "stdafx.h"
#include <grts/structs.db.migration.h>

#include <grtpp_util.h>


//================================================================================
// db_migration_Migration


void db_migration_Migration::init()
{

}

db_migration_Migration::~db_migration_Migration()
{
  
}


grt::Ref<GrtLogObject> db_migration_Migration::addMigrationLogEntry(long type, const grt::Ref<GrtObject> &sourceObject, const grt::Ref<GrtObject> &targetObject, const std::string &message)
{
  GrtLogObjectRef log = findMigrationLogEntry(sourceObject, targetObject);
  if (!log.is_valid())
  {
    log = GrtLogObjectRef(get_grt());
    log->owner(this);
    log->logObject(sourceObject);
    log->refObject(targetObject);
    
    migrationLog().insert(log);
  }

  GrtLogEntryRef entry = GrtLogEntryRef(get_grt());
  
  entry->owner(log);
  entry->entryType(type);
  entry->name(grt::StringRef(message));
  log->entries().insert(entry);

  return log;
}


grt::Ref<GrtLogObject> db_migration_Migration::findMigrationLogEntry(const grt::Ref<GrtObject> &sourceObject, const grt::Ref<GrtObject> &targetObject)
{
  for (size_t c = migrationLog().count(), i = 0; i < c; i++)
  {
    GrtLogObjectRef log(migrationLog()[i]);
    if (log->logObject() == sourceObject && log->refObject() == targetObject)
      return log;
  }
  return GrtLogObjectRef();
}



