/* $Id: GC_AssemblyUnit.cpp 346674 2011-12-08 18:37:59Z dicuccio $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'genome_collection.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/genomecoll/GC_AssemblyUnit.hpp>
#include <objects/genomecoll/GC_Assembly.hpp>
#include <objects/general/Dbtag.hpp>
#include <objects/general/Object_id.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// constructor
CGC_AssemblyUnit::CGC_AssemblyUnit(void)
    : m_Assembly(NULL)
{
}


// destructor
CGC_AssemblyUnit::~CGC_AssemblyUnit(void)
{
}

string CGC_AssemblyUnit::GetName() const
{
    return GetDesc().GetName();
}


string CGC_AssemblyUnit::GetAccession() const
{
	string accession;
	CGC_AssemblyUnit::TId ids;
	ITERATE (CGC_AssemblyUnit::TId, id_it, GetId())
	{
		if ((*id_it)->GetDb() == "GenColl"  &&
			(*id_it)->GetTag().IsStr())
		{
				return (*id_it)->GetTag().GetStr();
		}
	}
	return "";
}


int CGC_AssemblyUnit::GetReleaseId() const
{
    int release_id = 0;
    CGC_AssemblyUnit::TId ids;
    ITERATE (CGC_AssemblyUnit::TId, id_it, GetId()) {
        if ((*id_it)->GetDb() == "GenColl"  &&
            (*id_it)->GetTag().IsId()) {
            release_id = (*id_it)->GetTag().GetId();
            break;
        }
    }
    return release_id;
}


/// Access the assembly the sequence belongs to
CConstRef<CGC_Assembly> CGC_AssemblyUnit::GetFullAssembly() const
{
    return CConstRef<CGC_Assembly>(m_Assembly);
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1770, CRC32: de4faec2 */
