/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.BorderLayout;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator.DataModel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 * Ask whether the user is ready to launch the application. With all 
 * the consequences.
 *
 * @author Jaroslav Tulach
 */
final class LayoutWarningPanel extends BasicWizardIterator.Panel {
    private final DataModel data;
    
    @NbBundle.Messages({
        "LBL_LayoutWizardTitle=Launch Your Application?"
    })
    public LayoutWarningPanel(WizardDescriptor setting, NewTCIterator.DataModel data) {
        super(setting);
        this.data = data;
        initComponents();
        initAccessibility();
        putClientProperty("NewFileWizard_Title", Bundle.LBL_LayoutWizardTitle()); //NOI18N
        panel.add(DesignSupport.warningPanel(), BorderLayout.CENTER);
    }
    
    @Override
    protected void storeToDataModel() {
        data.setIgnorePreviousRun(ignore.isSelected());
    }
    
    @NbBundle.Messages({
        "MSG_UnsupportedWizard=This wizard can be used only with NetBeans Platform 7.1 and newer!"
    })
    @Override
    protected void readFromDataModel() {
        ignore.setSelected(data.isIgnorePreviousRun());
        if (!DesignSupport.isDesignModeSupported(data.getModuleInfo())) {
            setInfo(Bundle.MSG_UnsupportedWizard(), false);
        }
    }

    @Override
    protected String getPanelName() {
        return Bundle.LBL_LayoutWizardTitle();
    }
    
    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(LayoutWarningPanel.class);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        panel = new javax.swing.JPanel();
        ignore = new javax.swing.JCheckBox();

        panel.setLayout(new java.awt.BorderLayout());

        ignore.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(ignore, org.openide.util.NbBundle.getMessage(LayoutWarningPanel.class, "IGNORE PREVIOUS RUN", new Object[] {})); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(8, 8, 8)
                .addComponent(ignore, javax.swing.GroupLayout.DEFAULT_SIZE, 384, Short.MAX_VALUE)
                .addContainerGap())
            .addComponent(panel, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(panel, javax.swing.GroupLayout.DEFAULT_SIZE, 267, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(ignore)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox ignore;
    private javax.swing.JPanel panel;
    // End of variables declaration//GEN-END:variables
    
    @NbBundle.Messages({
        "ACS_LayoutWarningPanel=Do you want to launch your application?"
    })
    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Bundle.ACS_LayoutWarningPanel());
    }
    
}
