discard """
    output: '''Success'''
"""

# bug #3793

import os
import math
import lists
import strutils

proc mkleak() =
    # allocate 10 MB via linked lists
    let numberOfLists = 100
    for i in countUp(1, numberOfLists):
        var leakList = initDoublyLinkedList[string]()
        let numberOfLeaks = 50000
        for j in countUp(1, numberOfLeaks):
            let leakSize = 200
            let leaked = newString(leakSize)
            leakList.append(leaked)

proc mkManyLeaks() =
    for i in 0..0:
        when false: echo getOccupiedMem()
        mkleak()
        when false: echo getOccupiedMem()
        # Force a full collection. This should free all of the
        # lists and bring the memory usage down to a few MB's.
        GC_fullCollect()
        when false: echo getOccupiedMem()
        if getOccupiedMem() > 8 * 200 * 50_000 * 2:
          echo GC_getStatistics()
          quit "leaking"
    echo "Success"

mkManyLeaks()
