# Node Foundation TSC Meeting 2015-07-08

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-07-08
* **GitHub Issue**: https://github.com/nodejs/node-convergence-archive/issues/64
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1HuRtu5ZP7ZlrIp756EbZYo4I26v2RY-7CY1pr_3y1nY

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests prior to meeting.

### nodejs/io.js

* Default Unhandled Rejection Detection Behavior [#830](https://github.com/nodejs/io.js/issues/830)

### joyent/node

* Adding a "mentor-available" label [#25618](https://github.com/joyent/node/issues/25618)

## Minutes


### Present

* Mikeal Rogers
* Colin Ihrig (TSC)
* Ben Noordhuis (TSC)
* James Snell (TSC)
* Fedor Indutny (TSC)
* Bert Belder (TSC)
* Michael Dawson (TSC)
* Steven R Loomis (TSC)
* Alexis Campailla (TSC)
* Jeremiah Senkpiel (TSC)
* Julien Gilli (TSC)
* Chris Dickinson (TSC)
* Shigeki Ohtsu (TSC)
* Trevor Norris (TSC)
* Domenic Denicola
* Brian White (TSC)
* Rod Vagg (TSC)

### Review of the previous meeting

* Policy for PR blocking? [#2078](https://github.com/nodejs/io.js/issues/2078)
 - Resolution was to deal with it on a case-by-case basis for now.

* Internationalization WG (Steven)
 - Steven Loomis is going to kick off the working group.
 - Steven: no further responses on the github issue.
 - James: just need to get started

* lts: strawman LTS cycle [lts#13](https://github.com/nodejs/LTS/pull/13) / Proposal: Release Process [#1997](https://github.com/nodejs/io.js/issues/1997)


### Standup:

* Mikeal Rogers: wrote a new confrence call tool for us that uses Twillio
* Colin Ihrig: Not much, reviewing PRs, triaging issues.
* Ben Noordhuis: reviewed a lot of PRs, upgraded v8 in `next` and `next+1`.
* James Snell: Working on the LTS Proposal, triaging issues in joyent/node, investigating stuff for the upcoming openssl fix.
* Fedor Indutny: fixed node after v8 upgrade. Exposed critical issues.
* Bert Belder: Not much code, had conversations with Mike Dolan and James Snell about the foundation and organizational issues. Working through a laundry list of libuv PRs blocking the next release.
* Michael Dawson: Working on getting PowerPC to build on io.js, tested the security fix from last week, joyent/node triage.
* Steven R Loomis: Worked a bit on the Intl WG, not much else.
* Alexis Campailla: converged CI, almost done. Dealing with windows installer issues. Expect converged CI to work in a week.
* Jeremiah Senkpiel: General triaging and reviewing, helped do the release last friday. `_unrefActive` with optimizations with heap timers. At CascadiaJS the next of the week to get people’s feedback.
* Julien Gilli: Released 0.12.6 last week, working on setting up other people to do joyent/node releases, joyent/node issue triage
* Chris Dickinson: Working on docs more, have a new tool for docs to make sure the links are correct in a tree of docs, started a collaborator check-in on the io.js issue tracker, hopefully will be weekly.
Jeremiah: what is that doctool? 
Chris: “count-docula”, a MDAST-based tool to verify correctness of the docs.
* Shigeki Ohtsu: Not much on io.js, preparing to update OpenSSL tonight to get the OpenSSL security fix out.
* Trevor Norris: Investigating the UTF8 decoder security issue and working on the fix. Reviewing PRs and being involved in the W3C Web Assembly working group.
* Domenic Denicola: Not much on io.js, travelling, stress testing the vm module.
* Brian White: Triaging issues, working on the javascript http parser more & benchmarking it.
* Rod Vagg: We should discuss the LTS proposal again since there was lots of work done on that. Working on lots, including the security fix from last friday (writing up a post-mortem for it), getting external people involved to review our security processes.

### Default Unhandled Rejection Detection Behavior [#830](https://github.com/nodejs/io.js/issues/830)

* Domenic: let’s say there was a magic way to detect when an error in an err-back style callback was not handled, what would we do? Print to stderr?
* Bert: We do have a history of printing things to stderr. We should follow browser semantics if we can, in favor of primnting a warning but nothing else.
* Discussion about the technicalities of handling unhandledRejections
* Rod: not sure we should do anything since detecting this is somewhat arbitrary.
* Domenic: there is a proposal for this that chrome implements behind a flag that comes close to how the unhandledRejection hook in node works
* Discussion about the technicalities of having a better hook for printing a warning after garbage collection of an unhandled rejection.
* See this thread for background detail of options in v8: https://code.google.com/p/v8/issues/detail?id=3093#c1
* Action: nothing now, maybe if v8 adds a hook for when rejections get garbage collected.
* Domenic: looking at v8, it seems to have most of the hooks, so this may be possible soon.

### Adding a "mentor-available" label [#25618](https://github.com/joyent/node/issues/25618)

* Folks are interested in contributing to larger tasks, need mentors to help them understand the process. Should we add a label?
* Julien: Many people are interested in making “deeper” contributions, but they need a mentor. Let people add a mentor-available tag so they can locate these.
* … part of the discussion missing here ...
* Resolution: let’s try it, one such label has already been added.

### Having more people managing releases for Node.js v0.10.x and v0.12.x

* Julien: I will have less time to do releases; it needs to become more of a team effort.
* Alexis: in the long term this will be a responsibility of the build team.
* Julien: unsure how responsibilities will be decided. LTS will need to sign off and build will need to produce the release.
* Jeremiah: the iojs/current releases are already a group effort. It’s just that the “long-term” v0.10/v0.12 releases fall on few individuals now.
* Julien: it’s a bit too much to handle for one person. Also people are sometimes unavailable or on vacation. Would like to have a group of about four people.
* Ben: more contributors recently signed up. I think Sam Roberts might be interested.
* Julien: would like to have a release management team.
* Chris: iojs has had the release manager propose other release managers. Open an issue for this.
* Resolved as such.

### lts: LTS Proposal https://github.com/nodejs/LTS#proposed-lts)/ Proposal: Release Process [#1997](https://github.com/nodejs/io.js/issues/1997)

* James: when are we cutting over to the converged stream? Thinking of late august, first LTS release in October. Is this a good time? Most users won’t start migrating until next year because of the holidays.
* Julien: what are other projects doing, when do they release?
* James: looking it into it, some do it in fall. No clear pattern.
* Alexis: what is the benefit of being on a fixed release schedule?
* James: benefit is it makes planning easier.
* Trevor: coming from the enterprise side, not having a predictable release schedule isn’t useful.
* Steven: ICU and Unicode has announced that there will be a yearly release. It’s been helpful for planning.
* James: It also ties into our regular release schedule and merging next into master etc. The next-to-master merge defines when we can do an LTS release. This should happen at least twice a year. The LTS is cut just before a merge (major bump), so by the time a LTS is cut it should have been stable for half a year.
* James: please kick tires on this proposal, get feedback from the user communities you’re connected to wrt the frequency and release date.
* Rod: the TSC should consider the timeframe, and the requirement that there should be two next-to-master merge yearly.
* Trevor: how does this fit with a 6-week release schedule on master?
* James: depends on the schedule.
* Domenic: I don’t see the problem. Just take a 6 months old release and turn it into an LTS.
* Rod/James/Trevor: because version numbers. The LTS version number needs to be a continuation of a release version.
* Rod: fixed date, or part of the month.
* Chris, Rod: get feedback, comment on the issue 

### Next Meeting

July 15th 2015
