"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _cliCursor = _interopRequireDefault(require("cli-cursor"));

var _AppContext = _interopRequireDefault(require("./AppContext"));

var _StdinContext = _interopRequireDefault(require("./StdinContext"));

var _StdoutContext = _interopRequireDefault(require("./StdoutContext"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Root component for all Ink apps
// It renders stdin and stdout contexts, so that children can access them if needed
// It also handles Ctrl+C exiting and cursor visibility
class App extends _react.PureComponent {
  // Determines if TTY is supported on the provided stdin
  isRawModeSupported() {
    return this.props.stdin.isTTY;
  }

  constructor() {
    super(); // Count how many components enabled raw mode to avoid disabling
    // raw mode until all components don't need it anymore

    _defineProperty(this, "handleSetRawMode", isEnabled => {
      const {
        stdin
      } = this.props;

      if (!this.isRawModeSupported()) {
        if (stdin === process.stdin) {
          throw new Error('Raw mode is not supported on the current process.stdin, which Ink uses as input stream by default.\nRead about how to prevent this error on https://github.com/vadimdemedes/ink/#israwmodesupported');
        } else {
          throw new Error('Raw mode is not supported on the stdin provided to Ink.\nRead about how to prevent this error on https://github.com/vadimdemedes/ink/#israwmodesupported');
        }
      }

      stdin.setEncoding('utf8');

      if (isEnabled) {
        // Ensure raw mode is enabled only once
        if (this.rawModeEnabledCount === 0) {
          stdin.addListener('data', this.handleInput);
          stdin.resume();
          stdin.setRawMode(true);
        }

        this.rawModeEnabledCount++;
        return;
      } // Disable raw mode only when no components left that are using it


      if (--this.rawModeEnabledCount === 0) {
        stdin.setRawMode(false);
        stdin.removeListener('data', this.handleInput);
        stdin.pause();
      }
    });

    _defineProperty(this, "handleInput", input => {
      // Exit on Ctrl+C
      if (input === '\x03' && this.props.exitOnCtrlC) {
        // eslint-disable-line unicorn/no-hex-escape
        this.handleExit();
      }
    });

    _defineProperty(this, "handleExit", error => {
      if (this.isRawModeSupported()) {
        this.handleSetRawMode(false);
      }

      this.props.onExit(error);
    });

    this.rawModeEnabledCount = 0;
  }

  render() {
    return _react.default.createElement(_AppContext.default.Provider, {
      value: {
        exit: this.handleExit
      }
    }, _react.default.createElement(_StdinContext.default.Provider, {
      value: {
        stdin: this.props.stdin,
        setRawMode: this.handleSetRawMode,
        isRawModeSupported: this.isRawModeSupported()
      }
    }, _react.default.createElement(_StdoutContext.default.Provider, {
      value: {
        stdout: this.props.stdout
      }
    }, this.props.children)));
  }

  componentDidMount() {
    _cliCursor.default.hide(this.props.stdout);
  }

  componentWillUnmount() {
    _cliCursor.default.show(this.props.stdout); // ignore calling setRawMode on an handle stdin it cannot be called


    if (this.isRawModeSupported()) {
      this.handleSetRawMode(false);
    }
  }

  componentDidCatch(error) {
    this.handleExit(error);
  }

}

exports.default = App;

_defineProperty(App, "propTypes", {
  children: _propTypes.default.node.isRequired,
  stdin: _propTypes.default.object.isRequired,
  stdout: _propTypes.default.object.isRequired,
  exitOnCtrlC: _propTypes.default.bool.isRequired,
  // eslint-disable-line react/boolean-prop-naming
  onExit: _propTypes.default.func.isRequired
});