/* following code is from c47bfce06 of boringssl: crypto/curve25519 */

/* Copyright (c) 2020, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

// This file is generated from
//    ./make_curve25519_tables.py > curve25519_tables.h

static const fe d = {{
#if defined(ARCH_64BIT)
    929955233495203, 466365720129213, 1662059464998953, 2033849074728123,
    1442794654840575
#else
    56195235, 13857412, 51736253, 6949390, 114729, 24766616, 60832955, 30306712,
    48412415, 21499315
#endif
}};

static const fe sqrtm1 = {{
#if defined(ARCH_64BIT)
    1718705420411056, 234908883556509, 2233514472574048, 2117202627021982,
    765476049583133
#else
    34513072, 25610706, 9377949, 3500415, 12389472, 33281959, 41962654,
    31548777, 326685, 11406482
#endif
}};

static const fe d2 = {{
#if defined(ARCH_64BIT)
    1859910466990425, 932731440258426, 1072319116312658, 1815898335770999,
    633789495995903
#else
    45281625, 27714825, 36363642, 13898781, 229458, 15978800, 54557047,
    27058993, 29715967, 9444199
#endif
}};

// This block of code replaces the standard base-point table with a much smaller
// one. The standard table is 30,720 bytes while this one is just 960.
//
// This table contains 15 pairs of group elements, (x, y), where each field
// element is serialised with |fe_tobytes|. If |i| is the index of the group
// element then consider i+1 as a four-bit number: (i₀, i₁, i₂, i₃) (where i₀
// is the most significant bit). The value of the group element is then:
// (i₀×2^192 + i₁×2^128 + i₂×2^64 + i₃)G, where G is the generator.
static const uint8_t k25519SmallPrecomp[15 * 2 * 32] = {
    0x1a, 0xd5, 0x25, 0x8f, 0x60, 0x2d, 0x56, 0xc9, 0xb2, 0xa7, 0x25, 0x95,
    0x60, 0xc7, 0x2c, 0x69, 0x5c, 0xdc, 0xd6, 0xfd, 0x31, 0xe2, 0xa4, 0xc0,
    0xfe, 0x53, 0x6e, 0xcd, 0xd3, 0x36, 0x69, 0x21, 0x58, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x02, 0xa2, 0xed, 0xf4, 0x8f, 0x6b, 0x0b, 0x3e,
    0xeb, 0x35, 0x1a, 0xd5, 0x7e, 0xdb, 0x78, 0x00, 0x96, 0x8a, 0xa0, 0xb4,
    0xcf, 0x60, 0x4b, 0xd4, 0xd5, 0xf9, 0x2d, 0xbf, 0x88, 0xbd, 0x22, 0x62,
    0x13, 0x53, 0xe4, 0x82, 0x57, 0xfa, 0x1e, 0x8f, 0x06, 0x2b, 0x90, 0xba,
    0x08, 0xb6, 0x10, 0x54, 0x4f, 0x7c, 0x1b, 0x26, 0xed, 0xda, 0x6b, 0xdd,
    0x25, 0xd0, 0x4e, 0xea, 0x42, 0xbb, 0x25, 0x03, 0xa2, 0xfb, 0xcc, 0x61,
    0x67, 0x06, 0x70, 0x1a, 0xc4, 0x78, 0x3a, 0xff, 0x32, 0x62, 0xdd, 0x2c,
    0xab, 0x50, 0x19, 0x3b, 0xf2, 0x9b, 0x7d, 0xb8, 0xfd, 0x4f, 0x29, 0x9c,
    0xa7, 0x91, 0xba, 0x0e, 0x46, 0x5e, 0x51, 0xfe, 0x1d, 0xbf, 0xe5, 0xe5,
    0x9b, 0x95, 0x0d, 0x67, 0xf8, 0xd1, 0xb5, 0x5a, 0xa1, 0x93, 0x2c, 0xc3,
    0xde, 0x0e, 0x97, 0x85, 0x2d, 0x7f, 0xea, 0xab, 0x3e, 0x47, 0x30, 0x18,
    0x24, 0xe8, 0xb7, 0x60, 0xae, 0x47, 0x80, 0xfc, 0xe5, 0x23, 0xe7, 0xc2,
    0xc9, 0x85, 0xe6, 0x98, 0xa0, 0x29, 0x4e, 0xe1, 0x84, 0x39, 0x2d, 0x95,
    0x2c, 0xf3, 0x45, 0x3c, 0xff, 0xaf, 0x27, 0x4c, 0x6b, 0xa6, 0xf5, 0x4b,
    0x11, 0xbd, 0xba, 0x5b, 0x9e, 0xc4, 0xa4, 0x51, 0x1e, 0xbe, 0xd0, 0x90,
    0x3a, 0x9c, 0xc2, 0x26, 0xb6, 0x1e, 0xf1, 0x95, 0x7d, 0xc8, 0x6d, 0x52,
    0xe6, 0x99, 0x2c, 0x5f, 0x9a, 0x96, 0x0c, 0x68, 0x29, 0xfd, 0xe2, 0xfb,
    0xe6, 0xbc, 0xec, 0x31, 0x08, 0xec, 0xe6, 0xb0, 0x53, 0x60, 0xc3, 0x8c,
    0xbe, 0xc1, 0xb3, 0x8a, 0x8f, 0xe4, 0x88, 0x2b, 0x55, 0xe5, 0x64, 0x6e,
    0x9b, 0xd0, 0xaf, 0x7b, 0x64, 0x2a, 0x35, 0x25, 0x10, 0x52, 0xc5, 0x9e,
    0x58, 0x11, 0x39, 0x36, 0x45, 0x51, 0xb8, 0x39, 0x93, 0xfc, 0x9d, 0x6a,
    0xbe, 0x58, 0xcb, 0xa4, 0x0f, 0x51, 0x3c, 0x38, 0x05, 0xca, 0xab, 0x43,
    0x63, 0x0e, 0xf3, 0x8b, 0x41, 0xa6, 0xf8, 0x9b, 0x53, 0x70, 0x80, 0x53,
    0x86, 0x5e, 0x8f, 0xe3, 0xc3, 0x0d, 0x18, 0xc8, 0x4b, 0x34, 0x1f, 0xd8,
    0x1d, 0xbc, 0xf2, 0x6d, 0x34, 0x3a, 0xbe, 0xdf, 0xd9, 0xf6, 0xf3, 0x89,
    0xa1, 0xe1, 0x94, 0x9f, 0x5d, 0x4c, 0x5d, 0xe9, 0xa1, 0x49, 0x92, 0xef,
    0x0e, 0x53, 0x81, 0x89, 0x58, 0x87, 0xa6, 0x37, 0xf1, 0xdd, 0x62, 0x60,
    0x63, 0x5a, 0x9d, 0x1b, 0x8c, 0xc6, 0x7d, 0x52, 0xea, 0x70, 0x09, 0x6a,
    0xe1, 0x32, 0xf3, 0x73, 0x21, 0x1f, 0x07, 0x7b, 0x7c, 0x9b, 0x49, 0xd8,
    0xc0, 0xf3, 0x25, 0x72, 0x6f, 0x9d, 0xed, 0x31, 0x67, 0x36, 0x36, 0x54,
    0x40, 0x92, 0x71, 0xe6, 0x11, 0x28, 0x11, 0xad, 0x93, 0x32, 0x85, 0x7b,
    0x3e, 0xb7, 0x3b, 0x49, 0x13, 0x1c, 0x07, 0xb0, 0x2e, 0x93, 0xaa, 0xfd,
    0xfd, 0x28, 0x47, 0x3d, 0x8d, 0xd2, 0xda, 0xc7, 0x44, 0xd6, 0x7a, 0xdb,
    0x26, 0x7d, 0x1d, 0xb8, 0xe1, 0xde, 0x9d, 0x7a, 0x7d, 0x17, 0x7e, 0x1c,
    0x37, 0x04, 0x8d, 0x2d, 0x7c, 0x5e, 0x18, 0x38, 0x1e, 0xaf, 0xc7, 0x1b,
    0x33, 0x48, 0x31, 0x00, 0x59, 0xf6, 0xf2, 0xca, 0x0f, 0x27, 0x1b, 0x63,
    0x12, 0x7e, 0x02, 0x1d, 0x49, 0xc0, 0x5d, 0x79, 0x87, 0xef, 0x5e, 0x7a,
    0x2f, 0x1f, 0x66, 0x55, 0xd8, 0x09, 0xd9, 0x61, 0x38, 0x68, 0xb0, 0x07,
    0xa3, 0xfc, 0xcc, 0x85, 0x10, 0x7f, 0x4c, 0x65, 0x65, 0xb3, 0xfa, 0xfa,
    0xa5, 0x53, 0x6f, 0xdb, 0x74, 0x4c, 0x56, 0x46, 0x03, 0xe2, 0xd5, 0x7a,
    0x29, 0x1c, 0xc6, 0x02, 0xbc, 0x59, 0xf2, 0x04, 0x75, 0x63, 0xc0, 0x84,
    0x2f, 0x60, 0x1c, 0x67, 0x76, 0xfd, 0x63, 0x86, 0xf3, 0xfa, 0xbf, 0xdc,
    0xd2, 0x2d, 0x90, 0x91, 0xbd, 0x33, 0xa9, 0xe5, 0x66, 0x0c, 0xda, 0x42,
    0x27, 0xca, 0xf4, 0x66, 0xc2, 0xec, 0x92, 0x14, 0x57, 0x06, 0x63, 0xd0,
    0x4d, 0x15, 0x06, 0xeb, 0x69, 0x58, 0x4f, 0x77, 0xc5, 0x8b, 0xc7, 0xf0,
    0x8e, 0xed, 0x64, 0xa0, 0xb3, 0x3c, 0x66, 0x71, 0xc6, 0x2d, 0xda, 0x0a,
    0x0d, 0xfe, 0x70, 0x27, 0x64, 0xf8, 0x27, 0xfa, 0xf6, 0x5f, 0x30, 0xa5,
    0x0d, 0x6c, 0xda, 0xf2, 0x62, 0x5e, 0x78, 0x47, 0xd3, 0x66, 0x00, 0x1c,
    0xfd, 0x56, 0x1f, 0x5d, 0x3f, 0x6f, 0xf4, 0x4c, 0xd8, 0xfd, 0x0e, 0x27,
    0xc9, 0x5c, 0x2b, 0xbc, 0xc0, 0xa4, 0xe7, 0x23, 0x29, 0x02, 0x9f, 0x31,
    0xd6, 0xe9, 0xd7, 0x96, 0xf4, 0xe0, 0x5e, 0x0b, 0x0e, 0x13, 0xee, 0x3c,
    0x09, 0xed, 0xf2, 0x3d, 0x76, 0x91, 0xc3, 0xa4, 0x97, 0xae, 0xd4, 0x87,
    0xd0, 0x5d, 0xf6, 0x18, 0x47, 0x1f, 0x1d, 0x67, 0xf2, 0xcf, 0x63, 0xa0,
    0x91, 0x27, 0xf8, 0x93, 0x45, 0x75, 0x23, 0x3f, 0xd1, 0xf1, 0xad, 0x23,
    0xdd, 0x64, 0x93, 0x96, 0x41, 0x70, 0x7f, 0xf7, 0xf5, 0xa9, 0x89, 0xa2,
    0x34, 0xb0, 0x8d, 0x1b, 0xae, 0x19, 0x15, 0x49, 0x58, 0x23, 0x6d, 0x87,
    0x15, 0x4f, 0x81, 0x76, 0xfb, 0x23, 0xb5, 0xea, 0xcf, 0xac, 0x54, 0x8d,
    0x4e, 0x42, 0x2f, 0xeb, 0x0f, 0x63, 0xdb, 0x68, 0x37, 0xa8, 0xcf, 0x8b,
    0xab, 0xf5, 0xa4, 0x6e, 0x96, 0x2a, 0xb2, 0xd6, 0xbe, 0x9e, 0xbd, 0x0d,
    0xb4, 0x42, 0xa9, 0xcf, 0x01, 0x83, 0x8a, 0x17, 0x47, 0x76, 0xc4, 0xc6,
    0x83, 0x04, 0x95, 0x0b, 0xfc, 0x11, 0xc9, 0x62, 0xb8, 0x0c, 0x76, 0x84,
    0xd9, 0xb9, 0x37, 0xfa, 0xfc, 0x7c, 0xc2, 0x6d, 0x58, 0x3e, 0xb3, 0x04,
    0xbb, 0x8c, 0x8f, 0x48, 0xbc, 0x91, 0x27, 0xcc, 0xf9, 0xb7, 0x22, 0x19,
    0x83, 0x2e, 0x09, 0xb5, 0x72, 0xd9, 0x54, 0x1c, 0x4d, 0xa1, 0xea, 0x0b,
    0xf1, 0xc6, 0x08, 0x72, 0x46, 0x87, 0x7a, 0x6e, 0x80, 0x56, 0x0a, 0x8a,
    0xc0, 0xdd, 0x11, 0x6b, 0xd6, 0xdd, 0x47, 0xdf, 0x10, 0xd9, 0xd8, 0xea,
    0x7c, 0xb0, 0x8f, 0x03, 0x00, 0x2e, 0xc1, 0x8f, 0x44, 0xa8, 0xd3, 0x30,
    0x06, 0x89, 0xa2, 0xf9, 0x34, 0xad, 0xdc, 0x03, 0x85, 0xed, 0x51, 0xa7,
    0x82, 0x9c, 0xe7, 0x5d, 0x52, 0x93, 0x0c, 0x32, 0x9a, 0x5b, 0xe1, 0xaa,
    0xca, 0xb8, 0x02, 0x6d, 0x3a, 0xd4, 0xb1, 0x3a, 0xf0, 0x5f, 0xbe, 0xb5,
    0x0d, 0x10, 0x6b, 0x38, 0x32, 0xac, 0x76, 0x80, 0xbd, 0xca, 0x94, 0x71,
    0x7a, 0xf2, 0xc9, 0x35, 0x2a, 0xde, 0x9f, 0x42, 0x49, 0x18, 0x01, 0xab,
    0xbc, 0xef, 0x7c, 0x64, 0x3f, 0x58, 0x3d, 0x92, 0x59, 0xdb, 0x13, 0xdb,
    0x58, 0x6e, 0x0a, 0xe0, 0xb7, 0x91, 0x4a, 0x08, 0x20, 0xd6, 0x2e, 0x3c,
    0x45, 0xc9, 0x8b, 0x17, 0x79, 0xe7, 0xc7, 0x90, 0x99, 0x3a, 0x18, 0x25,
};

// Bi[i] = (2*i+1)*B
static const ge_precomp Bi[8] = {
    {
        {{
#if defined(ARCH_64BIT)
            1288382639258501, 245678601348599, 269427782077623,
            1462984067271730, 137412439391563
#else
            25967493, 19198397, 29566455, 3660896, 54414519, 4014786, 27544626,
            21800161, 61029707, 2047604
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            62697248952638, 204681361388450, 631292143396476, 338455783676468,
            1213667448819585
#else
            54563134, 934261, 64385954, 3049989, 66381436, 9406985, 12720692,
            5043384, 19500929, 18085054
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            301289933810280, 1259582250014073, 1422107436869536,
            796239922652654, 1953934009299142
#else
            58370664, 4489569, 9688441, 18769238, 10184608, 21191052, 29287918,
            11864899, 42594502, 29115885
#endif
        }},
    },
    {
        {{
#if defined(ARCH_64BIT)
            1601611775252272, 1720807796594148, 1132070835939856,
            1260455018889551, 2147779492816911
#else
            15636272, 23865875, 24204772, 25642034, 616976, 16869170, 27787599,
            18782243, 28944399, 32004408
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            316559037616741, 2177824224946892, 1459442586438991,
            1461528397712656, 751590696113597
#else
            16568933, 4717097, 55552716, 32452109, 15682895, 21747389, 16354576,
            21778470, 7689661, 11199574
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            1850748884277385, 1200145853858453, 1068094770532492,
            672251375690438, 1586055907191707
#else
            30464137, 27578307, 55329429, 17883566, 23220364, 15915852, 7512774,
            10017326, 49359771, 23634074
#endif
        }},
    },
    {
        {{
#if defined(ARCH_64BIT)
            769950342298419, 132954430919746, 844085933195555, 974092374476333,
            726076285546016
#else
            10861363, 11473154, 27284546, 1981175, 37044515, 12577860, 32867885,
            14515107, 51670560, 10819379
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            425251763115706, 608463272472562, 442562545713235, 837766094556764,
            374555092627893
#else
            4708026, 6336745, 20377586, 9066809, 55836755, 6594695, 41455196,
            12483687, 54440373, 5581305
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            1086255230780037, 274979815921559, 1960002765731872,
            929474102396301, 1190409889297339
#else
            19563141, 16186464, 37722007, 4097518, 10237984, 29206317, 28542349,
            13850243, 43430843, 17738489
#endif
        }},
    },
    {
        {{
#if defined(ARCH_64BIT)
            665000864555967, 2065379846933859, 370231110385876, 350988370788628,
            1233371373142985
#else
            5153727, 9909285, 1723747, 30776558, 30523604, 5516873, 19480852,
            5230134, 43156425, 18378665
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            2019367628972465, 676711900706637, 110710997811333,
            1108646842542025, 517791959672113
#else
            36839857, 30090922, 7665485, 10083793, 28475525, 1649722, 20654025,
            16520125, 30598449, 7715701
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            965130719900578, 247011430587952, 526356006571389, 91986625355052,
            2157223321444601
#else
            28881826, 14381568, 9657904, 3680757, 46927229, 7843315, 35708204,
            1370707, 29794553, 32145132
#endif
        }},
    },
    {
        {{
#if defined(ARCH_64BIT)
            1802695059465007, 1664899123557221, 593559490740857,
            2160434469266659, 927570450755031
#else
            44589871, 26862249, 14201701, 24808930, 43598457, 8844725, 18474211,
            32192982, 54046167, 13821876
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            1725674970513508, 1933645953859181, 1542344539275782,
            1767788773573747, 1297447965928905
#else
            60653668, 25714560, 3374701, 28813570, 40010246, 22982724, 31655027,
            26342105, 18853321, 19333481
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            1381809363726107, 1430341051343062, 2061843536018959,
            1551778050872521, 2036394857967624
#else
            4566811, 20590564, 38133974, 21313742, 59506191, 30723862, 58594505,
            23123294, 2207752, 30344648
#endif
        }},
    },
    {
        {{
#if defined(ARCH_64BIT)
            1970894096313054, 528066325833207, 1619374932191227,
            2207306624415883, 1169170329061080
#else
            41954014, 29368610, 29681143, 7868801, 60254203, 24130566, 54671499,
            32891431, 35997400, 17421995
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            2070390218572616, 1458919061857835, 624171843017421,
            1055332792707765, 433987520732508
#else
            25576264, 30851218, 7349803, 21739588, 16472781, 9300885, 3844789,
            15725684, 171356, 6466918
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            893653801273833, 1168026499324677, 1242553501121234,
            1306366254304474, 1086752658510815
#else
            23103977, 13316479, 9739013, 17404951, 817874, 18515490, 8965338,
            19466374, 36393951, 16193876
#endif
        }},
    },
    {
        {{
#if defined(ARCH_64BIT)
            213454002618221, 939771523987438, 1159882208056014, 317388369627517,
            621213314200687
#else
            33587053, 3180712, 64714734, 14003686, 50205390, 17283591, 17238397,
            4729455, 49034351, 9256799
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            1971678598905747, 338026507889165, 762398079972271, 655096486107477,
            42299032696322
#else
            41926547, 29380300, 32336397, 5036987, 45872047, 11360616, 22616405,
            9761698, 47281666, 630304
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            177130678690680, 1754759263300204, 1864311296286618,
            1180675631479880, 1292726903152791
#else
            53388152, 2639452, 42871404, 26147950, 9494426, 27780403, 60554312,
            17593437, 64659607, 19263131
#endif
        }},
    },
    {
        {{
#if defined(ARCH_64BIT)
            1913163449625248, 460779200291993, 2193883288642314,
            1008900146920800, 1721983679009502
#else
            63957664, 28508356, 9282713, 6866145, 35201802, 32691408, 48168288,
            15033783, 25105118, 25659556
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            1070401523076875, 1272492007800961, 1910153608563310,
            2075579521696771, 1191169788841221
#else
            42782475, 15950225, 35307649, 18961608, 55446126, 28463506, 1573891,
            30928545, 2198789, 17749813
#endif
        }},
        {{
#if defined(ARCH_64BIT)
            692896803108118, 500174642072499, 2068223309439677,
            1162190621851337, 1426986007309901
#else
            64009494, 10324966, 64867251, 7453182, 61661885, 30818928, 53296841,
            17317989, 34647629, 21263748
#endif
        }},
    },
};
