/*###############################################################################
# Linux Management Providers (LMP), Software Update provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_RegisteredSoftwareUpdateProfileAccess.h"

const string instanceID="OpenDRIM:SoftwareUpdate:1.0.0";

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredSoftwareUpdateProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredSoftwareUpdateProfile instance;
	instance.setInstanceID(instanceID);
	
	if (discriminant == "ei")
		CF_assert(SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredSoftwareUpdateProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=instanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}

	CF_assert(SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_populate(instance, errorMessage));
	_L_;
	return OK;
}

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSoftwareUpdateProfile& newInstance, const OpenDRIM_RegisteredSoftwareUpdateProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSoftwareUpdateProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredSoftwareUpdateProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareUpdate_OpenDRIM_RegisteredSoftwareUpdateProfile_populate(OpenDRIM_RegisteredSoftwareUpdateProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> AdvertiseTypes;

	instance.setRegisteredName("Software Update");
	instance.setRegisteredVersion("1.0.0");
	instance.setRegisteredOrganization(2);	// DMTF

	AdvertiseTypes.push_back(2);			// Not Advertised
	instance.setAdvertiseTypes(AdvertiseTypes);
	_L_;
	return OK;
}

