#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
#################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SSHSessionSettingData.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SSHSessionSettingData provider module";
Name = "SSH_OpenDRIM_SSHSessionSettingDataModule";
Location = "cmpiSSH_OpenDRIM_SSHSessionSettingDataProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SSHSessionSettingData provider";
Name = "SSH_OpenDRIM_SSHSessionSettingDataProvider";
ProviderModuleName = "SSH_OpenDRIM_SSHSessionSettingDataModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SSHSessionSettingData provider capabilities";
ProviderModuleName = "SSH_OpenDRIM_SSHSessionSettingDataModule";
ProviderName = "SSH_OpenDRIM_SSHSessionSettingDataProvider";
ClassName = "OpenDRIM_SSHSessionSettingData";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"ManagedElement", "SettingData", "IsDefault", "IsCurrent", "IsNext", "IsMinimum", "IsMaximum", "IsPending"};
CapabilityID = "SSH_OpenDRIM_SSHSessionSettingData";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SSHSessionSettingData.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SSHSessionSettingData]   
   provider: SSH_OpenDRIM_SSHSessionSettingDataProvider
   location: cmpiSSH_OpenDRIM_SSHSessionSettingDataProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SSHSessionSettingData.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SSHSessionSettingData-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SSHSessionSettingData.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
