/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_LIBRARY_P_H_
#define _GTLFRAGMENT_LIBRARY_P_H_

#include "Compiler_p.h"
#include "Library.h"

#include <GTLCore/CompilationMessages.h>
#include <GTLCore/Debug_thread_p.h>
#include <GTLCore/String.h>
#include <GTLCore/Value.h>

#include "Source.h"

#include <map>

namespace llvm {
  class Function;
  class Module;
}

namespace GTLCore {
  class ModuleData;
  namespace Metadata {
    class Group;
  }
}

namespace GTLFragment {
  struct ParameterInfo {
    GTLCore::Value value;
    GTLCore::String name;
  };
  class LibraryCompilation;
  /**
   * @internal
   * @ingroup GTLFragment
   * Private structure for a @ref Library
   */
  struct Library::Private {    
    Private() : m_moduleData(0), standardLibrary(NotAStdLibrary), libraryCompilation(0)
    {
    }
    void metadataToParameters( const GTLCore::Metadata::Group* );
    void initparameters();
    int createParameter(GTLCore::String _name, GTLCore::Value _value);
    
    GTLCore::String name;
    Source source;
    bool compiled;
    llvm::Module* m_llvmModule;
    GTLCore::ModuleData* m_moduleData;
    int count_channels_generic;
    Type mode;
    WhichStdLibrary standardLibrary;
    std::vector< ParameterInfo > parameters_info;
    std::map< GTLCore::String, int > parameters_name2id;
    GTLCore::CompilationMessages compilationErrors;
    LibraryCompilation* libraryCompilation;
    TEST_GUARD_VARIABLE
  };
}

#endif
