# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1770-1 (imp4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63798);
 script_cve_id("CVE-2008-4182", "CVE-2009-0930");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1770-1 (imp4)";
 script_name(name);

 desc = "The remote host is missing an update to imp4
announced via advisory DSA 1770-1.

Several vulnerabilities have been found in imp4, a webmail component for
the horde framework. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2008-4182

It was discovered that imp4 suffers from a cross-site scripting (XSS)
attack via the user field in an IMAP session, which allows attackers to
inject arbitrary HTML code.

CVE-2009-0930

It was discovered that imp4 is prone to several cross-site scripting
(XSS) attacks via several vectors in the mail code allowing attackers
to inject arbitrary HTML code.

For the oldstable distribution (etch), these problems have been fixed in
version 4.1.3-4etch1.

For the stable distribution (lenny), these problems have been fixed in
version 4.2-4, which was already included in the lenny release.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems have been fixed in version 4.2-4.


We recommend that you upgrade your imp4 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201770-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1770-1 (imp4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imp4", ver:"4.1.3-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
