###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for kernel CESA-2007:1104 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880327);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.1");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "CESA", value: "2007:1104");
  script_cve_id("CVE-2007-4997", "CVE-2007-5494");
  script_name( "CentOS Update for kernel CESA-2007:1104 centos4 i386");
  desc = "

  Vulnerability Insight:
  The kernel packages contain the Linux kernel, the core of any Linux
  operating system. 
  
  These updated packages fix the following security issues:
  
  A flaw was found in the handling of IEEE 802.11 frames, which affected
  several wireless LAN modules. In certain situations, a remote attacker
  could trigger this flaw by sending a malicious packet over a wireless
  network, causing a denial of service (kernel crash).
  (CVE-2007-4997, Important)
  
  A memory leak was found in the Red Hat Content Accelerator kernel patch.
  A local user could use this flaw to cause a denial of service (memory
  exhaustion). (CVE-2007-5494, Important)
  
  Additionally, the following bugs were fixed:
  
  * when running the &quot;ls -la&quot; command on an NFSv4 mount point, incorrect
  file attributes, and outdated file size and timestamp information were
  returned. As well, symbolic links may have been displayed as actual files.
  
  * a bug which caused the cmirror write path to appear deadlocked after a
  successful recovery, which may have caused syncing to hang, has been
  resolved.
  
  * a kernel panic which occurred when manually configuring LCS interfaces on
  the IBM S/390 has been resolved.
  
  * when running a 32-bit binary on a 64-bit system, it was possible to
  mmap page at address 0 without flag MAP_FIXED set. This has been
  resolved in these updated packages.
  
  * the Non-Maskable Interrupt (NMI) Watchdog did not increment the NMI
  interrupt counter in &quot;/proc/interrupts&quot; on systems running an AMD Opteron
  CPU. This caused systems running NMI Watchdog to restart at regular
  intervals.
  
  * a bug which caused the diskdump utility to run very slowly on devices
  using Fusion MPT has been resolved.
  
  All users are advised to upgrade to these updated packages, which resolve
  these issues.


  Affected Software/OS:
  kernel on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2007-December/014550.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS4")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem", rpm:"kernel-hugemem~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-hugemem-devel", rpm:"kernel-hugemem-devel~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU-devel", rpm:"kernel-xenU-devel~2.6.9~67.0.1.EL", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
