###############################################################################
# OpenVAS Vulnerability Test
# $Id: landesk_detect.nasl 7516 2010-05-04 08:24:56Z chandra $
#
# Landesk Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
LANDesk Management Agent is running at this host.

Risk factor : None";

if (description)
{
 script_id(100328);
 script_version ("1.0-$Revision: 7516 $");
 script_tag(name:"risk_factor", value:"None");
 script_name("Landesk Detection");
 script_description(desc);
 script_summary("Checks for the presence of Landesk Management Agent");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports(9595, 9593);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");
include("misc_func.inc");

port  = 9595;
port1 = 9593;

if(!get_port_state(port))exit(0);
if(!get_port_state(port1))exit(0);

soc = open_sock_tcp(port1);
if(!soc)exit(0);
close(soc);

 url = string("/");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 if( buf == NULL )continue;

 if(egrep(pattern: "LANDesk.*Management Agent", string: buf, icase: TRUE))
 {
    set_kb_item(name: string("www/", port, "/landesk"), value: TRUE);
    register_service(port:port,  ipproto:"tcp", proto:"landesk");
    register_service(port:port1, ipproto:"tcp", proto:"landesk");

    if(report_verbosity > 0) {
       security_note(port:port);
       security_note(port:port1);
    }
     exit(0);
 }

exit(0);

