# nnposter
# GPL
# kst-depend-rpc


desc = "
Synopsis :

The remote web server is used to manage a network device. 

Description :

The remote web server is a Packeteer web management interface. 

See also :

http://www.packeteer.com/

Solution :

Filter incoming traffic to this port.

Risk factor :

None";


desc_unencrypted = "
Synopsis :

The remote web server is used to manage a network device. 

Description :

The remote web server is an unencrypted Packeteer web management
interface. 

See also :

http://www.packeteer.com/

Solution :

Consider disabling this port completely and using only HTTPS.  And
filter incoming traffic to this port. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
    {
    script_id(80031);
    script_version ("$Revision: 1.3 $");
    script_tag(name:"cvss_base", value:"5.0");
    script_tag(name:"risk_factor", value:"Medium");

    name="Packeteer Web Management Interface Detection";
    script_name(name);

    script_description(desc);

    summary="Detects Packeteer web management interface";
    script_summary(summary);

    family="Web application abuses";
    script_family(family);

    script_category(ACT_GATHER_INFO);

    script_copyright("This script is Copyright (c) 2006-2007 nnposter");
    script_dependencies("http_version.nasl");
    script_require_ports("Services/www",80);
    exit(0);
    }

# Notes:
# - Does not work with http_keepalive_send_recv() for some reason.
#   Resorting to http_send_recv()


include("http_func.inc");
#include("http_keepalive.inc");
include("misc_func.inc");


port=get_http_port(default:80);
if (!get_tcp_port_state(port)) exit(0);
encaps = get_kb_item("Transports/TCP/"+port);

#resp=http_keepalive_send_recv(port:port,data:http_get(item:"/login.htm",port:port));
resp=http_send_recv(port:port,data:http_get(item:"/login.htm",port:port));
if (!resp) exit(0);

server=egrep(pattern:"^Server: *httpd/1\.",string:resp,icase:TRUE);
cookie=egrep(pattern:"^Set-Cookie: *[^a-z0-9]PScfgstr=",string:resp,icase:TRUE);
if (!server || !cookie) exit(0);

product="(unknown)";
# 8.x product extraction
match=eregmatch(pattern:': ([a-z]+) +Login</title>',string:resp,icase:TRUE);
if (isnull(match))
    # 7.x product extraction
    match=eregmatch(pattern:'\n([a-zA-Z]+) +/login\\.htm\n',string:resp);
if (!isnull(match)) product=match[1];

replace_kb_item(name:"www/packeteer",value:TRUE);
replace_kb_item(name:"www/"+port+"/packeteer",value:product);
if (product=="PacketShaper")
    replace_kb_item(name:"Services/www/"+port+"/embedded",value:TRUE);

issue="A Packeteer "+product+" web management interface is running on this port.";
if (encaps && (encaps >= ENCAPS_SSLv2 && encaps <= ENCAPS_TLSv1))
    {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      issue
    );
    security_warning(port:port,data:report);
    }
else
    {
    report = string(
      desc_unencrypted,
      "\n\n",
      "Plugin output :\n",
      "\n",
      issue
    );
    security_warning(port:port,data:report);
    }
