###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_prochatrooms_detect.nasl 1086 2009-03-30 14:29:24Z mar $
#
# Pro Chat Rooms Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900330);
  script_version("Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Pro Chat Rooms Version Detection");
  desc = "
  Overview: This script detects the installed version of Pro Chat Rooms
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of Pro Chat Rooms");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

pcrPort = get_kb_item("Services/www");
if(!pcrPort){
  exit(0);
}

foreach dir (make_list("/prochatrooms", "/prochatrooms/admin", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:pcrPort);
  rcvRes = http_keepalive_send_recv(port:pcrPort, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) &&
     egrep(pattern:"Pro Chat Rooms", string:rcvRes))
  {
    pcrVer = eregmatch(pattern:"Pro Chat Rooms.* v?([0-9.]\.[0-9.]+)<",
                       string:rcvRes);
    if(pcrVer[1] != NULL)
    {
      set_kb_item(name:"www/"+ pcrPort + "/ProChatRooms",
                  value:pcrVer[1]);
      security_note(data:"Pro Chat Room version " + pcrVer[1] + " running at "+
                         "location " + dir +  " was detected on the host");
    }
    exit(0);
  }
}
