# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:001
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63187);
 script_cve_id("CVE-2008-2380", "CVE-2008-3933", "CVE-2008-3934", "CVE-2008-3963", "CVE-2008-4097", "CVE-2008-4098", "CVE-2008-4225", "CVE-2008-4314", "CVE-2008-4552", "CVE-2008-4575", "CVE-2008-4639", "CVE-2008-4640", "CVE-2008-4641", "CVE-2008-4680", "CVE-2008-4681", "CVE-2008-4682", "CVE-2008-4683", "CVE-2008-4684", "CVE-2008-4685", "CVE-2008-4864", "CVE-2008-5006", "CVE-2008-5031", "CVE-2008-5285", "CVE-2008-5514", "CVE-2008-5517", "CVE-2008-5617", "CVE-2008-5618", "CVE-2009-0022", "CVE-2008-5660");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "SuSE Security Summary SUSE-SR:2009:001 (OpenSuSE 11.0)";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SR:2009:001.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SR:2009:001 (OpenSuSE 11.0)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ConsoleKit", rpm:"ConsoleKit~0.2.10~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ConsoleKit-devel", rpm:"ConsoleKit-devel~0.2.10~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ConsoleKit-x11", rpm:"ConsoleKit-x11~0.2.10~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"GraphicsMagick", rpm:"GraphicsMagick~1.1.11~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"GraphicsMagick-devel", rpm:"GraphicsMagick-devel~1.1.11~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaThunderbird", rpm:"MozillaThunderbird~2.0.0.19~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaThunderbird-devel", rpm:"MozillaThunderbird-devel~2.0.0.19~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaThunderbird-translations", rpm:"MozillaThunderbird-translations~2.0.0.19~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.7.0.r3685~7.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-devel", rpm:"NetworkManager-devel~0.7.0.r3685~7.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-glib", rpm:"NetworkManager-glib~0.7.0.r3685~7.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-gnome", rpm:"NetworkManager-gnome~0.7.0.r729~7.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde", rpm:"NetworkManager-kde~0.7r821737~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde-devel", rpm:"NetworkManager-kde-devel~0.7r821737~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-openvpn-kde", rpm:"NetworkManager-openvpn-kde~0.7r821737~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-vpnc-kde", rpm:"NetworkManager-vpnc-kde~0.7r821737~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org", rpm:"OpenOffice_org~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-base", rpm:"OpenOffice_org-base~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-branding-upstream", rpm:"OpenOffice_org-branding-upstream~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-calc", rpm:"OpenOffice_org-calc~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-devel", rpm:"OpenOffice_org-devel~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-draw", rpm:"OpenOffice_org-draw~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-filters", rpm:"OpenOffice_org-filters~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-gnome", rpm:"OpenOffice_org-gnome~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-icon-themes-prebuilt", rpm:"OpenOffice_org-icon-themes-prebuilt~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-impress", rpm:"OpenOffice_org-impress~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-kde", rpm:"OpenOffice_org-kde~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-mailmerge", rpm:"OpenOffice_org-mailmerge~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-math", rpm:"OpenOffice_org-math~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-mono", rpm:"OpenOffice_org-mono~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-officebean", rpm:"OpenOffice_org-officebean~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-pyuno", rpm:"OpenOffice_org-pyuno~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-sdk", rpm:"OpenOffice_org-sdk~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-sdk-doc", rpm:"OpenOffice_org-sdk-doc~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-testtool", rpm:"OpenOffice_org-testtool~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"OpenOffice_org-writer", rpm:"OpenOffice_org-writer~2.4.0.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit", rpm:"PackageKit~0.2.1~15.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"PackageKit-devel", rpm:"PackageKit-devel~0.2.1~15.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"WebKitGtk", rpm:"WebKitGtk~1.0.29509~49.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"WebKitGtk-devel", rpm:"WebKitGtk-devel~1.0.29509~49.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aaa_base", rpm:"aaa_base~11.0~79.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acl", rpm:"acl~2.2.47~6.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acpid", rpm:"acpid~1.0.6~63.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.3~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aide", rpm:"aide~0.13.1~20.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.8~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.8~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.8~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.8~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-mod_php5", rpm:"apache2-mod_php5~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.8~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-utils", rpm:"apache2-utils~2.2.8~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.8~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs", rpm:"aufs~cvs20080429~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-debug", rpm:"aufs-kmp-debug~cvs20080429_2.6.25.16_0.1~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-default", rpm:"aufs-kmp-default~cvs20080429_2.6.25.16_0.1~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-pae", rpm:"aufs-kmp-pae~cvs20080429_2.6.25.16_0.1~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aufs-kmp-xen", rpm:"aufs-kmp-xen~cvs20080429_2.6.25.16_0.1~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.2~39.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.4.2~39.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.2~39.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.4.2~39.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.4.2~39.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.2~39.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-audio", rpm:"bluez-audio~3.32~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-cups", rpm:"bluez-cups~3.32~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-libs", rpm:"bluez-libs~3.32~3.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-test", rpm:"bluez-test~3.32~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~3.32~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boost", rpm:"boost~1.34.1~42.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boost-devel", rpm:"boost-devel~1.34.1~42.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"boost-doc", rpm:"boost-doc~1.34.1~42.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bytefx-data-mysql", rpm:"bytefx-data-mysql~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cabextract", rpm:"cabextract~1.2~94.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cifs-mount", rpm:"cifs-mount~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.94.2~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.94.2~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"compiz-kde4", rpm:"compiz-kde4~0.7.4~31.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib", rpm:"courier-authlib~0.60.2~40.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-devel", rpm:"courier-authlib-devel~0.60.2~40.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-ldap", rpm:"courier-authlib-ldap~0.60.2~40.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-mysql", rpm:"courier-authlib-mysql~0.60.2~40.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-pgsql", rpm:"courier-authlib-pgsql~0.60.2~40.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-pipe", rpm:"courier-authlib-pipe~0.60.2~40.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"courier-authlib-userdb", rpm:"courier-authlib-userdb~0.60.2~40.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.7~25.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-client", rpm:"cups-client~1.3.7~25.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.7~25.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.7~25.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1", rpm:"dbus-1~1.2.1~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel", rpm:"dbus-1-devel~1.2.1~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel-doc", rpm:"dbus-1-devel-doc~1.2.1~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-x11", rpm:"dbus-1-x11~1.2.1~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"devhelp", rpm:"devhelp~0.19~35.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"devhelp-devel", rpm:"devhelp-devel~0.19~35.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dhcpcd", rpm:"dhcpcd~3.2.3~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"digikam", rpm:"digikam~0.9.3~70.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"digikamimageplugins", rpm:"digikamimageplugins~0.9.3~70.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"digikamimageplugins-superimpose", rpm:"digikamimageplugins-superimpose~0.9.3~70.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dnsmasq", rpm:"dnsmasq~2.45~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd", rpm:"drbd~8.2.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-debug", rpm:"drbd-kmp-debug~8.2.6_2.6.25.9_0.2~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-default", rpm:"drbd-kmp-default~8.2.6_2.6.25.9_0.2~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-pae", rpm:"drbd-kmp-pae~8.2.6_2.6.25.9_0.2~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"drbd-kmp-xen", rpm:"drbd-kmp-xen~8.2.6_2.6.25.9_0.2~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"emacs", rpm:"emacs~22.2~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"emacs-el", rpm:"emacs-el~22.2~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"emacs-info", rpm:"emacs-info~22.2~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"emacs-nox", rpm:"emacs-nox~22.2~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"emacs-x11", rpm:"emacs-x11~22.2~24.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"enscript", rpm:"enscript~1.6.4~124.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"epiphany", rpm:"epiphany~2.22.1.1~25.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"epiphany-devel", rpm:"epiphany-devel~2.22.1.1~25.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"epiphany-doc", rpm:"epiphany-doc~2.22.1.1~25.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"epiphany-extensions", rpm:"epiphany-extensions~2.22.0~37.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"esound", rpm:"esound~0.2.38~75.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~2.22.1.1~11.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-devel", rpm:"evolution-data-server-devel~2.22.1.1~11.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"evolution-data-server-doc", rpm:"evolution-data-server-doc~2.22.1.1~11.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"exiv2", rpm:"exiv2~0.16~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"fileshareset", rpm:"fileshareset~2.0~501.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch", rpm:"finch~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"flash-player", rpm:"flash-player~9.0.152.0~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeradius-server", rpm:"freeradius-server~2.0.5~8.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeradius-server-devel", rpm:"freeradius-server-devel~2.0.5~8.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeradius-server-dialupadmin", rpm:"freeradius-server-dialupadmin~2.0.5~8.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeradius-server-doc", rpm:"freeradius-server-doc~2.0.5~8.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeradius-server-libs", rpm:"freeradius-server-libs~2.0.5~8.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeradius-server-utils", rpm:"freeradius-server-utils~2.0.5~8.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2", rpm:"freetype2~2.3.5~62.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freetype2-devel", rpm:"freetype2-devel~2.3.5~62.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcalctool", rpm:"gcalctool~5.22.1~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git", rpm:"git~1.5.6~43.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-arch", rpm:"git-arch~1.5.6~43.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-core", rpm:"git-core~1.5.6~43.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-cvs", rpm:"git-cvs~1.5.6~43.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-email", rpm:"git-email~1.5.6~43.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-svn", rpm:"git-svn~1.5.6~43.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gitk", rpm:"gitk~1.5.6~43.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-branding-upstream", rpm:"glib2-branding-upstream~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-doc", rpm:"glib2-doc~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-lang", rpm:"glib2-lang~2.16.3~20.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc", rpm:"glibc~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-devel", rpm:"glibc-devel~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-html", rpm:"glibc-html~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-i18ndata", rpm:"glibc-i18ndata~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-info", rpm:"glibc-info~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-locale", rpm:"glibc-locale~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-obsolete", rpm:"glibc-obsolete~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glibc-profile", rpm:"glibc-profile~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-main-menu", rpm:"gnome-main-menu~0.9.10~30.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-main-menu-devel", rpm:"gnome-main-menu-devel~0.9.10~30.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-packagekit", rpm:"gnome-packagekit~0.2.1~15.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-web-photo", rpm:"gnome-web-photo~0.4~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~2.2.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz", rpm:"graphviz~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-devel", rpm:"graphviz-devel~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-doc", rpm:"graphviz-doc~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-gd", rpm:"graphviz-gd~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-gnome", rpm:"graphviz-gnome~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-guile", rpm:"graphviz-guile~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-java", rpm:"graphviz-java~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-lua", rpm:"graphviz-lua~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-ocaml", rpm:"graphviz-ocaml~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-perl", rpm:"graphviz-perl~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-php", rpm:"graphviz-php~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-python", rpm:"graphviz-python~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-ruby", rpm:"graphviz-ruby~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-sharp", rpm:"graphviz-sharp~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"graphviz-tcl", rpm:"graphviz-tcl~2.18~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gvfs", rpm:"gvfs~0.2.3~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gvfs-backends", rpm:"gvfs-backends~0.2.3~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gvfs-devel", rpm:"gvfs-devel~0.2.3~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gvfs-fuse", rpm:"gvfs-fuse~0.2.3~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.11~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-devel", rpm:"hal-devel~0.5.11~8.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-doc", rpm:"hal-doc~0.5.11~9.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"htop", rpm:"htop~0.7~32.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ibm-data-db2", rpm:"ibm-data-db2~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap", rpm:"imap~2006c1_suse~100.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-devel", rpm:"imap-devel~2006c1_suse~100.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imap-lib", rpm:"imap-lib~2006c1_suse~100.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imlib2", rpm:"imlib2~1.4.0~46.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imlib2-devel", rpm:"imlib2-devel~1.4.0~46.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imlib2-filters", rpm:"imlib2-filters~1.4.0~46.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"imlib2-loaders", rpm:"imlib2-loaders~1.4.0~46.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"inn", rpm:"inn~2.4.2~164.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"inn-devel", rpm:"inn-devel~2.4.2~164.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"insserv", rpm:"insserv~1.11.0~31.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.7~61.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"jasper", rpm:"jasper~1.900.1~98.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-gcj-compat", rpm:"java-1_5_0-gcj-compat~1.5.0.0~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-gcj-compat-devel", rpm:"java-1_5_0-gcj-compat-devel~1.5.0.0~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun", rpm:"java-1_5_0-sun~1.5.0_update17~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-alsa", rpm:"java-1_5_0-sun-alsa~1.5.0_update17~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-demo", rpm:"java-1_5_0-sun-demo~1.5.0_update17~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-devel", rpm:"java-1_5_0-sun-devel~1.5.0_update17~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-jdbc", rpm:"java-1_5_0-sun-jdbc~1.5.0_update17~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-plugin", rpm:"java-1_5_0-sun-plugin~1.5.0_update17~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_5_0-sun-src", rpm:"java-1_5_0-sun-src~1.5.0_update17~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun", rpm:"java-1_6_0-sun~1.6.0.u11~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-alsa", rpm:"java-1_6_0-sun-alsa~1.6.0.u11~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-demo", rpm:"java-1_6_0-sun-demo~1.6.0.u11~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-devel", rpm:"java-1_6_0-sun-devel~1.6.0.u11~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-jdbc", rpm:"java-1_6_0-sun-jdbc~1.6.0.u11~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-sun-plugin", rpm:"java-1_6_0-sun-plugin~1.6.0.u11~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"jhead", rpm:"jhead~2.82~11.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-akregator", rpm:"kde4-akregator~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-dolphin", rpm:"kde4-dolphin~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kaddressbook", rpm:"kde4-kaddressbook~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kalarm", rpm:"kde4-kalarm~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdepasswd", rpm:"kde4-kdepasswd~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdialog", rpm:"kde4-kdialog~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdm", rpm:"kde4-kdm~4.0.4~24.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kdm-branding-upstream", rpm:"kde4-kdm-branding-upstream~4.0.4~24.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-keditbookmarks", rpm:"kde4-keditbookmarks~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kfind", rpm:"kde4-kfind~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kinfocenter", rpm:"kde4-kinfocenter~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kmail", rpm:"kde4-kmail~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kmobiletools", rpm:"kde4-kmobiletools~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-knode", rpm:"kde4-knode~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-knotes", rpm:"kde4-knotes~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-konqueror", rpm:"kde4-konqueror~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-konsole", rpm:"kde4-konsole~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kontact", rpm:"kde4-kontact~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-korganizer", rpm:"kde4-korganizer~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-korn", rpm:"kde4-korn~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kpilot", rpm:"kde4-kpilot~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-ktimetracker", rpm:"kde4-ktimetracker~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-ktnef", rpm:"kde4-ktnef~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kwin", rpm:"kde4-kwin~4.0.4~24.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kde4-kwrite", rpm:"kde4-kwrite~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3", rpm:"kdebase3~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-beagle", rpm:"kdebase3-beagle~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-devel", rpm:"kdebase3-devel~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-extra", rpm:"kdebase3-extra~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-kdm", rpm:"kdebase3-kdm~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-nsplugin", rpm:"kdebase3-nsplugin~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-runtime", rpm:"kdebase3-runtime~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-samba", rpm:"kdebase3-samba~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase3-session", rpm:"kdebase3-session~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4", rpm:"kdebase4~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-libkonq", rpm:"kdebase4-libkonq~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-nsplugin", rpm:"kdebase4-nsplugin~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-runtime", rpm:"kdebase4-runtime~4.0.4~20.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace", rpm:"kdebase4-workspace~4.0.4~24.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-branding-upstream", rpm:"kdebase4-workspace-branding-upstream~4.0.4~24.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-devel", rpm:"kdebase4-workspace-devel~4.0.4~24.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-ksysguardd", rpm:"kdebase4-workspace-ksysguardd~4.0.4~24.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdebase4-workspace-plasmoids", rpm:"kdebase4-workspace-plasmoids~4.0.1~71.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs4", rpm:"kdelibs4~4.0.4~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs4-core", rpm:"kdelibs4-core~4.0.4~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs4-doc", rpm:"kdelibs4-doc~4.0.4~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdenetwork3-InstantMessenger", rpm:"kdenetwork3-InstantMessenger~3.5.9~39.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim4", rpm:"kdepim4~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim4-devel", rpm:"kdepim4-devel~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdepim4-wizards", rpm:"kdepim4-wizards~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae", rpm:"kernel-pae~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt", rpm:"kernel-rt~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-rt_debug", rpm:"kernel-rt_debug~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-vanilla", rpm:"kernel-vanilla~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.25.18~0.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kerneloops", rpm:"kerneloops~0.11~19.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kerneloops-applet", rpm:"kerneloops-applet~0.11~19.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kismet", rpm:"kismet~2007_10_R1~60.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"klamav", rpm:"klamav~0.42~54.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kpowersave", rpm:"kpowersave~0.7.3~100.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ktorrent", rpm:"ktorrent~3.0.2~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ktorrent-devel", rpm:"ktorrent-devel~3.0.2~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kvm", rpm:"kvm~63~31.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ldapsmb", rpm:"ldapsmb~1.34b~195.8", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libGraphicsMagick++-devel", rpm:"libGraphicsMagick++-devel~1.1.11~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libGraphicsMagick++1", rpm:"libGraphicsMagick++1~1.1.11~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libGraphicsMagick1", rpm:"libGraphicsMagick1~1.1.11~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libGraphicsMagickWand0", rpm:"libGraphicsMagickWand0~1.1.11~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit-devel", rpm:"libQtWebKit-devel~4.4.0~12.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libQtWebKit4", rpm:"libQtWebKit4~4.4.0~12.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libWebKitGtk0", rpm:"libWebKitGtk0~1.0.29509~49.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libacl", rpm:"libacl~2.2.47~6.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libacl-devel", rpm:"libacl-devel~2.2.47~6.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcdaudio", rpm:"libcdaudio~0.99.12~114.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcdaudio-devel", rpm:"libcdaudio-devel~0.99.12~114.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libdigikam-devel", rpm:"libdigikam-devel~0.9.3~70.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libesd-devel", rpm:"libesd-devel~0.2.38~75.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libesd0", rpm:"libesd0~0.2.38~75.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libexif", rpm:"libexif~0.6.16.2~32.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libexif-devel", rpm:"libexif-devel~0.6.16.2~32.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libexiv2-2", rpm:"libexiv2-2~0.16~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libexiv2-devel", rpm:"libexiv2-devel~0.16~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgadu", rpm:"libgadu~1.8.0~16.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgadu-devel", rpm:"libgadu-devel~1.8.0~16.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-2_0-0", rpm:"libgio-2_0-0~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgio-fam", rpm:"libgio-fam~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libglib-2_0-0", rpm:"libglib-2_0-0~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgmodule-2_0-0", rpm:"libgmodule-2_0-0~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnome", rpm:"libgnome~2.22.0~30.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnome-devel", rpm:"libgnome-devel~2.22.0~30.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnome-doc", rpm:"libgnome-doc~2.22.0~30.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnome-lang", rpm:"libgnome-lang~2.22.0~30.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomecanvas", rpm:"libgnomecanvas~2.20.1.1~42.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomecanvas-devel", rpm:"libgnomecanvas-devel~2.20.1.1~42.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnomecanvas-doc", rpm:"libgnomecanvas-doc~2.20.1.1~42.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-devel", rpm:"libgnutls-devel~2.2.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra-devel", rpm:"libgnutls-extra-devel~2.2.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls-extra26", rpm:"libgnutls-extra26~2.2.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnutls26", rpm:"libgnutls26~2.2.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgobject-2_0-0", rpm:"libgobject-2_0-0~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgthread-2_0-0", rpm:"libgthread-2_0-0~2.16.3~20.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgvfscommon0", rpm:"libgvfscommon0~0.2.3~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libjasper", rpm:"libjasper~1.900.1~98.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libjasper-devel", rpm:"libjasper-devel~1.900.1~98.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkde4", rpm:"libkde4~4.0.4~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkde4-devel", rpm:"libkde4-devel~4.0.4~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdecore4", rpm:"libkdecore4~4.0.4~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdecore4-devel", rpm:"libkdecore4-devel~4.0.4~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdepim4", rpm:"libkdepim4~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkdepim4-devel", rpm:"libkdepim4-devel~4.0.80~9.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkonq4", rpm:"libkonq4~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libkonq4-devel", rpm:"libkonq4-devel~4.0.4~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmysqlclient-devel", rpm:"libmysqlclient-devel~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmysqlclient15", rpm:"libmysqlclient15~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmysqlclient_r15", rpm:"libmysqlclient_r15~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libneon-devel", rpm:"libneon-devel~0.28.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libneon27", rpm:"libneon27~0.28.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnetapi-devel", rpm:"libnetapi-devel~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnetapi0", rpm:"libnetapi0~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libopensc2", rpm:"libopensc2~0.11.4~37.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.26~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng12-0", rpm:"libpng12-0~1.2.26~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-devel", rpm:"libpoppler-devel~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-doc", rpm:"libpoppler-doc~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-glib-devel", rpm:"libpoppler-glib-devel~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-glib3", rpm:"libpoppler-glib3~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-qt2", rpm:"libpoppler-qt2~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-qt3-devel", rpm:"libpoppler-qt3-devel~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-qt4-3", rpm:"libpoppler-qt4-3~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler-qt4-devel", rpm:"libpoppler-qt4-devel~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpoppler3", rpm:"libpoppler3~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpulse-browse0", rpm:"libpulse-browse0~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpulse-devel", rpm:"libpulse-devel~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpulse-mainloop-glib0", rpm:"libpulse-mainloop-glib0~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpulse0", rpm:"libpulse0~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpulsecore4", rpm:"libpulsecore4~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-meanwhile", rpm:"libpurple-meanwhile~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-mono", rpm:"libpurple-mono~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4", rpm:"libqt4~4.4.0~12.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel", rpm:"libqt4-devel~4.4.0~12.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-devel-doc", rpm:"libqt4-devel-doc~4.4.0~12.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-qt3support", rpm:"libqt4-qt3support~4.4.0~12.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql", rpm:"libqt4-sql~4.4.0~12.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-postgresql", rpm:"libqt4-sql-postgresql~4.4.0~5.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-sql-sqlite", rpm:"libqt4-sql-sqlite~4.4.0~12.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libqt4-x11", rpm:"libqt4-x11~4.4.0~12.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-devel", rpm:"libsatsolver-devel~0.9.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-perl", rpm:"libsatsolver-perl~0.9.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsatsolver-ruby", rpm:"libsatsolver-ruby~0.9.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbsharemodes-devel", rpm:"libsmbsharemodes-devel~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbsharemodes0", rpm:"libsmbsharemodes0~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsnmp15", rpm:"libsnmp15~5.4.1~77.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc-devel", rpm:"libtalloc-devel~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc1", rpm:"libtalloc1~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb-devel", rpm:"libtdb-devel~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb1", rpm:"libtdb1~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.8.2~108.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff3", rpm:"libtiff3~3.8.2~108.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt", rpm:"libvirt~0.4.0~59.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-devel", rpm:"libvirt-devel~0.4.0~59.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-doc", rpm:"libvirt-doc~0.4.0~59.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvirt-python", rpm:"libvirt-python~0.4.0~59.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwbclient-devel", rpm:"libwbclient-devel~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwbclient0", rpm:"libwbclient0~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwsman-devel", rpm:"libwsman-devel~2.0.0~3.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwsman1", rpm:"libwsman1~2.0.0~3.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxcrypt", rpm:"libxcrypt~3.0~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxcrypt-devel", rpm:"libxcrypt-devel~3.0~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.6.32~11.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.6.32~11.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-doc", rpm:"libxml2-doc~2.6.32~11.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxslt", rpm:"libxslt~1.1.23~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxslt-devel", rpm:"libxslt-devel~1.1.23~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp", rpm:"libzypp~4.28.0~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libzypp-devel", rpm:"libzypp-devel~4.28.0~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"licq", rpm:"licq~1.3.5.2~19.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"licq-devel", rpm:"licq-devel~1.3.5.2~19.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"licq-qt4-gui", rpm:"licq-qt4-gui~1.3.5.2~19.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd", rpm:"lighttpd~1.4.19~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_cml", rpm:"lighttpd-mod_cml~1.4.19~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_magnet", rpm:"lighttpd-mod_magnet~1.4.19~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_mysql_vhost", rpm:"lighttpd-mod_mysql_vhost~1.4.19~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_rrdtool", rpm:"lighttpd-mod_rrdtool~1.4.19~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_trigger_b4_dl", rpm:"lighttpd-mod_trigger_b4_dl~1.4.19~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lighttpd-mod_webdav", rpm:"lighttpd-mod_webdav~1.4.19~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lvm2", rpm:"lvm2~2.02.33~28.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lvm2-clvm", rpm:"lvm2-clvm~2.02.33~28.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lynx", rpm:"lynx~2.8.6~109.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mailman", rpm:"mailman~2.1.9~159.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mercurial", rpm:"mercurial~1.0~30.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"microcode_ctl", rpm:"microcode_ctl~1.17~78.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mininews", rpm:"mininews~2.4.2~164.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"misc-console-font", rpm:"misc-console-font~3.5.9~65.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mkinitrd", rpm:"mkinitrd~2.2~19.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-complete", rpm:"mono-complete~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-core", rpm:"mono-core~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-data", rpm:"mono-data~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-data-firebird", rpm:"mono-data-firebird~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-data-oracle", rpm:"mono-data-oracle~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-data-postgresql", rpm:"mono-data-postgresql~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-data-sqlite", rpm:"mono-data-sqlite~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-data-sybase", rpm:"mono-data-sybase~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-devel", rpm:"mono-devel~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-extras", rpm:"mono-extras~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-jscript", rpm:"mono-jscript~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-locale-extras", rpm:"mono-locale-extras~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-nunit", rpm:"mono-nunit~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-web", rpm:"mono-web~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mono-winforms", rpm:"mono-winforms~1.9.1~6.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-nspr", rpm:"mozilla-nspr~4.7.1~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-nspr-devel", rpm:"mozilla-nspr-devel~4.7.1~18.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-nss", rpm:"mozilla-nss~3.12.0~23.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-nss-devel", rpm:"mozilla-nss-devel~3.12.0~23.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-nss-tools", rpm:"mozilla-nss-tools~3.12.0~23.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner181", rpm:"mozilla-xulrunner181~1.8.1.19~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner181-devel", rpm:"mozilla-xulrunner181-devel~1.8.1.19~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner181-l10n", rpm:"mozilla-xulrunner181-l10n~1.8.1.19~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.5~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mrtg", rpm:"mrtg~2.16.1~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql", rpm:"mysql~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-Max", rpm:"mysql-Max~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-bench", rpm:"mysql-bench~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-client", rpm:"mysql-client~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-debug", rpm:"mysql-debug~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mysql-tools", rpm:"mysql-tools~5.0.51a~27.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nautilus", rpm:"nautilus~2.22.2~30.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nautilus-devel", rpm:"nautilus-devel~2.22.2~30.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nautilus-gnome-main-menu", rpm:"nautilus-gnome-main-menu~0.9.10~30.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nautilus-lang", rpm:"nautilus-lang~2.22.2~30.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper", rpm:"ndiswrapper~1.52~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper-kmp-default", rpm:"ndiswrapper-kmp-default~1.52_2.6.25.18_0.2~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper-kmp-pae", rpm:"ndiswrapper-kmp-pae~1.52_2.6.25.18_0.2~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ndiswrapper-kmp-xen", rpm:"ndiswrapper-kmp-xen~1.52_2.6.25.18_0.2~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"neon", rpm:"neon~0.28.2~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.4.1~77.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.4.1~77.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-client", rpm:"nfs-client~1.1.2~9.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-doc", rpm:"nfs-doc~1.1.2~9.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nfs-kernel-server", rpm:"nfs-kernel-server~1.1.2~9.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"novell-nortelplugins", rpm:"novell-nortelplugins~0.1.3~54.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nscd", rpm:"nscd~2.8~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nspluginwrapper", rpm:"nspluginwrapper~0.9.91.5.99.20071225~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"obex-data-server", rpm:"obex-data-server~0.3~26.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openldap2", rpm:"openldap2~2.4.9~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openldap2-back-meta", rpm:"openldap2-back-meta~2.4.9~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openldap2-back-perl", rpm:"openldap2-back-perl~2.4.9~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openldap2-client", rpm:"openldap2-client~2.4.9~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openldap2-devel", rpm:"openldap2-devel~2.4.9~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openmotif22-libs", rpm:"openmotif22-libs~2.2.4~149.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc", rpm:"opensc~0.11.4~37.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opensc-devel", rpm:"opensc-devel~0.11.4~37.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openvpn", rpm:"openvpn~2.0.9~96.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openvpn-auth-pam-plugin", rpm:"openvpn-auth-pam-plugin~2.0.9~96.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openvpn-down-root-plugin", rpm:"openvpn-down-root-plugin~2.0.9~96.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openwsman-client", rpm:"openwsman-client~2.0.0~3.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openwsman-python", rpm:"openwsman-python~2.0.0~3.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openwsman-ruby", rpm:"openwsman-ruby~2.0.0~3.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"openwsman-server", rpm:"openwsman-server~2.0.0~3.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opera", rpm:"opera~9.63~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam_krb5", rpm:"pam_krb5~2.2.22~35.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pam_mount", rpm:"pam_mount~0.35~15.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pavucontrol", rpm:"pavucontrol~0.9.6~4.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pcre", rpm:"pcre~7.6~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~7.6~22.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdns", rpm:"pdns~2.9.21~143.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdns-backend-ldap", rpm:"pdns-backend-ldap~2.9.21~143.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdns-backend-mysql", rpm:"pdns-backend-mysql~2.9.21~143.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdns-backend-postgresql", rpm:"pdns-backend-postgresql~2.9.21~143.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdns-backend-sqlite2", rpm:"pdns-backend-sqlite2~2.9.21~143.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdns-backend-sqlite3", rpm:"pdns-backend-sqlite3~2.9.21~143.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pdns-recursor", rpm:"pdns-recursor~3.1.5~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl", rpm:"perl~5.10.0~37.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-GraphicsMagick", rpm:"perl-GraphicsMagick~1.1.11~29.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-SNMP", rpm:"perl-SNMP~5.4.1~77.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Socket6", rpm:"perl-Socket6~0.22~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-base", rpm:"perl-base~5.10.0~37.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-doc", rpm:"perl-doc~5.10.0~37.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5", rpm:"php5~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bcmath", rpm:"php5-bcmath~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-bz2", rpm:"php5-bz2~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-calendar", rpm:"php5-calendar~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ctype", rpm:"php5-ctype~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-curl", rpm:"php5-curl~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dba", rpm:"php5-dba~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dbase", rpm:"php5-dbase~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-devel", rpm:"php5-devel~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-dom", rpm:"php5-dom~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-exif", rpm:"php5-exif~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-fastcgi", rpm:"php5-fastcgi~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ftp", rpm:"php5-ftp~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gd", rpm:"php5-gd~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gettext", rpm:"php5-gettext~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-gmp", rpm:"php5-gmp~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-hash", rpm:"php5-hash~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-iconv", rpm:"php5-iconv~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-imap", rpm:"php5-imap~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-json", rpm:"php5-json~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ldap", rpm:"php5-ldap~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mbstring", rpm:"php5-mbstring~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mcrypt", rpm:"php5-mcrypt~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-mysql", rpm:"php5-mysql~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-ncurses", rpm:"php5-ncurses~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-odbc", rpm:"php5-odbc~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-openssl", rpm:"php5-openssl~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pcntl", rpm:"php5-pcntl~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pdo", rpm:"php5-pdo~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pear", rpm:"php5-pear~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pgsql", rpm:"php5-pgsql~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-posix", rpm:"php5-posix~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-pspell", rpm:"php5-pspell~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-readline", rpm:"php5-readline~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-shmop", rpm:"php5-shmop~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-snmp", rpm:"php5-snmp~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-soap", rpm:"php5-soap~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sockets", rpm:"php5-sockets~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sqlite", rpm:"php5-sqlite~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-suhosin", rpm:"php5-suhosin~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvmsg", rpm:"php5-sysvmsg~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvsem", rpm:"php5-sysvsem~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-sysvshm", rpm:"php5-sysvshm~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tidy", rpm:"php5-tidy~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-tokenizer", rpm:"php5-tokenizer~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-wddx", rpm:"php5-wddx~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlreader", rpm:"php5-xmlreader~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlrpc", rpm:"php5-xmlrpc~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xmlwriter", rpm:"php5-xmlwriter~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-xsl", rpm:"php5-xsl~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zip", rpm:"php5-zip~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php5-zlib", rpm:"php5-zlib~5.2.6~0.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.4.1~28.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"poppler-tools", rpm:"poppler-tools~0.8.2~1.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postfix", rpm:"postfix~2.5.1~28.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postfix-devel", rpm:"postfix-devel~2.5.1~28.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postfix-mysql", rpm:"postfix-mysql~2.5.1~28.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"postfix-postgresql", rpm:"postfix-postgresql~2.5.1~28.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"procinfo", rpm:"procinfo~18~170.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio", rpm:"pulseaudio~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-esound-compat", rpm:"pulseaudio-esound-compat~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-module-bluetooth", rpm:"pulseaudio-module-bluetooth~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-module-gconf", rpm:"pulseaudio-module-gconf~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-module-jack", rpm:"pulseaudio-module-jack~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-module-lirc", rpm:"pulseaudio-module-lirc~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-module-x11", rpm:"pulseaudio-module-x11~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-module-zeroconf", rpm:"pulseaudio-module-zeroconf~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pulseaudio-utils", rpm:"pulseaudio-utils~0.9.10~26.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pure-ftpd", rpm:"pure-ftpd~1.0.21~145.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python", rpm:"python~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-curses", rpm:"python-curses~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-demo", rpm:"python-demo~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-devel", rpm:"python-devel~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-gdbm", rpm:"python-gdbm~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-idle", rpm:"python-idle~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-tk", rpm:"python-tk~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xml", rpm:"python-xml~2.5.2~26.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt4-x11-tools", rpm:"qt4-x11-tools~4.4.0~12.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rsh", rpm:"rsh~0.17~680.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rsh-server", rpm:"rsh-server~0.17~680.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby", rpm:"ruby~1.8.6.p114~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-devel", rpm:"ruby-devel~1.8.6.p114~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-doc-html", rpm:"ruby-doc-html~1.8.6.p114~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-doc-ri", rpm:"ruby-doc-ri~1.8.6.p114~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-examples", rpm:"ruby-examples~1.8.6.p114~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-test-suite", rpm:"ruby-test-suite~1.8.6.p114~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ruby-tk", rpm:"ruby-tk~1.8.6.p114~6.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rubygem-actionpack", rpm:"rubygem-actionpack~1.13.5~71.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rubygem-activerecord", rpm:"rubygem-activerecord~1.15.5~71.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"rxvt-unicode", rpm:"rxvt-unicode~9.02~14.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba", rpm:"samba~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-devel", rpm:"samba-devel~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-krb-printing", rpm:"samba-krb-printing~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.2.4~4.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"satsolver-tools", rpm:"satsolver-tools~0.9.6~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.1.14~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.1.14~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-irc", rpm:"seamonkey-irc~1.1.14~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.1.14~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-spellchecker", rpm:"seamonkey-spellchecker~1.1.14~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-venkman", rpm:"seamonkey-venkman~1.1.14~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"smart", rpm:"smart~0.52~90.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"smart-gui", rpm:"smart-gui~0.52~90.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"smart-ksmarttray", rpm:"smart-ksmarttray~0.52~90.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"snmp-mibs", rpm:"snmp-mibs~5.4.1~77.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"squid", rpm:"squid~2.6.STABLE20~12.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"strongswan", rpm:"strongswan~4.2.1~11.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"strongswan-doc", rpm:"strongswan-doc~4.2.1~11.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sudo", rpm:"sudo~1.6.9p15~13.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"suspend", rpm:"suspend~0.80.20080523~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"systemtap", rpm:"systemtap~0.6~60.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tiff", rpm:"tiff~3.8.2~108.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"timezone", rpm:"timezone~2008h~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tsclient", rpm:"tsclient~0.150~28.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uvcvideo-kmp-debug", rpm:"uvcvideo-kmp-debug~r200_2.6.25.11_0.1~2.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uvcvideo-kmp-default", rpm:"uvcvideo-kmp-default~r200_2.6.25.11_0.1~2.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uvcvideo-kmp-pae", rpm:"uvcvideo-kmp-pae~r200_2.6.25.11_0.1~2.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uvcvideo-kmp-xen", rpm:"uvcvideo-kmp-xen~r200_2.6.25.11_0.1~2.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"valgrind", rpm:"valgrind~3.3.0~43.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"valgrind-devel", rpm:"valgrind-devel~3.3.0~43.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"viewvc", rpm:"viewvc~1.0.5~29.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vinagre", rpm:"vinagre~0.5.1~20.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"vsftpd", rpm:"vsftpd~2.0.6~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.0~17.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-devel", rpm:"wireshark-devel~1.0.0~17.7", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-input-wacom", rpm:"x11-input-wacom~0.7.9~50.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-input-wacom-devel", rpm:"x11-input-wacom-devel~0.7.9~50.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-input-wacom-tools", rpm:"x11-input-wacom-tools~0.7.9~50.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xgl", rpm:"xgl~git_071026~79.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11", rpm:"xorg-x11~7.3~96.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-Xvnc", rpm:"xorg-x11-Xvnc~7.3~110.9", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-video", rpm:"xorg-x11-driver-video~7.3~138.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~7.3~110.9", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-server-extra", rpm:"xorg-x11-server-extra~7.3~110.9", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-server-sdk", rpm:"xorg-x11-server-sdk~7.3~110.9", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xterm", rpm:"xterm~235~12.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-gtk", rpm:"yast2-gtk~2.16.14~1.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-ncurses-pkg", rpm:"yast2-ncurses-pkg~2.16.14~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-pkg-bindings", rpm:"yast2-pkg-bindings~2.16.42~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yast2-qt-pkg", rpm:"yast2-qt-pkg~2.16.48~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yelp", rpm:"yelp~2.22.1~25.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yum", rpm:"yum~3.2.14~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"yum-updatesd", rpm:"yum-updatesd~3.2.14~15.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"zypper", rpm:"zypper~0.11.10~0.3", rls:"openSUSE11.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
