/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <QueryAttributes.h>
#include <DataNode.h>
#include <stdio.h>

//
// Enum conversion methods for QueryAttributes::VarType
//

static const char *VarType_strings[] = {
"Mesh", "Scalar", "Vector", 
"Tensor", "Symmetric_Tensor", "Array", 
"Label", "Material", "Species", 
"Curve", "Unknown"};

std::string
QueryAttributes::VarType_ToString(QueryAttributes::VarType t)
{
    int index = int(t);
    if(index < 0 || index >= 11) index = 0;
    return VarType_strings[index];
}

std::string
QueryAttributes::VarType_ToString(int t)
{
    int index = (t < 0 || t >= 11) ? 0 : t;
    return VarType_strings[index];
}

bool
QueryAttributes::VarType_FromString(const std::string &s, QueryAttributes::VarType &val)
{
    val = QueryAttributes::Mesh;
    for(int i = 0; i < 11; ++i)
    {
        if(s == VarType_strings[i])
        {
            val = (VarType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for QueryAttributes::DataType
//

static const char *DataType_strings[] = {
"ActualData", "OriginalData"};

std::string
QueryAttributes::DataType_ToString(QueryAttributes::DataType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return DataType_strings[index];
}

std::string
QueryAttributes::DataType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return DataType_strings[index];
}

bool
QueryAttributes::DataType_FromString(const std::string &s, QueryAttributes::DataType &val)
{
    val = QueryAttributes::ActualData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == DataType_strings[i])
        {
            val = (DataType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Init utility for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void QueryAttributes::Init()
{
    resultsValue.push_back(0);
    timeStep = 0;
    pipeIndex = -1;
    floatFormat = "%g";
    suppressOutput = false;
    defaultVars.push_back("default");

    QueryAttributes::SelectAll();
}

// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Copy utility for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void QueryAttributes::Copy(const QueryAttributes &obj)
{
    resultsMessage = obj.resultsMessage;
    resultsValue = obj.resultsValue;
    timeStep = obj.timeStep;
    varTypes = obj.varTypes;
    pipeIndex = obj.pipeIndex;
    xUnits = obj.xUnits;
    yUnits = obj.yUnits;
    floatFormat = obj.floatFormat;
    xmlResult = obj.xmlResult;
    suppressOutput = obj.suppressOutput;
    queryInputParams = obj.queryInputParams;
    defaultName = obj.defaultName;
    defaultVars = obj.defaultVars;

    QueryAttributes::SelectAll();
}

// Type map format string
const char *QueryAttributes::TypeMapFormatString = QUERYATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t QueryAttributes::TmfsStruct = {QUERYATTRIBUTES_TMFS};


// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Default constructor for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::QueryAttributes() : 
    AttributeSubject(QueryAttributes::TypeMapFormatString)
{
    QueryAttributes::Init();
}

// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Constructor for the derived classes of QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::QueryAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    QueryAttributes::Init();
}

// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Copy constructor for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::QueryAttributes(const QueryAttributes &obj) : 
    AttributeSubject(QueryAttributes::TypeMapFormatString)
{
    QueryAttributes::Copy(obj);
}

// ****************************************************************************
// Method: QueryAttributes::QueryAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::QueryAttributes(const QueryAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    QueryAttributes::Copy(obj);
}

// ****************************************************************************
// Method: QueryAttributes::~QueryAttributes
//
// Purpose: 
//   Destructor for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes::~QueryAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: QueryAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QueryAttributes& 
QueryAttributes::operator = (const QueryAttributes &obj)
{
    if (this == &obj) return *this;

    QueryAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: QueryAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::operator == (const QueryAttributes &obj) const
{
    // Create the return value
    return ((resultsMessage == obj.resultsMessage) &&
            (resultsValue == obj.resultsValue) &&
            (timeStep == obj.timeStep) &&
            (varTypes == obj.varTypes) &&
            (pipeIndex == obj.pipeIndex) &&
            (xUnits == obj.xUnits) &&
            (yUnits == obj.yUnits) &&
            (floatFormat == obj.floatFormat) &&
            (xmlResult == obj.xmlResult) &&
            (suppressOutput == obj.suppressOutput) &&
            (queryInputParams == obj.queryInputParams) &&
            true /* can ignore defaultName */ &&
            true /* can ignore defaultVars */);
}

// ****************************************************************************
// Method: QueryAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::operator != (const QueryAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: QueryAttributes::TypeName
//
// Purpose: 
//   Type name method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
QueryAttributes::TypeName() const
{
    return "QueryAttributes";
}

// ****************************************************************************
// Method: QueryAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const QueryAttributes *tmp = (const QueryAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: QueryAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new QueryAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: QueryAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the QueryAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
QueryAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new QueryAttributes(*this);
    else
        retval = new QueryAttributes;

    return retval;
}

// ****************************************************************************
// Method: QueryAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QueryAttributes::SelectAll()
{
    Select(ID_resultsMessage,   (void *)&resultsMessage);
    Select(ID_resultsValue,     (void *)&resultsValue);
    Select(ID_timeStep,         (void *)&timeStep);
    Select(ID_varTypes,         (void *)&varTypes);
    Select(ID_pipeIndex,        (void *)&pipeIndex);
    Select(ID_xUnits,           (void *)&xUnits);
    Select(ID_yUnits,           (void *)&yUnits);
    Select(ID_floatFormat,      (void *)&floatFormat);
    Select(ID_xmlResult,        (void *)&xmlResult);
    Select(ID_suppressOutput,   (void *)&suppressOutput);
    Select(ID_queryInputParams, (void *)&queryInputParams);
    Select(ID_defaultName,      (void *)&defaultName);
    Select(ID_defaultVars,      (void *)&defaultVars);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    QueryAttributes defaultObject;
    bool addToParent = false;
    // Create a node for QueryAttributes.
    DataNode *node = new DataNode("QueryAttributes");

    if(completeSave || !FieldsEqual(ID_resultsMessage, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("resultsMessage", resultsMessage));
    }

    if(completeSave || !FieldsEqual(ID_resultsValue, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("resultsValue", resultsValue));
    }

    if(completeSave || !FieldsEqual(ID_timeStep, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeStep", timeStep));
    }

    if(completeSave || !FieldsEqual(ID_varTypes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("varTypes", varTypes));
    }

    if(completeSave || !FieldsEqual(ID_pipeIndex, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("pipeIndex", pipeIndex));
    }

    if(completeSave || !FieldsEqual(ID_xUnits, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xUnits", xUnits));
    }

    if(completeSave || !FieldsEqual(ID_yUnits, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yUnits", yUnits));
    }

    if(completeSave || !FieldsEqual(ID_floatFormat, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("floatFormat", floatFormat));
    }

    if(completeSave || !FieldsEqual(ID_xmlResult, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xmlResult", xmlResult));
    }

    if(completeSave || !FieldsEqual(ID_suppressOutput, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("suppressOutput", suppressOutput));
    }

    if(completeSave || !FieldsEqual(ID_queryInputParams, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("queryInputParams", queryInputParams));
    }

    if(completeSave || !FieldsEqual(ID_defaultName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultName", defaultName));
    }

    if(completeSave || !FieldsEqual(ID_defaultVars, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("defaultVars", defaultVars));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: QueryAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QueryAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("QueryAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("resultsMessage")) != 0)
        SetResultsMessage(node->AsString());
    if((node = searchNode->GetNode("resultsValue")) != 0)
        SetResultsValue(node->AsDoubleVector());
    if((node = searchNode->GetNode("timeStep")) != 0)
        SetTimeStep(node->AsInt());
    if((node = searchNode->GetNode("varTypes")) != 0)
        SetVarTypes(node->AsIntVector());
    if((node = searchNode->GetNode("pipeIndex")) != 0)
        SetPipeIndex(node->AsInt());
    if((node = searchNode->GetNode("xUnits")) != 0)
        SetXUnits(node->AsString());
    if((node = searchNode->GetNode("yUnits")) != 0)
        SetYUnits(node->AsString());
    if((node = searchNode->GetNode("floatFormat")) != 0)
        SetFloatFormat(node->AsString());
    if((node = searchNode->GetNode("xmlResult")) != 0)
        SetXmlResult(node->AsString());
    if((node = searchNode->GetNode("suppressOutput")) != 0)
        SetSuppressOutput(node->AsBool());
    if((node = searchNode->GetNode("queryInputParams")) != 0)
        SetQueryInputParams(node->AsMapNode());
    if((node = searchNode->GetNode("defaultName")) != 0)
        SetDefaultName(node->AsString());
    if((node = searchNode->GetNode("defaultVars")) != 0)
        SetDefaultVars(node->AsStringVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryAttributes::SetResultsMessage(const std::string &resultsMessage_)
{
    resultsMessage = resultsMessage_;
    Select(ID_resultsMessage, (void *)&resultsMessage);
}

void
QueryAttributes::SetResultsValue(const doubleVector &resultsValue_)
{
    resultsValue = resultsValue_;
    Select(ID_resultsValue, (void *)&resultsValue);
}

void
QueryAttributes::SetTimeStep(int timeStep_)
{
    timeStep = timeStep_;
    Select(ID_timeStep, (void *)&timeStep);
}

void
QueryAttributes::SetVarTypes(const intVector &varTypes_)
{
    varTypes = varTypes_;
    Select(ID_varTypes, (void *)&varTypes);
}

void
QueryAttributes::SetPipeIndex(int pipeIndex_)
{
    pipeIndex = pipeIndex_;
    Select(ID_pipeIndex, (void *)&pipeIndex);
}

void
QueryAttributes::SetXUnits(const std::string &xUnits_)
{
    xUnits = xUnits_;
    Select(ID_xUnits, (void *)&xUnits);
}

void
QueryAttributes::SetYUnits(const std::string &yUnits_)
{
    yUnits = yUnits_;
    Select(ID_yUnits, (void *)&yUnits);
}

void
QueryAttributes::SetFloatFormat(const std::string &floatFormat_)
{
    floatFormat = floatFormat_;
    Select(ID_floatFormat, (void *)&floatFormat);
}

void
QueryAttributes::SetXmlResult(const std::string &xmlResult_)
{
    xmlResult = xmlResult_;
    Select(ID_xmlResult, (void *)&xmlResult);
}

void
QueryAttributes::SetSuppressOutput(bool suppressOutput_)
{
    suppressOutput = suppressOutput_;
    Select(ID_suppressOutput, (void *)&suppressOutput);
}

void
QueryAttributes::SetQueryInputParams(const MapNode &queryInputParams_)
{
    queryInputParams = queryInputParams_;
    Select(ID_queryInputParams, (void *)&queryInputParams);
}

void
QueryAttributes::SetDefaultName(const std::string &defaultName_)
{
    defaultName = defaultName_;
    Select(ID_defaultName, (void *)&defaultName);
}

void
QueryAttributes::SetDefaultVars(const stringVector &defaultVars_)
{
    defaultVars = defaultVars_;
    Select(ID_defaultVars, (void *)&defaultVars);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
QueryAttributes::GetResultsMessage() const
{
    return resultsMessage;
}

std::string &
QueryAttributes::GetResultsMessage()
{
    return resultsMessage;
}

const doubleVector &
QueryAttributes::GetResultsValue() const
{
    return resultsValue;
}

doubleVector &
QueryAttributes::GetResultsValue()
{
    return resultsValue;
}

int
QueryAttributes::GetTimeStep() const
{
    return timeStep;
}

const intVector &
QueryAttributes::GetVarTypes() const
{
    return varTypes;
}

intVector &
QueryAttributes::GetVarTypes()
{
    return varTypes;
}

int
QueryAttributes::GetPipeIndex() const
{
    return pipeIndex;
}

const std::string &
QueryAttributes::GetXUnits() const
{
    return xUnits;
}

std::string &
QueryAttributes::GetXUnits()
{
    return xUnits;
}

const std::string &
QueryAttributes::GetYUnits() const
{
    return yUnits;
}

std::string &
QueryAttributes::GetYUnits()
{
    return yUnits;
}

const std::string &
QueryAttributes::GetFloatFormat() const
{
    return floatFormat;
}

std::string &
QueryAttributes::GetFloatFormat()
{
    return floatFormat;
}

const std::string &
QueryAttributes::GetXmlResult() const
{
    return xmlResult;
}

std::string &
QueryAttributes::GetXmlResult()
{
    return xmlResult;
}

bool
QueryAttributes::GetSuppressOutput() const
{
    return suppressOutput;
}

const MapNode &
QueryAttributes::GetQueryInputParams() const
{
    return queryInputParams;
}

MapNode &
QueryAttributes::GetQueryInputParams()
{
    return queryInputParams;
}

const std::string &
QueryAttributes::GetDefaultName() const
{
    return defaultName;
}

std::string &
QueryAttributes::GetDefaultName()
{
    return defaultName;
}

const stringVector &
QueryAttributes::GetDefaultVars() const
{
    return defaultVars;
}

stringVector &
QueryAttributes::GetDefaultVars()
{
    return defaultVars;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
QueryAttributes::SelectResultsMessage()
{
    Select(ID_resultsMessage, (void *)&resultsMessage);
}

void
QueryAttributes::SelectResultsValue()
{
    Select(ID_resultsValue, (void *)&resultsValue);
}

void
QueryAttributes::SelectVarTypes()
{
    Select(ID_varTypes, (void *)&varTypes);
}

void
QueryAttributes::SelectXUnits()
{
    Select(ID_xUnits, (void *)&xUnits);
}

void
QueryAttributes::SelectYUnits()
{
    Select(ID_yUnits, (void *)&yUnits);
}

void
QueryAttributes::SelectFloatFormat()
{
    Select(ID_floatFormat, (void *)&floatFormat);
}

void
QueryAttributes::SelectXmlResult()
{
    Select(ID_xmlResult, (void *)&xmlResult);
}

void
QueryAttributes::SelectQueryInputParams()
{
    Select(ID_queryInputParams, (void *)&queryInputParams);
}

void
QueryAttributes::SelectDefaultName()
{
    Select(ID_defaultName, (void *)&defaultName);
}

void
QueryAttributes::SelectDefaultVars()
{
    Select(ID_defaultVars, (void *)&defaultVars);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: QueryAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_resultsMessage:   return "resultsMessage";
    case ID_resultsValue:     return "resultsValue";
    case ID_timeStep:         return "timeStep";
    case ID_varTypes:         return "varTypes";
    case ID_pipeIndex:        return "pipeIndex";
    case ID_xUnits:           return "xUnits";
    case ID_yUnits:           return "yUnits";
    case ID_floatFormat:      return "floatFormat";
    case ID_xmlResult:        return "xmlResult";
    case ID_suppressOutput:   return "suppressOutput";
    case ID_queryInputParams: return "queryInputParams";
    case ID_defaultName:      return "defaultName";
    case ID_defaultVars:      return "defaultVars";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
QueryAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_resultsMessage:   return FieldType_string;
    case ID_resultsValue:     return FieldType_doubleVector;
    case ID_timeStep:         return FieldType_int;
    case ID_varTypes:         return FieldType_intVector;
    case ID_pipeIndex:        return FieldType_int;
    case ID_xUnits:           return FieldType_string;
    case ID_yUnits:           return FieldType_string;
    case ID_floatFormat:      return FieldType_string;
    case ID_xmlResult:        return FieldType_string;
    case ID_suppressOutput:   return FieldType_bool;
    case ID_queryInputParams: return FieldType_MapNode;
    case ID_defaultName:      return FieldType_string;
    case ID_defaultVars:      return FieldType_stringVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: QueryAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
QueryAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_resultsMessage:   return "string";
    case ID_resultsValue:     return "doubleVector";
    case ID_timeStep:         return "int";
    case ID_varTypes:         return "intVector";
    case ID_pipeIndex:        return "int";
    case ID_xUnits:           return "string";
    case ID_yUnits:           return "string";
    case ID_floatFormat:      return "string";
    case ID_xmlResult:        return "string";
    case ID_suppressOutput:   return "bool";
    case ID_queryInputParams: return "MapNode";
    case ID_defaultName:      return "string";
    case ID_defaultVars:      return "stringVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: QueryAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
QueryAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const QueryAttributes &obj = *((const QueryAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_resultsMessage:
        {  // new scope
        retval = (resultsMessage == obj.resultsMessage);
        }
        break;
    case ID_resultsValue:
        {  // new scope
        retval = (resultsValue == obj.resultsValue);
        }
        break;
    case ID_timeStep:
        {  // new scope
        retval = (timeStep == obj.timeStep);
        }
        break;
    case ID_varTypes:
        {  // new scope
        retval = (varTypes == obj.varTypes);
        }
        break;
    case ID_pipeIndex:
        {  // new scope
        retval = (pipeIndex == obj.pipeIndex);
        }
        break;
    case ID_xUnits:
        {  // new scope
        retval = (xUnits == obj.xUnits);
        }
        break;
    case ID_yUnits:
        {  // new scope
        retval = (yUnits == obj.yUnits);
        }
        break;
    case ID_floatFormat:
        {  // new scope
        retval = (floatFormat == obj.floatFormat);
        }
        break;
    case ID_xmlResult:
        {  // new scope
        retval = (xmlResult == obj.xmlResult);
        }
        break;
    case ID_suppressOutput:
        {  // new scope
        retval = (suppressOutput == obj.suppressOutput);
        }
        break;
    case ID_queryInputParams:
        {  // new scope
        retval = (queryInputParams == obj.queryInputParams);
        }
        break;
    case ID_defaultName:
        {  // new scope
        retval = (defaultName == obj.defaultName);
        }
        break;
    case ID_defaultVars:
        {  // new scope
        retval = (defaultVars == obj.defaultVars);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
QueryAttributes::SetVariables(const stringVector &variables_)
{
   queryInputParams["vars"] = variables_;
}

const std::string &
QueryAttributes::GetName() const
{
    if (queryInputParams.HasEntry("query_name"))
        return queryInputParams.GetEntry("query_name")->AsString();
    return defaultName;
}

std::string &
QueryAttributes::GetName() 
{
    if (queryInputParams.HasEntry("query_name"))
        return queryInputParams.GetEntry("query_name")->AsString();
    return defaultName;
}

const stringVector &
QueryAttributes::GetVariables() const
{
    if (queryInputParams.HasEntry("vars"))
        return queryInputParams.GetEntry("vars")->AsStringVector();
    return defaultVars;
}

stringVector &
QueryAttributes::GetVariables() 
{
    if (queryInputParams.HasEntry("vars"))
        return queryInputParams.GetEntry("vars")->AsStringVector();
    return defaultVars;
}

QueryAttributes::DataType
QueryAttributes::GetDataType() const
{
    if (queryInputParams.HasNumericEntry("data_type"))
        return (QueryAttributes::DataType)queryInputParams.GetEntry("data_type")->ToInt();
    else
        return QueryAttributes::ActualData;
}

void
QueryAttributes::Reset()
{
    resultsMessage  = " ";
    xUnits = "";
    yUnits = "";
    if (!varTypes.empty())
    {
         varTypes.clear();
    }
    if (!resultsValue.empty())
    {
        resultsValue.clear();
        resultsValue.push_back(0.);
    }
    pipeIndex = -1;

    queryInputParams.Reset();
 
    SelectAll();
}

void
QueryAttributes::PrintSelf(ostream &os)
{
    os << "\n" << GetName().c_str() << ":  ";
    os << "selected variables: ";
    stringVector &v = GetVariables();
    for (size_t i = 0; i < v.size(); i++)
        os << v[i].c_str() << "  ";
    os << "\n";
    os << "Results: <" << resultsMessage.c_str() << ">\n";
}

void
QueryAttributes::SetResultsValue(const double val)
{
    resultsValue[0] = val;    
}

void
QueryAttributes::SetResultsValues(const double *vals, const int numVals)
{
    int i;
    resultsValue.clear();
    for (i = 0; i < numVals; ++i)
        resultsValue.push_back(vals[i]);
}

