/***********************************************************************************************************************************
Socket Server

A simple socket server intended to expose services by accepting a socket.
***********************************************************************************************************************************/
#ifndef COMMON_IO_SOCKET_SERVER_H
#define COMMON_IO_SOCKET_SERVER_H

#include "common/io/server.h"
#include "common/io/socket/client.h"
#include "common/time.h"

/***********************************************************************************************************************************
Io server type
***********************************************************************************************************************************/
#define IO_SERVER_SOCKET_TYPE                                       IO_CLIENT_SOCKET_TYPE

/***********************************************************************************************************************************
Statistics constants
***********************************************************************************************************************************/
#define SOCKET_STAT_SERVER                                          "socket.server"         // Servers created
    STRING_DECLARE(SOCKET_STAT_SERVER_STR);

/***********************************************************************************************************************************
Constructors
***********************************************************************************************************************************/
IoServer *sckServerNew(const String *address, unsigned int port, TimeMSec timeout);

#endif
