/*
 * Picviz - Parallel coordinates ploter
 * Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <debug.h>
#include <linuxlist.h>
//#include <plugins.h>
#include <math.h>

#include <picviz.h>


#include <plplot.h>

#define DISPLAY_PC 0
#define DISPLAY_PS 1
#define DISPLAY_BOTH 2
#define DISPLAY_GRANDTOUR 3

void output(pcimage_t *i, char *arg)
{
        struct axis_t *a;
        struct line_t *l;
        struct axisplot_t *axisplot;

        PcvHeight last_y;
	PcvString color;

	PLFLT plx[PICVIZ_MAX_AXES], ply[PICVIZ_MAX_AXES];
	PLFLT epx[PICVIZ_MAX_AXES], epy[PICVIZ_MAX_AXES];

	unsigned long n = 0;
	unsigned int apos = 0;
	unsigned int axisn = 1;

	int j;

	char display = DISPLAY_PC;

	if (arg) {
		if (!strcmp(arg, "ps")) {
			display = DISPLAY_PS;
		} else if (!strcmp(arg,"both")) {
			display = DISPLAY_BOTH;
		} else if (!strcmp(arg,"grandtour")) {
			display = DISPLAY_GRANDTOUR;
		}
	}


	if (display >= DISPLAY_BOTH) {
		plssub(1, 2);
	}

//	plsdev("pngcairo");
	plscolbg(255,255,255);
	plinit();

        llist_for_each_entry(a, &i->axes, list) {
		n++;
        }


	if ( display != DISPLAY_PS) {
		const char *label;

		plenv(0, n-1, 0, i->height + i->header_height, 0, -2);
		plscol0(0, 0,0,0); // Workaround plcol(0) that must be black but replaced with the background color!! (which is white)
		plcol0(0); // Lines in black

		/* Axes */
		llist_for_each_entry(a, &i->axes, list) {
			pljoin(a->id, 0, a->id, i->height);
			label = picviz_properties_get(a->props, "label");
			if (label) {
				plptex(a->id, i->height + i->header_height, 0, 0, 0, label);
			}
		}

		/* Lines */
		llist_for_each_entry(l, &i->lines, list) {
			apos = 0;
			axisn=0;

			if (!l->hidden) {
				llist_for_each_entry(axisplot, &l->axisplot, list) {
					plx[apos] = axisn;
					ply[apos] = axisplot->y;

					apos++;
					axisn++;
				}

				color = picviz_properties_get(l->props, "color");

				if (!strcmp(color, "#FF0000")) {
					plcol0(1); /* red */
				}
				if (!strcmp(color, "#00FF00")) {
					plcol0(3); /* green */
				}
				if (!strcmp(color, "#0FF000")) {
					plcol0(3); /* green */
				}
				if (!strcmp(color, "#0000FF")) {
					plcol0(9); /* blue */
				}

				plwid(atoi(picviz_properties_get(l->props, "penwidth")));

				plline(apos, plx, ply);
				plcol0(0);
			}
		}
	}

	if ( display != DISPLAY_PC) {
		j = 0;
		plenv(-0.5, n-0.5, 0, i->height, 0, -2);

		plcol0(3); // Lines in green
		pljoin(-0.5,0,-0.5,i->height);


		llist_for_each_entry(l, &i->lines, list) {
			if (!l->hidden) {
				/* Draw red axis */
				plcol0(1); // Lines in red
				pljoin(j,0,j,i->height);
				plcol0(3); // Lines in green
				pljoin(j+0.5,0,j+0.5,i->height);
				plcol0(0); // Lines in black

				apos = 0;
				last_y = i->height/2;
				llist_for_each_entry(axisplot, &l->axisplot, list) {
					epy[apos] = axisplot->y;
					epx[apos] = (double)apos + 1.0/M_PI * (double)atan((double)((double)axisplot->y - (double)last_y)/(double)i->height);

					last_y = axisplot->y;
					apos++;
				}
				plpoin(apos,epx,epy,1);

				j++;
			}
		}

		plcol0(1); // Lines in red
		pljoin(j,0,j,i->height);
		plcol0(3); // Lines in green
		pljoin(j+0.5,0,j+0.5,i->height);
	}

	plend();

	if ( display == DISPLAY_GRANDTOUR ) {
		char buf[500];
		char *strings[PICVIZ_MAX_AXES];
		unsigned int nbaxes = 0;
		unsigned int first = 0;
		unsigned int second = 0;

		llist_for_each_entry(a, &i->axes, list) {
			strings[nbaxes] = picviz_properties_get(a->props, "label");
			nbaxes++;
		}

		for (;first<nbaxes;first++) {
			for (;second<nbaxes;second++) {
				if ( first != second) {
					plssub(1, 2);
					plsdev("pngcairo");

					sprintf(buf, "%s-%s.png", strings[first], strings[second]);
					plsfnam(buf);
					plscolbg(255,255,255);
					plinit();

					/* Yes, this is duplicated code but I'll do better latter! */
					/************
					 * Start: PC
					 ************/
					plenv(0, 1, 0, i->height + i->header_height, 0, -2);
					plscol0(0, 0,0,0); // Workaround plcol(0) that must be black but replaced with the background color!! (which is white)
					plcol0(0); // Lines in black

					pljoin(0,0,0,i->height);
					pljoin(1,0,1,i->height);

					/* Lines */
					llist_for_each_entry(l, &i->lines, list) {
						if (!l->hidden) {
							llist_for_each_entry(axisplot, &l->axisplot, list) {
								if ( axisplot->axis_id == first+1 ) {
									plx[0] = 0;
									ply[0] = axisplot->y;
								}
								if ( axisplot->axis_id == second+1 ) {
									plx[1] = 1;
									ply[1] = axisplot->y;
								}
							}

							if (!strcmp(picviz_properties_get(l->props, "color"), "#FF0000")) {
								plcol0(1); /* red */
							}
							if (!strcmp(picviz_properties_get(l->props, "color"), "#00FF00")) {
								plcol0(3); /* green */
							}
							if (!strcmp(picviz_properties_get(l->props, "color"), "#0000FF")) {
								plcol0(9); /* blue */
							}

							plline(2, plx, ply);
							plcol0(0);
							}
					}

					/**********
					 * End: PC
					 **********/
					/***********
					 * Start: PS
					 ***********/
					plenv(-0.5, 1.5, 0, i->height, 0, -2);

					plcol0(3); // Lines in green
					pljoin(-0.5,0,-0.5,i->height);
					pljoin(0.5,0,0.5,i->height);
					pljoin(1.5,0,1.5,i->height);
					plcol0(1); // Lines in red
					pljoin(0,0,0,i->height);
					pljoin(1,0,1,i->height);
					plcol0(0); // Lines in black

					llist_for_each_entry(l, &i->lines, list) {
						if (!l->hidden) {
							last_y = i->height/2;
							llist_for_each_entry(axisplot, &l->axisplot, list) {
								if ( axisplot->axis_id == first+1 ) {
									epy[0] = axisplot->y;
									epx[0] = (double) 1.0/M_PI * (double)atan((double)((double)axisplot->y - (double)last_y)/(double)i->height);
								}
								if ( axisplot->axis_id == second+1 ) {
									epy[1] = axisplot->y;
									epx[1] = (double) 1 + 1.0/M_PI * (double)atan((double)((double)axisplot->y - (double)last_y)/(double)i->height);
								}

								last_y = axisplot->y;
							}
							plpoin(apos,epx,epy,1);

							j++;
						}
					}

					/**********
					 * End: PS
					 **********/
					plend();
					printf("File %s written\n", buf);
				}
			}
			second = 0;
		}

	}

}


