/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

%{
#include <src/messages/messages/compilateur/global.h>

#include <src/messages/messages/compilateur/localisationfichier.h>

#include <src/messages/messages/compilateur/syntaxique.h>

extern LocalisationFichier *localisation;

extern Chaine racinesources;

typedef struct pilebuffer PileBuffer;

struct pilebuffer
{
	YY_BUFFER_STATE buffer;
	PileBuffer *suivant;
};

PileBuffer *pile=NULL;

Resultat buffer_empile()
{
	PileBuffer *nouveau;
	if((nouveau=(PileBuffer*)(malloc(sizeof(PileBuffer))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	nouveau->buffer=YY_CURRENT_BUFFER;
	nouveau->suivant=pile;
	pile=nouveau;
	return RESULTAT_OK;
}

Resultat buffer_depile()
{
	PileBuffer *ancien;
	if(pile==NULL)
		return RESULTAT_ERREUR;
	ancien=pile;
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(ancien->buffer);
	pile=ancien->suivant;
	free(ancien);
	return RESULTAT_OK;
}

%}

%option nounput

%%

#" "			{
				return TOKEN_ESPACE;
			}
#\t			{
				return TOKEN_TAB;
			}
#\{			{
				return TOKEN_ACCOUV;
			}
#\}			{
				return TOKEN_ACCFER;
			}
##			{
				return TOKEN_DIESE;
			}
#\n			{
			}

#output			{
				return TOKEN_OUTPUT;
			}
#function		{
				return TOKEN_FUNCTION;
			}
#lang			{
				return TOKEN_LANG;
			}
#charset		{
				return TOKEN_CHARSET;
			}
#mesg			{
				return TOKEN_MESG;
			}
#end			{
				return TOKEN_FIN;
			}
#default_lang		{
				return TOKEN_DEFAUT_LANG;
			}
#default_charset	{
				return TOKEN_DEFAUT_CHARSET;
			}
#default_mesg		{
				return TOKEN_DEFAUT_MESG;
			}
#[0-9]+			{
				yylval._Entier=atoi(yytext+1)-1;
				return TOKEN_PARAM;
			}

#include[ \t\n]+[^\n]+	{
				Chaine include , fichier , fichierreel;
				DescripteurFichier fichierinclus;
				DEBUTZONESECURISEE
				if((include=(Chaine)(strdup((char*)(yytext))))==NULL)
					return RESULTAT_ERREUR_MEMOIRE;
				fichier=include+8;
				while((*fichier==' ')||(*fichier=='\t')||(*fichier=='\n'))
					fichier++;
				if((fichierreel=(Chaine)(malloc(strlen(racinesources)+strlen(fichier)+1)))==NULL)
					return 1;
				strcpy(fichierreel,racinesources);
				strcat(fichierreel,fichier);
				if((fichierinclus=fopen(fichierreel,"r"))==NULL)
				{
					printf("Et on ne lit pas le fichier %s !\n",fichierreel);
				}
				else
				{
					SECURISE(localisationfichier_ajout(&localisation,fichier,NULL,fichierinclus,0));
					yyin=fichierinclus;
					SECURISE(buffer_empile());
					yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
				}
				free(include);
				free(fichierreel);
				FINZONESECURISEE
			}

\{[^\n \t}]*\}		{
				yylval._Chaine=strdup(yytext+1);
				yylval._Chaine[strlen(yylval._Chaine)-1]='\0';
				return TOKEN_PARAM_NOM;
			}
\{[^}]*\}		{
				yylval._Chaine=strdup(yytext+1);
				yylval._Chaine[strlen(yylval._Chaine)-1]='\0';
				return TOKEN_PARAM_FICHIER;
			}
[^#{ \t\n\/][^#\n]*	{
				yylval._Chaine=strdup(yytext);
				return TOKEN_TEXTE;
			}
[ \t\n]*		{
			}
#pass[^\n]*		{
				printf("%s\n",yytext+1);
				fflush(stdout);
			}
\/[^\n]*\n		{
			}

%%

int yywrap( void )
{
	Booleen vide;
	DEBUTZONESECURISEE
	fclose(yyin);
	SECURISE(localisationfichier_retrait(&localisation));
	SECURISE(localisationfichier_vide(localisation,&vide));
	if(vide==VRAI)
		return 1;
	SECURISE(localisationfichier_lecture_descripteur(localisation,&yyin));
	SECURISE(buffer_depile());
	return 0;
	FINZONESECURISEE
}
