/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2009-2010 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef TASKBUTTONFRAMESVG_H
#define TASKBUTTONFRAMESVG_H

#include <plasma/framesvg.h>

class QRectF;

namespace SmoothTasks {

class TaskbuttonFrameSvg : public ::Plasma::FrameSvg
{
	Q_OBJECT
	
public:
	TaskbuttonFrameSvg(QObject *parent = 0);
	virtual ~TaskbuttonFrameSvg() {};
	
	virtual void getMaximalMargins(qreal &left, qreal &top, qreal &right, qreal &bottom);
	virtual QRectF minimalContentsRect();
	
	virtual void getMaximalMarginsCustom(qreal &left, qreal &top, qreal &right, qreal &bottom);
	virtual QRectF minimalContentsRectCustom();
	
	virtual void setCustomMargins(const qreal &left, const qreal &top, const qreal &right, const qreal &bottom);
	virtual qreal customMarginSize(const Plasma::MarginEdge edge) const;
	virtual void enableCustomMargins(const bool &enable);
	virtual bool customMarginsEnabled() const { return m_customMargins; };
	
	virtual QRectF contentsRectCustom() const;
	virtual void getMarginsCustom(qreal &left, qreal &top, qreal &right, qreal &bottom) const;
	virtual qreal marginSizeCustom(const Plasma::MarginEdge edge) const;
	
private:
	bool  m_customMargins;
	qreal m_customMarginLeft;
	qreal m_customMarginTop;
	qreal m_customMarginRight;
	qreal m_customMarginBottom;
};

}

#endif // TASKBUTTONFRAMESVG_H
