/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Misc functions used to handle system accounts
 *
 * Copyright (C) 2006 Isak Savo
 */

#ifndef __SYSTEM_ACCOUNTS_H__
#define __SYSTEM_ACCOUNTS_H__
#include <glib.h>

/* Represents a system account (i.e. passwd or group entry) */
typedef struct
{
	guint id;
	gchar *name;
} SystemAccount;

GList *sys_get_user_ids (void);
GList *sys_get_group_ids (void);
//GList *sys_get_user_ids_str (void);
//GList *sys_get_group_ids_str (void);
gboolean sys_get_uid_exists(guint uid);
gboolean sys_get_gid_exists(guint gid);
guint sys_get_available_user_id (guint min_id);
guint sys_get_available_group_id (guint min_id);
gboolean sys_create_user (const gchar *username, guint userid, guint groupid, GError **err);

/* Creates a new group with the specified name and id. If 'groupid' is 0, the groupadd command will pick one instead. */
gboolean sys_create_group (const gchar *groupname, guint groupid, GError **err);
/* Frees one SystemAccount object */
void system_account_free(SystemAccount *account);
/* Frees a GList containing SystemAccount objects */
void system_account_list_free (GList *list);

#endif /* __SYSTEM_ACCOUNTS_H__ */
