#!/usr/bin/python

"""Routines to manage pwrkap device/meter discovery."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import default_domain
import traceback
import sys

# List of drivers and discovery functions
PWRKAP_DRIVERS = ["acpi_meter", "sysfs_meter", "cpu_device", "ibm_domain", "ipmi_meter"]
PWRKAP_DEVICE_DISCOVERY = []
PWRKAP_METER_DISCOVERY = []
PWRKAP_POWER_DOMAIN_DISCOVERY = []

# List of devices
PWRKAP_DEVICES = []
PWRKAP_POWER_METERS = []
PWRKAP_ENERGY_METERS = []
PWRKAP_DEVICE_DOMAINS = []
PWRKAP_POWER_DOMAINS = []

def load_pwrkap_drivers():
	"""Load all known pwrkap drivers."""
	global PWRKAP_DRIVERS

	for driver in PWRKAP_DRIVERS:
		__import__(driver)

def discover_devices():
	"""Discover power-managed devices."""
	global PWRKAP_DEVICE_DISCOVERY

	for func in PWRKAP_DEVICE_DISCOVERY:
		func()

def discover_meters():
	"""Discover power meters."""
	global PWRKAP_METER_DISCOVERY

	for func in PWRKAP_METER_DISCOVERY:
		try:
			func()
		except Exception, e:
			traceback.print_exc()
			pass

def discover_power_domains():
	"""Discover power domains."""
	global PWRKAP_POWER_DOMAIN_DISCOVERY, PWRKAP_POWER_DOMAINS

	for func in PWRKAP_POWER_DOMAIN_DISCOVERY:
		func()

	default_domain.default_system_discover()

	if len(PWRKAP_POWER_DOMAINS) < 1:
		print "No power domains found."
		sys.exit(1)

	# Now remove domains that aren't reporting power use
	dead_domains = []
	for pdom in PWRKAP_POWER_DOMAINS:
		if pdom.get_energy_use() == None or \
		   pdom.get_power_use() == None:
			dead_domains.append(pdom)
	for pdom in dead_domains:
		PWRKAP_POWER_DOMAINS.remove(pdom)

	if len(PWRKAP_POWER_DOMAINS) < 1:
		print "No working power domains found."
		sys.exit(1)

def find_domain_by_name(name):
	"""Find a domain by name."""
	for dom in PWRKAP_POWER_DOMAINS:
		if dom.name() == name:
			return dom

	return None
