# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Resource(msrest.serialization.Model):
    """Represents an instance of an PowerBI Dedicated resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: An identifier that represents the PowerBI Dedicated resource.
    :vartype id: str
    :ivar name: The name of the PowerBI Dedicated resource.
    :vartype name: str
    :ivar type: The type of the PowerBI Dedicated resource.
    :vartype type: str
    :param location: Required. Location of the PowerBI Dedicated resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional resource provisioning properties.
    :type tags: dict[str, str]
    :param system_data: Metadata pertaining to creation and last modification of the resource.
    :type system_data: ~azure.mgmt.powerbidedicated.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.system_data = kwargs.get('system_data', None)


class AutoScaleVCore(Resource):
    """Represents an instance of an auto scale v-core resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: An identifier that represents the PowerBI Dedicated resource.
    :vartype id: str
    :ivar name: The name of the PowerBI Dedicated resource.
    :vartype name: str
    :ivar type: The type of the PowerBI Dedicated resource.
    :vartype type: str
    :param location: Required. Location of the PowerBI Dedicated resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional resource provisioning properties.
    :type tags: dict[str, str]
    :param system_data: Metadata pertaining to creation and last modification of the resource.
    :type system_data: ~azure.mgmt.powerbidedicated.models.SystemData
    :param sku: Required. The SKU of the auto scale v-core resource.
    :type sku: ~azure.mgmt.powerbidedicated.models.AutoScaleVCoreSku
    :param capacity_limit: The maximum capacity of an auto scale v-core resource.
    :type capacity_limit: int
    :param capacity_object_id: The object ID of the capacity resource associated with the auto
     scale v-core resource.
    :type capacity_object_id: str
    :ivar provisioning_state: The current deployment state of an auto scale v-core resource. The
     provisioningState is to indicate states for resource provisioning. Possible values include:
     "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.powerbidedicated.models.VCoreProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'AutoScaleVCoreSku'},
        'capacity_limit': {'key': 'properties.capacityLimit', 'type': 'int'},
        'capacity_object_id': {'key': 'properties.capacityObjectId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoScaleVCore, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.capacity_limit = kwargs.get('capacity_limit', None)
        self.capacity_object_id = kwargs.get('capacity_object_id', None)
        self.provisioning_state = None


class AutoScaleVCoreListResult(msrest.serialization.Model):
    """An array of auto scale v-core resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. An array of auto scale v-core resources.
    :type value: list[~azure.mgmt.powerbidedicated.models.AutoScaleVCore]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutoScaleVCore]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoScaleVCoreListResult, self).__init__(**kwargs)
        self.value = kwargs['value']


class AutoScaleVCoreMutableProperties(msrest.serialization.Model):
    """An object that represents a set of mutable auto scale v-core resource properties.

    :param capacity_limit: The maximum capacity of an auto scale v-core resource.
    :type capacity_limit: int
    """

    _attribute_map = {
        'capacity_limit': {'key': 'capacityLimit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoScaleVCoreMutableProperties, self).__init__(**kwargs)
        self.capacity_limit = kwargs.get('capacity_limit', None)


class AutoScaleVCoreProperties(AutoScaleVCoreMutableProperties):
    """Properties of an auto scale v-core resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param capacity_limit: The maximum capacity of an auto scale v-core resource.
    :type capacity_limit: int
    :param capacity_object_id: The object ID of the capacity resource associated with the auto
     scale v-core resource.
    :type capacity_object_id: str
    :ivar provisioning_state: The current deployment state of an auto scale v-core resource. The
     provisioningState is to indicate states for resource provisioning. Possible values include:
     "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.powerbidedicated.models.VCoreProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'capacity_limit': {'key': 'capacityLimit', 'type': 'int'},
        'capacity_object_id': {'key': 'capacityObjectId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoScaleVCoreProperties, self).__init__(**kwargs)
        self.capacity_object_id = kwargs.get('capacity_object_id', None)
        self.provisioning_state = None


class AutoScaleVCoreSku(msrest.serialization.Model):
    """Represents the SKU name and Azure pricing tier for auto scale v-core resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the SKU level.
    :type name: str
    :param tier: The name of the Azure pricing tier to which the SKU applies. Possible values
     include: "AutoScale".
    :type tier: str or ~azure.mgmt.powerbidedicated.models.VCoreSkuTier
    :param capacity: The capacity of an auto scale v-core resource.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoScaleVCoreSku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class AutoScaleVCoreUpdateParameters(msrest.serialization.Model):
    """Update request specification.

    :param sku: The SKU of the auto scale v-core resource.
    :type sku: ~azure.mgmt.powerbidedicated.models.AutoScaleVCoreSku
    :param tags: A set of tags. Key-value pairs of additional provisioning properties.
    :type tags: dict[str, str]
    :param capacity_limit: The maximum capacity of an auto scale v-core resource.
    :type capacity_limit: int
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'AutoScaleVCoreSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'capacity_limit': {'key': 'properties.capacityLimit', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoScaleVCoreUpdateParameters, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.capacity_limit = kwargs.get('capacity_limit', None)


class CapacitySku(msrest.serialization.Model):
    """Represents the SKU name and Azure pricing tier for PowerBI Dedicated capacity resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the SKU level.
    :type name: str
    :param tier: The name of the Azure pricing tier to which the SKU applies. Possible values
     include: "PBIE_Azure", "Premium", "AutoPremiumHost".
    :type tier: str or ~azure.mgmt.powerbidedicated.models.CapacitySkuTier
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapacitySku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)


class CheckCapacityNameAvailabilityParameters(msrest.serialization.Model):
    """Details of capacity name request body.

    :param name: Name for checking availability.
    :type name: str
    :param type: The resource type of PowerBI dedicated.
    :type type: str
    """

    _validation = {
        'name': {'max_length': 63, 'min_length': 3, 'pattern': r'^[a-z][a-z0-9]*$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckCapacityNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', "Microsoft.PowerBIDedicated/capacities")


class CheckCapacityNameAvailabilityResult(msrest.serialization.Model):
    """The checking result of capacity name availability.

    :param name_available: Indicator of availability of the capacity name.
    :type name_available: bool
    :param reason: The reason of unavailability.
    :type reason: str
    :param message: The detailed message of the request unavailability.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckCapacityNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class DedicatedCapacities(msrest.serialization.Model):
    """An array of Dedicated capacities resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. An array of Dedicated capacities resources.
    :type value: list[~azure.mgmt.powerbidedicated.models.DedicatedCapacity]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DedicatedCapacity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedCapacities, self).__init__(**kwargs)
        self.value = kwargs['value']


class DedicatedCapacity(Resource):
    """Represents an instance of a Dedicated Capacity resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: An identifier that represents the PowerBI Dedicated resource.
    :vartype id: str
    :ivar name: The name of the PowerBI Dedicated resource.
    :vartype name: str
    :ivar type: The type of the PowerBI Dedicated resource.
    :vartype type: str
    :param location: Required. Location of the PowerBI Dedicated resource.
    :type location: str
    :param tags: A set of tags. Key-value pairs of additional resource provisioning properties.
    :type tags: dict[str, str]
    :param system_data: Metadata pertaining to creation and last modification of the resource.
    :type system_data: ~azure.mgmt.powerbidedicated.models.SystemData
    :param sku: Required. The SKU of the PowerBI Dedicated capacity resource.
    :type sku: ~azure.mgmt.powerbidedicated.models.CapacitySku
    :param administration: A collection of Dedicated capacity administrators.
    :type administration: ~azure.mgmt.powerbidedicated.models.DedicatedCapacityAdministrators
    :param mode: The capacity mode. Possible values include: "Gen1", "Gen2".
    :type mode: str or ~azure.mgmt.powerbidedicated.models.Mode
    :ivar state: The current state of PowerBI Dedicated resource. The state is to indicate more
     states outside of resource provisioning. Possible values include: "Deleting", "Succeeded",
     "Failed", "Paused", "Suspended", "Provisioning", "Updating", "Suspending", "Pausing",
     "Resuming", "Preparing", "Scaling".
    :vartype state: str or ~azure.mgmt.powerbidedicated.models.State
    :ivar provisioning_state: The current deployment state of PowerBI Dedicated resource. The
     provisioningState is to indicate states for resource provisioning. Possible values include:
     "Deleting", "Succeeded", "Failed", "Paused", "Suspended", "Provisioning", "Updating",
     "Suspending", "Pausing", "Resuming", "Preparing", "Scaling".
    :vartype provisioning_state: str or
     ~azure.mgmt.powerbidedicated.models.CapacityProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'CapacitySku'},
        'administration': {'key': 'properties.administration', 'type': 'DedicatedCapacityAdministrators'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedCapacity, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.administration = kwargs.get('administration', None)
        self.mode = kwargs.get('mode', None)
        self.state = None
        self.provisioning_state = None


class DedicatedCapacityAdministrators(msrest.serialization.Model):
    """An array of administrator user identities.

    :param members: An array of administrator user identities.
    :type members: list[str]
    """

    _attribute_map = {
        'members': {'key': 'members', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedCapacityAdministrators, self).__init__(**kwargs)
        self.members = kwargs.get('members', None)


class DedicatedCapacityMutableProperties(msrest.serialization.Model):
    """An object that represents a set of mutable Dedicated capacity resource properties.

    :param administration: A collection of Dedicated capacity administrators.
    :type administration: ~azure.mgmt.powerbidedicated.models.DedicatedCapacityAdministrators
    :param mode: The capacity mode. Possible values include: "Gen1", "Gen2".
    :type mode: str or ~azure.mgmt.powerbidedicated.models.Mode
    """

    _attribute_map = {
        'administration': {'key': 'administration', 'type': 'DedicatedCapacityAdministrators'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedCapacityMutableProperties, self).__init__(**kwargs)
        self.administration = kwargs.get('administration', None)
        self.mode = kwargs.get('mode', None)


class DedicatedCapacityProperties(DedicatedCapacityMutableProperties):
    """Properties of Dedicated Capacity resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param administration: A collection of Dedicated capacity administrators.
    :type administration: ~azure.mgmt.powerbidedicated.models.DedicatedCapacityAdministrators
    :param mode: The capacity mode. Possible values include: "Gen1", "Gen2".
    :type mode: str or ~azure.mgmt.powerbidedicated.models.Mode
    :ivar state: The current state of PowerBI Dedicated resource. The state is to indicate more
     states outside of resource provisioning. Possible values include: "Deleting", "Succeeded",
     "Failed", "Paused", "Suspended", "Provisioning", "Updating", "Suspending", "Pausing",
     "Resuming", "Preparing", "Scaling".
    :vartype state: str or ~azure.mgmt.powerbidedicated.models.State
    :ivar provisioning_state: The current deployment state of PowerBI Dedicated resource. The
     provisioningState is to indicate states for resource provisioning. Possible values include:
     "Deleting", "Succeeded", "Failed", "Paused", "Suspended", "Provisioning", "Updating",
     "Suspending", "Pausing", "Resuming", "Preparing", "Scaling".
    :vartype provisioning_state: str or
     ~azure.mgmt.powerbidedicated.models.CapacityProvisioningState
    """

    _validation = {
        'state': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'administration': {'key': 'administration', 'type': 'DedicatedCapacityAdministrators'},
        'mode': {'key': 'mode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedCapacityProperties, self).__init__(**kwargs)
        self.state = None
        self.provisioning_state = None


class DedicatedCapacityUpdateParameters(msrest.serialization.Model):
    """Provision request specification.

    :param sku: The SKU of the Dedicated capacity resource.
    :type sku: ~azure.mgmt.powerbidedicated.models.CapacitySku
    :param tags: A set of tags. Key-value pairs of additional provisioning properties.
    :type tags: dict[str, str]
    :param administration: A collection of Dedicated capacity administrators.
    :type administration: ~azure.mgmt.powerbidedicated.models.DedicatedCapacityAdministrators
    :param mode: The capacity mode. Possible values include: "Gen1", "Gen2".
    :type mode: str or ~azure.mgmt.powerbidedicated.models.Mode
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'CapacitySku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'administration': {'key': 'properties.administration', 'type': 'DedicatedCapacityAdministrators'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DedicatedCapacityUpdateParameters, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.administration = kwargs.get('administration', None)
        self.mode = kwargs.get('mode', None)


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param error: The error object.
    :type error: ~azure.mgmt.powerbidedicated.models.ErrorResponseError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseError(msrest.serialization.Model):
    """The error object.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Operation(msrest.serialization.Model):
    """Capacities REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.powerbidedicated.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.PowerBIDedicated.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: capacity, etc.
    :vartype resource: str
    :ivar operation: Operation type: create, update, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """Result listing capacities. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of capacities supported by the Microsoft.PowerBIDedicated resource provider.
    :vartype value: list[~azure.mgmt.powerbidedicated.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SkuDetailsForExistingResource(msrest.serialization.Model):
    """An object that represents SKU details for existing resources.

    :param sku: The SKU in SKU details for existing resources.
    :type sku: ~azure.mgmt.powerbidedicated.models.CapacitySku
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'CapacitySku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuDetailsForExistingResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)


class SkuEnumerationForExistingResourceResult(msrest.serialization.Model):
    """An object that represents enumerating SKUs for existing resources.

    :param value: The collection of available SKUs for existing resources.
    :type value: list[~azure.mgmt.powerbidedicated.models.SkuDetailsForExistingResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuDetailsForExistingResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuEnumerationForExistingResourceResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SkuEnumerationForNewResourceResult(msrest.serialization.Model):
    """An object that represents enumerating SKUs for new resources.

    :param value: The collection of available SKUs for new resources.
    :type value: list[~azure.mgmt.powerbidedicated.models.CapacitySku]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapacitySku]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuEnumerationForNewResourceResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: An identifier for the identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.powerbidedicated.models.IdentityType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: An identifier for the identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.powerbidedicated.models.IdentityType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)
