# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import (
    Any,
    AsyncIterable,
    AsyncIterator,
    Callable,
    Dict,
    IO,
    List,
    Optional,
    Type,
    TypeVar,
    Union,
    cast,
    overload,
)
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ...operations._web_apps_operations import (
    build_add_premier_add_on_request,
    build_add_premier_add_on_slot_request,
    build_analyze_custom_hostname_request,
    build_analyze_custom_hostname_slot_request,
    build_apply_slot_config_to_production_request,
    build_apply_slot_configuration_slot_request,
    build_approve_or_reject_private_endpoint_connection_request,
    build_approve_or_reject_private_endpoint_connection_slot_request,
    build_backup_request,
    build_backup_slot_request,
    build_create_deployment_request,
    build_create_deployment_slot_request,
    build_create_function_request,
    build_create_instance_function_slot_request,
    build_create_instance_ms_deploy_operation_request,
    build_create_instance_ms_deploy_operation_slot_request,
    build_create_ms_deploy_operation_request,
    build_create_ms_deploy_operation_slot_request,
    build_create_one_deploy_operation_request,
    build_create_or_update_configuration_request,
    build_create_or_update_configuration_slot_request,
    build_create_or_update_domain_ownership_identifier_request,
    build_create_or_update_domain_ownership_identifier_slot_request,
    build_create_or_update_function_secret_request,
    build_create_or_update_function_secret_slot_request,
    build_create_or_update_host_name_binding_request,
    build_create_or_update_host_name_binding_slot_request,
    build_create_or_update_host_secret_request,
    build_create_or_update_host_secret_slot_request,
    build_create_or_update_hybrid_connection_request,
    build_create_or_update_hybrid_connection_slot_request,
    build_create_or_update_public_certificate_request,
    build_create_or_update_public_certificate_slot_request,
    build_create_or_update_relay_service_connection_request,
    build_create_or_update_relay_service_connection_slot_request,
    build_create_or_update_request,
    build_create_or_update_site_container_request,
    build_create_or_update_site_container_slot_request,
    build_create_or_update_slot_request,
    build_create_or_update_source_control_request,
    build_create_or_update_source_control_slot_request,
    build_create_or_update_swift_virtual_network_connection_with_check_request,
    build_create_or_update_swift_virtual_network_connection_with_check_slot_request,
    build_create_or_update_vnet_connection_gateway_request,
    build_create_or_update_vnet_connection_gateway_slot_request,
    build_create_or_update_vnet_connection_request,
    build_create_or_update_vnet_connection_slot_request,
    build_delete_backup_configuration_request,
    build_delete_backup_configuration_slot_request,
    build_delete_backup_request,
    build_delete_backup_slot_request,
    build_delete_continuous_web_job_request,
    build_delete_continuous_web_job_slot_request,
    build_delete_deployment_request,
    build_delete_deployment_slot_request,
    build_delete_domain_ownership_identifier_request,
    build_delete_domain_ownership_identifier_slot_request,
    build_delete_function_request,
    build_delete_function_secret_request,
    build_delete_function_secret_slot_request,
    build_delete_host_name_binding_request,
    build_delete_host_name_binding_slot_request,
    build_delete_host_secret_request,
    build_delete_host_secret_slot_request,
    build_delete_hybrid_connection_request,
    build_delete_hybrid_connection_slot_request,
    build_delete_instance_function_slot_request,
    build_delete_instance_process_request,
    build_delete_instance_process_slot_request,
    build_delete_premier_add_on_request,
    build_delete_premier_add_on_slot_request,
    build_delete_private_endpoint_connection_request,
    build_delete_private_endpoint_connection_slot_request,
    build_delete_process_request,
    build_delete_process_slot_request,
    build_delete_public_certificate_request,
    build_delete_public_certificate_slot_request,
    build_delete_relay_service_connection_request,
    build_delete_relay_service_connection_slot_request,
    build_delete_request,
    build_delete_site_container_request,
    build_delete_site_container_slot_request,
    build_delete_site_extension_request,
    build_delete_site_extension_slot_request,
    build_delete_slot_request,
    build_delete_source_control_request,
    build_delete_source_control_slot_request,
    build_delete_swift_virtual_network_request,
    build_delete_swift_virtual_network_slot_request,
    build_delete_triggered_web_job_request,
    build_delete_triggered_web_job_slot_request,
    build_delete_vnet_connection_request,
    build_delete_vnet_connection_slot_request,
    build_deploy_workflow_artifacts_request,
    build_deploy_workflow_artifacts_slot_request,
    build_discover_backup_request,
    build_discover_backup_slot_request,
    build_generate_new_site_publishing_password_request,
    build_generate_new_site_publishing_password_slot_request,
    build_get_app_setting_key_vault_reference_request,
    build_get_app_setting_key_vault_reference_slot_request,
    build_get_app_settings_key_vault_references_request,
    build_get_app_settings_key_vault_references_slot_request,
    build_get_auth_settings_request,
    build_get_auth_settings_slot_request,
    build_get_auth_settings_v2_request,
    build_get_auth_settings_v2_slot_request,
    build_get_auth_settings_v2_without_secrets_request,
    build_get_auth_settings_v2_without_secrets_slot_request,
    build_get_backup_configuration_request,
    build_get_backup_configuration_slot_request,
    build_get_backup_status_request,
    build_get_backup_status_slot_request,
    build_get_configuration_request,
    build_get_configuration_slot_request,
    build_get_configuration_snapshot_request,
    build_get_configuration_snapshot_slot_request,
    build_get_container_logs_zip_request,
    build_get_container_logs_zip_slot_request,
    build_get_continuous_web_job_request,
    build_get_continuous_web_job_slot_request,
    build_get_deployment_request,
    build_get_deployment_slot_request,
    build_get_diagnostic_logs_configuration_request,
    build_get_diagnostic_logs_configuration_slot_request,
    build_get_domain_ownership_identifier_request,
    build_get_domain_ownership_identifier_slot_request,
    build_get_ftp_allowed_request,
    build_get_ftp_allowed_slot_request,
    build_get_function_request,
    build_get_functions_admin_token_request,
    build_get_functions_admin_token_slot_request,
    build_get_host_name_binding_request,
    build_get_host_name_binding_slot_request,
    build_get_hybrid_connection_request,
    build_get_hybrid_connection_slot_request,
    build_get_instance_function_slot_request,
    build_get_instance_info_request,
    build_get_instance_info_slot_request,
    build_get_instance_ms_deploy_log_request,
    build_get_instance_ms_deploy_log_slot_request,
    build_get_instance_ms_deploy_status_request,
    build_get_instance_ms_deploy_status_slot_request,
    build_get_instance_process_dump_request,
    build_get_instance_process_dump_slot_request,
    build_get_instance_process_module_request,
    build_get_instance_process_module_slot_request,
    build_get_instance_process_request,
    build_get_instance_process_slot_request,
    build_get_instance_workflow_slot_request,
    build_get_migrate_my_sql_status_request,
    build_get_migrate_my_sql_status_slot_request,
    build_get_ms_deploy_log_request,
    build_get_ms_deploy_log_slot_request,
    build_get_ms_deploy_status_request,
    build_get_ms_deploy_status_slot_request,
    build_get_network_trace_operation_request,
    build_get_network_trace_operation_slot_request,
    build_get_network_trace_operation_slot_v2_request,
    build_get_network_trace_operation_v2_request,
    build_get_network_traces_request,
    build_get_network_traces_slot_request,
    build_get_network_traces_slot_v2_request,
    build_get_network_traces_v2_request,
    build_get_one_deploy_status_request,
    build_get_premier_add_on_request,
    build_get_premier_add_on_slot_request,
    build_get_private_access_request,
    build_get_private_access_slot_request,
    build_get_private_endpoint_connection_list_request,
    build_get_private_endpoint_connection_list_slot_request,
    build_get_private_endpoint_connection_request,
    build_get_private_endpoint_connection_slot_request,
    build_get_private_link_resources_request,
    build_get_private_link_resources_slot_request,
    build_get_process_dump_request,
    build_get_process_dump_slot_request,
    build_get_process_module_request,
    build_get_process_module_slot_request,
    build_get_process_request,
    build_get_process_slot_request,
    build_get_production_site_deployment_status_request,
    build_get_public_certificate_request,
    build_get_public_certificate_slot_request,
    build_get_relay_service_connection_request,
    build_get_relay_service_connection_slot_request,
    build_get_request,
    build_get_scm_allowed_request,
    build_get_scm_allowed_slot_request,
    build_get_site_connection_string_key_vault_reference_request,
    build_get_site_connection_string_key_vault_reference_slot_request,
    build_get_site_connection_string_key_vault_references_request,
    build_get_site_connection_string_key_vault_references_slot_request,
    build_get_site_container_request,
    build_get_site_container_slot_request,
    build_get_site_extension_request,
    build_get_site_extension_slot_request,
    build_get_site_php_error_log_flag_request,
    build_get_site_php_error_log_flag_slot_request,
    build_get_slot_request,
    build_get_slot_site_deployment_status_slot_request,
    build_get_source_control_request,
    build_get_source_control_slot_request,
    build_get_swift_virtual_network_connection_request,
    build_get_swift_virtual_network_connection_slot_request,
    build_get_triggered_web_job_history_request,
    build_get_triggered_web_job_history_slot_request,
    build_get_triggered_web_job_request,
    build_get_triggered_web_job_slot_request,
    build_get_vnet_connection_gateway_request,
    build_get_vnet_connection_gateway_slot_request,
    build_get_vnet_connection_request,
    build_get_vnet_connection_slot_request,
    build_get_web_job_request,
    build_get_web_job_slot_request,
    build_get_web_site_container_logs_request,
    build_get_web_site_container_logs_slot_request,
    build_get_workflow_request,
    build_install_site_extension_request,
    build_install_site_extension_slot_request,
    build_is_cloneable_request,
    build_is_cloneable_slot_request,
    build_list_application_settings_request,
    build_list_application_settings_slot_request,
    build_list_azure_storage_accounts_request,
    build_list_azure_storage_accounts_slot_request,
    build_list_backup_status_secrets_request,
    build_list_backup_status_secrets_slot_request,
    build_list_backups_request,
    build_list_backups_slot_request,
    build_list_basic_publishing_credentials_policies_request,
    build_list_basic_publishing_credentials_policies_slot_request,
    build_list_by_resource_group_request,
    build_list_configuration_snapshot_info_request,
    build_list_configuration_snapshot_info_slot_request,
    build_list_configurations_request,
    build_list_configurations_slot_request,
    build_list_connection_strings_request,
    build_list_connection_strings_slot_request,
    build_list_continuous_web_jobs_request,
    build_list_continuous_web_jobs_slot_request,
    build_list_deployment_log_request,
    build_list_deployment_log_slot_request,
    build_list_deployments_request,
    build_list_deployments_slot_request,
    build_list_domain_ownership_identifiers_request,
    build_list_domain_ownership_identifiers_slot_request,
    build_list_function_keys_request,
    build_list_function_keys_slot_request,
    build_list_function_secrets_request,
    build_list_function_secrets_slot_request,
    build_list_functions_request,
    build_list_host_keys_request,
    build_list_host_keys_slot_request,
    build_list_host_name_bindings_request,
    build_list_host_name_bindings_slot_request,
    build_list_hybrid_connections_request,
    build_list_hybrid_connections_slot_request,
    build_list_instance_functions_slot_request,
    build_list_instance_identifiers_request,
    build_list_instance_identifiers_slot_request,
    build_list_instance_process_modules_request,
    build_list_instance_process_modules_slot_request,
    build_list_instance_process_threads_request,
    build_list_instance_process_threads_slot_request,
    build_list_instance_processes_request,
    build_list_instance_processes_slot_request,
    build_list_instance_workflows_slot_request,
    build_list_metadata_request,
    build_list_metadata_slot_request,
    build_list_network_features_request,
    build_list_network_features_slot_request,
    build_list_perf_mon_counters_request,
    build_list_perf_mon_counters_slot_request,
    build_list_premier_add_ons_request,
    build_list_premier_add_ons_slot_request,
    build_list_process_modules_request,
    build_list_process_modules_slot_request,
    build_list_process_threads_request,
    build_list_process_threads_slot_request,
    build_list_processes_request,
    build_list_processes_slot_request,
    build_list_production_site_deployment_statuses_request,
    build_list_public_certificates_request,
    build_list_public_certificates_slot_request,
    build_list_publishing_credentials_request,
    build_list_publishing_credentials_slot_request,
    build_list_publishing_profile_xml_with_secrets_request,
    build_list_publishing_profile_xml_with_secrets_slot_request,
    build_list_relay_service_connections_request,
    build_list_relay_service_connections_slot_request,
    build_list_request,
    build_list_site_backups_request,
    build_list_site_backups_slot_request,
    build_list_site_containers_request,
    build_list_site_containers_slot_request,
    build_list_site_extensions_request,
    build_list_site_extensions_slot_request,
    build_list_site_push_settings_request,
    build_list_site_push_settings_slot_request,
    build_list_slot_configuration_names_request,
    build_list_slot_differences_from_production_request,
    build_list_slot_differences_slot_request,
    build_list_slot_site_deployment_statuses_slot_request,
    build_list_slots_request,
    build_list_snapshots_from_dr_secondary_request,
    build_list_snapshots_from_dr_secondary_slot_request,
    build_list_snapshots_request,
    build_list_snapshots_slot_request,
    build_list_sync_function_triggers_request,
    build_list_sync_function_triggers_slot_request,
    build_list_sync_status_request,
    build_list_sync_status_slot_request,
    build_list_triggered_web_job_history_request,
    build_list_triggered_web_job_history_slot_request,
    build_list_triggered_web_jobs_request,
    build_list_triggered_web_jobs_slot_request,
    build_list_usages_request,
    build_list_usages_slot_request,
    build_list_vnet_connections_request,
    build_list_vnet_connections_slot_request,
    build_list_web_jobs_request,
    build_list_web_jobs_slot_request,
    build_list_workflows_connections_request,
    build_list_workflows_connections_slot_request,
    build_list_workflows_request,
    build_migrate_my_sql_request,
    build_migrate_storage_request,
    build_put_private_access_vnet_request,
    build_put_private_access_vnet_slot_request,
    build_recover_site_configuration_snapshot_request,
    build_recover_site_configuration_snapshot_slot_request,
    build_reset_production_slot_config_request,
    build_reset_slot_configuration_slot_request,
    build_restart_request,
    build_restart_slot_request,
    build_restore_from_backup_blob_request,
    build_restore_from_backup_blob_slot_request,
    build_restore_from_deleted_app_request,
    build_restore_from_deleted_app_slot_request,
    build_restore_request,
    build_restore_slot_request,
    build_restore_snapshot_request,
    build_restore_snapshot_slot_request,
    build_run_triggered_web_job_request,
    build_run_triggered_web_job_slot_request,
    build_start_continuous_web_job_request,
    build_start_continuous_web_job_slot_request,
    build_start_network_trace_request,
    build_start_network_trace_slot_request,
    build_start_request,
    build_start_slot_request,
    build_start_web_site_network_trace_operation_request,
    build_start_web_site_network_trace_operation_slot_request,
    build_start_web_site_network_trace_request,
    build_start_web_site_network_trace_slot_request,
    build_stop_continuous_web_job_request,
    build_stop_continuous_web_job_slot_request,
    build_stop_network_trace_request,
    build_stop_network_trace_slot_request,
    build_stop_request,
    build_stop_slot_request,
    build_stop_web_site_network_trace_request,
    build_stop_web_site_network_trace_slot_request,
    build_swap_slot_request,
    build_swap_slot_with_production_request,
    build_sync_function_triggers_request,
    build_sync_function_triggers_slot_request,
    build_sync_functions_request,
    build_sync_functions_slot_request,
    build_sync_repository_request,
    build_sync_repository_slot_request,
    build_update_application_settings_request,
    build_update_application_settings_slot_request,
    build_update_auth_settings_request,
    build_update_auth_settings_slot_request,
    build_update_auth_settings_v2_request,
    build_update_auth_settings_v2_slot_request,
    build_update_azure_storage_accounts_request,
    build_update_azure_storage_accounts_slot_request,
    build_update_backup_configuration_request,
    build_update_backup_configuration_slot_request,
    build_update_configuration_request,
    build_update_configuration_slot_request,
    build_update_connection_strings_request,
    build_update_connection_strings_slot_request,
    build_update_diagnostic_logs_config_request,
    build_update_diagnostic_logs_config_slot_request,
    build_update_domain_ownership_identifier_request,
    build_update_domain_ownership_identifier_slot_request,
    build_update_ftp_allowed_request,
    build_update_ftp_allowed_slot_request,
    build_update_hybrid_connection_request,
    build_update_hybrid_connection_slot_request,
    build_update_machine_key_request,
    build_update_metadata_request,
    build_update_metadata_slot_request,
    build_update_premier_add_on_request,
    build_update_premier_add_on_slot_request,
    build_update_relay_service_connection_request,
    build_update_relay_service_connection_slot_request,
    build_update_request,
    build_update_scm_allowed_request,
    build_update_scm_allowed_slot_request,
    build_update_site_push_settings_request,
    build_update_site_push_settings_slot_request,
    build_update_slot_configuration_names_request,
    build_update_slot_request,
    build_update_source_control_request,
    build_update_source_control_slot_request,
    build_update_swift_virtual_network_connection_with_check_request,
    build_update_swift_virtual_network_connection_with_check_slot_request,
    build_update_vnet_connection_gateway_request,
    build_update_vnet_connection_gateway_slot_request,
    build_update_vnet_connection_request,
    build_update_vnet_connection_slot_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class WebAppsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2024_04_01.aio.WebSiteManagementClient`'s
        :attr:`web_apps` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Site"]:
        """Get all apps for a subscription.

        Description for Get all apps for a subscription.

        :return: An iterator like instance of either Site or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.WebAppCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, include_slots: Optional[bool] = None, **kwargs: Any
    ) -> AsyncIterable["_models.Site"]:
        """Gets all web, mobile, and API apps in the specified resource group.

        Description for Gets all web, mobile, and API apps in the specified resource group.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param include_slots: Specify :code:`<strong>true</strong>` to include deployment slots in
         results. The default is false, which only gives you the production slot of all apps. Default
         value is None.
        :type include_slots: bool
        :return: An iterator like instance of either Site or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.WebAppCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    include_slots=include_slots,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.Site:
        """Gets the details of a web, mobile, or API app.

        Description for Gets the details of a web, mobile, or API app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Site", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self, resource_group_name: str, name: str, site_envelope: Union[_models.Site, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IOBase, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "Site")

        _request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: _models.Site,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.Site
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self, resource_group_name: str, name: str, site_envelope: Union[_models.Site, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         Site type or a IO[bytes] type. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.Site or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                name=name,
                site_envelope=site_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Site", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Site].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Site](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def delete(
        self,
        resource_group_name: str,
        name: str,
        delete_metrics: Optional[bool] = None,
        delete_empty_server_farm: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a web, mobile, or API app, or one of the deployment slots.

        Description for Deletes a web, mobile, or API app, or one of the deployment slots.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app to delete. Required.
        :type name: str
        :param delete_metrics: If true, web app metrics are also deleted. Default value is None.
        :type delete_metrics: bool
        :param delete_empty_server_farm: Specify false if you want to keep empty App Service plan. By
         default, empty App Service plan is deleted. Default value is None.
        :type delete_empty_server_farm: bool
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            delete_metrics=delete_metrics,
            delete_empty_server_farm=delete_empty_server_farm,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: _models.SitePatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.SitePatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: Union[_models.SitePatchResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         SitePatchResource type or a IO[bytes] type. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.SitePatchResource or IO[bytes]
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IOBase, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "SitePatchResource")

        _request = build_update_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Site", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def analyze_custom_hostname(
        self, resource_group_name: str, name: str, host_name: Optional[str] = None, **kwargs: Any
    ) -> _models.CustomHostnameAnalysisResult:
        """Analyze a custom hostname.

        Description for Analyze a custom hostname.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param host_name: Custom hostname. Default value is None.
        :type host_name: str
        :return: CustomHostnameAnalysisResult or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CustomHostnameAnalysisResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CustomHostnameAnalysisResult] = kwargs.pop("cls", None)

        _request = build_analyze_custom_hostname_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            host_name=host_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CustomHostnameAnalysisResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def apply_slot_config_to_production(
        self,
        resource_group_name: str,
        name: str,
        slot_swap_entity: _models.CsmSlotEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Description for Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2024_04_01.models.CsmSlotEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def apply_slot_config_to_production(
        self,
        resource_group_name: str,
        name: str,
        slot_swap_entity: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Description for Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def apply_slot_config_to_production(
        self,
        resource_group_name: str,
        name: str,
        slot_swap_entity: Union[_models.CsmSlotEntity, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Description for Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Is either
         a CsmSlotEntity type or a IO[bytes] type. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2024_04_01.models.CsmSlotEntity or IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(slot_swap_entity, (IOBase, bytes)):
            _content = slot_swap_entity
        else:
            _json = self._serialize.body(slot_swap_entity, "CsmSlotEntity")

        _request = build_apply_slot_config_to_production_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def backup(
        self,
        resource_group_name: str,
        name: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Description for Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def backup(
        self,
        resource_group_name: str,
        name: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Description for Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def backup(
        self, resource_group_name: str, name: str, request: Union[_models.BackupRequest, IO[bytes]], **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Description for Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Is either a BackupRequest type or a IO[bytes] type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest or IO[bytes]
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        _request = build_backup_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_backups(self, resource_group_name: str, name: str, **kwargs: Any) -> AsyncIterable["_models.BackupItem"]:
        """Gets existing backups of an app.

        Description for Gets existing backups of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either BackupItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.BackupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.BackupItemCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_backups_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BackupItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_backup_status(
        self, resource_group_name: str, name: str, backup_id: str, **kwargs: Any
    ) -> _models.BackupItem:
        """Gets a backup of an app by its ID.

        Description for Gets a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        _request = build_get_backup_status_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_backup(self, resource_group_name: str, name: str, backup_id: str, **kwargs: Any) -> None:
        """Deletes a backup of an app by its ID.

        Description for Deletes a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_backup_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def list_backup_status_secrets(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Description for Gets status of a web app backup that may be in progress, including secrets
        associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the
        SAS URL for the backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param request: Information on backup request. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_backup_status_secrets(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Description for Gets status of a web app backup that may be in progress, including secrets
        associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the
        SAS URL for the backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param request: Information on backup request. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_backup_status_secrets(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: Union[_models.BackupRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Description for Gets status of a web app backup that may be in progress, including secrets
        associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the
        SAS URL for the backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param request: Information on backup request. Is either a BackupRequest type or a IO[bytes]
         type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest or IO[bytes]
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        _request = build_list_backup_status_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _restore_initial(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: Union[_models.RestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        _request = build_restore_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_restore(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Description for Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param request: Information on restore request . Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Description for Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param request: Information on restore request . Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: Union[_models.RestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Description for Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param request: Information on restore request . Is either a RestoreRequest type or a IO[bytes]
         type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_initial(
                resource_group_name=resource_group_name,
                name=name,
                backup_id=backup_id,
                request=request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_basic_publishing_credentials_policies(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.CsmPublishingCredentialsPoliciesEntity"]:
        # pylint: disable=line-too-long
        """Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.

        Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a
        given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either CsmPublishingCredentialsPoliciesEntity or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PublishingCredentialsPoliciesCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_basic_publishing_credentials_policies_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublishingCredentialsPoliciesCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_ftp_allowed(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether FTP is allowed on the site or not.

        Description for Returns whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        _request = build_get_ftp_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_ftp_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Description for Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_ftp_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Description for Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_ftp_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO[bytes]],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Description for Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO[bytes] type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity or IO[bytes]
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IOBase, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        _request = build_update_ftp_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_scm_allowed(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether Scm basic auth is allowed on the site or not.

        Description for Returns whether Scm basic auth is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        _request = build_get_scm_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_scm_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Description for Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_scm_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Description for Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_scm_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO[bytes]],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Description for Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO[bytes] type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity or IO[bytes]
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IOBase, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        _request = build_update_scm_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_configurations(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteConfigResource"]:
        """List the configurations of an app.

        Description for List the configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either SiteConfigResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.SiteConfigResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigResourceCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_configurations_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteConfigResourceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def update_application_settings(
        self,
        resource_group_name: str,
        name: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Description for Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_application_settings(
        self,
        resource_group_name: str,
        name: str,
        app_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Description for Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_application_settings(
        self,
        resource_group_name: str,
        name: str,
        app_settings: Union[_models.StringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Description for Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_settings: Application settings of the app. Is either a StringDictionary type or a
         IO[bytes] type. Required.
        :type app_settings: ~azure.mgmt.web.v2024_04_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        _request = build_update_application_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_application_settings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of an app.

        Description for Gets the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_application_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_auth_settings(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings: _models.SiteAuthSettings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Description for Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Description for Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings: Union[_models.SiteAuthSettings, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Description for Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings: Auth settings associated with web app. Is either a SiteAuthSettings
         type or a IO[bytes] type. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings or IO[bytes]
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings, (IOBase, bytes)):
            _content = site_auth_settings
        else:
            _json = self._serialize.body(site_auth_settings, "SiteAuthSettings")

        _request = build_update_auth_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_auth_settings(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.SiteAuthSettings:
        """Gets the Authentication/Authorization settings of an app.

        Description for Gets the Authentication/Authorization settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        _request = build_get_auth_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_auth_settings_v2_without_secrets(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Gets site's Authentication / Authorization settings for apps via the V2 format.

        Description for Gets site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        _request = build_get_auth_settings_v2_without_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_auth_settings_v2(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings_v2: _models.SiteAuthSettingsV2,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Description for Updates site's Authentication / Authorization settings for apps via the V2
        format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings_v2(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings_v2: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Description for Updates site's Authentication / Authorization settings for apps via the V2
        format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings_v2(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings_v2: Union[_models.SiteAuthSettingsV2, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Description for Updates site's Authentication / Authorization settings for apps via the V2
        format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings_v2: Auth settings associated with web app. Is either a
         SiteAuthSettingsV2 type or a IO[bytes] type. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2 or IO[bytes]
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings_v2, (IOBase, bytes)):
            _content = site_auth_settings_v2
        else:
            _json = self._serialize.body(site_auth_settings_v2, "SiteAuthSettingsV2")

        _request = build_update_auth_settings_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_auth_settings_v2(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Gets site's Authentication / Authorization settings for apps via the V2 format.

        Description for Gets site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        _request = build_get_auth_settings_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_azure_storage_accounts(
        self,
        resource_group_name: str,
        name: str,
        azure_storage_accounts: _models.AzureStoragePropertyDictionaryResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Description for Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_azure_storage_accounts(
        self,
        resource_group_name: str,
        name: str,
        azure_storage_accounts: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Description for Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_azure_storage_accounts(
        self,
        resource_group_name: str,
        name: str,
        azure_storage_accounts: Union[_models.AzureStoragePropertyDictionaryResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Description for Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param azure_storage_accounts: Azure storage accounts of the app. Is either a
         AzureStoragePropertyDictionaryResource type or a IO[bytes] type. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource or IO[bytes]
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(azure_storage_accounts, (IOBase, bytes)):
            _content = azure_storage_accounts
        else:
            _json = self._serialize.body(azure_storage_accounts, "AzureStoragePropertyDictionaryResource")

        _request = build_update_azure_storage_accounts_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_azure_storage_accounts(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Gets the Azure storage account configurations of an app.

        Description for Gets the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        _request = build_list_azure_storage_accounts_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_backup_configuration(
        self,
        resource_group_name: str,
        name: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Description for Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Edited backup configuration. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_backup_configuration(
        self,
        resource_group_name: str,
        name: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Description for Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Edited backup configuration. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_backup_configuration(
        self, resource_group_name: str, name: str, request: Union[_models.BackupRequest, IO[bytes]], **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Description for Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Edited backup configuration. Is either a BackupRequest type or a IO[bytes]
         type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest or IO[bytes]
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        _request = build_update_backup_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_backup_configuration(self, resource_group_name: str, name: str, **kwargs: Any) -> None:
        """Deletes the backup configuration of an app.

        Description for Deletes the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_backup_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_backup_configuration(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.BackupRequest:
        """Gets the backup configuration of an app.

        Description for Gets the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        _request = build_get_backup_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_app_settings_key_vault_references(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Description for Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_app_settings_key_vault_references_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_app_setting_key_vault_reference(
        self, resource_group_name: str, name: str, app_setting_key: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Description for Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_setting_key: App Setting key name. Required.
        :type app_setting_key: str
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        _request = build_get_app_setting_key_vault_reference_request(
            resource_group_name=resource_group_name,
            name=name,
            app_setting_key=app_setting_key,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_site_connection_string_key_vault_references(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Description for Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_site_connection_string_key_vault_references_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_site_connection_string_key_vault_reference(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, connection_string_key: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Description for Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_string_key: Required.
        :type connection_string_key: str
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        _request = build_get_site_connection_string_key_vault_reference_request(
            resource_group_name=resource_group_name,
            name=name,
            connection_string_key=connection_string_key,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_connection_strings(
        self,
        resource_group_name: str,
        name: str,
        connection_strings: _models.ConnectionStringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Description for Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_connection_strings(
        self,
        resource_group_name: str,
        name: str,
        connection_strings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Description for Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_connection_strings(
        self,
        resource_group_name: str,
        name: str,
        connection_strings: Union[_models.ConnectionStringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Description for Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_strings: Connection strings of the app or deployment slot. See example. Is
         either a ConnectionStringDictionary type or a IO[bytes] type. Required.
        :type connection_strings: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary or
         IO[bytes]
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_strings, (IOBase, bytes)):
            _content = connection_strings
        else:
            _json = self._serialize.body(connection_strings, "ConnectionStringDictionary")

        _request = build_update_connection_strings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_connection_strings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Gets the connection strings of an app.

        Description for Gets the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        _request = build_list_connection_strings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_diagnostic_logs_configuration(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Gets the logging configuration of an app.

        Description for Gets the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        _request = build_get_diagnostic_logs_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_diagnostic_logs_config(
        self,
        resource_group_name: str,
        name: str,
        site_logs_config: _models.SiteLogsConfig,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Description for Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_diagnostic_logs_config(
        self,
        resource_group_name: str,
        name: str,
        site_logs_config: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Description for Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_diagnostic_logs_config(
        self,
        resource_group_name: str,
        name: str,
        site_logs_config: Union[_models.SiteLogsConfig, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Description for Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Is either a SiteLogsConfig type or a IO[bytes] type.
         Required.
        :type site_logs_config: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig or IO[bytes]
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_logs_config, (IOBase, bytes)):
            _content = site_logs_config
        else:
            _json = self._serialize.body(site_logs_config, "SiteLogsConfig")

        _request = build_update_diagnostic_logs_config_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_metadata(
        self,
        resource_group_name: str,
        name: str,
        metadata: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Description for Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_metadata(
        self,
        resource_group_name: str,
        name: str,
        metadata: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Description for Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_metadata(
        self, resource_group_name: str, name: str, metadata: Union[_models.StringDictionary, IO[bytes]], **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Description for Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Is either a
         StringDictionary type or a IO[bytes] type. Required.
        :type metadata: ~azure.mgmt.web.v2024_04_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(metadata, (IOBase, bytes)):
            _content = metadata
        else:
            _json = self._serialize.body(metadata, "StringDictionary")

        _request = build_update_metadata_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_metadata(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.StringDictionary:
        """Gets the metadata of an app.

        Description for Gets the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_metadata_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _list_publishing_credentials_initial(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_list_publishing_credentials_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_list_publishing_credentials(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.User]:
        """Gets the Git/FTP publishing credentials of an app.

        Description for Gets the Git/FTP publishing credentials of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An instance of AsyncLROPoller that returns either User or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.User]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.User] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_publishing_credentials_initial(
                resource_group_name=resource_group_name,
                name=name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("User", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.User].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.User](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def update_site_push_settings(
        self,
        resource_group_name: str,
        name: str,
        push_settings: _models.PushSettings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Description for Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param push_settings: Push settings associated with web app. Required.
        :type push_settings: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_site_push_settings(
        self,
        resource_group_name: str,
        name: str,
        push_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Description for Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param push_settings: Push settings associated with web app. Required.
        :type push_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_site_push_settings(
        self, resource_group_name: str, name: str, push_settings: Union[_models.PushSettings, IO[bytes]], **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Description for Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param push_settings: Push settings associated with web app. Is either a PushSettings type or a
         IO[bytes] type. Required.
        :type push_settings: ~azure.mgmt.web.v2024_04_01.models.PushSettings or IO[bytes]
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PushSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(push_settings, (IOBase, bytes)):
            _content = push_settings
        else:
            _json = self._serialize.body(push_settings, "PushSettings")

        _request = build_update_site_push_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PushSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_site_push_settings(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.PushSettings:
        """Gets the Push settings associated with web app.

        Description for Gets the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PushSettings] = kwargs.pop("cls", None)

        _request = build_list_site_push_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PushSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_slot_configuration_names(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Gets the names of app settings and connection strings that stick to the slot (not swapped).

        Description for Gets the names of app settings and connection strings that stick to the slot
        (not swapped).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SlotConfigNamesResource] = kwargs.pop("cls", None)

        _request = build_list_slot_configuration_names_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SlotConfigNamesResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_slot_configuration_names(
        self,
        resource_group_name: str,
        name: str,
        slot_config_names: _models.SlotConfigNamesResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        Description for Updates the names of application settings and connection string that remain
        with the slot during swap operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_config_names: Names of application settings and connection strings. See example.
         Required.
        :type slot_config_names: ~azure.mgmt.web.v2024_04_01.models.SlotConfigNamesResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_slot_configuration_names(
        self,
        resource_group_name: str,
        name: str,
        slot_config_names: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        Description for Updates the names of application settings and connection string that remain
        with the slot during swap operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_config_names: Names of application settings and connection strings. See example.
         Required.
        :type slot_config_names: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_slot_configuration_names(
        self,
        resource_group_name: str,
        name: str,
        slot_config_names: Union[_models.SlotConfigNamesResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        Description for Updates the names of application settings and connection string that remain
        with the slot during swap operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_config_names: Names of application settings and connection strings. See example. Is
         either a SlotConfigNamesResource type or a IO[bytes] type. Required.
        :type slot_config_names: ~azure.mgmt.web.v2024_04_01.models.SlotConfigNamesResource or
         IO[bytes]
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SlotConfigNamesResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(slot_config_names, (IOBase, bytes)):
            _content = slot_config_names
        else:
            _json = self._serialize.body(slot_config_names, "SlotConfigNamesResource")

        _request = build_update_slot_configuration_names_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SlotConfigNamesResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_configuration(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.SiteConfigResource:
        """Gets the configuration of an app, such as platform version and bitness, default documents,
        virtual applications, Always On, etc.

        Description for Gets the configuration of an app, such as platform version and bitness, default
        documents, virtual applications, Always On, etc.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        _request = build_get_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: _models.SiteConfigResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: Union[_models.SiteConfigResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Is either a
         SiteConfigResource type or a IO[bytes] type. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource or IO[bytes]
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_config, (IOBase, bytes)):
            _content = site_config
        else:
            _json = self._serialize.body(site_config, "SiteConfigResource")

        _request = build_create_or_update_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: _models.SiteConfigResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: Union[_models.SiteConfigResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Is either a
         SiteConfigResource type or a IO[bytes] type. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource or IO[bytes]
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_config, (IOBase, bytes)):
            _content = site_config
        else:
            _json = self._serialize.body(site_config, "SiteConfigResource")

        _request = build_update_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_configuration_snapshot_info(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteConfigurationSnapshotInfo"]:
        """Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
        timestamp and the ID of the snapshot.

        Description for Gets a list of web app configuration snapshots identifiers. Each element of the
        list contains a timestamp and the ID of the snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either SiteConfigurationSnapshotInfo or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.SiteConfigurationSnapshotInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigurationSnapshotInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_configuration_snapshot_info_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteConfigurationSnapshotInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_configuration_snapshot(
        self, resource_group_name: str, name: str, snapshot_id: str, **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Gets a snapshot of the configuration of an app at a previous point in time.

        Description for Gets a snapshot of the configuration of an app at a previous point in time.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param snapshot_id: The ID of the snapshot to read. Required.
        :type snapshot_id: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        _request = build_get_configuration_snapshot_request(
            resource_group_name=resource_group_name,
            name=name,
            snapshot_id=snapshot_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def recover_site_configuration_snapshot(
        self, resource_group_name: str, name: str, snapshot_id: str, **kwargs: Any
    ) -> None:
        """Reverts the configuration of an app to a previous snapshot.

        Description for Reverts the configuration of an app to a previous snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param snapshot_id: The ID of the snapshot to read. Required.
        :type snapshot_id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_recover_site_configuration_snapshot_request(
            resource_group_name=resource_group_name,
            name=name,
            snapshot_id=snapshot_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_web_site_container_logs(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> Optional[AsyncIterator[bytes]]:
        """Gets the last lines of docker logs for the given site.

        Description for Gets the last lines of docker logs for the given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: AsyncIterator[bytes] or None or the result of cls(response)
        :rtype: AsyncIterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[Optional[AsyncIterator[bytes]]] = kwargs.pop("cls", None)

        _request = build_get_web_site_container_logs_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_container_logs_zip(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> Optional[AsyncIterator[bytes]]:
        """Gets the ZIP archived docker log files for the given site.

        Description for Gets the ZIP archived docker log files for the given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: AsyncIterator[bytes] or None or the result of cls(response)
        :rtype: AsyncIterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[Optional[AsyncIterator[bytes]]] = kwargs.pop("cls", None)

        _request = build_get_container_logs_zip_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_continuous_web_jobs(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ContinuousWebJob"]:
        """List continuous web jobs for an app, or a deployment slot.

        Description for List continuous web jobs for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :return: An iterator like instance of either ContinuousWebJob or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ContinuousWebJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ContinuousWebJobCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_continuous_web_jobs_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ContinuousWebJobCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_continuous_web_job(
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> _models.ContinuousWebJob:
        """Gets a continuous web job by its ID for an app, or a deployment slot.

        Description for Gets a continuous web job by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :return: ContinuousWebJob or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ContinuousWebJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ContinuousWebJob] = kwargs.pop("cls", None)

        _request = build_get_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ContinuousWebJob", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_continuous_web_job(
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> None:
        """Delete a continuous web job by its ID for an app, or a deployment slot.

        Description for Delete a continuous web job by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def start_continuous_web_job(
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> None:
        """Start a continuous web job for an app, or a deployment slot.

        Description for Start a continuous web job for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_start_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def stop_continuous_web_job(
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> None:
        """Stop a continuous web job for an app, or a deployment slot.

        Description for Stop a continuous web job for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_stop_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_production_site_deployment_statuses(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.CsmDeploymentStatus"]:
        """List deployment statuses for an app (or deployment slot, if specified).

        List deployment statuses for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either CsmDeploymentStatus or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.CsmDeploymentStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmDeploymentStatusCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_production_site_deployment_statuses_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CsmDeploymentStatusCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _get_production_site_deployment_status_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, deployment_status_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_get_production_site_deployment_status_request(
            resource_group_name=resource_group_name,
            name=name,
            deployment_status_id=deployment_status_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_production_site_deployment_status(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, deployment_status_id: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.CsmDeploymentStatus]:
        """Gets the deployment status for an app (or deployment slot, if specified).

        Gets the deployment status for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param deployment_status_id: GUID of the deployment operation. Required.
        :type deployment_status_id: str
        :return: An instance of AsyncLROPoller that returns either CsmDeploymentStatus or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.CsmDeploymentStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmDeploymentStatus] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_production_site_deployment_status_initial(
                resource_group_name=resource_group_name,
                name=name,
                deployment_status_id=deployment_status_id,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("CsmDeploymentStatus", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.CsmDeploymentStatus].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.CsmDeploymentStatus](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_deployments(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.Deployment"]:
        """List deployments for an app, or a deployment slot.

        Description for List deployments for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either Deployment or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.Deployment]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.DeploymentCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_deployments_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_deployment(self, resource_group_name: str, name: str, id: str, **kwargs: Any) -> _models.Deployment:
        """Get a deployment by its ID for an app, or a deployment slot.

        Description for Get a deployment by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: Deployment ID. Required.
        :type id: str
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.Deployment] = kwargs.pop("cls", None)

        _request = build_get_deployment_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Deployment", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_deployment(
        self,
        resource_group_name: str,
        name: str,
        id: str,
        deployment: _models.Deployment,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Deployment:
        """Create a deployment for an app, or a deployment slot.

        Description for Create a deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: ID of an existing deployment. Required.
        :type id: str
        :param deployment: Deployment details. Required.
        :type deployment: ~azure.mgmt.web.v2024_04_01.models.Deployment
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_deployment(
        self,
        resource_group_name: str,
        name: str,
        id: str,
        deployment: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Deployment:
        """Create a deployment for an app, or a deployment slot.

        Description for Create a deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: ID of an existing deployment. Required.
        :type id: str
        :param deployment: Deployment details. Required.
        :type deployment: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_deployment(
        self,
        resource_group_name: str,
        name: str,
        id: str,
        deployment: Union[_models.Deployment, IO[bytes]],
        **kwargs: Any
    ) -> _models.Deployment:
        """Create a deployment for an app, or a deployment slot.

        Description for Create a deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: ID of an existing deployment. Required.
        :type id: str
        :param deployment: Deployment details. Is either a Deployment type or a IO[bytes] type.
         Required.
        :type deployment: ~azure.mgmt.web.v2024_04_01.models.Deployment or IO[bytes]
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Deployment] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment, (IOBase, bytes)):
            _content = deployment
        else:
            _json = self._serialize.body(deployment, "Deployment")

        _request = build_create_deployment_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Deployment", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_deployment(self, resource_group_name: str, name: str, id: str, **kwargs: Any) -> None:
        """Delete a deployment by its ID for an app, or a deployment slot.

        Description for Delete a deployment by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: Deployment ID. Required.
        :type id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_deployment_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def list_deployment_log(
        self, resource_group_name: str, name: str, id: str, **kwargs: Any
    ) -> _models.Deployment:
        """List deployment log for specific deployment for an app, or a deployment slot.

        Description for List deployment log for specific deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: The ID of a specific deployment. This is the value of the name property in the JSON
         response from "GET /api/sites/{siteName}/deployments". Required.
        :type id: str
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.Deployment] = kwargs.pop("cls", None)

        _request = build_list_deployment_log_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Deployment", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def discover_backup(
        self,
        resource_group_name: str,
        name: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RestoreRequest:
        """Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        Description for Discovers an existing app backup that can be restored from a blob in Azure
        storage. Use this to get information about the databases stored in a backup.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: A RestoreRequest object that includes Azure storage URL and blog name for
         discovery of backup. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RestoreRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def discover_backup(
        self,
        resource_group_name: str,
        name: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RestoreRequest:
        """Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        Description for Discovers an existing app backup that can be restored from a blob in Azure
        storage. Use this to get information about the databases stored in a backup.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: A RestoreRequest object that includes Azure storage URL and blog name for
         discovery of backup. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RestoreRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def discover_backup(
        self, resource_group_name: str, name: str, request: Union[_models.RestoreRequest, IO[bytes]], **kwargs: Any
    ) -> _models.RestoreRequest:
        """Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        Description for Discovers an existing app backup that can be restored from a blob in Azure
        storage. Use this to get information about the databases stored in a backup.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: A RestoreRequest object that includes Azure storage URL and blog name for
         discovery of backup. Is either a RestoreRequest type or a IO[bytes] type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest or IO[bytes]
        :return: RestoreRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RestoreRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        _request = build_discover_backup_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RestoreRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_domain_ownership_identifiers(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.Identifier"]:
        """Lists ownership identifiers for domain associated with web app.

        Description for Lists ownership identifiers for domain associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either Identifier or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.Identifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.IdentifierCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_domain_ownership_identifiers_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("IdentifierCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_domain_ownership_identifier(
        self, resource_group_name: str, name: str, domain_ownership_identifier_name: str, **kwargs: Any
    ) -> _models.Identifier:
        """Get domain ownership identifier for web app.

        Description for Get domain ownership identifier for web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.Identifier] = kwargs.pop("cls", None)

        _request = build_get_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Identifier", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_domain_ownership_identifier(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: _models.Identifier,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Description for Creates a domain ownership identifier for web app, or updates an existing
        ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_domain_ownership_identifier(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Description for Creates a domain ownership identifier for web app, or updates an existing
        ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_domain_ownership_identifier(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: Union[_models.Identifier, IO[bytes]],
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Description for Creates a domain ownership identifier for web app, or updates an existing
        ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Is either a Identifier type or a IO[bytes] type. Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2024_04_01.models.Identifier or IO[bytes]
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Identifier] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain_ownership_identifier, (IOBase, bytes)):
            _content = domain_ownership_identifier
        else:
            _json = self._serialize.body(domain_ownership_identifier, "Identifier")

        _request = build_create_or_update_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Identifier", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_domain_ownership_identifier(
        self, resource_group_name: str, name: str, domain_ownership_identifier_name: str, **kwargs: Any
    ) -> None:
        """Deletes a domain ownership identifier for a web app.

        Description for Deletes a domain ownership identifier for a web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: _models.Identifier,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Description for Creates a domain ownership identifier for web app, or updates an existing
        ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Description for Creates a domain ownership identifier for web app, or updates an existing
        ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: Union[_models.Identifier, IO[bytes]],
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Description for Creates a domain ownership identifier for web app, or updates an existing
        ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Is either a Identifier type or a IO[bytes] type. Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2024_04_01.models.Identifier or IO[bytes]
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Identifier] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain_ownership_identifier, (IOBase, bytes)):
            _content = domain_ownership_identifier
        else:
            _json = self._serialize.body(domain_ownership_identifier, "Identifier")

        _request = build_update_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Identifier", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_ms_deploy_status(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.MSDeployStatus:
        """Get the status of the last MSDeploy operation.

        Description for Get the status of the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: MSDeployStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.MSDeployStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)

        _request = build_get_ms_deploy_status_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployStatus", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_ms_deploy_operation_initial(
        self, resource_group_name: str, name: str, ms_deploy: Union[_models.MSDeploy, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            304: ResourceNotModifiedError,
            409: cast(
                Type[HttpResponseError],
                lambda response: ResourceExistsError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(ms_deploy, (IOBase, bytes)):
            _content = ms_deploy
        else:
            _json = self._serialize.body(ms_deploy, "MSDeploy")

        _request = build_create_ms_deploy_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_ms_deploy_operation(
        self,
        resource_group_name: str,
        name: str,
        ms_deploy: _models.MSDeploy,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Description for Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: ~azure.mgmt.web.v2024_04_01.models.MSDeploy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_ms_deploy_operation(
        self,
        resource_group_name: str,
        name: str,
        ms_deploy: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Description for Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_ms_deploy_operation(
        self, resource_group_name: str, name: str, ms_deploy: Union[_models.MSDeploy, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Description for Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param ms_deploy: Details of MSDeploy operation. Is either a MSDeploy type or a IO[bytes] type.
         Required.
        :type ms_deploy: ~azure.mgmt.web.v2024_04_01.models.MSDeploy or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_ms_deploy_operation_initial(
                resource_group_name=resource_group_name,
                name=name,
                ms_deploy=ms_deploy,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("MSDeployStatus", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.MSDeployStatus].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.MSDeployStatus](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_ms_deploy_log(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.MSDeployLog:
        """Get the MSDeploy Log for the last MSDeploy operation.

        Description for Get the MSDeploy Log for the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: MSDeployLog or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.MSDeployLog
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.MSDeployLog] = kwargs.pop("cls", None)

        _request = build_get_ms_deploy_log_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployLog", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_one_deploy_status(self, resource_group_name: str, name: str, **kwargs: Any) -> JSON:
        """Invoke onedeploy status API /api/deployments and gets the deployment status for the site.

        Description for Invoke onedeploy status API /api/deployments and gets the deployment status for
        the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_get_one_deploy_status_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def create_one_deploy_operation(self, resource_group_name: str, name: str, **kwargs: Any) -> JSON:
        """Invoke the OneDeploy publish web app extension.

        Description for Invoke the OneDeploy publish web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_create_one_deploy_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_functions(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.FunctionEnvelope"]:
        """List the functions for a web site, or a deployment slot.

        Description for List the functions for a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :return: An iterator like instance of either FunctionEnvelope or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.FunctionEnvelopeCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_functions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("FunctionEnvelopeCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_functions_admin_token(self, resource_group_name: str, name: str, **kwargs: Any) -> str:
        """Fetch a short lived token that can be exchanged for a master key.

        Description for Fetch a short lived token that can be exchanged for a master key.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[str] = kwargs.pop("cls", None)

        _request = build_get_functions_admin_token_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("str", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_function(
        self, resource_group_name: str, name: str, function_name: str, **kwargs: Any
    ) -> _models.FunctionEnvelope:
        """Get function information by its ID for web site, or a deployment slot.

        Description for Get function information by its ID for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :return: FunctionEnvelope or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.FunctionEnvelope
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.FunctionEnvelope] = kwargs.pop("cls", None)

        _request = build_get_function_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FunctionEnvelope", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_function_initial(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: Union[_models.FunctionEnvelope, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(function_envelope, (IOBase, bytes)):
            _content = function_envelope
        else:
            _json = self._serialize.body(function_envelope, "FunctionEnvelope")

        _request = build_create_function_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_function(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: _models.FunctionEnvelope,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FunctionEnvelope]:
        """Create function for web site, or a deployment slot.

        Description for Create function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :param function_envelope: Function details. Required.
        :type function_envelope: ~azure.mgmt.web.v2024_04_01.models.FunctionEnvelope
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either FunctionEnvelope or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_function(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FunctionEnvelope]:
        """Create function for web site, or a deployment slot.

        Description for Create function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :param function_envelope: Function details. Required.
        :type function_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either FunctionEnvelope or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_function(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: Union[_models.FunctionEnvelope, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FunctionEnvelope]:
        """Create function for web site, or a deployment slot.

        Description for Create function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :param function_envelope: Function details. Is either a FunctionEnvelope type or a IO[bytes]
         type. Required.
        :type function_envelope: ~azure.mgmt.web.v2024_04_01.models.FunctionEnvelope or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either FunctionEnvelope or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FunctionEnvelope] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_function_initial(
                resource_group_name=resource_group_name,
                name=name,
                function_name=function_name,
                function_envelope=function_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("FunctionEnvelope", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.FunctionEnvelope].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.FunctionEnvelope](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def delete_function(self, resource_group_name: str, name: str, function_name: str, **kwargs: Any) -> None:
        """Delete a function for web site, or a deployment slot.

        Description for Delete a function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_function_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def create_or_update_function_secret(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        key_name: str,
        key: _models.KeyInfo,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a function secret.

        Description for Add or update a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_function_secret(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        key_name: str,
        key: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a function secret.

        Description for Add or update a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_function_secret(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        key_name: str,
        key: Union[_models.KeyInfo, IO[bytes]],
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a function secret.

        Description for Add or update a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Is either a KeyInfo type or a IO[bytes] type.
         Required.
        :type key: ~azure.mgmt.web.v2024_04_01.models.KeyInfo or IO[bytes]
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyInfo] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(key, (IOBase, bytes)):
            _content = key
        else:
            _json = self._serialize.body(key, "KeyInfo")

        _request = build_create_or_update_function_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("KeyInfo", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_function_secret(
        self, resource_group_name: str, name: str, function_name: str, key_name: str, **kwargs: Any
    ) -> None:
        """Delete a function secret.

        Description for Delete a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_function_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def list_function_keys(
        self, resource_group_name: str, name: str, function_name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Get function keys for a function in a web site, or a deployment slot.

        Description for Get function keys for a function in a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_function_keys_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_function_secrets(
        self, resource_group_name: str, name: str, function_name: str, **kwargs: Any
    ) -> _models.FunctionSecrets:
        """Get function secrets for a function in a web site, or a deployment slot.

        Description for Get function secrets for a function in a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :return: FunctionSecrets or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.FunctionSecrets
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.FunctionSecrets] = kwargs.pop("cls", None)

        _request = build_list_function_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FunctionSecrets", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_host_keys(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.HostKeys:
        """Get host secrets for a function app.

        Description for Get host secrets for a function app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :return: HostKeys or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HostKeys
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.HostKeys] = kwargs.pop("cls", None)

        _request = build_list_host_keys_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HostKeys", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_sync_status(self, resource_group_name: str, name: str, **kwargs: Any) -> None:
        """This is to allow calling via powershell and ARM template.

        Description for This is to allow calling via powershell and ARM template.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_list_sync_status_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def sync_functions(self, resource_group_name: str, name: str, **kwargs: Any) -> None:
        """Syncs function trigger metadata to the management database.

        Description for Syncs function trigger metadata to the management database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_sync_functions_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def create_or_update_host_secret(
        self,
        resource_group_name: str,
        name: str,
        key_type: str,
        key_name: str,
        key: _models.KeyInfo,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a host level secret.

        Description for Add or update a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_host_secret(
        self,
        resource_group_name: str,
        name: str,
        key_type: str,
        key_name: str,
        key: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a host level secret.

        Description for Add or update a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_host_secret(
        self,
        resource_group_name: str,
        name: str,
        key_type: str,
        key_name: str,
        key: Union[_models.KeyInfo, IO[bytes]],
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a host level secret.

        Description for Add or update a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Is either a KeyInfo type or a IO[bytes] type.
         Required.
        :type key: ~azure.mgmt.web.v2024_04_01.models.KeyInfo or IO[bytes]
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyInfo] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(key, (IOBase, bytes)):
            _content = key
        else:
            _json = self._serialize.body(key, "KeyInfo")

        _request = build_create_or_update_host_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            key_type=key_type,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("KeyInfo", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_host_secret(
        self, resource_group_name: str, name: str, key_type: str, key_name: str, **kwargs: Any
    ) -> None:
        """Delete a host level secret.

        Description for Delete a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_host_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            key_type=key_type,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_host_name_bindings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.HostNameBinding"]:
        """Get hostname bindings for an app or a deployment slot.

        Description for Get hostname bindings for an app or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either HostNameBinding or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.HostNameBinding]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.HostNameBindingCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_host_name_bindings_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("HostNameBindingCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_host_name_binding(
        self, resource_group_name: str, name: str, host_name: str, **kwargs: Any
    ) -> _models.HostNameBinding:
        """Get the named hostname binding for an app (or deployment slot, if specified).

        Description for Get the named hostname binding for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.HostNameBinding] = kwargs.pop("cls", None)

        _request = build_get_host_name_binding_request(
            resource_group_name=resource_group_name,
            name=name,
            host_name=host_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HostNameBinding", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_host_name_binding(
        self,
        resource_group_name: str,
        name: str,
        host_name: str,
        host_name_binding: _models.HostNameBinding,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HostNameBinding:
        """Creates a hostname binding for an app.

        Description for Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :param host_name_binding: Binding details. This is the JSON representation of a HostNameBinding
         object. Required.
        :type host_name_binding: ~azure.mgmt.web.v2024_04_01.models.HostNameBinding
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_host_name_binding(
        self,
        resource_group_name: str,
        name: str,
        host_name: str,
        host_name_binding: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HostNameBinding:
        """Creates a hostname binding for an app.

        Description for Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :param host_name_binding: Binding details. This is the JSON representation of a HostNameBinding
         object. Required.
        :type host_name_binding: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_host_name_binding(
        self,
        resource_group_name: str,
        name: str,
        host_name: str,
        host_name_binding: Union[_models.HostNameBinding, IO[bytes]],
        **kwargs: Any
    ) -> _models.HostNameBinding:
        """Creates a hostname binding for an app.

        Description for Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :param host_name_binding: Binding details. This is the JSON representation of a HostNameBinding
         object. Is either a HostNameBinding type or a IO[bytes] type. Required.
        :type host_name_binding: ~azure.mgmt.web.v2024_04_01.models.HostNameBinding or IO[bytes]
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HostNameBinding] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(host_name_binding, (IOBase, bytes)):
            _content = host_name_binding
        else:
            _json = self._serialize.body(host_name_binding, "HostNameBinding")

        _request = build_create_or_update_host_name_binding_request(
            resource_group_name=resource_group_name,
            name=name,
            host_name=host_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HostNameBinding", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_host_name_binding(
        self, resource_group_name: str, name: str, host_name: str, **kwargs: Any
    ) -> None:
        """Deletes a hostname binding for an app.

        Description for Deletes a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_host_name_binding_request(
            resource_group_name=resource_group_name,
            name=name,
            host_name=host_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_hybrid_connection(
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> _models.HybridConnection:
        """Retrieves a specific Service Bus Hybrid Connection used by this Web App.

        Description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        _request = build_get_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: _models.HybridConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Description for Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Description for Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: Union[_models.HybridConnection, IO[bytes]],
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Description for Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Is either a HybridConnection
         type or a IO[bytes] type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.HybridConnection or IO[bytes]
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IOBase, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "HybridConnection")

        _request = build_create_or_update_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_hybrid_connection(
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> None:
        """Removes a Hybrid Connection from this site.

        Description for Removes a Hybrid Connection from this site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: _models.HybridConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Description for Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Description for Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: Union[_models.HybridConnection, IO[bytes]],
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Description for Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Is either a HybridConnection
         type or a IO[bytes] type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.HybridConnection or IO[bytes]
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IOBase, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "HybridConnection")

        _request = build_update_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_hybrid_connections(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.HybridConnection:
        """Retrieves all Service Bus Hybrid Connections used by this Web App.

        Description for Retrieves all Service Bus Hybrid Connections used by this Web App.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        _request = build_list_hybrid_connections_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_relay_service_connections(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Gets hybrid connections configured for an app (or deployment slot, if specified).

        Description for Gets hybrid connections configured for an app (or deployment slot, if
        specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        _request = build_list_relay_service_connections_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_relay_service_connection(
        self, resource_group_name: str, name: str, entity_name: str, **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Gets a hybrid connection configuration by its name.

        Description for Gets a hybrid connection configuration by its name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection. Required.
        :type entity_name: str
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        _request = build_get_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_relay_service_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: _models.RelayServiceConnectionEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Description for Creates a new hybrid connection configuration (PUT), or updates an existing one
        (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_relay_service_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Description for Creates a new hybrid connection configuration (PUT), or updates an existing one
        (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_relay_service_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: Union[_models.RelayServiceConnectionEntity, IO[bytes]],
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Description for Creates a new hybrid connection configuration (PUT), or updates an existing one
        (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Is either a
         RelayServiceConnectionEntity type or a IO[bytes] type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity or
         IO[bytes]
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IOBase, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "RelayServiceConnectionEntity")

        _request = build_create_or_update_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_relay_service_connection(
        self, resource_group_name: str, name: str, entity_name: str, **kwargs: Any
    ) -> None:
        """Deletes a relay service connection by its name.

        Description for Deletes a relay service connection by its name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: _models.RelayServiceConnectionEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Description for Creates a new hybrid connection configuration (PUT), or updates an existing one
        (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Description for Creates a new hybrid connection configuration (PUT), or updates an existing one
        (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: Union[_models.RelayServiceConnectionEntity, IO[bytes]],
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Description for Creates a new hybrid connection configuration (PUT), or updates an existing one
        (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Is either a
         RelayServiceConnectionEntity type or a IO[bytes] type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity or
         IO[bytes]
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IOBase, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "RelayServiceConnectionEntity")

        _request = build_update_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_instance_identifiers(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.WebSiteInstanceStatus"]:
        """Gets all scale-out instances of an app.

        Description for Gets all scale-out instances of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either WebSiteInstanceStatus or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.WebSiteInstanceStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.WebAppInstanceStatusCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_instance_identifiers_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppInstanceStatusCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_instance_info(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> _models.WebSiteInstanceStatus:
        """Gets all scale-out instances of an app.

        Description for Gets all scale-out instances of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param instance_id: Required.
        :type instance_id: str
        :return: WebSiteInstanceStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.WebSiteInstanceStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.WebSiteInstanceStatus] = kwargs.pop("cls", None)

        _request = build_get_instance_info_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("WebSiteInstanceStatus", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_instance_ms_deploy_status(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> _models.MSDeployStatus:
        """Get the status of the last MSDeploy operation.

        Description for Get the status of the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :return: MSDeployStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.MSDeployStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)

        _request = build_get_instance_ms_deploy_status_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployStatus", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_instance_ms_deploy_operation_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: Union[_models.MSDeploy, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            304: ResourceNotModifiedError,
            409: cast(
                Type[HttpResponseError],
                lambda response: ResourceExistsError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(ms_deploy, (IOBase, bytes)):
            _content = ms_deploy
        else:
            _json = self._serialize.body(ms_deploy, "MSDeploy")

        _request = build_create_instance_ms_deploy_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_instance_ms_deploy_operation(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: _models.MSDeploy,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Description for Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: ~azure.mgmt.web.v2024_04_01.models.MSDeploy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_instance_ms_deploy_operation(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Description for Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_instance_ms_deploy_operation(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: Union[_models.MSDeploy, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Description for Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :param ms_deploy: Details of MSDeploy operation. Is either a MSDeploy type or a IO[bytes] type.
         Required.
        :type ms_deploy: ~azure.mgmt.web.v2024_04_01.models.MSDeploy or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_instance_ms_deploy_operation_initial(
                resource_group_name=resource_group_name,
                name=name,
                instance_id=instance_id,
                ms_deploy=ms_deploy,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("MSDeployStatus", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.MSDeployStatus].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.MSDeployStatus](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_instance_ms_deploy_log(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> _models.MSDeployLog:
        """Get the MSDeploy Log for the last MSDeploy operation.

        Description for Get the MSDeploy Log for the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :return: MSDeployLog or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.MSDeployLog
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.MSDeployLog] = kwargs.pop("cls", None)

        _request = build_get_instance_ms_deploy_log_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployLog", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_instance_processes(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessInfo"]:
        """Get list of processes for a web site, or a deployment slot, or for a specific scaled-out
        instance in a web site.

        Description for Get list of processes for a web site, or a deployment slot, or for a specific
        scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :return: An iterator like instance of either ProcessInfo or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ProcessInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_instance_processes_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    instance_id=instance_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_instance_process(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> _models.ProcessInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Description for Get process information by its ID for a specific scaled-out instance in a web
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :return: ProcessInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ProcessInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessInfo] = kwargs.pop("cls", None)

        _request = build_get_instance_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessInfo", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_instance_process(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> None:
        """Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
        instance in a web site.

        Description for Terminate a process by its ID for a web site, or a deployment slot, or specific
        scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_instance_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_instance_process_dump(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.

        Description for Get a memory dump of a process by its ID for a specific scaled-out instance in
        a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :return: AsyncIterator[bytes] or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_get_instance_process_dump_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_instance_process_modules(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessModuleInfo"]:
        """List module information for a process by its ID for a specific scaled-out instance in a web
        site.

        Description for List module information for a process by its ID for a specific scaled-out
        instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :return: An iterator like instance of either ProcessModuleInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ProcessModuleInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessModuleInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_instance_process_modules_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    instance_id=instance_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessModuleInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_instance_process_module(
        self, resource_group_name: str, name: str, process_id: str, base_address: str, instance_id: str, **kwargs: Any
    ) -> _models.ProcessModuleInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Description for Get process information by its ID for a specific scaled-out instance in a web
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param base_address: Module base address. Required.
        :type base_address: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :return: ProcessModuleInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ProcessModuleInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessModuleInfo] = kwargs.pop("cls", None)

        _request = build_get_instance_process_module_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            base_address=base_address,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessModuleInfo", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_instance_process_threads(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessThreadInfo"]:
        """List the threads in a process by its ID for a specific scaled-out instance in a web site.

        Description for List the threads in a process by its ID for a specific scaled-out instance in a
        web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :return: An iterator like instance of either ProcessThreadInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ProcessThreadInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessThreadInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_instance_process_threads_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    instance_id=instance_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessThreadInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def is_cloneable(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.SiteCloneability:
        """Shows whether an app can be cloned to another resource group or subscription.

        Description for Shows whether an app can be cloned to another resource group or subscription.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SiteCloneability or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteCloneability
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteCloneability] = kwargs.pop("cls", None)

        _request = build_is_cloneable_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteCloneability", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_site_backups(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.BackupItem"]:
        """Gets existing backups of an app.

        Description for Gets existing backups of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either BackupItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.BackupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.BackupItemCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_site_backups_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BackupItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def list_sync_function_triggers(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.FunctionSecrets:
        """This is to allow calling via powershell and ARM template.

        Description for This is to allow calling via powershell and ARM template.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: FunctionSecrets or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.FunctionSecrets
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.FunctionSecrets] = kwargs.pop("cls", None)

        _request = build_list_sync_function_triggers_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FunctionSecrets", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def update_machine_key(self, resource_group_name: str, name: str, **kwargs: Any) -> JSON:
        """Updates the machine key of an app.

        Updates the machine key of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: JSON or the result of cls(response)
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_update_machine_key_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _migrate_storage_initial(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: Union[_models.StorageMigrationOptions, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(migration_options, (IOBase, bytes)):
            _content = migration_options
        else:
            _json = self._serialize.body(migration_options, "StorageMigrationOptions")

        _request = build_migrate_storage_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            subscription_name=subscription_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_migrate_storage(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: _models.StorageMigrationOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StorageMigrationResponse]:
        """Restores a web app.

        Description for Restores a web app.

        :param subscription_name: Azure subscription. Required.
        :type subscription_name: str
        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_options: Migration migrationOptions. Required.
        :type migration_options: ~azure.mgmt.web.v2024_04_01.models.StorageMigrationOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StorageMigrationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.StorageMigrationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_migrate_storage(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StorageMigrationResponse]:
        """Restores a web app.

        Description for Restores a web app.

        :param subscription_name: Azure subscription. Required.
        :type subscription_name: str
        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_options: Migration migrationOptions. Required.
        :type migration_options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StorageMigrationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.StorageMigrationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_migrate_storage(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: Union[_models.StorageMigrationOptions, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StorageMigrationResponse]:
        """Restores a web app.

        Description for Restores a web app.

        :param subscription_name: Azure subscription. Required.
        :type subscription_name: str
        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_options: Migration migrationOptions. Is either a StorageMigrationOptions type
         or a IO[bytes] type. Required.
        :type migration_options: ~azure.mgmt.web.v2024_04_01.models.StorageMigrationOptions or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either StorageMigrationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.StorageMigrationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StorageMigrationResponse] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._migrate_storage_initial(
                subscription_name=subscription_name,
                resource_group_name=resource_group_name,
                name=name,
                migration_options=migration_options,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("StorageMigrationResponse", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.StorageMigrationResponse].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.StorageMigrationResponse](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _migrate_my_sql_initial(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: Union[_models.MigrateMySqlRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(migration_request_envelope, (IOBase, bytes)):
            _content = migration_request_envelope
        else:
            _json = self._serialize.body(migration_request_envelope, "MigrateMySqlRequest")

        _request = build_migrate_my_sql_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_migrate_my_sql(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: _models.MigrateMySqlRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Operation]:
        """Migrates a local (in-app) MySql database to a remote MySql database.

        Description for Migrates a local (in-app) MySql database to a remote MySql database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_request_envelope: MySql migration options. Required.
        :type migration_request_envelope: ~azure.mgmt.web.v2024_04_01.models.MigrateMySqlRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Operation or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_migrate_my_sql(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Operation]:
        """Migrates a local (in-app) MySql database to a remote MySql database.

        Description for Migrates a local (in-app) MySql database to a remote MySql database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_request_envelope: MySql migration options. Required.
        :type migration_request_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Operation or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_migrate_my_sql(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: Union[_models.MigrateMySqlRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Operation]:
        """Migrates a local (in-app) MySql database to a remote MySql database.

        Description for Migrates a local (in-app) MySql database to a remote MySql database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_request_envelope: MySql migration options. Is either a MigrateMySqlRequest
         type or a IO[bytes] type. Required.
        :type migration_request_envelope: ~azure.mgmt.web.v2024_04_01.models.MigrateMySqlRequest or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either Operation or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Operation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._migrate_my_sql_initial(
                resource_group_name=resource_group_name,
                name=name,
                migration_request_envelope=migration_request_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Operation", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Operation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Operation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_migrate_my_sql_status(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.MigrateMySqlStatus:
        """Returns the status of MySql in app migration, if one is active, and whether or not MySql in app
        is enabled.

        Description for Returns the status of MySql in app migration, if one is active, and whether or
        not MySql in app is enabled.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: MigrateMySqlStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.MigrateMySqlStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.MigrateMySqlStatus] = kwargs.pop("cls", None)

        _request = build_get_migrate_my_sql_status_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MigrateMySqlStatus", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_swift_virtual_network_connection(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Gets a Swift Virtual Network connection.

        Description for Gets a Swift Virtual Network connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SwiftVirtualNetwork] = kwargs.pop("cls", None)

        _request = build_get_swift_virtual_network_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SwiftVirtualNetwork", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_swift_virtual_network_connection_with_check(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: _models.SwiftVirtualNetwork,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Description for Integrates this Web App with a Virtual Network. This requires that 1)
        "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet
        has already been delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_swift_virtual_network_connection_with_check(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Description for Integrates this Web App with a Virtual Network. This requires that 1)
        "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet
        has already been delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_swift_virtual_network_connection_with_check(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: Union[_models.SwiftVirtualNetwork, IO[bytes]],
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Description for Integrates this Web App with a Virtual Network. This requires that 1)
        "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet
        has already been delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example. Is
         either a SwiftVirtualNetwork type or a IO[bytes] type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork or IO[bytes]
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SwiftVirtualNetwork] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IOBase, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "SwiftVirtualNetwork")

        _request = build_create_or_update_swift_virtual_network_connection_with_check_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SwiftVirtualNetwork", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_swift_virtual_network(self, resource_group_name: str, name: str, **kwargs: Any) -> None:
        """Deletes a Swift Virtual Network connection from an app (or deployment slot).

        Description for Deletes a Swift Virtual Network connection from an app (or deployment slot).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_swift_virtual_network_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_swift_virtual_network_connection_with_check(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: _models.SwiftVirtualNetwork,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Description for Integrates this Web App with a Virtual Network. This requires that 1)
        "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet
        has already been delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_swift_virtual_network_connection_with_check(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Description for Integrates this Web App with a Virtual Network. This requires that 1)
        "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet
        has already been delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_swift_virtual_network_connection_with_check(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: Union[_models.SwiftVirtualNetwork, IO[bytes]],
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Description for Integrates this Web App with a Virtual Network. This requires that 1)
        "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet
        has already been delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example. Is
         either a SwiftVirtualNetwork type or a IO[bytes] type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork or IO[bytes]
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SwiftVirtualNetwork] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IOBase, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "SwiftVirtualNetwork")

        _request = build_update_swift_virtual_network_connection_with_check_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SwiftVirtualNetwork", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_network_features(
        self, resource_group_name: str, name: str, view: str, **kwargs: Any
    ) -> _models.NetworkFeatures:
        """Gets all network features used by the app (or deployment slot, if specified).

        Description for Gets all network features used by the app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param view: The type of view. Only "summary" is supported at this time. Required.
        :type view: str
        :return: NetworkFeatures or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.NetworkFeatures
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.NetworkFeatures] = kwargs.pop("cls", None)

        _request = build_list_network_features_request(
            resource_group_name=resource_group_name,
            name=name,
            view=view,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkFeatures", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_network_trace_operation(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Description for Gets a named operation for a network trace capturing (or deployment slot, if
        specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2024_04_01.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        _request = build_get_network_trace_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[NetworkTrace]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def start_web_site_network_trace(
        self,
        resource_group_name: str,
        name: str,
        duration_in_seconds: Optional[int] = None,
        max_frame_length: Optional[int] = None,
        sas_url: Optional[str] = None,
        **kwargs: Any
    ) -> str:
        """Start capturing network packets for the site (To be deprecated).

        Description for Start capturing network packets for the site (To be deprecated).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param duration_in_seconds: The duration to keep capturing in seconds. Default value is None.
        :type duration_in_seconds: int
        :param max_frame_length: The maximum frame length in bytes (Optional). Default value is None.
        :type max_frame_length: int
        :param sas_url: The Blob URL to store capture file. Default value is None.
        :type sas_url: str
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[str] = kwargs.pop("cls", None)

        _request = build_start_web_site_network_trace_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            duration_in_seconds=duration_in_seconds,
            max_frame_length=max_frame_length,
            sas_url=sas_url,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("str", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _start_web_site_network_trace_operation_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        duration_in_seconds: Optional[int] = None,
        max_frame_length: Optional[int] = None,
        sas_url: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_start_web_site_network_trace_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            duration_in_seconds=duration_in_seconds,
            max_frame_length=max_frame_length,
            sas_url=sas_url,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_start_web_site_network_trace_operation(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        duration_in_seconds: Optional[int] = None,
        max_frame_length: Optional[int] = None,
        sas_url: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[List[_models.NetworkTrace]]:
        """Start capturing network packets for the site.

        Description for Start capturing network packets for the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param duration_in_seconds: The duration to keep capturing in seconds. Default value is None.
        :type duration_in_seconds: int
        :param max_frame_length: The maximum frame length in bytes (Optional). Default value is None.
        :type max_frame_length: int
        :param sas_url: The Blob URL to store capture file. Default value is None.
        :type sas_url: str
        :return: An instance of AsyncLROPoller that returns either list of NetworkTrace or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[list[~azure.mgmt.web.v2024_04_01.models.NetworkTrace]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._start_web_site_network_trace_operation_initial(
                resource_group_name=resource_group_name,
                name=name,
                duration_in_seconds=duration_in_seconds,
                max_frame_length=max_frame_length,
                sas_url=sas_url,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[List[_models.NetworkTrace]].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[List[_models.NetworkTrace]](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def stop_web_site_network_trace(self, resource_group_name: str, name: str, **kwargs: Any) -> None:
        """Stop ongoing capturing network packets for the site.

        Description for Stop ongoing capturing network packets for the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_stop_web_site_network_trace_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_network_traces(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Description for Gets a named operation for a network trace capturing (or deployment slot, if
        specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2024_04_01.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        _request = build_get_network_traces_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[NetworkTrace]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_network_trace_operation_v2(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Description for Gets a named operation for a network trace capturing (or deployment slot, if
        specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2024_04_01.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        _request = build_get_network_trace_operation_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[NetworkTrace]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_network_traces_v2(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Description for Gets a named operation for a network trace capturing (or deployment slot, if
        specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2024_04_01.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        _request = build_get_network_traces_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[NetworkTrace]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def generate_new_site_publishing_password(self, resource_group_name: str, name: str, **kwargs: Any) -> None:
        """Generates a new publishing password for an app (or deployment slot, if specified).

        Description for Generates a new publishing password for an app (or deployment slot, if
        specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_generate_new_site_publishing_password_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_perf_mon_counters(
        self, resource_group_name: str, name: str, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.PerfMonResponse"]:
        """Gets perfmon counters for web app.

        Description for Gets perfmon counters for web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param filter: Return only usages/metrics specified in the filter. Filter conforms to odata
         syntax. Example: $filter=(startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z
         and timeGrain eq duration'[Hour|Minute|Day]'. Default value is None.
        :type filter: str
        :return: An iterator like instance of either PerfMonResponse or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.PerfMonResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PerfMonCounterCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_perf_mon_counters_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PerfMonCounterCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_site_php_error_log_flag(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SitePhpErrorLogFlag:
        """Gets web app's event logs.

        Description for Gets web app's event logs.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :return: SitePhpErrorLogFlag or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SitePhpErrorLogFlag
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SitePhpErrorLogFlag] = kwargs.pop("cls", None)

        _request = build_get_site_php_error_log_flag_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SitePhpErrorLogFlag", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_premier_add_ons(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.PremierAddOn:
        """Gets the premier add-ons of an app.

        Description for Gets the premier add-ons of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        _request = build_list_premier_add_ons_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_premier_add_on(
        self, resource_group_name: str, name: str, premier_add_on_name: str, **kwargs: Any
    ) -> _models.PremierAddOn:
        """Gets a named add-on of an app.

        Description for Gets a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        _request = build_get_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: _models.PremierAddOn,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Description for Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Description for Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: Union[_models.PremierAddOn, IO[bytes]],
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Description for Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Is either a
         PremierAddOn type or a IO[bytes] type. Required.
        :type premier_add_on: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn or IO[bytes]
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(premier_add_on, (IOBase, bytes)):
            _content = premier_add_on
        else:
            _json = self._serialize.body(premier_add_on, "PremierAddOn")

        _request = build_add_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_premier_add_on(
        self, resource_group_name: str, name: str, premier_add_on_name: str, **kwargs: Any
    ) -> None:
        """Delete a premier add-on from an app.

        Description for Delete a premier add-on from an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: _models.PremierAddOnPatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Description for Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: ~azure.mgmt.web.v2024_04_01.models.PremierAddOnPatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Description for Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: Union[_models.PremierAddOnPatchResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Description for Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Is either a
         PremierAddOnPatchResource type or a IO[bytes] type. Required.
        :type premier_add_on: ~azure.mgmt.web.v2024_04_01.models.PremierAddOnPatchResource or IO[bytes]
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(premier_add_on, (IOBase, bytes)):
            _content = premier_add_on
        else:
            _json = self._serialize.body(premier_add_on, "PremierAddOnPatchResource")

        _request = build_update_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_private_access(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.PrivateAccess:
        """Gets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Description for Gets data around private site access enablement and authorized Virtual Networks
        that can access the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PrivateAccess] = kwargs.pop("cls", None)

        _request = build_get_private_access_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PrivateAccess", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def put_private_access_vnet(
        self,
        resource_group_name: str,
        name: str,
        access: _models.PrivateAccess,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PrivateAccess:
        """Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Description for Sets data around private site access enablement and authorized Virtual Networks
        that can access the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param access: The information for the private access. Required.
        :type access: ~azure.mgmt.web.v2024_04_01.models.PrivateAccess
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def put_private_access_vnet(
        self,
        resource_group_name: str,
        name: str,
        access: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PrivateAccess:
        """Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Description for Sets data around private site access enablement and authorized Virtual Networks
        that can access the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param access: The information for the private access. Required.
        :type access: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def put_private_access_vnet(
        self, resource_group_name: str, name: str, access: Union[_models.PrivateAccess, IO[bytes]], **kwargs: Any
    ) -> _models.PrivateAccess:
        """Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Description for Sets data around private site access enablement and authorized Virtual Networks
        that can access the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param access: The information for the private access. Is either a PrivateAccess type or a
         IO[bytes] type. Required.
        :type access: ~azure.mgmt.web.v2024_04_01.models.PrivateAccess or IO[bytes]
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PrivateAccess] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(access, (IOBase, bytes)):
            _content = access
        else:
            _json = self._serialize.body(access, "PrivateAccess")

        _request = build_put_private_access_vnet_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PrivateAccess", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_private_endpoint_connection_list(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.RemotePrivateEndpointConnectionARMResource"]:
        # pylint: disable=line-too-long
        """Gets the list of private endpoint connections associated with a site.

        Description for Gets the list of private endpoint connections associated with a site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :return: An iterator like instance of either RemotePrivateEndpointConnectionARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PrivateEndpointConnectionCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_private_endpoint_connection_list_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PrivateEndpointConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_private_endpoint_connection(
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> _models.RemotePrivateEndpointConnectionARMResource:
        """Gets a private endpoint connection.

        Description for Gets a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :return: RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.RemotePrivateEndpointConnectionARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.RemotePrivateEndpointConnectionARMResource] = kwargs.pop("cls", None)

        _request = build_get_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RemotePrivateEndpointConnectionARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _approve_or_reject_private_endpoint_connection_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: Union[_models.RemotePrivateEndpointConnectionARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(private_endpoint_wrapper, (IOBase, bytes)):
            _content = private_endpoint_wrapper
        else:
            _json = self._serialize.body(private_endpoint_wrapper, "RemotePrivateEndpointConnectionARMResource")

        _request = build_approve_or_reject_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_approve_or_reject_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: _models.RemotePrivateEndpointConnectionARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        # pylint: disable=line-too-long
        """Approves or rejects a private endpoint connection.

        Description for Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Required.
        :type private_endpoint_wrapper:
         ~azure.mgmt.web.v2024_04_01.models.RemotePrivateEndpointConnectionARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_approve_or_reject_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        # pylint: disable=line-too-long
        """Approves or rejects a private endpoint connection.

        Description for Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Required.
        :type private_endpoint_wrapper: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_approve_or_reject_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: Union[_models.RemotePrivateEndpointConnectionARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        # pylint: disable=line-too-long
        """Approves or rejects a private endpoint connection.

        Description for Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Is either a RemotePrivateEndpointConnectionARMResource type or
         a IO[bytes] type. Required.
        :type private_endpoint_wrapper:
         ~azure.mgmt.web.v2024_04_01.models.RemotePrivateEndpointConnectionARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RemotePrivateEndpointConnectionARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._approve_or_reject_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                name=name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                private_endpoint_wrapper=private_endpoint_wrapper,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize(
                "RemotePrivateEndpointConnectionARMResource", pipeline_response.http_response
            )
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_private_endpoint_connection_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_private_endpoint_connection(
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Deletes a private endpoint connection.

        Description for Deletes a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :return: An instance of AsyncLROPoller that returns either JSON or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                name=name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("object", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_private_link_resources(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.PrivateLinkResourcesWrapper:
        """Gets the private link resources.

        Description for Gets the private link resources.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :return: PrivateLinkResourcesWrapper or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PrivateLinkResourcesWrapper
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PrivateLinkResourcesWrapper] = kwargs.pop("cls", None)

        _request = build_get_private_link_resources_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PrivateLinkResourcesWrapper", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_processes(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessInfo"]:
        """Get list of processes for a web site, or a deployment slot, or for a specific scaled-out
        instance in a web site.

        Description for Get list of processes for a web site, or a deployment slot, or for a specific
        scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :return: An iterator like instance of either ProcessInfo or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ProcessInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_processes_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_process(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> _models.ProcessInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Description for Get process information by its ID for a specific scaled-out instance in a web
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :return: ProcessInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ProcessInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessInfo] = kwargs.pop("cls", None)

        _request = build_get_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessInfo", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_process(self, resource_group_name: str, name: str, process_id: str, **kwargs: Any) -> None:
        """Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
        instance in a web site.

        Description for Terminate a process by its ID for a web site, or a deployment slot, or specific
        scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_process_dump(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.

        Description for Get a memory dump of a process by its ID for a specific scaled-out instance in
        a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :return: AsyncIterator[bytes] or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_get_process_dump_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_process_modules(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessModuleInfo"]:
        """List module information for a process by its ID for a specific scaled-out instance in a web
        site.

        Description for List module information for a process by its ID for a specific scaled-out
        instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :return: An iterator like instance of either ProcessModuleInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ProcessModuleInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessModuleInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_process_modules_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessModuleInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_process_module(
        self, resource_group_name: str, name: str, process_id: str, base_address: str, **kwargs: Any
    ) -> _models.ProcessModuleInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Description for Get process information by its ID for a specific scaled-out instance in a web
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param base_address: Module base address. Required.
        :type base_address: str
        :return: ProcessModuleInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ProcessModuleInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessModuleInfo] = kwargs.pop("cls", None)

        _request = build_get_process_module_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            base_address=base_address,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessModuleInfo", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_process_threads(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessThreadInfo"]:
        """List the threads in a process by its ID for a specific scaled-out instance in a web site.

        Description for List the threads in a process by its ID for a specific scaled-out instance in a
        web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :return: An iterator like instance of either ProcessThreadInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ProcessThreadInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ProcessThreadInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_process_threads_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessThreadInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_public_certificates(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.PublicCertificate"]:
        """Get public certificates for an app or a deployment slot.

        Description for Get public certificates for an app or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either PublicCertificate or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.PublicCertificate]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PublicCertificateCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_public_certificates_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublicCertificateCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_public_certificate(
        self, resource_group_name: str, name: str, public_certificate_name: str, **kwargs: Any
    ) -> _models.PublicCertificate:
        """Get the named public certificate for an app (or deployment slot, if specified).

        Description for Get the named public certificate for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PublicCertificate] = kwargs.pop("cls", None)

        _request = build_get_public_certificate_request(
            resource_group_name=resource_group_name,
            name=name,
            public_certificate_name=public_certificate_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PublicCertificate", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_public_certificate(
        self,
        resource_group_name: str,
        name: str,
        public_certificate_name: str,
        public_certificate: _models.PublicCertificate,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PublicCertificate:
        """Creates a hostname binding for an app.

        Description for Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :param public_certificate: Public certificate details. This is the JSON representation of a
         PublicCertificate object. Required.
        :type public_certificate: ~azure.mgmt.web.v2024_04_01.models.PublicCertificate
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_public_certificate(
        self,
        resource_group_name: str,
        name: str,
        public_certificate_name: str,
        public_certificate: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PublicCertificate:
        """Creates a hostname binding for an app.

        Description for Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :param public_certificate: Public certificate details. This is the JSON representation of a
         PublicCertificate object. Required.
        :type public_certificate: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_public_certificate(
        self,
        resource_group_name: str,
        name: str,
        public_certificate_name: str,
        public_certificate: Union[_models.PublicCertificate, IO[bytes]],
        **kwargs: Any
    ) -> _models.PublicCertificate:
        """Creates a hostname binding for an app.

        Description for Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :param public_certificate: Public certificate details. This is the JSON representation of a
         PublicCertificate object. Is either a PublicCertificate type or a IO[bytes] type. Required.
        :type public_certificate: ~azure.mgmt.web.v2024_04_01.models.PublicCertificate or IO[bytes]
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PublicCertificate] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(public_certificate, (IOBase, bytes)):
            _content = public_certificate
        else:
            _json = self._serialize.body(public_certificate, "PublicCertificate")

        _request = build_create_or_update_public_certificate_request(
            resource_group_name=resource_group_name,
            name=name,
            public_certificate_name=public_certificate_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PublicCertificate", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_public_certificate(
        self, resource_group_name: str, name: str, public_certificate_name: str, **kwargs: Any
    ) -> None:
        """Deletes a hostname binding for an app.

        Description for Deletes a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_public_certificate_request(
            resource_group_name=resource_group_name,
            name=name,
            public_certificate_name=public_certificate_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def list_publishing_profile_xml_with_secrets(
        self,
        resource_group_name: str,
        name: str,
        publishing_profile_options: _models.CsmPublishingProfileOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Gets the publishing profile for an app (or deployment slot, if specified).

        Description for Gets the publishing profile for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param publishing_profile_options: Specifies publishingProfileOptions for publishing profile.
         For example, use {"format": "FileZilla3"} to get a FileZilla publishing profile. Required.
        :type publishing_profile_options:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingProfileOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes] or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_publishing_profile_xml_with_secrets(
        self,
        resource_group_name: str,
        name: str,
        publishing_profile_options: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Gets the publishing profile for an app (or deployment slot, if specified).

        Description for Gets the publishing profile for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param publishing_profile_options: Specifies publishingProfileOptions for publishing profile.
         For example, use {"format": "FileZilla3"} to get a FileZilla publishing profile. Required.
        :type publishing_profile_options: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AsyncIterator[bytes] or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_publishing_profile_xml_with_secrets(
        self,
        resource_group_name: str,
        name: str,
        publishing_profile_options: Union[_models.CsmPublishingProfileOptions, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Gets the publishing profile for an app (or deployment slot, if specified).

        Description for Gets the publishing profile for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param publishing_profile_options: Specifies publishingProfileOptions for publishing profile.
         For example, use {"format": "FileZilla3"} to get a FileZilla publishing profile. Is either a
         CsmPublishingProfileOptions type or a IO[bytes] type. Required.
        :type publishing_profile_options:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingProfileOptions or IO[bytes]
        :return: AsyncIterator[bytes] or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(publishing_profile_options, (IOBase, bytes)):
            _content = publishing_profile_options
        else:
            _json = self._serialize.body(publishing_profile_options, "CsmPublishingProfileOptions")

        _request = build_list_publishing_profile_xml_with_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def reset_production_slot_config(self, resource_group_name: str, name: str, **kwargs: Any) -> None:
        """Resets the configuration settings of the current slot if they were previously modified by
        calling the API with POST.

        Description for Resets the configuration settings of the current slot if they were previously
        modified by calling the API with POST.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_reset_production_slot_config_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def restart(
        self,
        resource_group_name: str,
        name: str,
        soft_restart: Optional[bool] = None,
        synchronous: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Restarts an app (or deployment slot, if specified).

        Description for Restarts an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param soft_restart: Specify true to apply the configuration settings and restarts the app only
         if necessary. By default, the API always restarts and reprovisions the app. Default value is
         None.
        :type soft_restart: bool
        :param synchronous: Specify true to block until the app is restarted. By default, it is set to
         false, and the API responds immediately (asynchronous). Default value is None.
        :type synchronous: bool
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_restart_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            soft_restart=soft_restart,
            synchronous=synchronous,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    async def _restore_from_backup_blob_initial(
        self, resource_group_name: str, name: str, request: Union[_models.RestoreRequest, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        _request = build_restore_from_backup_blob_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_restore_from_backup_blob(
        self,
        resource_group_name: str,
        name: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores an app from a backup blob in Azure Storage.

        Description for Restores an app from a backup blob in Azure Storage.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Information on restore request . Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_from_backup_blob(
        self,
        resource_group_name: str,
        name: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores an app from a backup blob in Azure Storage.

        Description for Restores an app from a backup blob in Azure Storage.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Information on restore request . Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_from_backup_blob(
        self, resource_group_name: str, name: str, request: Union[_models.RestoreRequest, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores an app from a backup blob in Azure Storage.

        Description for Restores an app from a backup blob in Azure Storage.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Information on restore request . Is either a RestoreRequest type or a IO[bytes]
         type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_from_backup_blob_initial(
                resource_group_name=resource_group_name,
                name=name,
                request=request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _restore_from_deleted_app_initial(
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.DeletedAppRestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(restore_request, (IOBase, bytes)):
            _content = restore_request
        else:
            _json = self._serialize.body(restore_request, "DeletedAppRestoreRequest")

        _request = build_restore_from_deleted_app_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_restore_from_deleted_app(
        self,
        resource_group_name: str,
        name: str,
        restore_request: _models.DeletedAppRestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a deleted web app to this web app.

        Description for Restores a deleted web app to this web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Deleted web app restore information. Required.
        :type restore_request: ~azure.mgmt.web.v2024_04_01.models.DeletedAppRestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_from_deleted_app(
        self,
        resource_group_name: str,
        name: str,
        restore_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a deleted web app to this web app.

        Description for Restores a deleted web app to this web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Deleted web app restore information. Required.
        :type restore_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_from_deleted_app(
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.DeletedAppRestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a deleted web app to this web app.

        Description for Restores a deleted web app to this web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Deleted web app restore information. Is either a
         DeletedAppRestoreRequest type or a IO[bytes] type. Required.
        :type restore_request: ~azure.mgmt.web.v2024_04_01.models.DeletedAppRestoreRequest or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_from_deleted_app_initial(
                resource_group_name=resource_group_name,
                name=name,
                restore_request=restore_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _restore_snapshot_initial(
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.SnapshotRestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(restore_request, (IOBase, bytes)):
            _content = restore_request
        else:
            _json = self._serialize.body(restore_request, "SnapshotRestoreRequest")

        _request = build_restore_snapshot_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_restore_snapshot(
        self,
        resource_group_name: str,
        name: str,
        restore_request: _models.SnapshotRestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a web app from a snapshot.

        Description for Restores a web app from a snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Snapshot restore settings. Snapshot information can be obtained by
         calling GetDeletedSites or GetSiteSnapshots API. Required.
        :type restore_request: ~azure.mgmt.web.v2024_04_01.models.SnapshotRestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_snapshot(
        self,
        resource_group_name: str,
        name: str,
        restore_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a web app from a snapshot.

        Description for Restores a web app from a snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Snapshot restore settings. Snapshot information can be obtained by
         calling GetDeletedSites or GetSiteSnapshots API. Required.
        :type restore_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_snapshot(
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.SnapshotRestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a web app from a snapshot.

        Description for Restores a web app from a snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Snapshot restore settings. Snapshot information can be obtained by
         calling GetDeletedSites or GetSiteSnapshots API. Is either a SnapshotRestoreRequest type or a
         IO[bytes] type. Required.
        :type restore_request: ~azure.mgmt.web.v2024_04_01.models.SnapshotRestoreRequest or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_snapshot_initial(
                resource_group_name=resource_group_name,
                name=name,
                restore_request=restore_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_site_containers(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteContainer"]:
        """Lists all the site containers of a site, or a deployment slot.

        Lists all the site containers of a site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either SiteContainer or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.SiteContainer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteContainerCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_site_containers_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteContainerCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_site_container(
        self, resource_group_name: str, name: str, container_name: str, **kwargs: Any
    ) -> _models.SiteContainer:
        """Gets a site container of a site, or a deployment slot.

        Gets a site container of a site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param container_name: Site Container Name. Required.
        :type container_name: str
        :return: SiteContainer or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteContainer] = kwargs.pop("cls", None)

        _request = build_get_site_container_request(
            resource_group_name=resource_group_name,
            name=name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteContainer", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_site_container(
        self,
        resource_group_name: str,
        name: str,
        container_name: str,
        request: _models.SiteContainer,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteContainer:
        """Creates or Updates a site container for a site, or a deployment slot.

        Creates or Updates a site container for a site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param container_name: Site Container Name. Required.
        :type container_name: str
        :param request: Container Entity. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.SiteContainer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteContainer or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_site_container(
        self,
        resource_group_name: str,
        name: str,
        container_name: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteContainer:
        """Creates or Updates a site container for a site, or a deployment slot.

        Creates or Updates a site container for a site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param container_name: Site Container Name. Required.
        :type container_name: str
        :param request: Container Entity. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteContainer or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_site_container(
        self,
        resource_group_name: str,
        name: str,
        container_name: str,
        request: Union[_models.SiteContainer, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteContainer:
        """Creates or Updates a site container for a site, or a deployment slot.

        Creates or Updates a site container for a site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param container_name: Site Container Name. Required.
        :type container_name: str
        :param request: Container Entity. Is either a SiteContainer type or a IO[bytes] type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.SiteContainer or IO[bytes]
        :return: SiteContainer or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteContainer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteContainer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "SiteContainer")

        _request = build_create_or_update_site_container_request(
            resource_group_name=resource_group_name,
            name=name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteContainer", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_site_container(
        self, resource_group_name: str, name: str, container_name: str, **kwargs: Any
    ) -> None:
        """Deletes a site container for a site, or a deployment slot.

        Deletes a site container for a site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param container_name: Site Container Name. Required.
        :type container_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_site_container_request(
            resource_group_name=resource_group_name,
            name=name,
            container_name=container_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_site_extensions(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteExtensionInfo"]:
        """Get list of siteextensions for a web site, or a deployment slot.

        Description for Get list of siteextensions for a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :return: An iterator like instance of either SiteExtensionInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.SiteExtensionInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteExtensionInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_site_extensions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteExtensionInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_site_extension(
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> _models.SiteExtensionInfo:
        """Get site extension information by its ID for a web site, or a deployment slot.

        Description for Get site extension information by its ID for a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param site_extension_id: Site extension name. Required.
        :type site_extension_id: str
        :return: SiteExtensionInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteExtensionInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteExtensionInfo] = kwargs.pop("cls", None)

        _request = build_get_site_extension_request(
            resource_group_name=resource_group_name,
            name=name,
            site_extension_id=site_extension_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteExtensionInfo", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _install_site_extension_initial(
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            429: cast(
                Type[HttpResponseError],
                lambda response: HttpResponseError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_install_site_extension_request(
            resource_group_name=resource_group_name,
            name=name,
            site_extension_id=site_extension_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_install_site_extension(
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.SiteExtensionInfo]:
        """Install site extension on a web site, or a deployment slot.

        Description for Install site extension on a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param site_extension_id: Site extension name. Required.
        :type site_extension_id: str
        :return: An instance of AsyncLROPoller that returns either SiteExtensionInfo or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.SiteExtensionInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteExtensionInfo] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._install_site_extension_initial(
                resource_group_name=resource_group_name,
                name=name,
                site_extension_id=site_extension_id,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("SiteExtensionInfo", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.SiteExtensionInfo].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.SiteExtensionInfo](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def delete_site_extension(
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> None:
        """Remove a site extension from a web site, or a deployment slot.

        Description for Remove a site extension from a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param site_extension_id: Site extension name. Required.
        :type site_extension_id: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_site_extension_request(
            resource_group_name=resource_group_name,
            name=name,
            site_extension_id=site_extension_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_slots(self, resource_group_name: str, name: str, **kwargs: Any) -> AsyncIterable["_models.Site"]:
        """Gets an app's deployment slots.

        Description for Gets an app's deployment slots.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :return: An iterator like instance of either Site or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.WebAppCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_slots_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_slot(self, resource_group_name: str, name: str, slot: str, **kwargs: Any) -> _models.Site:
        """Gets the details of a web, mobile, or API app.

        Description for Gets the details of a web, mobile, or API app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. By default, this API returns the production slot.
         Required.
        :type slot: str
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        _request = build_get_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Site", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_slot_initial(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: Union[_models.Site, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IOBase, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "Site")

        _request = build_create_or_update_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: _models.Site,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. By default, this API attempts to
         create or modify the production slot. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.Site
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. By default, this API attempts to
         create or modify the production slot. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: Union[_models.Site, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. By default, this API attempts to
         create or modify the production slot. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         Site type or a IO[bytes] type. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.Site or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_slot_initial(
                resource_group_name=resource_group_name,
                name=name,
                slot=slot,
                site_envelope=site_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Site", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Site].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Site](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def delete_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        delete_metrics: Optional[bool] = None,
        delete_empty_server_farm: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a web, mobile, or API app, or one of the deployment slots.

        Description for Deletes a web, mobile, or API app, or one of the deployment slots.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app to delete. Required.
        :type name: str
        :param slot: Name of the deployment slot to delete. By default, the API deletes the production
         slot. Required.
        :type slot: str
        :param delete_metrics: If true, web app metrics are also deleted. Default value is None.
        :type delete_metrics: bool
        :param delete_empty_server_farm: Specify false if you want to keep empty App Service plan. By
         default, empty App Service plan is deleted. Default value is None.
        :type delete_empty_server_farm: bool
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            delete_metrics=delete_metrics,
            delete_empty_server_farm=delete_empty_server_farm,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: _models.SitePatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. By default, this API attempts to
         create or modify the production slot. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.SitePatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. By default, this API attempts to
         create or modify the production slot. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: Union[_models.SitePatchResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Description for Creates a new web, mobile, or API app in an existing resource group, or updates
        an existing app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. By default, this API attempts to
         create or modify the production slot. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         SitePatchResource type or a IO[bytes] type. Required.
        :type site_envelope: ~azure.mgmt.web.v2024_04_01.models.SitePatchResource or IO[bytes]
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IOBase, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "SitePatchResource")

        _request = build_update_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Site", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def analyze_custom_hostname_slot(
        self, resource_group_name: str, name: str, slot: str, host_name: Optional[str] = None, **kwargs: Any
    ) -> _models.CustomHostnameAnalysisResult:
        """Analyze a custom hostname.

        Description for Analyze a custom hostname.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param host_name: Custom hostname. Default value is None.
        :type host_name: str
        :return: CustomHostnameAnalysisResult or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CustomHostnameAnalysisResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CustomHostnameAnalysisResult] = kwargs.pop("cls", None)

        _request = build_analyze_custom_hostname_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            host_name=host_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CustomHostnameAnalysisResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def apply_slot_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        slot_swap_entity: _models.CsmSlotEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Description for Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the source slot. If a slot is not specified, the production slot is used
         as the source slot. Required.
        :type slot: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2024_04_01.models.CsmSlotEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def apply_slot_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        slot_swap_entity: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Description for Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the source slot. If a slot is not specified, the production slot is used
         as the source slot. Required.
        :type slot: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def apply_slot_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        slot_swap_entity: Union[_models.CsmSlotEntity, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Description for Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the source slot. If a slot is not specified, the production slot is used
         as the source slot. Required.
        :type slot: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Is either
         a CsmSlotEntity type or a IO[bytes] type. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2024_04_01.models.CsmSlotEntity or IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(slot_swap_entity, (IOBase, bytes)):
            _content = slot_swap_entity
        else:
            _json = self._serialize.body(slot_swap_entity, "CsmSlotEntity")

        _request = build_apply_slot_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def backup_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Description for Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will create a
         backup for the production slot. Required.
        :type slot: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def backup_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Description for Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will create a
         backup for the production slot. Required.
        :type slot: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def backup_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: Union[_models.BackupRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Description for Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will create a
         backup for the production slot. Required.
        :type slot: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Is either a BackupRequest type or a IO[bytes] type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest or IO[bytes]
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        _request = build_backup_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_backups_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.BackupItem"]:
        """Gets existing backups of an app.

        Description for Gets existing backups of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get backups
         of the production slot. Required.
        :type slot: str
        :return: An iterator like instance of either BackupItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.BackupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.BackupItemCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_backups_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BackupItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_backup_status_slot(
        self, resource_group_name: str, name: str, backup_id: str, slot: str, **kwargs: Any
    ) -> _models.BackupItem:
        """Gets a backup of an app by its ID.

        Description for Gets a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get a backup
         of the production slot. Required.
        :type slot: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        _request = build_get_backup_status_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_backup_slot(
        self, resource_group_name: str, name: str, backup_id: str, slot: str, **kwargs: Any
    ) -> None:
        """Deletes a backup of an app by its ID.

        Description for Deletes a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will delete a
         backup of the production slot. Required.
        :type slot: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_backup_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def list_backup_status_secrets_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Description for Gets status of a web app backup that may be in progress, including secrets
        associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the
        SAS URL for the backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param request: Information on backup request. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_backup_status_secrets_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Description for Gets status of a web app backup that may be in progress, including secrets
        associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the
        SAS URL for the backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param request: Information on backup request. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_backup_status_secrets_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: Union[_models.BackupRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Description for Gets status of a web app backup that may be in progress, including secrets
        associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the
        SAS URL for the backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param request: Information on backup request. Is either a BackupRequest type or a IO[bytes]
         type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest or IO[bytes]
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        _request = build_list_backup_status_secrets_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _restore_slot_initial(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: Union[_models.RestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        _request = build_restore_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_restore_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Description for Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will restore a
         backup of the production slot. Required.
        :type slot: str
        :param request: Information on restore request . Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Description for Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will restore a
         backup of the production slot. Required.
        :type slot: str
        :param request: Information on restore request . Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: Union[_models.RestoreRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Description for Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will restore a
         backup of the production slot. Required.
        :type slot: str
        :param request: Information on restore request . Is either a RestoreRequest type or a IO[bytes]
         type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.RestoreRequest or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_slot_initial(
                resource_group_name=resource_group_name,
                name=name,
                backup_id=backup_id,
                slot=slot,
                request=request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_basic_publishing_credentials_policies_slot(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.CsmPublishingCredentialsPoliciesEntity"]:
        # pylint: disable=line-too-long
        """Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.

        Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a
        given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :return: An iterator like instance of either CsmPublishingCredentialsPoliciesEntity or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PublishingCredentialsPoliciesCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_basic_publishing_credentials_policies_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublishingCredentialsPoliciesCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_ftp_allowed_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether FTP is allowed on the site or not.

        Description for Returns whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        _request = build_get_ftp_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_ftp_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Description for Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_ftp_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Description for Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_ftp_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO[bytes]],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Description for Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO[bytes] type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity or IO[bytes]
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IOBase, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        _request = build_update_ftp_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_scm_allowed_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether Scm basic auth is allowed on the site or not.

        Description for Returns whether Scm basic auth is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        _request = build_get_scm_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_scm_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Description for Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_scm_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Description for Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_scm_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO[bytes]],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Description for Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO[bytes] type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity or IO[bytes]
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IOBase, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        _request = build_update_scm_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_configurations_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteConfigResource"]:
        """List the configurations of an app.

        Description for List the configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will return
         configuration for the production slot. Required.
        :type slot: str
        :return: An iterator like instance of either SiteConfigResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.SiteConfigResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigResourceCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_configurations_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteConfigResourceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def update_application_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Description for Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         application settings for the production slot. Required.
        :type slot: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_application_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        app_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Description for Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         application settings for the production slot. Required.
        :type slot: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_application_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        app_settings: Union[_models.StringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Description for Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         application settings for the production slot. Required.
        :type slot: str
        :param app_settings: Application settings of the app. Is either a StringDictionary type or a
         IO[bytes] type. Required.
        :type app_settings: ~azure.mgmt.web.v2024_04_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        _request = build_update_application_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_application_settings_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of an app.

        Description for Gets the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         application settings for the production slot. Required.
        :type slot: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_application_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_auth_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings: _models.SiteAuthSettings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Description for Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Description for Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings: Union[_models.SiteAuthSettings, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Description for Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings: Auth settings associated with web app. Is either a SiteAuthSettings
         type or a IO[bytes] type. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings or IO[bytes]
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings, (IOBase, bytes)):
            _content = site_auth_settings
        else:
            _json = self._serialize.body(site_auth_settings, "SiteAuthSettings")

        _request = build_update_auth_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_auth_settings_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Gets the Authentication/Authorization settings of an app.

        Description for Gets the Authentication/Authorization settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         settings for the production slot. Required.
        :type slot: str
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        _request = build_get_auth_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_auth_settings_v2_without_secrets_slot(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Gets site's Authentication / Authorization settings for apps via the V2 format.

        Gets site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         settings for the production slot. Required.
        :type slot: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        _request = build_get_auth_settings_v2_without_secrets_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_auth_settings_v2_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings_v2: _models.SiteAuthSettingsV2,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Description for Updates site's Authentication / Authorization settings for apps via the V2
        format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings_v2_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings_v2: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Description for Updates site's Authentication / Authorization settings for apps via the V2
        format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings_v2_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings_v2: Union[_models.SiteAuthSettingsV2, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Description for Updates site's Authentication / Authorization settings for apps via the V2
        format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings_v2: Auth settings associated with web app. Is either a
         SiteAuthSettingsV2 type or a IO[bytes] type. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2 or IO[bytes]
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings_v2, (IOBase, bytes)):
            _content = site_auth_settings_v2
        else:
            _json = self._serialize.body(site_auth_settings_v2, "SiteAuthSettingsV2")

        _request = build_update_auth_settings_v2_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_auth_settings_v2_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Gets site's Authentication / Authorization settings for apps via the V2 format.

        Description for Gets site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         settings for the production slot. Required.
        :type slot: str
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        _request = build_get_auth_settings_v2_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_azure_storage_accounts_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        azure_storage_accounts: _models.AzureStoragePropertyDictionaryResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Description for Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_azure_storage_accounts_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        azure_storage_accounts: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Description for Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_azure_storage_accounts_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        azure_storage_accounts: Union[_models.AzureStoragePropertyDictionaryResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Description for Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :param azure_storage_accounts: Azure storage accounts of the app. Is either a
         AzureStoragePropertyDictionaryResource type or a IO[bytes] type. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource or IO[bytes]
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(azure_storage_accounts, (IOBase, bytes)):
            _content = azure_storage_accounts
        else:
            _json = self._serialize.body(azure_storage_accounts, "AzureStoragePropertyDictionaryResource")

        _request = build_update_azure_storage_accounts_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_azure_storage_accounts_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Gets the Azure storage account configurations of an app.

        Description for Gets the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        _request = build_list_azure_storage_accounts_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_backup_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Description for Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         backup configuration for the production slot. Required.
        :type slot: str
        :param request: Edited backup configuration. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_backup_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Description for Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         backup configuration for the production slot. Required.
        :type slot: str
        :param request: Edited backup configuration. Required.
        :type request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_backup_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: Union[_models.BackupRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Description for Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         backup configuration for the production slot. Required.
        :type slot: str
        :param request: Edited backup configuration. Is either a BackupRequest type or a IO[bytes]
         type. Required.
        :type request: ~azure.mgmt.web.v2024_04_01.models.BackupRequest or IO[bytes]
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IOBase, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        _request = build_update_backup_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_backup_configuration_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> None:
        """Deletes the backup configuration of an app.

        Description for Deletes the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will delete the
         backup configuration for the production slot. Required.
        :type slot: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_backup_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_backup_configuration_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.BackupRequest:
        """Gets the backup configuration of an app.

        Description for Gets the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         backup configuration for the production slot. Required.
        :type slot: str
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        _request = build_get_backup_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_app_settings_key_vault_references_slot(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Description for Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_app_settings_key_vault_references_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_app_setting_key_vault_reference_slot(
        self, resource_group_name: str, name: str, app_setting_key: str, slot: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Description for Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_setting_key: App Setting key name. Required.
        :type app_setting_key: str
        :param slot: Required.
        :type slot: str
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        _request = build_get_app_setting_key_vault_reference_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            app_setting_key=app_setting_key,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_site_connection_string_key_vault_references_slot(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Description for Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_site_connection_string_key_vault_references_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_site_connection_string_key_vault_reference_slot(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, connection_string_key: str, slot: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Description for Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_string_key: Required.
        :type connection_string_key: str
        :param slot: Required.
        :type slot: str
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        _request = build_get_site_connection_string_key_vault_reference_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            connection_string_key=connection_string_key,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_connection_strings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        connection_strings: _models.ConnectionStringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Description for Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         connection settings for the production slot. Required.
        :type slot: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_connection_strings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        connection_strings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Description for Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         connection settings for the production slot. Required.
        :type slot: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_connection_strings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        connection_strings: Union[_models.ConnectionStringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Description for Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         connection settings for the production slot. Required.
        :type slot: str
        :param connection_strings: Connection strings of the app or deployment slot. See example. Is
         either a ConnectionStringDictionary type or a IO[bytes] type. Required.
        :type connection_strings: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary or
         IO[bytes]
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_strings, (IOBase, bytes)):
            _content = connection_strings
        else:
            _json = self._serialize.body(connection_strings, "ConnectionStringDictionary")

        _request = build_update_connection_strings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_connection_strings_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Gets the connection strings of an app.

        Description for Gets the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         connection settings for the production slot. Required.
        :type slot: str
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        _request = build_list_connection_strings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_diagnostic_logs_configuration_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Gets the logging configuration of an app.

        Description for Gets the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         logging configuration for the production slot. Required.
        :type slot: str
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        _request = build_get_diagnostic_logs_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_diagnostic_logs_config_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_logs_config: _models.SiteLogsConfig,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Description for Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         logging configuration for the production slot. Required.
        :type slot: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_diagnostic_logs_config_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_logs_config: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Description for Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         logging configuration for the production slot. Required.
        :type slot: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_diagnostic_logs_config_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_logs_config: Union[_models.SiteLogsConfig, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Description for Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         logging configuration for the production slot. Required.
        :type slot: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Is either a SiteLogsConfig type or a IO[bytes] type.
         Required.
        :type site_logs_config: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig or IO[bytes]
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_logs_config, (IOBase, bytes)):
            _content = site_logs_config
        else:
            _json = self._serialize.body(site_logs_config, "SiteLogsConfig")

        _request = build_update_diagnostic_logs_config_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_metadata_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        metadata: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Description for Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         metadata for the production slot. Required.
        :type slot: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_metadata_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        metadata: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Description for Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         metadata for the production slot. Required.
        :type slot: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_metadata_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        metadata: Union[_models.StringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Description for Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         metadata for the production slot. Required.
        :type slot: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Is either a
         StringDictionary type or a IO[bytes] type. Required.
        :type metadata: ~azure.mgmt.web.v2024_04_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(metadata, (IOBase, bytes)):
            _content = metadata
        else:
            _json = self._serialize.body(metadata, "StringDictionary")

        _request = build_update_metadata_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_metadata_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the metadata of an app.

        Description for Gets the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         metadata for the production slot. Required.
        :type slot: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_metadata_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _list_publishing_credentials_slot_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_list_publishing_credentials_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_list_publishing_credentials_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.User]:
        """Gets the Git/FTP publishing credentials of an app.

        Description for Gets the Git/FTP publishing credentials of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         publishing credentials for the production slot. Required.
        :type slot: str
        :return: An instance of AsyncLROPoller that returns either User or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.User]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.User] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_publishing_credentials_slot_initial(
                resource_group_name=resource_group_name,
                name=name,
                slot=slot,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("User", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.User].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.User](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def update_site_push_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        push_settings: _models.PushSettings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Description for Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param push_settings: Push settings associated with web app. Required.
        :type push_settings: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_site_push_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        push_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Description for Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param push_settings: Push settings associated with web app. Required.
        :type push_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_site_push_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        push_settings: Union[_models.PushSettings, IO[bytes]],
        **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Description for Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param push_settings: Push settings associated with web app. Is either a PushSettings type or a
         IO[bytes] type. Required.
        :type push_settings: ~azure.mgmt.web.v2024_04_01.models.PushSettings or IO[bytes]
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PushSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(push_settings, (IOBase, bytes)):
            _content = push_settings
        else:
            _json = self._serialize.body(push_settings, "PushSettings")

        _request = build_update_site_push_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PushSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_site_push_settings_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.PushSettings:
        """Gets the Push settings associated with web app.

        Description for Gets the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.PushSettings] = kwargs.pop("cls", None)

        _request = build_list_site_push_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PushSettings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_configuration_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Gets the configuration of an app, such as platform version and bitness, default documents,
        virtual applications, Always On, etc.

        Description for Gets the configuration of an app, such as platform version and bitness, default
        documents, virtual applications, Always On, etc.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will return
         configuration for the production slot. Required.
        :type slot: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        _request = build_get_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_config: _models.SiteConfigResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update
         configuration for the production slot. Required.
        :type slot: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_config: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update
         configuration for the production slot. Required.
        :type slot: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_config: Union[_models.SiteConfigResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update
         configuration for the production slot. Required.
        :type slot: str
        :param site_config: JSON representation of a SiteConfig object. See example. Is either a
         SiteConfigResource type or a IO[bytes] type. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource or IO[bytes]
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_config, (IOBase, bytes)):
            _content = site_config
        else:
            _json = self._serialize.body(site_config, "SiteConfigResource")

        _request = build_create_or_update_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_config: _models.SiteConfigResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update
         configuration for the production slot. Required.
        :type slot: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_config: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update
         configuration for the production slot. Required.
        :type slot: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_config: Union[_models.SiteConfigResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Description for Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update
         configuration for the production slot. Required.
        :type slot: str
        :param site_config: JSON representation of a SiteConfig object. See example. Is either a
         SiteConfigResource type or a IO[bytes] type. Required.
        :type site_config: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource or IO[bytes]
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_config, (IOBase, bytes)):
            _content = site_config
        else:
            _json = self._serialize.body(site_config, "SiteConfigResource")

        _request = build_update_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_configuration_snapshot_info_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteConfigurationSnapshotInfo"]:
        """Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
        timestamp and the ID of the snapshot.

        Description for Gets a list of web app configuration snapshots identifiers. Each element of the
        list contains a timestamp and the ID of the snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will return
         configuration for the production slot. Required.
        :type slot: str
        :return: An iterator like instance of either SiteConfigurationSnapshotInfo or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.SiteConfigurationSnapshotInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigurationSnapshotInfoCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_configuration_snapshot_info_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteConfigurationSnapshotInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_configuration_snapshot_slot(
        self, resource_group_name: str, name: str, snapshot_id: str, slot: str, **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Gets a snapshot of the configuration of an app at a previous point in time.

        Description for Gets a snapshot of the configuration of an app at a previous point in time.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param snapshot_id: The ID of the snapshot to read. Required.
        :type snapshot_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will return
         configuration for the production slot. Required.
        :type slot: str
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        _request = build_get_configuration_snapshot_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            snapshot_id=snapshot_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def recover_site_configuration_snapshot_slot(
        self, resource_group_name: str, name: str, snapshot_id: str, slot: str, **kwargs: Any
    ) -> None:
        """Reverts the configuration of an app to a previous snapshot.

        Description for Reverts the configuration of an app to a previous snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param snapshot_id: The ID of the snapshot to read. Required.
        :type snapshot_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will return
         configuration for the production slot. Required.
        :type slot: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_recover_site_configuration_snapshot_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            snapshot_id=snapshot_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_web_site_container_logs_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> Optional[AsyncIterator[bytes]]:
        """Gets the last lines of docker logs for the given site.

        Description for Gets the last lines of docker logs for the given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :return: AsyncIterator[bytes] or None or the result of cls(response)
        :rtype: AsyncIterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[Optional[AsyncIterator[bytes]]] = kwargs.pop("cls", None)

        _request = build_get_web_site_container_logs_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_container_logs_zip_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> Optional[AsyncIterator[bytes]]:
        """Gets the ZIP archived docker log files for the given site.

        Description for Gets the ZIP archived docker log files for the given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :return: AsyncIterator[bytes] or None or the result of cls(response)
        :rtype: AsyncIterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[Optional[AsyncIterator[bytes]]] = kwargs.pop("cls", None)

        _request = build_get_container_logs_zip_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_continuous_web_jobs_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.ContinuousWebJob"]:
        """List continuous web jobs for an app, or a deployment slot.

        Description for List continuous web jobs for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API deletes a
         deployment for the production slot. Required.
        :type slot: str
        :return: An iterator like instance of either ContinuousWebJob or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.ContinuousWebJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ContinuousWebJobCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_continuous_web_jobs_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ContinuousWebJobCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_continuous_web_job_slot(
        self, resource_group_name: str, name: str, web_job_name: str, slot: str, **kwargs: Any
    ) -> _models.ContinuousWebJob:
        """Gets a continuous web job by its ID for an app, or a deployment slot.

        Description for Gets a continuous web job by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API deletes a
         deployment for the production slot. Required.
        :type slot: str
        :return: ContinuousWebJob or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2024_04_01.models.ContinuousWebJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.ContinuousWebJob] = kwargs.pop("cls", None)

        _request = build_get_continuous_web_job_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ContinuousWebJob", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_continuous_web_job_slot(
        self, resource_group_name: str, name: str, web_job_name: str, slot: str, **kwargs: Any
    ) -> None:
        """Delete a continuous web job by its ID for an app, or a deployment slot.

        Description for Delete a continuous web job by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API deletes a
         deployment for the production slot. Required.
        :type slot: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_continuous_web_job_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def start_continuous_web_job_slot(
        self, resource_group_name: str, name: str, web_job_name: str, slot: str, **kwargs: Any
    ) -> None:
        """Start a continuous web job for an app, or a deployment slot.

        Description for Start a continuous web job for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API deletes a
         deployment for the production slot. Required.
        :type slot: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_start_continuous_web_job_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def stop_continuous_web_job_slot(
        self, resource_group_name: str, name: str, web_job_name: str, slot: str, **kwargs: Any
    ) -> None:
        """Stop a continuous web job for an app, or a deployment slot.

        Description for Stop a continuous web job for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API deletes a
         deployment for the production slot. Required.
        :type slot: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: cast(
                Type[HttpResponseError],
                lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_stop_continuous_web_job_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)  # type: ignore
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def list_slot_site_deployment_statuses_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.CsmDeploymentStatus"]:
        """List deployment statuses for an app (or deployment slot, if specified).

        List deployment statuses for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         deployment status for the production slot. Required.
        :type slot: str
        :return: An iterator like instance of either CsmDeploymentStatus or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2024_04_01.models.CsmDeploymentStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmDeploymentStatusCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_slot_site_deployment_statuses_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CsmDeploymentStatusCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _get_slot_site_deployment_status_slot_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, slot: str, deployment_status_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_get_slot_site_deployment_status_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            deployment_status_id=deployment_status_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_slot_site_deployment_status_slot(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, slot: str, deployment_status_id: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.CsmDeploymentStatus]:
        """Gets the deployment status for an app (or deployment slot, if specified).

        Gets the deployment status for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         deployment status for the production slot. Required.
        :type slot: str
        :param deployment_status_id: GUID of the deployment operation. Required.
        :type deployment_status_id: str
        :return: An instance of AsyncLROPoller that returns either CsmDeploymentStatus or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2024_04_01.models.CsmDeploymentStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2024-04-01"))
        cls: ClsType[_models.CsmDeploymentStatus] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_slot_site_deployment_status_slot_initial(
                resource_group_name=resource_group_name,
                name=name,
                slot=slot,
                deployment_status_id=deployment_status_id,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("CsmDeploymentStatus", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPo