#
# PySNMP MIB module ISCSI-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/ISCSI-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:18:55 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, OctetString, Integer, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ConstraintsIntersection, ValueSizeConstraint, ValueRangeConstraint, SingleValueConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ConstraintsIntersection", "ValueSizeConstraint", "ValueRangeConstraint", "SingleValueConstraint")
( InetAddress, InetPortNumber, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetPortNumber", "InetAddressType")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( Counter32, Counter64, iso, MibScalar, MibTable, MibTableRow, MibTableColumn, Unsigned32, ObjectIdentity, Gauge32, mib_2, Integer32, TimeTicks, ModuleIdentity, IpAddress, Bits, MibIdentifier, NotificationType, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter32", "Counter64", "iso", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Unsigned32", "ObjectIdentity", "Gauge32", "mib-2", "Integer32", "TimeTicks", "ModuleIdentity", "IpAddress", "Bits", "MibIdentifier", "NotificationType")
( RowPointer, DisplayString, RowStatus, AutonomousType, TimeStamp, TextualConvention, StorageType, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowPointer", "DisplayString", "RowStatus", "AutonomousType", "TimeStamp", "TextualConvention", "StorageType", "TruthValue")
iscsiMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 142)).setRevisions(("2006-05-22 00:00",))
if mibBuilder.loadTexts: iscsiMibModule.setLastUpdated('200605220000Z')
if mibBuilder.loadTexts: iscsiMibModule.setOrganization('IETF IPS Working Group')
if mibBuilder.loadTexts: iscsiMibModule.setContactInfo('\n    Mark Bakke\n    Cisco Systems, Inc\n    7900 International Drive, Suite 400\n    Bloomington, MN\n    USA 55425\n\n    E-mail: mbakke@cisco.com\n\n    Marjorie Krueger\n    Hewlett-Packard\n    Networked Storage Architecture\n    Networked Storage Solutions Org.\n    8000 Foothills Blvd.\n    Roseville, CA 95747\n\n    E-mail: marjorie_krueger@hp.com\n\n    Tom McSweeney\n    IBM Corporation\n    600 Park Offices Drive\n    Research Triangle Park, NC\n    USA 27709\n\n    E-mail: tommcs@us.ibm.com\n\n    James Muchow\n    Qlogic Corp.\n    6321 Bury Dr.\n    Eden Prairie, MN\n    USA 55346\n\n    E-mail: james.muchow@qlogic.com')
if mibBuilder.loadTexts: iscsiMibModule.setDescription('The iSCSI Protocol MIB module.\n         Copyright (C) The Internet Society (2006).  This version of\n         this MIB module is part of RFC 4544;  see the RFC itself for\n         full legal notices.')
iscsiNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 0))
iscsiObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1))
iscsiConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 2))
iscsiAdmin = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3))
class IscsiTransportProtocol(Unsigned32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,255)

class IscsiDigestMethod(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))
    namedValues = NamedValues(("none", 1), ("other", 2), ("noDigest", 3), ("crc32c", 4),)

class IscsiName(OctetString, TextualConvention):
    displayHint = '223t'
    subtypeSpec = OctetString.subtypeSpec+ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(16,223),)
iscsiDescriptors = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3, 1))
iscsiHeaderIntegrityTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3, 1, 1))
iscsiHdrIntegrityNone = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 1, 1))
if mibBuilder.loadTexts: iscsiHdrIntegrityNone.setDescription('The authoritative identifier when no integrity\n        scheme (for either the header or data) is being\n\n        used.')
iscsiHdrIntegrityCrc32c = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 1, 2))
if mibBuilder.loadTexts: iscsiHdrIntegrityCrc32c.setDescription('The authoritative identifier when the integrity\n        scheme (for either the header or data) is CRC32c.')
iscsiDataIntegrityTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3, 1, 2))
iscsiDataIntegrityNone = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 2, 1))
if mibBuilder.loadTexts: iscsiDataIntegrityNone.setDescription('The authoritative identifier when no integrity\n        scheme (for either the header or data) is being\n        used.')
iscsiDataIntegrityCrc32c = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 2, 2))
if mibBuilder.loadTexts: iscsiDataIntegrityCrc32c.setDescription('The authoritative identifier when the integrity\n        scheme (for either the header or data) is CRC32c.')
iscsiInstance = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 1))
iscsiInstanceAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 1, 1), )
if mibBuilder.loadTexts: iscsiInstanceAttributesTable.setDescription('A list of iSCSI instances present on the system.')
iscsiInstanceAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"))
if mibBuilder.loadTexts: iscsiInstanceAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular iSCSI instance.')
iscsiInstIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: iscsiInstIndex.setDescription('An arbitrary integer used to uniquely identify a particular\n        iSCSI instance.  This index value must not be modified or\n        reused by an agent unless a reboot has occurred.  An agent\n        should attempt to keep this value persistent across reboots.')
iscsiInstDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstDescr.setDescription('A UTF-8 string, determined by the implementation to\n        describe the iSCSI instance.  When only a single instance\n        is present, this object may be set to the zero-length\n        string; with multiple iSCSI instances, it may be used in\n        an implementation-dependent manner to describe the purpose\n        of the respective instance.')
iscsiInstVersionMin = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVersionMin.setDescription('The minimum version number of the iSCSI specification\n        such that this iSCSI instance supports this minimum\n        value, the maximum value indicated by the corresponding\n        instance in iscsiInstVersionMax, and all versions in\n        between.')
iscsiInstVersionMax = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVersionMax.setDescription('The maximum version number of the iSCSI specification\n        such that this iSCSI instance supports this maximum\n        value, the minimum value indicated by the corresponding\n        instance in iscsiInstVersionMin, and all versions in\n        between.')
iscsiInstVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVendorID.setDescription('A UTF-8 string describing the manufacturer of the\n        implementation of this instance.')
iscsiInstVendorVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 6), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVendorVersion.setDescription('A UTF-8 string set by the manufacturer describing the\n        version of the implementation of this instance.  The\n        format of this string is determined solely by the\n        manufacturer, and is for informational purposes only.\n\n        It is unrelated to the iSCSI specification version numbers.')
iscsiInstPortalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 7), Unsigned32()).setUnits('transport endpoints').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstPortalNumber.setDescription('The number of rows in the iscsiPortalAttributesTable\n        that are currently associated with this iSCSI instance.')
iscsiInstNodeNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 8), Unsigned32()).setUnits('iSCSI nodes').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstNodeNumber.setDescription('The number of rows in the iscsiNodeAttributesTable\n        that are currently associated with this iSCSI instance.')
iscsiInstSessionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 9), Unsigned32()).setUnits('sessions').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSessionNumber.setDescription('The number of rows in the iscsiSessionAttributesTable\n        that are currently associated with this iSCSI instance.')
iscsiInstSsnFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 10), Counter32()).setUnits('sessions').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnFailures.setDescription('This object counts the number of times a session belonging\n        to this instance has been failed.  If this counter has\n        suffered a discontinuity, the time of the last discontinuity\n        is indicated in iscsiInstDiscontinuityTime.')
iscsiInstLastSsnFailureType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 11), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstLastSsnFailureType.setDescription('The counter object in the iscsiInstSsnErrorStatsTable\n        that was incremented when the last session failure occurred.\n\n        If the reason for failure is not found in the\n        iscsiInstSsnErrorStatsTable, the value { 0.0 } is\n        used instead.')
iscsiInstLastSsnRmtNodeName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 12), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstLastSsnRmtNodeName.setDescription('The iSCSI name of the remote node from the failed\n        session.')
iscsiInstDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 13), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstDiscontinuityTime.setDescription("The value of SysUpTime on the most recent occasion\n        at which any one or more of this instance's counters\n        suffered a discontinuity.\n\n        If no such discontinuities have occurred since the last\n        re-initialization of the local management subsystem,\n        then this object contains a zero value.")
iscsiInstanceSsnErrorStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 1, 2), )
if mibBuilder.loadTexts: iscsiInstanceSsnErrorStatsTable.setDescription('Statistics regarding the occurrences of error types\n        that result in a session failure.')
iscsiInstanceSsnErrorStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1), )
iscsiInstanceAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiInstanceSsnErrorStatsEntry"))
iscsiInstanceSsnErrorStatsEntry.setIndexNames(*iscsiInstanceAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: iscsiInstanceSsnErrorStatsEntry.setDescription('An entry (row) containing management information applicable\n        to a particular iSCSI instance.')
iscsiInstSsnDigestErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1, 1), Counter32()).setUnits('sessions').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnDigestErrors.setDescription('The count of sessions that were failed due to receipt of\n        a PDU containing header or data digest errors.  If this\n        counter has suffered a discontinuity, the time of the last\n        discontinuity is indicated in iscsiInstDiscontinuityTime.')
iscsiInstSsnCxnTimeoutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1, 2), Counter32()).setUnits('sessions').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnCxnTimeoutErrors.setDescription('The count of sessions that were failed due to a sequence\n        exceeding a time limit.  If this counter has suffered a\n        discontinuity, the time of the last discontinuity\n        is indicated in iscsiInstDiscontinuityTime.')
iscsiInstSsnFormatErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1, 3), Counter32()).setUnits('sessions').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnFormatErrors.setDescription('The count of sessions that were failed due to receipt of\n        a PDU that contained a format error.  If this counter has\n        suffered a discontinuity, the time of the last discontinuity\n        is indicated in iscsiInstDiscontinuityTime.')
iscsiPortal = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 2))
iscsiPortalAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 2, 1), )
if mibBuilder.loadTexts: iscsiPortalAttributesTable.setDescription('A list of transport endpoints (using TCP or another transport\n        protocol) used by this iSCSI instance.  An iSCSI instance may\n        use a portal to listen for incoming connections to its targets,\n        to initiate connections to other targets, or both.')
iscsiPortalAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiPortalIndex"))
if mibBuilder.loadTexts: iscsiPortalAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular portal instance.')
iscsiPortalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: iscsiPortalIndex.setDescription('An arbitrary integer used to uniquely identify a particular\n        transport endpoint within this iSCSI instance.  This index\n        value must not be modified or reused by an agent unless a\n        reboot has occurred.  An agent should attempt to keep this\n        value persistent across reboots.')
iscsiPortalRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalRowStatus.setDescription("This field allows entries to be dynamically added and\n        removed from this table via SNMP.  When adding a row to\n        this table, all non-Index/RowStatus objects must be set.\n        When the value of this object is 'active', the values of\n        the other objects in this table cannot be changed.\n        Rows may be discarded using RowStatus.\n\n        Note that creating a row in this table will typically\n        cause the agent to create one or more rows in\n        iscsiTgtPortalAttributesTable and/or\n        iscsiIntrPortalAttributesTable.")
iscsiPortalRoles = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 3), Bits().clone(namedValues=NamedValues(("targetTypePortal", 0), ("initiatorTypePortal", 1),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalRoles.setDescription('A portal can operate in one or both of two roles:\n        as a target portal and/or an initiator portal.  If\n        the portal will operate in both roles, both bits\n        must be set.\n\n        This object will define a corresponding row that\n\n        will exist or must be created in the\n        iscsiTgtPortalAttributesTable, the\n        iscsiIntrPortalAttributesTable or both.  If the\n        targetTypePortal bit is set, one or more corresponding\n        iscsiTgtPortalAttributesEntry rows will be found or\n        created.  If the initiatorTypePortal bit is set,\n        one or more corresponding iscsiIntrPortalAttributesEntry\n        rows will be found or created.  If both bits are set, one\n        or more corresponding rows will be found or created in\n        one of the above tables.')
iscsiPortalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 4), InetAddressType().clone('ipv4')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalAddrType.setDescription('The type of Internet Network Address contained in the\n        corresponding instance of the iscsiPortalAddr.')
iscsiPortalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 5), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalAddr.setDescription("The portal's Internet Network Address, of the type\n        specified by the object iscsiPortalAddrType.  If\n        iscsiPortalAddrType has the value 'dns', this address\n        gets resolved to an IP address whenever a new iSCSI\n        connection is established using this portal.")
iscsiPortalProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 6), IscsiTransportProtocol().clone(6)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalProtocol.setDescription("The portal's transport protocol.")
iscsiPortalMaxRecvDataSegLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(512,16777215)).clone(8192)).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalMaxRecvDataSegLength.setDescription('The maximum PDU length this portal can receive.\n        This may be constrained by hardware characteristics\n        and individual implementations may choose not to\n        allow this object to be changed.')
iscsiPortalPrimaryHdrDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 8), IscsiDigestMethod().clone('crc32c')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalPrimaryHdrDigest.setDescription('The preferred header digest for this portal.')
iscsiPortalPrimaryDataDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 9), IscsiDigestMethod().clone('crc32c')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalPrimaryDataDigest.setDescription('The preferred data digest method for this portal.')
iscsiPortalSecondaryHdrDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 10), IscsiDigestMethod().clone('noDigest')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalSecondaryHdrDigest.setDescription('An alternate header digest preference for this portal.')
iscsiPortalSecondaryDataDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 11), IscsiDigestMethod().clone('noDigest')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalSecondaryDataDigest.setDescription('An alternate data digest preference for this portal.')
iscsiPortalRecvMarker = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 12), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalRecvMarker.setDescription('This object indicates whether or not this portal will\n        request markers in its incoming data stream.')
iscsiPortalStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 13), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalStorageType.setDescription("The storage type for this row.  Rows in this table that were\n         created through an external process may have a storage type of\n         readOnly or permanent.\n\n         Conceptual rows having the value 'permanent' need not\n         allow write access to any columnar objects in the row.")
iscsiTargetPortal = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 3))
iscsiTgtPortalAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 3, 1), )
if mibBuilder.loadTexts: iscsiTgtPortalAttributesTable.setDescription('A list of transport endpoints (using TCP or another transport\n        protocol) on which this iSCSI instance listens for incoming\n        connections to its targets.')
iscsiTgtPortalAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiPortalIndex"), (0, "ISCSI-MIB", "iscsiTgtPortalNodeIndexOrZero"))
if mibBuilder.loadTexts: iscsiTgtPortalAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular portal instance that is used to listen for\n        incoming connections to local targets.  One or more rows in\n        this table is populated by the agent for each\n\n        iscsiPortalAttributesEntry row that has the bit\n        targetTypePortal set in its iscsiPortalRoles column.')
iscsiTgtPortalNodeIndexOrZero = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: iscsiTgtPortalNodeIndexOrZero.setDescription('An arbitrary integer used to uniquely identify a\n        particular node within an iSCSI instance present\n        on the local system.\n\n        For implementations where each {portal, node} tuple\n        can have a different portal tag, this value will\n        map to the iscsiNodeIndex.\n\n        For implementations where the portal tag is the\n        same for a given portal regardless of which node\n        is using the portal, the value 0 (zero) is used.')
iscsiTgtPortalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1, 2), InetPortNumber().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiTgtPortalPort.setDescription("The portal's transport protocol port number on which the\n        portal listens for incoming iSCSI connections when the\n        portal is used as a target portal.  This object's storage\n        type is specified in iscsiPortalStorageType.")
iscsiTgtPortalTag = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiTgtPortalTag.setDescription("The portal's aggregation tag when the portal is used as\n        a target portal.  Multiple-connection sessions may\n\n        be aggregated over portals sharing an identical\n        aggregation tag.  This object's storage type is\n        specified in iscsiPortalStorageType.")
iscsiInitiatorPortal = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 4))
iscsiIntrPortalAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 4, 1), )
if mibBuilder.loadTexts: iscsiIntrPortalAttributesTable.setDescription('A list of Internet Network Addresses (using TCP or another\n        transport protocol) from which this iSCSI instance may\n        initiate connections to other targets.')
iscsiIntrPortalAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 4, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiPortalIndex"), (0, "ISCSI-MIB", "iscsiIntrPortalNodeIndexOrZero"))
if mibBuilder.loadTexts: iscsiIntrPortalAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular portal instance that is used to initiate\n        connections to iSCSI targets.  One or more rows in\n        this table is populated by the agent for each\n        iscsiPortalAttributesEntry row that has the bit\n        initiatorTypePortal set in its iscsiPortalRoles column.')
iscsiIntrPortalNodeIndexOrZero = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 4, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: iscsiIntrPortalNodeIndexOrZero.setDescription('An arbitrary integer used to uniquely identify a\n        particular node within an iSCSI instance present\n        on the local system.\n\n        For implementations where each {portal, node} tuple\n        can have a different portal tag, this value will\n        map to the iscsiNodeIndex.\n\n        For implementations where the portal tag is the\n        same for a given portal regardless of which node\n        is using the portal, the value 0 (zero) is used.')
iscsiIntrPortalTag = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 4, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiIntrPortalTag.setDescription("The portal's aggregation tag when the portal is used as\n        an initiator portal.  Multiple-connection sessions may\n        be aggregated over portals sharing an identical\n        aggregation tag.  This object's storage type is\n        specified in iscsiPortalStorageType.")
iscsiNode = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 5))
iscsiNodeAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 5, 1), )
if mibBuilder.loadTexts: iscsiNodeAttributesTable.setDescription('A list of iSCSI nodes belonging to each iSCSI instance\n        present on the local system.  An iSCSI node can act as\n        an initiator, a target, or both.')
iscsiNodeAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"))
if mibBuilder.loadTexts: iscsiNodeAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular iSCSI node.')
iscsiNodeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: iscsiNodeIndex.setDescription('An arbitrary integer used to uniquely identify a particular\n        node within an iSCSI instance.  This index value must not be\n        modified or reused by an agent unless a reboot has occurred.\n        An agent should attempt to keep this value persistent across\n        reboots.')
iscsiNodeName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 2), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeName.setDescription("This node's iSCSI name, which is independent of the location\n        of the node, and can be resolved into a set of addresses\n        through various discovery services.")
iscsiNodeAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeAlias.setDescription("A character string that is a human-readable name or\n        description of the iSCSI node.  If configured, this alias\n        may be communicated to the initiator or target node at\n        the remote end of the connection during a Login Request\n        or Response message.  This string is not used as an\n        identifier, but can be displayed by the system's user\n        interface in a list of initiators and/or targets to\n        which it is connected.\n\n        If no alias exists, the value is a zero-length string.")
iscsiNodeRoles = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 4), Bits().clone(namedValues=NamedValues(("targetTypeNode", 0), ("initiatorTypeNode", 1),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeRoles.setDescription('A node can operate in one or both of two roles:\n        a target role and/or an initiator role.  If the node\n        will operate in both roles, both bits must be set.\n\n        This object will also define the corresponding rows that\n        will exist in the iscsiTargetAttributesTable, the\n        iscsiInitiatorAttributesTable or both.  If the\n        targetTypeNode bit is set, there will be a corresponding\n        iscsiTargetAttributesEntry.  If the initiatorTypeNode bit\n        is set, there will be a corresponding\n        iscsiInitiatorAttributesEntry.  If both bits are set,\n        there will be a corresponding iscsiTgtPortalAttributesEntry\n        and iscsiPortalAttributesEntry.')
iscsiNodeTransportType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 5), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeTransportType.setDescription('A pointer to the corresponding row in the appropriate\n\n        table for this SCSI transport, thereby allowing management\n        stations to locate the SCSI-level device that is represented\n        by this iscsiNode.  For example, it will usually point to the\n        corresponding scsiTrnspt object in the SCSI MIB module.\n\n        If no corresponding row exists, the value 0.0 must be\n        used to indicate this.')
iscsiNodeInitialR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeInitialR2T.setDescription('This object indicates the InitialR2T preference for this\n        node:\n        true = YES,\n        false = will try to negotiate NO, will accept YES ')
iscsiNodeImmediateData = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 7), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeImmediateData.setDescription('This object indicates ImmediateData preference for this\n        node:\n        true = YES (but will accept NO),\n        false = NO ')
iscsiNodeMaxOutstandingR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(1)).setUnits('R2Ts').setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeMaxOutstandingR2T.setDescription('Maximum number of outstanding requests-to-transmit (R2Ts)\n        allowed per iSCSI task.')
iscsiNodeFirstBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 9), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(512,16777215)).clone(65536)).setUnits('bytes').setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeFirstBurstLength.setDescription('The maximum length (bytes) supported for unsolicited data\n        to/from this node.')
iscsiNodeMaxBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(512,16777215)).clone(262144)).setUnits('bytes').setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeMaxBurstLength.setDescription('The maximum number of bytes that can be sent within\n     a single sequence of Data-In or Data-Out PDUs.')
iscsiNodeMaxConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(1)).setUnits('connections').setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeMaxConnections.setDescription('The maximum number of connections allowed in each\n        session to and/or from this node.')
iscsiNodeDataSequenceInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 12), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDataSequenceInOrder.setDescription('The DataSequenceInOrder preference of this node.\n\n        False (=No) indicates that iSCSI data PDU sequences may\n        be transferred in any order.  True (=Yes) indicates that\n        data PDU sequences must be transferred using\n        continuously increasing offsets, except during\n        error recovery.')
iscsiNodeDataPDUInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 13), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDataPDUInOrder.setDescription('The DataPDUInOrder preference of this node.\n        False (=No) indicates that iSCSI data PDUs within sequences\n        may be in any order.  True (=Yes) indicates that data PDUs\n        within sequences must be at continuously increasing\n        addresses, with no gaps or overlay between PDUs.')
iscsiNodeDefaultTime2Wait = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 14), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,3600)).clone(2)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDefaultTime2Wait.setDescription('The DefaultTime2Wait preference of this node.  This is the\n        minimum time, in seconds, to wait before attempting an\n        explicit/implicit logout or active iSCSI task reassignment\n        after an unexpected connection termination or a connection\n        reset.')
iscsiNodeDefaultTime2Retain = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 15), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,3600)).clone(20)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDefaultTime2Retain.setDescription('The DefaultTime2Retain preference of this node.  This is\n\n        the maximum time, in seconds after an initial wait\n        (Time2Wait), before which an active iSCSI task reassignment\n        is still possible after an unexpected connection termination\n        or a connection reset.')
iscsiNodeErrorRecoveryLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 16), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeErrorRecoveryLevel.setDescription('The ErrorRecoveryLevel preference of this node.\n        Currently, only 0-2 are valid.\n\n        This object is designed to accommodate future error recovery\n        levels.\n\n        Higher error recovery levels imply support in addition to\n        support for the lower error level functions.  In other words,\n        error level 2 implies support for levels 0-1, since those\n        functions are subsets of error level 2.')
iscsiNodeDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 17), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeDiscontinuityTime.setDescription("The value of SysUpTime on the most recent occasion\n        at which any one or more of this node's counters\n        suffered a discontinuity.\n\n        If no such discontinuities have occurred since the last\n        re-initialization of the local management subsystem,\n        then this object contains a zero value.")
iscsiNodeStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 18), StorageType().clone('volatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeStorageType.setDescription("The storage type for all read-write objects within this\n        row.  Rows in this table are always created via an\n        external process, and may have a storage type of readOnly\n        or permanent.  Conceptual rows having the value 'permanent'\n        need not allow write access to any columnar objects in\n        the row.\n\n        If this object has the value 'volatile', modifications\n        to read-write objects in this row are not persistent\n        across reboots.  If this object has the value\n        'nonVolatile', modifications to objects in this row\n        are persistent.\n\n        An implementation may choose to allow this object\n        to be set to either 'nonVolatile' or 'volatile',\n        allowing the management application to choose this\n        behavior.")
iscsiTarget = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 6))
iscsiTargetAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 6, 1), )
if mibBuilder.loadTexts: iscsiTargetAttributesTable.setDescription('A list of iSCSI nodes that can take on a target role,\n        belonging to each iSCSI instance present on the local\n        system.')
iscsiTargetAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"))
if mibBuilder.loadTexts: iscsiTargetAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular node that can take on a target role.')
iscsiTgtLoginFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 1), Counter32()).setUnits('failed login attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginFailures.setDescription('This object counts the number of times a login attempt to this\n        local target has failed.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtLastFailureTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastFailureTime.setDescription('The timestamp of the most recent failure of a login attempt\n        to this target.  A value of zero indicates that no such\n        failures have occurred since the last system boot.')
iscsiTgtLastFailureType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastFailureType.setDescription('The type of the most recent failure of a login attempt\n        to this target, represented as the OID of the counter\n        object in iscsiTargetLoginStatsTable for which the\n        relevant instance was incremented.  A value of 0.0\n        indicates a type that is not represented by any of\n        the counters in iscsiTargetLoginStatsTable.')
iscsiTgtLastIntrFailureName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 4), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastIntrFailureName.setDescription('The iSCSI name of the initiator that failed the last\n        login attempt.')
iscsiTgtLastIntrFailureAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 5), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastIntrFailureAddrType.setDescription("The type of Internet Network Address contained in the\n        corresponding instance of the iscsiTgtLastIntrFailureAddr.\n        The value 'dns' is not allowed.")
iscsiTgtLastIntrFailureAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 6), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastIntrFailureAddr.setDescription('An Internet Network Address, of the type specified by\n        the object iscsiTgtLastIntrFailureAddrType, giving the\n        host address of the initiator that failed the last login\n        attempt.')
iscsiTargetLoginStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 6, 2), )
if mibBuilder.loadTexts: iscsiTargetLoginStatsTable.setDescription("A table of counters that keep a record of the results\n        of initiators' login attempts to this target.")
iscsiTargetLoginStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1), )
iscsiTargetAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiTargetLoginStatsEntry"))
iscsiTargetLoginStatsEntry.setIndexNames(*iscsiTargetAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: iscsiTargetLoginStatsEntry.setDescription('An entry (row) containing counters for each result of\n        a login attempt to this target.')
iscsiTgtLoginAccepts = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 1), Counter32()).setUnits('successful logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginAccepts.setDescription('The count of Login Response PDUs with status\n        0x0000, Accept Login, transmitted by this\n        target.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtLoginOtherFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 2), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginOtherFails.setDescription('The number of Login Response PDUs that were transmitted\n        by this target and that were not counted by any other\n        object in the row.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtLoginRedirects = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 3), Counter32()).setUnits('redirected logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginRedirects.setDescription('The count of Login Response PDUs with status class 0x01,\n        Redirection, transmitted by this target.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtLoginAuthorizeFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 4), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginAuthorizeFails.setDescription('The count of Login Response PDUs with status 0x0202,\n        Forbidden Target, transmitted by this target.\n\n        If this counter is incremented, an iscsiTgtLoginFailure\n        notification should be generated.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtLoginAuthenticateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 5), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginAuthenticateFails.setDescription('The count of Login Response PDUs with status 0x0201,\n        Authentication Failed, transmitted by this target.\n\n        If this counter is incremented, an iscsiTgtLoginFailure\n        notification should be generated.\n\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtLoginNegotiateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 6), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginNegotiateFails.setDescription('The number of times a target has effectively refused a\n        login because the parameter negotiation failed.\n\n        If this counter is incremented, an iscsiTgtLoginFailure\n        notification should be generated.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTargetLogoutStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 6, 3), )
if mibBuilder.loadTexts: iscsiTargetLogoutStatsTable.setDescription('When a target receives a Logout command, it responds\n        with a Logout Response that carries a status code.\n        This table contains counters for both normal and\n        abnormal logout requests received by this target.')
iscsiTargetLogoutStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 6, 3, 1), )
iscsiTargetAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiTargetLogoutStatsEntry"))
iscsiTargetLogoutStatsEntry.setIndexNames(*iscsiTargetAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: iscsiTargetLogoutStatsEntry.setDescription('An entry (row) containing counters of Logout Response\n        PDUs that were received by this target.')
iscsiTgtLogoutNormals = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 3, 1, 1), Counter32()).setUnits('normal logouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLogoutNormals.setDescription('The count of Logout Command PDUs received by this target,\n        with reason code 0 (closes the session).\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtLogoutOthers = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 3, 1, 2), Counter32()).setUnits('abnormal logouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLogoutOthers.setDescription('The count of Logout Command PDUs received by this target,\n        with any reason code other than 0.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiTgtAuthorization = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 7))
iscsiTgtAuthAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 7, 1), )
if mibBuilder.loadTexts: iscsiTgtAuthAttributesTable.setDescription('A list of initiator identities that are authorized to\n        access each target node within each iSCSI instance\n        present on the local system.')
iscsiTgtAuthAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"), (0, "ISCSI-MIB", "iscsiTgtAuthIndex"))
if mibBuilder.loadTexts: iscsiTgtAuthAttributesEntry.setDescription("An entry (row) containing management information\n        applicable to a particular target node's authorized\n        initiator identity.")
iscsiTgtAuthIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: iscsiTgtAuthIndex.setDescription("An arbitrary integer used to uniquely identify a particular\n        target's authorized initiator identity within an iSCSI\n        instance present on the local system.  This index value must\n        not be modified or reused by an agent unless a reboot has\n        occurred.  An agent should attempt to keep this value\n        persistent across reboots.")
iscsiTgtAuthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiTgtAuthRowStatus.setDescription("This field allows entries to be dynamically added and\n        removed from this table via SNMP.  When adding a row to\n        this table, all non-Index/RowStatus objects must be set.\n        When the value of this object is 'active', the values of\n        the other objects in this table cannot be changed.\n        Rows may be discarded using RowStatus.")
iscsiTgtAuthIdentity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 3), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiTgtAuthIdentity.setDescription('A pointer to the corresponding user entry in the IPS-AUTH\n        MIB module that will be allowed to access this iSCSI target.')
iscsiTgtAuthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiTgtAuthStorageType.setDescription("The storage type for this row.  Rows in this table that were\n         created through an external process may have a storage type of\n         readOnly or permanent.\n\n         Conceptual rows having the value 'permanent' need not\n         allow write access to any columnar objects in the row.")
iscsiInitiator = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 8))
iscsiInitiatorAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 8, 1), )
if mibBuilder.loadTexts: iscsiInitiatorAttributesTable.setDescription('A list of iSCSI nodes that can take on an initiator\n        role, belonging to each iSCSI instance present on\n        the local system.')
iscsiInitiatorAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"))
if mibBuilder.loadTexts: iscsiInitiatorAttributesEntry.setDescription('An entry (row) containing management information\n        applicable to a particular iSCSI node that has\n        initiator capabilities.')
iscsiIntrLoginFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 1), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginFailures.setDescription('This object counts the number of times a login attempt from\n        this local initiator has failed.\n        If this counter has suffered a discontinuity, the time of the\n\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrLastFailureTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastFailureTime.setDescription('The timestamp of the most recent failure of a login attempt\n        from this initiator.  A value of zero indicates that no such\n        failures have occurred since the last system boot.')
iscsiIntrLastFailureType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastFailureType.setDescription('The type of the most recent failure of a login attempt\n        from this initiator, represented as the OID of the counter\n        object in iscsiInitiatorLoginStatsTable for which the\n        relevant instance was incremented.  A value of 0.0\n        indicates a type that is not represented by any of\n        the counters in iscsiInitiatorLoginStatsTable.')
iscsiIntrLastTgtFailureName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 4), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastTgtFailureName.setDescription('A UTF-8 string giving the name of the target that failed\n        the last login attempt.')
iscsiIntrLastTgtFailureAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 5), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastTgtFailureAddrType.setDescription("The type of Internet Network Address contained in the\n        corresponding instance of the iscsiIntrLastTgtFailureAddr.\n        The value 'dns' is not allowed.")
iscsiIntrLastTgtFailureAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 6), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastTgtFailureAddr.setDescription('An Internet Network Address, of the type specified by the\n        object iscsiIntrLastTgtFailureAddrType, giving the host\n        address of the target that failed the last login attempt.')
iscsiInitiatorLoginStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 8, 2), )
if mibBuilder.loadTexts: iscsiInitiatorLoginStatsTable.setDescription("A table of counters which keep track of the results of\n        this initiator's login attempts.")
iscsiInitiatorLoginStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1), )
iscsiInitiatorAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiInitiatorLoginStatsEntry"))
iscsiInitiatorLoginStatsEntry.setIndexNames(*iscsiInitiatorAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: iscsiInitiatorLoginStatsEntry.setDescription("An entry (row) containing counters of each result\n        of this initiator's login attempts.")
iscsiIntrLoginAcceptRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 1), Counter32()).setUnits('successful logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginAcceptRsps.setDescription('The count of Login Response PDUs with status\n        0x0000, Accept Login, received by this initiator.\n        If this counter has suffered a discontinuity, the time of the\n\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrLoginOtherFailRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 2), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginOtherFailRsps.setDescription('The count of Login Response PDUs received by this\n        initiator with any status code not counted in the\n        objects below.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrLoginRedirectRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 3), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginRedirectRsps.setDescription('The count of Login Response PDUs with status class 0x01,\n        Redirection, received by this initiator.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrLoginAuthFailRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 4), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginAuthFailRsps.setDescription('The count of Login Response PDUs with status class 0x201,\n        Authentication Failed, received by this initiator.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrLoginAuthenticateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 5), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginAuthenticateFails.setDescription('The number of times the initiator has aborted a\n        login because the target could not be authenticated.\n\n        No response is generated.\n\n        If this counter is incremented, an iscsiIntrLoginFailure\n        notification should be generated.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrLoginNegotiateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 6), Counter32()).setUnits('failed logins').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginNegotiateFails.setDescription('The number of times the initiator has aborted a\n        login because parameter negotiation with the target\n        failed.\n\n        No response is generated.\n\n        If this counter is incremented, an iscsiIntrLoginFailure\n        notification should be generated.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiInitiatorLogoutStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 8, 3), )
if mibBuilder.loadTexts: iscsiInitiatorLogoutStatsTable.setDescription('When an initiator attempts to send a Logout command, the target\n        responds with a Logout Response that carries a status code.\n\n        This table contains a list of counters of Logout Response\n        PDUs of each status code that was received by each\n        initiator belonging to this iSCSI instance present on this\n        system.')
iscsiInitiatorLogoutStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 8, 3, 1), )
iscsiInitiatorAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiInitiatorLogoutStatsEntry"))
iscsiInitiatorLogoutStatsEntry.setIndexNames(*iscsiInitiatorAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: iscsiInitiatorLogoutStatsEntry.setDescription('An entry (row) containing counters of Logout Response\n        PDUs of each status code that was generated by this\n        initiator.')
iscsiIntrLogoutNormals = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 3, 1, 1), Counter32()).setUnits('normal logouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLogoutNormals.setDescription('The count of Logout Command PDUs generated by this initiator\n        with reason code 0 (closes the session).\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrLogoutOthers = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 3, 1, 2), Counter32()).setUnits('abnormal logouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLogoutOthers.setDescription('The count of Logout Command PDUs generated by this initiator\n        with any status code other than 0.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiNodeDiscontinuityTime.')
iscsiIntrAuthorization = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 9))
iscsiIntrAuthAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 9, 1), )
if mibBuilder.loadTexts: iscsiIntrAuthAttributesTable.setDescription('A list of target identities that each initiator\n        on the local system may access.')
iscsiIntrAuthAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"), (0, "ISCSI-MIB", "iscsiIntrAuthIndex"))
if mibBuilder.loadTexts: iscsiIntrAuthAttributesEntry.setDescription("An entry (row) containing management information applicable\n        to a particular initiator node's authorized target identity.")
iscsiIntrAuthIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: iscsiIntrAuthIndex.setDescription("An arbitrary integer used to uniquely identify a\n        particular initiator node's authorized target\n        identity within an iSCSI instance present on the\n        local system.  This index value must not be modified\n        or reused by an agent unless a reboot has occurred.\n        An agent should attempt to keep this value persistent\n        across reboots.")
iscsiIntrAuthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiIntrAuthRowStatus.setDescription("This field allows entries to be dynamically added and\n        removed from this table via SNMP.  When adding a row to\n        this table, all non-Index/RowStatus objects must be set.\n        When the value of this object is 'active', the values of\n        the other objects in this table cannot be changed.\n        Rows may be discarded using RowStatus.")
iscsiIntrAuthIdentity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 3), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiIntrAuthIdentity.setDescription('A pointer to the corresponding user entry in the IPS-AUTH\n        MIB module to which this initiator node should attempt to\n        establish an iSCSI session.')
iscsiIntrAuthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiIntrAuthStorageType.setDescription("The storage type for this row.  Rows in this table that were\n        created through an external process may have a storage type of\n        readOnly or permanent.\n\n        Conceptual rows having the value 'permanent' need not\n        allow write access to any columnar objects in the row.")
iscsiSession = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 10))
iscsiSessionAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 10, 1), )
if mibBuilder.loadTexts: iscsiSessionAttributesTable.setDescription('A list of sessions belonging to each iSCSI instance\n        present on the system.')
iscsiSessionAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiSsnNodeIndex"), (0, "ISCSI-MIB", "iscsiSsnIndex"))
if mibBuilder.loadTexts: iscsiSessionAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular session.\n\n        If this session is a discovery session that is not attached\n        to any particular node, the iscsiSsnNodeIndex will be zero.\n        Otherwise, the iscsiSsnNodeIndex will have the same value as\n        iscsiNodeIndex.')
iscsiSsnNodeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: iscsiSsnNodeIndex.setDescription('An arbitrary integer used to uniquely identify a\n        particular node within an iSCSI instance present\n        on the local system.  For normal, non-discovery\n        sessions, this value will map to the iscsiNodeIndex.\n        For discovery sessions that do not have a node\n        associated, the value 0 (zero) is used.')
iscsiSsnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: iscsiSsnIndex.setDescription('An arbitrary integer used to uniquely identify a\n        particular session within an iSCSI instance present\n        on the local system.  An agent should attempt to\n        not reuse index values unless a reboot has occurred.\n        iSCSI sessions are destroyed during a reboot; rows\n        in this table are not persistent across reboots.')
iscsiSsnDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("inboundSession", 1), ("outboundSession", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDirection.setDescription('Direction of iSCSI session:\n        inboundSession  - session is established from an external\n                          initiator to a target within this iSCSI\n                          instance.\n        outboundSession - session is established from an initiator\n                          within this iSCSI instance to an external\n                          target.')
iscsiSsnInitiatorName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 4), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnInitiatorName.setDescription('If iscsiSsnDirection is Inbound, this object is a\n        UTF-8 string that will contain the name of the remote\n        initiator.  If this session is a discovery session that\n\n        does not specify a particular initiator, this object\n        will contain a zero-length string.\n\n        If iscsiSsnDirection is Outbound, this object will\n        contain a zero-length string.')
iscsiSsnTargetName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 5), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTargetName.setDescription('If iscsiSsnDirection is Outbound, this object is a\n        UTF-8 string that will contain the name of the remote\n        target.  If this session is a discovery session that\n        does not specify a particular target, this object will\n        contain a zero-length string.\n\n        If iscsiSsnDirection is Inbound, this object will\n        contain a zero-length string.')
iscsiSsnTSIH = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTSIH.setDescription('The target-defined identification handle for this session.')
iscsiSsnISID = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(6,6)).setFixedLength(6)).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnISID.setDescription('The initiator-defined portion of the iSCSI Session ID.')
iscsiSsnInitiatorAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 8), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnInitiatorAlias.setDescription('A UTF-8 string that gives the alias communicated by the\n\n        initiator end of the session during the login phase.\n\n        If no alias exists, the value is a zero-length string.')
iscsiSsnTargetAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTargetAlias.setDescription('A UTF-8 string that gives the alias communicated by the\n        target end of the session during the login phase.\n\n        If no alias exists, the value is a zero-length string.')
iscsiSsnInitialR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnInitialR2T.setDescription('If set to true, indicates that the initiator must wait\n        for an R2T before sending to the target.  If set to false,\n        the initiator may send data immediately, within limits set\n        by iscsiSsnFirstBurstLength and the expected data transfer\n        length of the request.')
iscsiSsnImmediateData = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnImmediateData.setDescription('Indicates whether the initiator and target have agreed to\n        support immediate data on this session.')
iscsiSsnType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("normalSession", 1), ("discoverySession", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnType.setDescription('Type of iSCSI session:\n        normalSession    - session is a normal iSCSI session\n        discoverySession - session is being used only for discovery.')
iscsiSsnMaxOutstandingR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setUnits('R2Ts').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnMaxOutstandingR2T.setDescription('The maximum number of outstanding requests-to-transmit\n        (R2Ts) per iSCSI task within this session.')
iscsiSsnFirstBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 14), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(512,16777215))).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnFirstBurstLength.setDescription('The maximum length supported for unsolicited data sent\n        within this session.')
iscsiSsnMaxBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 15), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(512,16777215))).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnMaxBurstLength.setDescription('The maximum number of bytes that can be sent within\n        a single sequence of Data-In or Data-Out PDUs.')
iscsiSsnConnectionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 16), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setUnits('connections').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnConnectionNumber.setDescription('The number of transport protocol connections that currently\n        belong to this session.')
iscsiSsnAuthIdentity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 17), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnAuthIdentity.setDescription('This object contains a pointer to a row in the\n        IPS-AUTH MIB module that identifies the authentication\n        method being used on this session, as communicated\n        during the login phase.')
iscsiSsnDataSequenceInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDataSequenceInOrder.setDescription('False indicates that iSCSI data PDU sequences may\n        be transferred in any order.  True indicates that\n        data PDU sequences must be transferred using\n        continuously increasing offsets, except during\n        error recovery.')
iscsiSsnDataPDUInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 19), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDataPDUInOrder.setDescription('False indicates that iSCSI data PDUs within sequences\n        may be in any order.  True indicates that data PDUs\n        within sequences must be at continuously increasing\n        addresses, with no gaps or overlay between PDUs.\n\n        Default is true.')
iscsiSsnErrorRecoveryLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 20), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnErrorRecoveryLevel.setDescription('The level of error recovery negotiated between\n        the initiator and the target.  Higher numbers\n        represent more detailed recovery schemes.')
iscsiSsnDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 21), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDiscontinuityTime.setDescription("The value of SysUpTime on the most recent occasion\n        at which any one or more of this session's counters\n        suffered a discontinuity.\n        When a session is established, and this object is\n        created, it is initialized to the current value\n        of SysUpTime.")
iscsiSessionStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 10, 2), )
if mibBuilder.loadTexts: iscsiSessionStatsTable.setDescription('A list of general iSCSI traffic counters for each of the\n        sessions present on the system.')
iscsiSessionStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1), )
iscsiSessionAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiSessionStatsEntry"))
iscsiSessionStatsEntry.setIndexNames(*iscsiSessionAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: iscsiSessionStatsEntry.setDescription('An entry (row) containing general iSCSI traffic counters\n        for a particular session.')
iscsiSsnCmdPDUs = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 1), Counter32()).setUnits('PDUs').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnCmdPDUs.setDescription('The count of Command PDUs transferred on this session.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.')
iscsiSsnRspPDUs = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 2), Counter32()).setUnits('PDUs').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnRspPDUs.setDescription('The count of Response PDUs transferred on this session.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.')
iscsiSsnTxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 3), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTxDataOctets.setDescription('The count of data octets that were transmitted by\n        the local iSCSI node on this session.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.')
iscsiSsnRxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 4), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnRxDataOctets.setDescription('The count of data octets that were received by\n        the local iSCSI node on this session.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.')
iscsiSsnLCTxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 5), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnLCTxDataOctets.setDescription("A Low Capacity shadow object of iscsiSsnTxDataOctets\n        for those systems that don't support Counter64.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSsnLCRxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 6), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnLCRxDataOctets.setDescription("A Low Capacity shadow object of iscsiSsnRxDataOctets\n        for those systems that don't support Counter64.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSessionCxnErrorStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 10, 3), )
if mibBuilder.loadTexts: iscsiSessionCxnErrorStatsTable.setDescription('A list of error counters for each of the sessions\n        present on this system.')
iscsiSessionCxnErrorStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 10, 3, 1), )
iscsiSessionAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiSessionCxnErrorStatsEntry"))
iscsiSessionCxnErrorStatsEntry.setIndexNames(*iscsiSessionAttributesEntry.getIndexNames())
if mibBuilder.loadTexts: iscsiSessionCxnErrorStatsEntry.setDescription('An entry (row) containing error counters for\n        a particular session.')
iscsiSsnCxnDigestErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 3, 1, 1), Counter32()).setUnits('PDUs').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnCxnDigestErrors.setDescription('The count of PDUs that were received on the session and\n        contained header or data digest errors.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.')
iscsiSsnCxnTimeoutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 3, 1, 2), Counter32()).setUnits('connections').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnCxnTimeoutErrors.setDescription('The count of connections within this session\n        that have been terminated due to timeout.\n        If this counter has suffered a discontinuity, the time of the\n        last discontinuity is indicated in iscsiSsnDiscontinuityTime.')
iscsiConnection = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 11))
iscsiConnectionAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 11, 1), )
if mibBuilder.loadTexts: iscsiConnectionAttributesTable.setDescription('A list of connections belonging to each iSCSI instance\n        present on the system.')
iscsiConnectionAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1), ).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiSsnNodeIndex"), (0, "ISCSI-MIB", "iscsiSsnIndex"), (0, "ISCSI-MIB", "iscsiCxnIndex"))
if mibBuilder.loadTexts: iscsiConnectionAttributesEntry.setDescription('An entry (row) containing management information applicable\n        to a particular connection.')
iscsiCxnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: iscsiCxnIndex.setDescription('An arbitrary integer used to uniquely identify a\n        particular connection of a particular session within\n        an iSCSI instance present on the local system.  An\n        agent should attempt to not reuse index values unless\n        a reboot has occurred.  iSCSI connections are destroyed\n        during a reboot; rows in this table are not persistent\n        across reboots.')
iscsiCxnCid = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnCid.setDescription('The iSCSI Connection ID for this connection.')
iscsiCxnState = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("login", 1), ("full", 2), ("logout", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnState.setDescription('The current state of this connection, from an iSCSI negotiation\n        point of view.  Here are the states:\n\n        login  - The transport protocol connection has been established,\n                 but a valid iSCSI login response with the final bit set\n                 has not been sent or received.\n        full   - A valid iSCSI login response with the final bit set\n                 has been sent or received.\n        logout - A valid iSCSI logout command has been sent or\n                 received, but the transport protocol connection has\n                 not yet been closed.')
iscsiCxnAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnAddrType.setDescription("The type of Internet Network Addresses contained in the\n        corresponding instances of iscsiCxnLocalAddr and\n        iscsiCxnRemoteAddr.\n        The value 'dns' is not allowed.")
iscsiCxnLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnLocalAddr.setDescription('The local Internet Network Address, of the type specified\n        by iscsiCxnAddrType, used by this connection.')
iscsiCxnProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 6), IscsiTransportProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnProtocol.setDescription('The transport protocol over which this connection is\n        running.')
iscsiCxnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 7), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnLocalPort.setDescription('The local transport protocol port used by this connection.\n        This object cannot have the value zero, since it represents\n        an established connection.')
iscsiCxnRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 8), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnRemoteAddr.setDescription('The remote Internet Network Address, of the type specified\n        by iscsiCxnAddrType, used by this connection.')
iscsiCxnRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 9), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnRemotePort.setDescription('The remote transport protocol port used by this connection.\n        This object cannot have the value zero, since it represents\n        an established connection.')
iscsiCxnMaxRecvDataSegLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(512,16777215))).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnMaxRecvDataSegLength.setDescription('The maximum data payload size supported for command\n        or data PDUs able to be received on this connection.')
iscsiCxnMaxXmitDataSegLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(512,16777215))).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnMaxXmitDataSegLength.setDescription('The maximum data payload size supported for command\n        or data PDUs to be sent on this connection.')
iscsiCxnHeaderIntegrity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 12), IscsiDigestMethod()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnHeaderIntegrity.setDescription('This object identifies the iSCSI header\n        digest scheme in use within this connection.')
iscsiCxnDataIntegrity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 13), IscsiDigestMethod()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnDataIntegrity.setDescription('This object identifies the iSCSI data\n        digest scheme in use within this connection.')
iscsiCxnRecvMarker = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 14), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnRecvMarker.setDescription('This object indicates whether or not this connection\n        is receiving markers in its incoming data stream.')
iscsiCxnSendMarker = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnSendMarker.setDescription('This object indicates whether or not this connection\n        is inserting markers in its outgoing data stream.')
iscsiCxnVersionActive = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 16), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnVersionActive.setDescription('Active version number of the iSCSI specification negotiated\n        on this connection.')
iscsiTgtLoginFailure = NotificationType((1, 3, 6, 1, 2, 1, 142, 0, 1)).setObjects(*(("ISCSI-MIB", "iscsiTgtLoginFailures"), ("ISCSI-MIB", "iscsiTgtLastFailureType"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureName"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddrType"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddr"),))
if mibBuilder.loadTexts: iscsiTgtLoginFailure.setDescription('Sent when a login is failed by a target.\n\n        To avoid sending an excessive number of notifications due\n        to multiple errors counted, an SNMP agent implementing this\n        notification SHOULD NOT send more than 3 notifications of\n        this type in any 10-second time period.')
iscsiIntrLoginFailure = NotificationType((1, 3, 6, 1, 2, 1, 142, 0, 2)).setObjects(*(("ISCSI-MIB", "iscsiIntrLoginFailures"), ("ISCSI-MIB", "iscsiIntrLastFailureType"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureName"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddrType"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddr"),))
if mibBuilder.loadTexts: iscsiIntrLoginFailure.setDescription('Sent when a login is failed by an initiator.\n\n        To avoid sending an excessive number of notifications due\n        to multiple errors counted, an SNMP agent implementing this\n        notification SHOULD NOT send more than 3 notifications of\n        this type in any 10-second time period.')
iscsiInstSessionFailure = NotificationType((1, 3, 6, 1, 2, 1, 142, 0, 3)).setObjects(*(("ISCSI-MIB", "iscsiInstSsnFailures"), ("ISCSI-MIB", "iscsiInstLastSsnFailureType"), ("ISCSI-MIB", "iscsiInstLastSsnRmtNodeName"),))
if mibBuilder.loadTexts: iscsiInstSessionFailure.setDescription('Sent when an active session is failed by either the initiator\n        or the target.\n\n        To avoid sending an excessive number of notifications due\n        to multiple errors counted, an SNMP agent implementing this\n        notification SHOULD NOT send more than 3 notifications of\n        this type in any 10-second time period.')
iscsiCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 2, 1))
iscsiGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 2, 2))
iscsiInstanceAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 1)).setObjects(*(("ISCSI-MIB", "iscsiInstDescr"), ("ISCSI-MIB", "iscsiInstVersionMin"), ("ISCSI-MIB", "iscsiInstVersionMax"), ("ISCSI-MIB", "iscsiInstVendorID"), ("ISCSI-MIB", "iscsiInstVendorVersion"), ("ISCSI-MIB", "iscsiInstPortalNumber"), ("ISCSI-MIB", "iscsiInstNodeNumber"), ("ISCSI-MIB", "iscsiInstSessionNumber"), ("ISCSI-MIB", "iscsiInstSsnFailures"), ("ISCSI-MIB", "iscsiInstLastSsnFailureType"), ("ISCSI-MIB", "iscsiInstLastSsnRmtNodeName"), ("ISCSI-MIB", "iscsiInstDiscontinuityTime"),))
if mibBuilder.loadTexts: iscsiInstanceAttributesGroup.setDescription('A collection of objects providing information about iSCSI\n        instances.')
iscsiInstanceSsnErrorStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 2)).setObjects(*(("ISCSI-MIB", "iscsiInstSsnDigestErrors"), ("ISCSI-MIB", "iscsiInstSsnCxnTimeoutErrors"), ("ISCSI-MIB", "iscsiInstSsnFormatErrors"),))
if mibBuilder.loadTexts: iscsiInstanceSsnErrorStatsGroup.setDescription('A collection of objects providing information about\n        errors that have caused a session failure for an\n        iSCSI instance.')
iscsiPortalAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 3)).setObjects(*(("ISCSI-MIB", "iscsiPortalRowStatus"), ("ISCSI-MIB", "iscsiPortalStorageType"), ("ISCSI-MIB", "iscsiPortalRoles"), ("ISCSI-MIB", "iscsiPortalAddrType"), ("ISCSI-MIB", "iscsiPortalAddr"), ("ISCSI-MIB", "iscsiPortalProtocol"), ("ISCSI-MIB", "iscsiPortalMaxRecvDataSegLength"), ("ISCSI-MIB", "iscsiPortalPrimaryHdrDigest"), ("ISCSI-MIB", "iscsiPortalPrimaryDataDigest"), ("ISCSI-MIB", "iscsiPortalSecondaryHdrDigest"), ("ISCSI-MIB", "iscsiPortalSecondaryDataDigest"), ("ISCSI-MIB", "iscsiPortalRecvMarker"),))
if mibBuilder.loadTexts: iscsiPortalAttributesGroup.setDescription('A collection of objects providing information about\n        the transport protocol endpoints of the local targets.')
iscsiTgtPortalAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 4)).setObjects(*(("ISCSI-MIB", "iscsiTgtPortalPort"), ("ISCSI-MIB", "iscsiTgtPortalTag"),))
if mibBuilder.loadTexts: iscsiTgtPortalAttributesGroup.setDescription('A collection of objects providing information about\n        the transport protocol endpoints of the local targets.')
iscsiIntrPortalAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 5)).setObjects(*(("ISCSI-MIB", "iscsiIntrPortalTag"),))
if mibBuilder.loadTexts: iscsiIntrPortalAttributesGroup.setDescription('An object providing information about\n        the portal tags used by the local initiators.')
iscsiNodeAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 6)).setObjects(*(("ISCSI-MIB", "iscsiNodeName"), ("ISCSI-MIB", "iscsiNodeAlias"), ("ISCSI-MIB", "iscsiNodeRoles"), ("ISCSI-MIB", "iscsiNodeTransportType"), ("ISCSI-MIB", "iscsiNodeInitialR2T"), ("ISCSI-MIB", "iscsiNodeImmediateData"), ("ISCSI-MIB", "iscsiNodeMaxOutstandingR2T"), ("ISCSI-MIB", "iscsiNodeFirstBurstLength"), ("ISCSI-MIB", "iscsiNodeMaxBurstLength"), ("ISCSI-MIB", "iscsiNodeMaxConnections"), ("ISCSI-MIB", "iscsiNodeDataSequenceInOrder"), ("ISCSI-MIB", "iscsiNodeDataPDUInOrder"), ("ISCSI-MIB", "iscsiNodeDefaultTime2Wait"), ("ISCSI-MIB", "iscsiNodeDefaultTime2Retain"), ("ISCSI-MIB", "iscsiNodeErrorRecoveryLevel"), ("ISCSI-MIB", "iscsiNodeDiscontinuityTime"), ("ISCSI-MIB", "iscsiNodeStorageType"),))
if mibBuilder.loadTexts: iscsiNodeAttributesGroup.setDescription('A collection of objects providing information about all\n        local targets.')
iscsiTargetAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 7)).setObjects(*(("ISCSI-MIB", "iscsiTgtLoginFailures"), ("ISCSI-MIB", "iscsiTgtLastFailureTime"), ("ISCSI-MIB", "iscsiTgtLastFailureType"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureName"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddrType"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddr"),))
if mibBuilder.loadTexts: iscsiTargetAttributesGroup.setDescription('A collection of objects providing information about all\n        local targets.')
iscsiTargetLoginStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 8)).setObjects(*(("ISCSI-MIB", "iscsiTgtLoginAccepts"), ("ISCSI-MIB", "iscsiTgtLoginOtherFails"), ("ISCSI-MIB", "iscsiTgtLoginRedirects"), ("ISCSI-MIB", "iscsiTgtLoginAuthorizeFails"), ("ISCSI-MIB", "iscsiTgtLoginAuthenticateFails"), ("ISCSI-MIB", "iscsiTgtLoginNegotiateFails"),))
if mibBuilder.loadTexts: iscsiTargetLoginStatsGroup.setDescription('A collection of objects providing information about all\n        login attempts by remote initiators to local targets.')
iscsiTargetLogoutStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 9)).setObjects(*(("ISCSI-MIB", "iscsiTgtLogoutNormals"), ("ISCSI-MIB", "iscsiTgtLogoutOthers"),))
if mibBuilder.loadTexts: iscsiTargetLogoutStatsGroup.setDescription('A collection of objects providing information about all\n        logout events between remote initiators and local targets.')
iscsiTargetAuthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 10)).setObjects(*(("ISCSI-MIB", "iscsiTgtAuthRowStatus"), ("ISCSI-MIB", "iscsiTgtAuthStorageType"), ("ISCSI-MIB", "iscsiTgtAuthIdentity"),))
if mibBuilder.loadTexts: iscsiTargetAuthGroup.setDescription('A collection of objects providing information about all\n        remote initiators that are authorized to connect to local\n        targets.')
iscsiInitiatorAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 11)).setObjects(*(("ISCSI-MIB", "iscsiIntrLoginFailures"), ("ISCSI-MIB", "iscsiIntrLastFailureTime"), ("ISCSI-MIB", "iscsiIntrLastFailureType"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureName"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddrType"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddr"),))
if mibBuilder.loadTexts: iscsiInitiatorAttributesGroup.setDescription('A collection of objects providing information about\n        all local initiators.')
iscsiInitiatorLoginStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 12)).setObjects(*(("ISCSI-MIB", "iscsiIntrLoginAcceptRsps"), ("ISCSI-MIB", "iscsiIntrLoginOtherFailRsps"), ("ISCSI-MIB", "iscsiIntrLoginRedirectRsps"), ("ISCSI-MIB", "iscsiIntrLoginAuthFailRsps"), ("ISCSI-MIB", "iscsiIntrLoginAuthenticateFails"), ("ISCSI-MIB", "iscsiIntrLoginNegotiateFails"),))
if mibBuilder.loadTexts: iscsiInitiatorLoginStatsGroup.setDescription('A collection of objects providing information about all\n        login attempts by local initiators to remote targets.')
iscsiInitiatorLogoutStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 13)).setObjects(*(("ISCSI-MIB", "iscsiIntrLogoutNormals"), ("ISCSI-MIB", "iscsiIntrLogoutOthers"),))
if mibBuilder.loadTexts: iscsiInitiatorLogoutStatsGroup.setDescription('A collection of objects providing information about all\n        logout events between local initiators and remote targets.')
iscsiInitiatorAuthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 14)).setObjects(*(("ISCSI-MIB", "iscsiIntrAuthRowStatus"), ("ISCSI-MIB", "iscsiIntrAuthStorageType"), ("ISCSI-MIB", "iscsiIntrAuthIdentity"),))
if mibBuilder.loadTexts: iscsiInitiatorAuthGroup.setDescription('A collection of objects providing information about all\n        remote targets that are initiators of the local system\n        that they are authorized to access.')
iscsiSessionAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 15)).setObjects(*(("ISCSI-MIB", "iscsiSsnDirection"), ("ISCSI-MIB", "iscsiSsnInitiatorName"), ("ISCSI-MIB", "iscsiSsnTargetName"), ("ISCSI-MIB", "iscsiSsnTSIH"), ("ISCSI-MIB", "iscsiSsnISID"), ("ISCSI-MIB", "iscsiSsnInitiatorAlias"), ("ISCSI-MIB", "iscsiSsnTargetAlias"), ("ISCSI-MIB", "iscsiSsnInitialR2T"), ("ISCSI-MIB", "iscsiSsnImmediateData"), ("ISCSI-MIB", "iscsiSsnType"), ("ISCSI-MIB", "iscsiSsnMaxOutstandingR2T"), ("ISCSI-MIB", "iscsiSsnFirstBurstLength"), ("ISCSI-MIB", "iscsiSsnMaxBurstLength"), ("ISCSI-MIB", "iscsiSsnConnectionNumber"), ("ISCSI-MIB", "iscsiSsnAuthIdentity"), ("ISCSI-MIB", "iscsiSsnDataSequenceInOrder"), ("ISCSI-MIB", "iscsiSsnDataPDUInOrder"), ("ISCSI-MIB", "iscsiSsnErrorRecoveryLevel"), ("ISCSI-MIB", "iscsiSsnDiscontinuityTime"),))
if mibBuilder.loadTexts: iscsiSessionAttributesGroup.setDescription('A collection of objects providing information applicable to\n        all sessions.')
iscsiSessionPDUStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 16)).setObjects(*(("ISCSI-MIB", "iscsiSsnCmdPDUs"), ("ISCSI-MIB", "iscsiSsnRspPDUs"),))
if mibBuilder.loadTexts: iscsiSessionPDUStatsGroup.setDescription('A collection of objects providing information about PDU\n        traffic for each session.')
iscsiSessionOctetStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 17)).setObjects(*(("ISCSI-MIB", "iscsiSsnTxDataOctets"), ("ISCSI-MIB", "iscsiSsnRxDataOctets"),))
if mibBuilder.loadTexts: iscsiSessionOctetStatsGroup.setDescription('A collection of objects providing information about octet\n        traffic for each session using a Counter64 data type.')
iscsiSessionLCOctetStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 18)).setObjects(*(("ISCSI-MIB", "iscsiSsnLCTxDataOctets"), ("ISCSI-MIB", "iscsiSsnLCRxDataOctets"),))
if mibBuilder.loadTexts: iscsiSessionLCOctetStatsGroup.setDescription('A collection of objects providing information about octet\n        traffic for each session using a Counter32 data type.')
iscsiSessionCxnErrorStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 19)).setObjects(*(("ISCSI-MIB", "iscsiSsnCxnDigestErrors"), ("ISCSI-MIB", "iscsiSsnCxnTimeoutErrors"),))
if mibBuilder.loadTexts: iscsiSessionCxnErrorStatsGroup.setDescription('A collection of objects providing information about connection\n        errors for all sessions.')
iscsiConnectionAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 20)).setObjects(*(("ISCSI-MIB", "iscsiCxnCid"), ("ISCSI-MIB", "iscsiCxnState"), ("ISCSI-MIB", "iscsiCxnProtocol"), ("ISCSI-MIB", "iscsiCxnAddrType"), ("ISCSI-MIB", "iscsiCxnLocalAddr"), ("ISCSI-MIB", "iscsiCxnLocalPort"), ("ISCSI-MIB", "iscsiCxnRemoteAddr"), ("ISCSI-MIB", "iscsiCxnRemotePort"), ("ISCSI-MIB", "iscsiCxnMaxRecvDataSegLength"), ("ISCSI-MIB", "iscsiCxnMaxXmitDataSegLength"), ("ISCSI-MIB", "iscsiCxnHeaderIntegrity"), ("ISCSI-MIB", "iscsiCxnDataIntegrity"), ("ISCSI-MIB", "iscsiCxnRecvMarker"), ("ISCSI-MIB", "iscsiCxnSendMarker"), ("ISCSI-MIB", "iscsiCxnVersionActive"),))
if mibBuilder.loadTexts: iscsiConnectionAttributesGroup.setDescription('A collection of objects providing information about all\n        connections used by all sessions.')
iscsiTgtLgnNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 21)).setObjects(*(("ISCSI-MIB", "iscsiTgtLoginFailure"),))
if mibBuilder.loadTexts: iscsiTgtLgnNotificationsGroup.setDescription('A collection of notifications that indicate a login\n        failure from a remote initiator to a local target.')
iscsiIntrLgnNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 22)).setObjects(*(("ISCSI-MIB", "iscsiIntrLoginFailure"),))
if mibBuilder.loadTexts: iscsiIntrLgnNotificationsGroup.setDescription('A collection of notifications that indicate a login\n        failure from a local initiator to a remote target.')
iscsiSsnFlrNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 23)).setObjects(*(("ISCSI-MIB", "iscsiInstSessionFailure"),))
if mibBuilder.loadTexts: iscsiSsnFlrNotificationsGroup.setDescription('A collection of notifications that indicate session\n        failures occurring after login.')
iscsiComplianceV1 = ModuleCompliance((1, 3, 6, 1, 2, 1, 142, 2, 1, 1)).setObjects(*(("ISCSI-MIB", "iscsiInstanceAttributesGroup"), ("ISCSI-MIB", "iscsiInstanceSsnErrorStatsGroup"), ("ISCSI-MIB", "iscsiPortalAttributesGroup"), ("ISCSI-MIB", "iscsiNodeAttributesGroup"), ("ISCSI-MIB", "iscsiSessionAttributesGroup"), ("ISCSI-MIB", "iscsiSessionPDUStatsGroup"), ("ISCSI-MIB", "iscsiSessionCxnErrorStatsGroup"), ("ISCSI-MIB", "iscsiConnectionAttributesGroup"), ("ISCSI-MIB", "iscsiSsnFlrNotificationsGroup"), ("ISCSI-MIB", "iscsiSessionOctetStatsGroup"), ("ISCSI-MIB", "iscsiSessionLCOctetStatsGroup"), ("ISCSI-MIB", "iscsiTgtPortalAttributesGroup"), ("ISCSI-MIB", "iscsiTargetAttributesGroup"), ("ISCSI-MIB", "iscsiTargetLoginStatsGroup"), ("ISCSI-MIB", "iscsiTargetLogoutStatsGroup"), ("ISCSI-MIB", "iscsiTgtLgnNotificationsGroup"), ("ISCSI-MIB", "iscsiTargetAuthGroup"), ("ISCSI-MIB", "iscsiIntrPortalAttributesGroup"), ("ISCSI-MIB", "iscsiInitiatorAttributesGroup"), ("ISCSI-MIB", "iscsiInitiatorLoginStatsGroup"), ("ISCSI-MIB", "iscsiInitiatorLogoutStatsGroup"), ("ISCSI-MIB", "iscsiIntrLgnNotificationsGroup"), ("ISCSI-MIB", "iscsiInitiatorAuthGroup"),))
if mibBuilder.loadTexts: iscsiComplianceV1.setDescription('Initial version of compliance statement based on\n        initial version of this MIB module.\n\n        If an implementation can be both a target and an\n        initiator, all groups are mandatory.')
mibBuilder.exportSymbols("ISCSI-MIB", iscsiTgtAuthRowStatus=iscsiTgtAuthRowStatus, iscsiTarget=iscsiTarget, iscsiTgtLoginAuthenticateFails=iscsiTgtLoginAuthenticateFails, iscsiIntrPortalAttributesTable=iscsiIntrPortalAttributesTable, iscsiCxnAddrType=iscsiCxnAddrType, iscsiObjects=iscsiObjects, iscsiNodeAttributesEntry=iscsiNodeAttributesEntry, iscsiPortalMaxRecvDataSegLength=iscsiPortalMaxRecvDataSegLength, iscsiSsnErrorRecoveryLevel=iscsiSsnErrorRecoveryLevel, iscsiTgtLoginAccepts=iscsiTgtLoginAccepts, iscsiTgtLastIntrFailureName=iscsiTgtLastIntrFailureName, iscsiSsnTargetAlias=iscsiSsnTargetAlias, iscsiSsnImmediateData=iscsiSsnImmediateData, iscsiIntrLoginFailure=iscsiIntrLoginFailure, iscsiSessionCxnErrorStatsGroup=iscsiSessionCxnErrorStatsGroup, iscsiSessionPDUStatsGroup=iscsiSessionPDUStatsGroup, iscsiNodeDataSequenceInOrder=iscsiNodeDataSequenceInOrder, iscsiSsnCxnTimeoutErrors=iscsiSsnCxnTimeoutErrors, iscsiTgtLoginFailures=iscsiTgtLoginFailures, iscsiGroups=iscsiGroups, iscsiInitiatorLoginStatsTable=iscsiInitiatorLoginStatsTable, iscsiInstSsnFailures=iscsiInstSsnFailures, iscsiIntrLastFailureType=iscsiIntrLastFailureType, iscsiSsnFirstBurstLength=iscsiSsnFirstBurstLength, iscsiSsnMaxOutstandingR2T=iscsiSsnMaxOutstandingR2T, iscsiPortalPrimaryHdrDigest=iscsiPortalPrimaryHdrDigest, iscsiNodeDefaultTime2Retain=iscsiNodeDefaultTime2Retain, IscsiDigestMethod=IscsiDigestMethod, iscsiInitiatorLogoutStatsEntry=iscsiInitiatorLogoutStatsEntry, iscsiSsnLCTxDataOctets=iscsiSsnLCTxDataOctets, iscsiCxnCid=iscsiCxnCid, iscsiIntrAuthRowStatus=iscsiIntrAuthRowStatus, iscsiSessionAttributesEntry=iscsiSessionAttributesEntry, iscsiTgtLastFailureType=iscsiTgtLastFailureType, iscsiTgtAuthAttributesTable=iscsiTgtAuthAttributesTable, iscsiPortalAttributesTable=iscsiPortalAttributesTable, iscsiCxnIndex=iscsiCxnIndex, iscsiInstIndex=iscsiInstIndex, iscsiIntrLastTgtFailureName=iscsiIntrLastTgtFailureName, iscsiNodeFirstBurstLength=iscsiNodeFirstBurstLength, iscsiTargetLogoutStatsTable=iscsiTargetLogoutStatsTable, iscsiSsnNodeIndex=iscsiSsnNodeIndex, iscsiInstSessionFailure=iscsiInstSessionFailure, iscsiTgtAuthAttributesEntry=iscsiTgtAuthAttributesEntry, iscsiTargetAttributesEntry=iscsiTargetAttributesEntry, iscsiIntrAuthIndex=iscsiIntrAuthIndex, iscsiNode=iscsiNode, iscsiCxnRemoteAddr=iscsiCxnRemoteAddr, iscsiIntrLoginAuthenticateFails=iscsiIntrLoginAuthenticateFails, iscsiInitiatorAttributesEntry=iscsiInitiatorAttributesEntry, iscsiIntrLoginAuthFailRsps=iscsiIntrLoginAuthFailRsps, iscsiMibModule=iscsiMibModule, iscsiSsnInitialR2T=iscsiSsnInitialR2T, iscsiIntrLoginOtherFailRsps=iscsiIntrLoginOtherFailRsps, iscsiSsnTSIH=iscsiSsnTSIH, iscsiInstSessionNumber=iscsiInstSessionNumber, iscsiPortalSecondaryHdrDigest=iscsiPortalSecondaryHdrDigest, iscsiInitiatorAuthGroup=iscsiInitiatorAuthGroup, iscsiIntrLoginRedirectRsps=iscsiIntrLoginRedirectRsps, iscsiNodeMaxOutstandingR2T=iscsiNodeMaxOutstandingR2T, iscsiTargetPortal=iscsiTargetPortal, iscsiInstLastSsnRmtNodeName=iscsiInstLastSsnRmtNodeName, iscsiSessionCxnErrorStatsEntry=iscsiSessionCxnErrorStatsEntry, iscsiNodeDiscontinuityTime=iscsiNodeDiscontinuityTime, iscsiTgtAuthorization=iscsiTgtAuthorization, iscsiHdrIntegrityNone=iscsiHdrIntegrityNone, iscsiIntrLastTgtFailureAddrType=iscsiIntrLastTgtFailureAddrType, iscsiInstVersionMin=iscsiInstVersionMin, iscsiDescriptors=iscsiDescriptors, iscsiHdrIntegrityCrc32c=iscsiHdrIntegrityCrc32c, iscsiInstVersionMax=iscsiInstVersionMax, iscsiTgtPortalPort=iscsiTgtPortalPort, iscsiTgtPortalTag=iscsiTgtPortalTag, iscsiNodeIndex=iscsiNodeIndex, iscsiInstVendorVersion=iscsiInstVendorVersion, iscsiTargetLogoutStatsEntry=iscsiTargetLogoutStatsEntry, iscsiComplianceV1=iscsiComplianceV1, iscsiTargetLoginStatsTable=iscsiTargetLoginStatsTable, PYSNMP_MODULE_ID=iscsiMibModule, iscsiInitiatorLoginStatsGroup=iscsiInitiatorLoginStatsGroup, iscsiTgtLogoutOthers=iscsiTgtLogoutOthers, iscsiSsnRspPDUs=iscsiSsnRspPDUs, iscsiTargetAuthGroup=iscsiTargetAuthGroup, iscsiInitiatorLoginStatsEntry=iscsiInitiatorLoginStatsEntry, iscsiInstanceSsnErrorStatsTable=iscsiInstanceSsnErrorStatsTable, iscsiInstance=iscsiInstance, iscsiCxnLocalAddr=iscsiCxnLocalAddr, iscsiTgtLgnNotificationsGroup=iscsiTgtLgnNotificationsGroup, iscsiIntrPortalAttributesEntry=iscsiIntrPortalAttributesEntry, iscsiCxnLocalPort=iscsiCxnLocalPort, iscsiIntrLastFailureTime=iscsiIntrLastFailureTime, iscsiSsnCxnDigestErrors=iscsiSsnCxnDigestErrors, iscsiSessionAttributesTable=iscsiSessionAttributesTable, iscsiIntrLoginFailures=iscsiIntrLoginFailures, iscsiInitiatorLogoutStatsTable=iscsiInitiatorLogoutStatsTable, iscsiNotifications=iscsiNotifications, iscsiInstDescr=iscsiInstDescr, iscsiPortalAttributesGroup=iscsiPortalAttributesGroup, iscsiDataIntegrityNone=iscsiDataIntegrityNone, iscsiPortalIndex=iscsiPortalIndex, iscsiSsnInitiatorName=iscsiSsnInitiatorName, iscsiConnectionAttributesGroup=iscsiConnectionAttributesGroup, iscsiNodeMaxBurstLength=iscsiNodeMaxBurstLength, iscsiIntrLogoutOthers=iscsiIntrLogoutOthers, iscsiPortalAddr=iscsiPortalAddr, iscsiTgtAuthIdentity=iscsiTgtAuthIdentity, iscsiIntrAuthIdentity=iscsiIntrAuthIdentity, iscsiSession=iscsiSession, iscsiTgtPortalAttributesTable=iscsiTgtPortalAttributesTable, iscsiTgtPortalAttributesEntry=iscsiTgtPortalAttributesEntry, iscsiNodeAlias=iscsiNodeAlias, iscsiCxnMaxRecvDataSegLength=iscsiCxnMaxRecvDataSegLength, iscsiTgtLoginRedirects=iscsiTgtLoginRedirects, iscsiIntrLgnNotificationsGroup=iscsiIntrLgnNotificationsGroup, iscsiTargetAttributesTable=iscsiTargetAttributesTable, iscsiIntrLoginNegotiateFails=iscsiIntrLoginNegotiateFails, iscsiInstSsnDigestErrors=iscsiInstSsnDigestErrors, iscsiIntrPortalNodeIndexOrZero=iscsiIntrPortalNodeIndexOrZero, iscsiTgtLoginOtherFails=iscsiTgtLoginOtherFails, iscsiSessionCxnErrorStatsTable=iscsiSessionCxnErrorStatsTable, iscsiInitiator=iscsiInitiator, iscsiSsnConnectionNumber=iscsiSsnConnectionNumber, iscsiSessionStatsEntry=iscsiSessionStatsEntry, iscsiSsnCmdPDUs=iscsiSsnCmdPDUs, iscsiSsnTargetName=iscsiSsnTargetName, iscsiIntrLogoutNormals=iscsiIntrLogoutNormals, iscsiCxnSendMarker=iscsiCxnSendMarker, iscsiSsnRxDataOctets=iscsiSsnRxDataOctets, iscsiInstanceSsnErrorStatsGroup=iscsiInstanceSsnErrorStatsGroup, iscsiTargetAttributesGroup=iscsiTargetAttributesGroup, iscsiSessionOctetStatsGroup=iscsiSessionOctetStatsGroup, iscsiSsnDataSequenceInOrder=iscsiSsnDataSequenceInOrder, iscsiSsnLCRxDataOctets=iscsiSsnLCRxDataOctets, iscsiTgtPortalNodeIndexOrZero=iscsiTgtPortalNodeIndexOrZero, iscsiNodeInitialR2T=iscsiNodeInitialR2T, iscsiConnection=iscsiConnection, iscsiInstSsnFormatErrors=iscsiInstSsnFormatErrors, iscsiNodeRoles=iscsiNodeRoles, iscsiTgtAuthStorageType=iscsiTgtAuthStorageType, iscsiTgtLoginAuthorizeFails=iscsiTgtLoginAuthorizeFails, iscsiPortalAttributesEntry=iscsiPortalAttributesEntry, iscsiSessionLCOctetStatsGroup=iscsiSessionLCOctetStatsGroup, iscsiTargetLoginStatsEntry=iscsiTargetLoginStatsEntry, iscsiIntrLastTgtFailureAddr=iscsiIntrLastTgtFailureAddr, iscsiNodeErrorRecoveryLevel=iscsiNodeErrorRecoveryLevel, iscsiNodeDataPDUInOrder=iscsiNodeDataPDUInOrder, iscsiIntrLoginAcceptRsps=iscsiIntrLoginAcceptRsps, iscsiNodeName=iscsiNodeName, iscsiSsnDiscontinuityTime=iscsiSsnDiscontinuityTime, iscsiTgtLastFailureTime=iscsiTgtLastFailureTime, iscsiInitiatorAttributesTable=iscsiInitiatorAttributesTable, iscsiTgtLastIntrFailureAddr=iscsiTgtLastIntrFailureAddr, iscsiSessionStatsTable=iscsiSessionStatsTable, iscsiCxnProtocol=iscsiCxnProtocol, iscsiInstDiscontinuityTime=iscsiInstDiscontinuityTime, iscsiSsnISID=iscsiSsnISID, iscsiAdmin=iscsiAdmin, iscsiHeaderIntegrityTypes=iscsiHeaderIntegrityTypes, iscsiPortalProtocol=iscsiPortalProtocol, iscsiIntrAuthAttributesEntry=iscsiIntrAuthAttributesEntry, iscsiCxnHeaderIntegrity=iscsiCxnHeaderIntegrity, iscsiPortalStorageType=iscsiPortalStorageType, iscsiNodeTransportType=iscsiNodeTransportType, iscsiNodeImmediateData=iscsiNodeImmediateData, iscsiNodeDefaultTime2Wait=iscsiNodeDefaultTime2Wait, iscsiInstNodeNumber=iscsiInstNodeNumber, iscsiTgtAuthIndex=iscsiTgtAuthIndex, iscsiCxnVersionActive=iscsiCxnVersionActive, iscsiSsnType=iscsiSsnType, iscsiCxnState=iscsiCxnState, iscsiIntrAuthStorageType=iscsiIntrAuthStorageType, iscsiInitiatorPortal=iscsiInitiatorPortal, iscsiPortal=iscsiPortal, iscsiSsnTxDataOctets=iscsiSsnTxDataOctets, iscsiInstLastSsnFailureType=iscsiInstLastSsnFailureType, iscsiPortalSecondaryDataDigest=iscsiPortalSecondaryDataDigest, iscsiSsnIndex=iscsiSsnIndex, iscsiCxnRecvMarker=iscsiCxnRecvMarker, iscsiInstanceAttributesTable=iscsiInstanceAttributesTable, iscsiPortalAddrType=iscsiPortalAddrType, iscsiIntrPortalAttributesGroup=iscsiIntrPortalAttributesGroup, iscsiTgtPortalAttributesGroup=iscsiTgtPortalAttributesGroup, iscsiPortalPrimaryDataDigest=iscsiPortalPrimaryDataDigest, iscsiInstPortalNumber=iscsiInstPortalNumber, iscsiInstanceAttributesEntry=iscsiInstanceAttributesEntry, iscsiPortalRoles=iscsiPortalRoles, iscsiInstanceSsnErrorStatsEntry=iscsiInstanceSsnErrorStatsEntry, iscsiIntrPortalTag=iscsiIntrPortalTag, iscsiNodeAttributesGroup=iscsiNodeAttributesGroup, iscsiSsnFlrNotificationsGroup=iscsiSsnFlrNotificationsGroup, iscsiConnectionAttributesEntry=iscsiConnectionAttributesEntry, iscsiInstVendorID=iscsiInstVendorID, iscsiSsnDirection=iscsiSsnDirection, iscsiPortalRecvMarker=iscsiPortalRecvMarker, iscsiPortalRowStatus=iscsiPortalRowStatus, iscsiConnectionAttributesTable=iscsiConnectionAttributesTable, iscsiInitiatorAttributesGroup=iscsiInitiatorAttributesGroup, IscsiName=IscsiName, iscsiNodeMaxConnections=iscsiNodeMaxConnections, iscsiCxnMaxXmitDataSegLength=iscsiCxnMaxXmitDataSegLength, iscsiTargetLogoutStatsGroup=iscsiTargetLogoutStatsGroup, iscsiCxnRemotePort=iscsiCxnRemotePort, iscsiTargetLoginStatsGroup=iscsiTargetLoginStatsGroup, iscsiSessionAttributesGroup=iscsiSessionAttributesGroup, iscsiNodeStorageType=iscsiNodeStorageType, iscsiTgtLoginFailure=iscsiTgtLoginFailure, iscsiInstanceAttributesGroup=iscsiInstanceAttributesGroup, iscsiCxnDataIntegrity=iscsiCxnDataIntegrity, iscsiInstSsnCxnTimeoutErrors=iscsiInstSsnCxnTimeoutErrors, iscsiSsnAuthIdentity=iscsiSsnAuthIdentity, iscsiTgtLogoutNormals=iscsiTgtLogoutNormals, iscsiSsnInitiatorAlias=iscsiSsnInitiatorAlias, iscsiDataIntegrityCrc32c=iscsiDataIntegrityCrc32c, iscsiDataIntegrityTypes=iscsiDataIntegrityTypes, iscsiNodeAttributesTable=iscsiNodeAttributesTable, iscsiCompliances=iscsiCompliances, iscsiSsnMaxBurstLength=iscsiSsnMaxBurstLength, iscsiTgtLastIntrFailureAddrType=iscsiTgtLastIntrFailureAddrType, iscsiIntrAuthAttributesTable=iscsiIntrAuthAttributesTable, iscsiIntrAuthorization=iscsiIntrAuthorization, iscsiConformance=iscsiConformance, IscsiTransportProtocol=IscsiTransportProtocol, iscsiInitiatorLogoutStatsGroup=iscsiInitiatorLogoutStatsGroup, iscsiTgtLoginNegotiateFails=iscsiTgtLoginNegotiateFails, iscsiSsnDataPDUInOrder=iscsiSsnDataPDUInOrder)
