# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class EventTypeTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.events.v1.event_types.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://events.twilio.com/v1/Types',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "types": [],
                "meta": {
                    "page": 0,
                    "page_size": 10,
                    "first_page_url": "https://events.twilio.com/v1/Types?PageSize=10&Page=0",
                    "previous_page_url": null,
                    "url": "https://events.twilio.com/v1/Types?PageSize=10&Page=0",
                    "next_page_url": null,
                    "key": "types"
                }
            }
            '''
        ))

        actual = self.client.events.v1.event_types.list()

        self.assertIsNotNone(actual)

    def test_read_results_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "types": [
                    {
                        "date_created": "2020-08-13T13:28:20Z",
                        "date_updated": "2020-08-13T13:28:20Z",
                        "type": "com.twilio.messaging.message.delivered",
                        "schema_id": "Messaging.MessageStatus",
                        "public": true,
                        "description": "Messaging- delivered message",
                        "url": "https://events.twilio.com/v1/Types/com.twilio.messaging.message.delivered",
                        "links": {
                            "schema": "https://events.twilio.com/v1/Schemas/Messaging.MessageStatus/Versions"
                        }
                    },
                    {
                        "date_created": "2020-08-13T13:28:19Z",
                        "date_updated": "2020-08-13T13:28:19Z",
                        "type": "com.twilio.messaging.message.failed",
                        "schema_id": "Messaging.MessageStatus",
                        "public": true,
                        "description": "Messaging- failed message",
                        "url": "https://events.twilio.com/v1/Types/com.twilio.messaging.message.failed",
                        "links": {
                            "schema": "https://events.twilio.com/v1/Schemas/Messaging.MessageStatus/Versions"
                        }
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 20,
                    "first_page_url": "https://events.twilio.com/v1/Types?PageSize=20&Page=0",
                    "previous_page_url": null,
                    "url": "https://events.twilio.com/v1/Types?PageSize=20&Page=0",
                    "next_page_url": null,
                    "key": "types"
                }
            }
            '''
        ))

        actual = self.client.events.v1.event_types.list()

        self.assertIsNotNone(actual)

    def test_read_results_with_schema_id_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "types": [
                    {
                        "date_created": "2020-08-13T13:28:20Z",
                        "date_updated": "2020-08-13T13:28:20Z",
                        "type": "com.twilio.messaging.message.delivered",
                        "schema_id": "Messaging.MessageStatus",
                        "public": true,
                        "description": "Messaging- delivered message",
                        "url": "https://events.twilio.com/v1/Types/com.twilio.messaging.message.delivered",
                        "links": {
                            "schema": "https://events.twilio.com/v1/Schemas/Messaging.MessageStatus/Versions"
                        }
                    },
                    {
                        "date_created": "2020-08-13T13:28:19Z",
                        "date_updated": "2020-08-13T13:28:19Z",
                        "type": "com.twilio.messaging.message.failed",
                        "schema_id": "Messaging.MessageStatus",
                        "public": true,
                        "description": "Messaging- failed message",
                        "url": "https://events.twilio.com/v1/Types/com.twilio.messaging.message.failed",
                        "links": {
                            "schema": "https://events.twilio.com/v1/Schemas/Messaging.MessageStatus/Versions"
                        }
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 20,
                    "first_page_url": "https://events.twilio.com/v1/Types?SchemaId=Messaging.MessageStatus&PageSize=20&Page=0",
                    "previous_page_url": null,
                    "url": "https://events.twilio.com/v1/Types?SchemaId=Messaging.MessageStatus&PageSize=20&Page=0",
                    "next_page_url": null,
                    "key": "types"
                }
            }
            '''
        ))

        actual = self.client.events.v1.event_types.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.events.v1.event_types("type").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://events.twilio.com/v1/Types/type',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "date_created": "2020-08-13T13:28:20Z",
                "date_updated": "2020-08-13T13:28:20Z",
                "type": "com.twilio.messaging.message.delivered",
                "schema_id": "Messaging.MessageStatus",
                "public": true,
                "description": "Messaging- delivered message",
                "url": "https://events.twilio.com/v1/Types/com.twilio.messaging.message.delivered",
                "links": {
                    "schema": "https://events.twilio.com/v1/Schemas/Messaging.MessageStatus/Versions"
                }
            }
            '''
        ))

        actual = self.client.events.v1.event_types("type").fetch()

        self.assertIsNotNone(actual)
