/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "filter.h"
#include "configparams.h"

filter::filter()
{
	filteredDataBuffer=0;
	volumeBuffer=0;
	filterParams=0;
	samplesI=0;
	samplesQ=0;
	filterLength=0;
}

filter::~filter()
{
  if(filteredDataBuffer) delete [] filteredDataBuffer;
  if(volumeBuffer) delete [] volumeBuffer;
  if(filterParams) delete [] filterParams;
}

filter::filter(unsigned int len,const DSPFLOAT *fparam,unsigned int filterLen,DSPFLOAT centerFrequency,bool scaled)
{
  filteredDataBuffer=0;
  volumeBuffer=0;
	filterParams=0;
	samplesI=0;
	samplesQ=0;
	filterLength=0;
	allocate(len);
  setFilterParams(fparam,filterLen,centerFrequency,scaled);
  resIprev=0;
  resQprev=0;
}

void filter::allocate(unsigned int len)
{
	length=len;
	if(filteredDataBuffer) delete [] filteredDataBuffer;
	if(volumeBuffer) delete [] volumeBuffer;
	filteredDataBuffer=new DSPFLOAT [len];
	volumeBuffer=new DSPFLOAT [len];
}

void filter::setFilterParams(const DSPFLOAT *fparam,unsigned filterLen,DSPFLOAT centerFrequency,bool scaled)
{
	unsigned int i;
  if(filterLen!=filterLength)
    {
      filterLength=filterLen;
      if(filterParams) delete [] filterParams;
      filterParams=new DSPFLOAT [filterLength];
      if(samplesI) delete [] samplesI;
      if(samplesQ) delete [] samplesQ;
      samplesI=new DSPFLOAT[filterLength];
      samplesQ=new DSPFLOAT[filterLength];
    }
  frCenter=centerFrequency;
	nco.init(frCenter/rxClock);
	angleToFc=rxClock/(2*M_PI);

	for(i=0;i<filterLength;i++)
		{
			samplesI[i]=0;
			samplesQ[i]=0;
		}
  DSPFLOAT gain=0;
	for(i=0;i<filterLength;i++)
		{
      gain+=fparam[i];
		}
  for(i=0;i<filterLength;i++)
    {
      if(scaled) filterParams[i]=fparam[i]/gain;
      else filterParams[i]=fparam[i];

    }
  addToLog(QString("filtergain:=%1").arg(gain),DBPERFORM);
}

void filter::processFM(short int *data)
{
	DSPFLOAT resI=0, resQ=0;
	DSPFLOAT temp;
	const DSPFLOAT *cf1;
	DSPFLOAT *fp1, *fp2 ,discRe,discIm;
	unsigned int i,k;
	int zeroes=filterLength-1;

	for (k=0;k<length;k++)
		{
			resI=0;
			resQ=0;
			cf1 = filterParams;
			fp1 = samplesI;
			fp2 = samplesQ;
			memmove(samplesI, samplesI+1, (zeroes)*sizeof(DSPFLOAT));
  		memmove(samplesQ, samplesQ+1, (zeroes)*sizeof(DSPFLOAT));
			nco.multiply(samplesI[zeroes],samplesQ[zeroes],(DSPFLOAT) (data[k]));
			for(i=0;i<filterLength;i++,fp1++,fp2++,cf1++)
 				{
   				resI+=(*fp1)*(*cf1);
   				resQ+=(*fp2)*(*cf1);
 				}
			discRe=resI*resIprev+resQ*resQprev;
  		discIm=-resQ*resIprev+resQprev*resI;
  		resIprev=resI;
  		resQprev=resQ;
  		if(discRe==0) discRe=0.0001;
			temp=frCenter-atan2(discIm,discRe)*angleToFc;
      if(temp<500) temp=holdPrev;
      if(temp>3000) temp=holdPrev;
			filteredDataBuffer[k]=temp;
      holdPrev=temp;
      volumeBuffer[k]=sqrt(resI*resI);
		}
}

void filter::processBP(short int *data)
{
  DSPFLOAT resI=0;
  const DSPFLOAT *cf1;
  DSPFLOAT *fp1;
  unsigned int i,k;
  int zeroes=filterLength-1;

  for (k=0;k<length;k++)
    {
      resI=0;
      cf1 = filterParams;
      fp1 = samplesI;
      memmove(samplesI, samplesI+1, (zeroes)*sizeof(DSPFLOAT));
      samplesI[zeroes]=(DSPFLOAT) (data[k]);
      for(i=0;i<filterLength;i++,fp1++,cf1++)
        {
          resI+=(*fp1)*(*cf1);
        }
      resIprev=resI;
      filteredDataBuffer[k]=(DSPFLOAT)(fabs(resI));

    }
}



void filter::processAM(short int *data)
{
	DSPFLOAT resI=0, resQ=0;
	const DSPFLOAT *cf1;
	DSPFLOAT *fp1, *fp2 ,amplitude;
	unsigned int i,k;
	int zeroes=filterLength-1;

	for (k=0;k<length;k++)
		{
			resI=0;
			resQ=0;
			cf1 = filterParams;
			fp1 = samplesI;
			fp2 = samplesQ;
			memmove(samplesI, samplesI+1, (zeroes)*sizeof(DSPFLOAT));
  		memmove(samplesQ, samplesQ+1, (zeroes)*sizeof(DSPFLOAT));
			nco.multiply(samplesI[zeroes],samplesQ[zeroes],(DSPFLOAT) (data[k]));
			for(i=0;i<filterLength;i++,fp1++,fp2++,cf1++)
 				{
   				resI+=(*fp1)*(*cf1);
   				resQ+=(*fp2)*(*cf1);
 				}
			amplitude=sqrt(resI*resI+resQ*resQ);
  		resIprev=resI;
  		resQprev=resQ;
			filteredDataBuffer[k]=amplitude;
		}
}

