/***************************************************************************
 *  This file is part of Qthid.
 *
 *  Copyright (C) 2010       Howard Long, G6LVB
 *  Copyright (C) 2011       Mario Lorenz, DL5MLO
 *  Copyright (C) 2011-2012  Alexandru Csete, OZ9AEC
 *
 *  Qthid is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Qthid is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Qthid.  If not, see <http://www.gnu.org/licenses/>.
 *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QComboBox>
#include <QLabel>
#include "fcd.h"
#include "firmware.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;        /*! UI generated by Qt Designer. */
    QTimer         *timer;     /*! Timer for cyclic polling of FCD. */
    QLabel         *fcdStatus; /*! Label showing FCD status in statusbar. */
    FCD_MODE_ENUM   prevMode;  /*! Previous mode to detect FCd mode changes (bootloader/app). */

    CFirmware  *fwDialog;      /*! Firmware tools (uplaod and verify firmware). */

    qint64      lnbOffset;     /*! Frequency offset when using up- and downconverters (Hz). */

    double StrToDouble(QString s);

    void readDevice(quint16 flags);

public slots:
    void setNewFrequency(qint64 freq);

private slots:
    void on_spinBoxCorr_valueChanged(int);
    void on_spinBoxLnb_valueChanged(double);
    void on_biasTeeButton_clicked();
    void on_lnaButton_clicked();
    void on_mixerButton_clicked();
    void on_ifGainSpinBox_valueChanged(int);

    void enableControls();
    void fwDialogFinished(int result);

    /* actions */
    void on_actionLoad_triggered();
    void on_actionSave_triggered();
    void on_actionFirmware_triggered();
    void on_actionDefault_triggered();
    void on_actionAbout_triggered();
    void on_actionAboutQt_triggered();
};

#endif // MAINWINDOW_H
