% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_cell_trajectory}
\alias{plot_cell_trajectory}
\title{Plots the minimum spanning tree on cells.}
\usage{
plot_cell_trajectory(
  cds,
  x = 1,
  y = 2,
  color_by = "State",
  show_tree = TRUE,
  show_backbone = TRUE,
  backbone_color = "black",
  markers = NULL,
  use_color_gradient = FALSE,
  markers_linear = FALSE,
  show_cell_names = FALSE,
  show_state_number = FALSE,
  cell_size = 1.5,
  cell_link_size = 0.75,
  cell_name_size = 2,
  state_number_size = 2.9,
  show_branch_points = TRUE,
  theta = 0,
  ...
)
}
\arguments{
\item{cds}{CellDataSet for the experiment}

\item{x}{the column of reducedDimS(cds) to plot on the horizontal axis}

\item{y}{the column of reducedDimS(cds) to plot on the vertical axis}

\item{color_by}{the cell attribute (e.g. the column of pData(cds)) to map to each cell's color}

\item{show_tree}{whether to show the links between cells connected in the minimum spanning tree}

\item{show_backbone}{whether to show the diameter path of the MST used to order the cells}

\item{backbone_color}{the color used to render the backbone.}

\item{markers}{a gene name or gene id to use for setting the size of each cell in the plot}

\item{use_color_gradient}{Whether or not to use color gradient instead of cell size to show marker expression level}

\item{markers_linear}{a boolean used to indicate whether you want to scale the markers logarithimically or linearly}

\item{show_cell_names}{draw the name of each cell in the plot}

\item{show_state_number}{show state number}

\item{cell_size}{The size of the point for each cell}

\item{cell_link_size}{The size of the line segments connecting cells (when used with ICA) or the principal graph (when used with DDRTree)}

\item{cell_name_size}{the size of cell name labels}

\item{state_number_size}{the size of the state number}

\item{show_branch_points}{Whether to show icons for each branch point (only available when reduceDimension was called with DDRTree)}

\item{theta}{How many degrees you want to rotate the trajectory}

\item{...}{Additional arguments passed into scale_color_viridis function}
}
\value{
a ggplot2 plot object
}
\description{
Plots the minimum spanning tree on cells.
}
\examples{
\dontrun{
lung <- load_lung()
plot_cell_trajectory(lung)
plot_cell_trajectory(lung, color_by="Pseudotime", show_backbone=FALSE)
plot_cell_trajectory(lung, markers="MYH3")
}
}
