% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuettnerESCData.R
\name{BuettnerESCData}
\alias{BuettnerESCData}
\title{Obtain the Buettner ESC data}
\usage{
BuettnerESCData(remove.htseq = TRUE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{remove.htseq}{Logical scalar indicating whether HT-seq alignment statistics should be removed.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse embryonic stem cell single-cell RNA-seq data from Buettner et al. (2015).
}
\details{
Rows corresponding to HT-seq's alignment statistics are removed by default.
These can be retained by setting \code{remove.htseq=FALSE}.

Column metadata contains the experimentally determined cell cycle phase for each cell.

Counts for ERCC spike-ins are stored in the \code{"ERCC"} entry in the \code{\link{altExps}}.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/buettner-esc}.
}
\examples{
sce <- BuettnerESCData()

}
\references{
Buettner F et al. (2015).
Computational analysis of cell-to-cell heterogeneity in single-cell RNA-sequencing data reveals hidden subpopulations of cells.
\emph{Nat. Biotechnol.} 33(2), 155-160.
}
\author{
Aaron Lun
}
