% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlm_tidiers.R
\name{rlm_tidiers}
\alias{rlm_tidiers}
\alias{glance.rlm}
\title{Tidying methods for an rlm (robust linear model) object}
\usage{
\method{glance}{rlm}(x, ...)
}
\arguments{
\item{x}{rlm object}

\item{...}{extra arguments (not used)}
}
\value{
\code{glance.rlm} returns a one-row data.frame with the columns
  \item{sigma}{The square root of the estimated residual variance}
  \item{converged}{whether the IWLS converged}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
}
\description{
This method provides a glance of an "rlm" object. The \code{tidy} and
\code{augment} methods are handled by \link{lm_tidiers}.
}
\examples{

library(MASS)

r <- rlm(stack.loss ~ ., stackloss)
tidy(r)
augment(r)
glance(r)

}
\seealso{
\link{lm_tidiers}
}
