% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n-distinct.R
\name{n_distinct}
\alias{n_distinct}
\title{Count unique combinations}
\usage{
n_distinct(..., na.rm = FALSE)
}
\arguments{
\item{...}{Unnamed vectors. If multiple vectors are supplied, then they should
have the same length.}

\item{na.rm}{If \code{TRUE}, exclude missing observations from the count.
If there are multiple vectors in \code{...}, an observation will
be excluded if \emph{any} of the values are missing.}
}
\value{
A single number.
}
\description{
\code{n_distinct()} counts the number of unique/distinct combinations in a set
of one or more vectors. It's a faster and more concise equivalent to
\code{nrow(unique(data.frame(...)))}.
}
\examples{
x <- c(1, 1, 2, 2, 2)
n_distinct(x)

y <- c(3, 3, NA, 3, 3)
n_distinct(y)
n_distinct(y, na.rm = TRUE)

# Pairs (1, 3), (2, 3), and (2, NA) are distinct
n_distinct(x, y)

# (2, NA) is dropped, leaving 2 distinct combinations
n_distinct(x, y, na.rm = TRUE)

# Also works with data frames
n_distinct(data.frame(x, y))
}
