% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{selectResponse}
\alias{selectResponse}
\alias{selectResponse.formula}
\title{Response Variable of a Formula}
\usage{
selectResponse(object, ...)

\method{selectResponse}{formula}(object, format = "call", ...)
}
\arguments{
\item{object}{a formula}

\item{...}{[internal] Only used by the generic method.}

\item{format}{[character] should an object of type call be returned (\code{format = "call"}),
or the names of the variables (\code{format = "vars"})}
}
\value{
See argument \code{format}.
}
\description{
Return the response variable contained in the formula.
}
\examples{

\dontrun{

selectResponse <- lavaSearch2:::selectResponse
selectResponse.formula <- lavaSearch2:::selectResponse.formula

selectResponse(Y1~X1+X2)
selectResponse(Y1~X1+X2, format = "vars")
selectResponse(Surv(event,time)~X1+X2, format = "vars")

selectResponse(Y1~X1+Y1)
selectResponse(Y1+Y2~X1+Y1, format = "vars")

selectResponse(~X1+X2)
selectResponse(~X1+X2, format = "vars")
}

}
\keyword{internal}
