% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distn.R
\name{InvWishart}
\alias{InvWishart}
\alias{diwish}
\alias{riwish}
\title{The Inverse Wishart Distribution}
\usage{
riwish(v, S)

diwish(W, v, S)
}
\arguments{
\item{v}{Degrees of freedom (scalar).}

\item{S}{Scale matrix \eqn{(p \times p)}.}

\item{W}{Positive definite matrix W \eqn{(p \times p)}.}
}
\value{
\code{diwish} evaluates the density at positive definite matrix W.
\code{riwish} generates one random draw from the distribution.
}
\description{
Density function and random generation from the Inverse Wishart
distribution.
}
\details{
The mean of an inverse Wishart random variable with \code{v} degrees of
freedom and scale matrix \code{S} is \eqn{(v-p-1)^{-1}S}.
}
\examples{

density <- diwish(matrix(c(2,-.3,-.3,4),2,2), 3, matrix(c(1,.3,.3,1),2,2))
draw <- riwish(3, matrix(c(1,.3,.3,1),2,2))

}
\keyword{distribution}
