% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persisters.R
\name{Persisters}
\alias{Persisters}
\alias{persister_fetch}
\title{Cassette persisters}
\usage{
persister_fetch(x = "FileSystem", file_name)
}
\description{
Keeps track of the cassette persisters in a hash-like object
}
\details{
There's only one option: \code{FileSystem}
\strong{Private Methods}
\describe{
\item{\code{persister_get()}}{
Gets and sets a named persister
}
}
}
\examples{
(aa <- Persisters$new())
aa$name
aa$persisters
yaml_serializer <- aa$persisters$new()
yaml_serializer
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{persisters}}{(list) internal use, holds persister object}

\item{\code{name}}{(character)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Persisters$new()}}
\item \href{#method-clone}{\code{Persisters$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{Persisters} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Persisters$new(persisters = list(), name = "FileSystem")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{persisters}}{(list) a list}

\item{\code{name}}{(character) Persister name, only option right now
is "FileSystem"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Persisters} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Persisters$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
