% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{maybe_lossy_cast}
\alias{maybe_lossy_cast}
\title{Lossy cast error}
\usage{
maybe_lossy_cast(
  result,
  x,
  to,
  lossy = NULL,
  locations = NULL,
  ...,
  loss_type = c("precision", "generality"),
  x_arg,
  to_arg,
  details = NULL,
  message = NULL,
  class = NULL,
  .deprecation = FALSE
)
}
\arguments{
\item{result}{The result of a potentially lossy cast.}

\item{x}{Vectors}

\item{to}{Type to cast to.}

\item{lossy}{A logical vector indicating which elements of \code{result}
were lossy.

Can also be a single \code{TRUE}, but note that \code{locations} picks up
locations from this vector by default. In this case, supply your
own location vector, possibly empty.}

\item{locations}{An optional integer vector giving the
locations where \code{x} lost information.}

\item{...}{Only use these fields when creating a subclass.}

\item{loss_type}{The kind of lossy cast to be mentioned in error
messages. Can be loss of precision (for instance from double to
integer) or loss of generality (from character to factor).}

\item{x_arg}{Argument names for \code{x}, \code{y}, and \code{to}. Used in
error messages to inform the user about the locations of incompatible
types.}

\item{to_arg}{Argument names for \code{x}, \code{y}, and \code{to}. Used in
error messages to inform the user about the locations of incompatible
types.}

\item{details}{Any additional human readable details.}

\item{message}{An overriding message for the error. \code{details} and
\code{message} are mutually exclusive, supplying both is an error.}

\item{class}{Only use these fields when creating a subclass.}

\item{.deprecation}{If \code{TRUE}, the error is downgraded to a
deprecation warning. This is useful for transitioning your class
to a stricter conversion scheme. The warning advises your users
to wrap their code with \code{allow_lossy_cast()}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

By default, lossy casts are an error. Use \code{allow_lossy_cast()} to
silence these errors and continue with the partial results. In this
case the lost values are typically set to \code{NA} or to a lower value
resolution, depending on the type of cast.

Lossy cast errors are thrown by \code{maybe_lossy_cast()}. Unlike
functions prefixed with \code{stop_}, \code{maybe_lossy_cast()} usually
returns a result. If a lossy cast is detected, it throws an error,
unless it's been wrapped in \code{allow_lossy_cast()}. In that case, it
returns the result silently.
}
\keyword{internal}
