use v6.c;
# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.p6.

use Test;

plan 2000;

ok Uni.new(0xC9D1).NFKD.list ~~ (0x110C, 0x1175, 0x11B8,), 'C9D1 -> 110C 1175 11B8';
ok Uni.new(0xC9D2).NFKD.list ~~ (0x110C, 0x1175, 0x11B9,), 'C9D2 -> 110C 1175 11B9';
ok Uni.new(0xC9D3).NFKD.list ~~ (0x110C, 0x1175, 0x11BA,), 'C9D3 -> 110C 1175 11BA';
ok Uni.new(0xC9D4).NFKD.list ~~ (0x110C, 0x1175, 0x11BB,), 'C9D4 -> 110C 1175 11BB';
ok Uni.new(0xC9D5).NFKD.list ~~ (0x110C, 0x1175, 0x11BC,), 'C9D5 -> 110C 1175 11BC';
ok Uni.new(0xC9D6).NFKD.list ~~ (0x110C, 0x1175, 0x11BD,), 'C9D6 -> 110C 1175 11BD';
ok Uni.new(0xC9D7).NFKD.list ~~ (0x110C, 0x1175, 0x11BE,), 'C9D7 -> 110C 1175 11BE';
ok Uni.new(0xC9D8).NFKD.list ~~ (0x110C, 0x1175, 0x11BF,), 'C9D8 -> 110C 1175 11BF';
ok Uni.new(0xC9D9).NFKD.list ~~ (0x110C, 0x1175, 0x11C0,), 'C9D9 -> 110C 1175 11C0';
ok Uni.new(0xC9DA).NFKD.list ~~ (0x110C, 0x1175, 0x11C1,), 'C9DA -> 110C 1175 11C1';
ok Uni.new(0xC9DB).NFKD.list ~~ (0x110C, 0x1175, 0x11C2,), 'C9DB -> 110C 1175 11C2';
ok Uni.new(0xC9DC).NFKD.list ~~ (0x110D, 0x1161,), 'C9DC -> 110D 1161';
ok Uni.new(0xC9DD).NFKD.list ~~ (0x110D, 0x1161, 0x11A8,), 'C9DD -> 110D 1161 11A8';
ok Uni.new(0xC9DE).NFKD.list ~~ (0x110D, 0x1161, 0x11A9,), 'C9DE -> 110D 1161 11A9';
ok Uni.new(0xC9DF).NFKD.list ~~ (0x110D, 0x1161, 0x11AA,), 'C9DF -> 110D 1161 11AA';
ok Uni.new(0xC9E0).NFKD.list ~~ (0x110D, 0x1161, 0x11AB,), 'C9E0 -> 110D 1161 11AB';
ok Uni.new(0xC9E1).NFKD.list ~~ (0x110D, 0x1161, 0x11AC,), 'C9E1 -> 110D 1161 11AC';
ok Uni.new(0xC9E2).NFKD.list ~~ (0x110D, 0x1161, 0x11AD,), 'C9E2 -> 110D 1161 11AD';
ok Uni.new(0xC9E3).NFKD.list ~~ (0x110D, 0x1161, 0x11AE,), 'C9E3 -> 110D 1161 11AE';
ok Uni.new(0xC9E4).NFKD.list ~~ (0x110D, 0x1161, 0x11AF,), 'C9E4 -> 110D 1161 11AF';
ok Uni.new(0xC9E5).NFKD.list ~~ (0x110D, 0x1161, 0x11B0,), 'C9E5 -> 110D 1161 11B0';
ok Uni.new(0xC9E6).NFKD.list ~~ (0x110D, 0x1161, 0x11B1,), 'C9E6 -> 110D 1161 11B1';
ok Uni.new(0xC9E7).NFKD.list ~~ (0x110D, 0x1161, 0x11B2,), 'C9E7 -> 110D 1161 11B2';
ok Uni.new(0xC9E8).NFKD.list ~~ (0x110D, 0x1161, 0x11B3,), 'C9E8 -> 110D 1161 11B3';
ok Uni.new(0xC9E9).NFKD.list ~~ (0x110D, 0x1161, 0x11B4,), 'C9E9 -> 110D 1161 11B4';
ok Uni.new(0xC9EA).NFKD.list ~~ (0x110D, 0x1161, 0x11B5,), 'C9EA -> 110D 1161 11B5';
ok Uni.new(0xC9EB).NFKD.list ~~ (0x110D, 0x1161, 0x11B6,), 'C9EB -> 110D 1161 11B6';
ok Uni.new(0xC9EC).NFKD.list ~~ (0x110D, 0x1161, 0x11B7,), 'C9EC -> 110D 1161 11B7';
ok Uni.new(0xC9ED).NFKD.list ~~ (0x110D, 0x1161, 0x11B8,), 'C9ED -> 110D 1161 11B8';
ok Uni.new(0xC9EE).NFKD.list ~~ (0x110D, 0x1161, 0x11B9,), 'C9EE -> 110D 1161 11B9';
ok Uni.new(0xC9EF).NFKD.list ~~ (0x110D, 0x1161, 0x11BA,), 'C9EF -> 110D 1161 11BA';
ok Uni.new(0xC9F0).NFKD.list ~~ (0x110D, 0x1161, 0x11BB,), 'C9F0 -> 110D 1161 11BB';
ok Uni.new(0xC9F1).NFKD.list ~~ (0x110D, 0x1161, 0x11BC,), 'C9F1 -> 110D 1161 11BC';
ok Uni.new(0xC9F2).NFKD.list ~~ (0x110D, 0x1161, 0x11BD,), 'C9F2 -> 110D 1161 11BD';
ok Uni.new(0xC9F3).NFKD.list ~~ (0x110D, 0x1161, 0x11BE,), 'C9F3 -> 110D 1161 11BE';
ok Uni.new(0xC9F4).NFKD.list ~~ (0x110D, 0x1161, 0x11BF,), 'C9F4 -> 110D 1161 11BF';
ok Uni.new(0xC9F5).NFKD.list ~~ (0x110D, 0x1161, 0x11C0,), 'C9F5 -> 110D 1161 11C0';
ok Uni.new(0xC9F6).NFKD.list ~~ (0x110D, 0x1161, 0x11C1,), 'C9F6 -> 110D 1161 11C1';
ok Uni.new(0xC9F7).NFKD.list ~~ (0x110D, 0x1161, 0x11C2,), 'C9F7 -> 110D 1161 11C2';
ok Uni.new(0xC9F8).NFKD.list ~~ (0x110D, 0x1162,), 'C9F8 -> 110D 1162';
ok Uni.new(0xC9F9).NFKD.list ~~ (0x110D, 0x1162, 0x11A8,), 'C9F9 -> 110D 1162 11A8';
ok Uni.new(0xC9FA).NFKD.list ~~ (0x110D, 0x1162, 0x11A9,), 'C9FA -> 110D 1162 11A9';
ok Uni.new(0xC9FB).NFKD.list ~~ (0x110D, 0x1162, 0x11AA,), 'C9FB -> 110D 1162 11AA';
ok Uni.new(0xC9FC).NFKD.list ~~ (0x110D, 0x1162, 0x11AB,), 'C9FC -> 110D 1162 11AB';
ok Uni.new(0xC9FD).NFKD.list ~~ (0x110D, 0x1162, 0x11AC,), 'C9FD -> 110D 1162 11AC';
ok Uni.new(0xC9FE).NFKD.list ~~ (0x110D, 0x1162, 0x11AD,), 'C9FE -> 110D 1162 11AD';
ok Uni.new(0xC9FF).NFKD.list ~~ (0x110D, 0x1162, 0x11AE,), 'C9FF -> 110D 1162 11AE';
ok Uni.new(0xCA00).NFKD.list ~~ (0x110D, 0x1162, 0x11AF,), 'CA00 -> 110D 1162 11AF';
ok Uni.new(0xCA01).NFKD.list ~~ (0x110D, 0x1162, 0x11B0,), 'CA01 -> 110D 1162 11B0';
ok Uni.new(0xCA02).NFKD.list ~~ (0x110D, 0x1162, 0x11B1,), 'CA02 -> 110D 1162 11B1';
ok Uni.new(0xCA03).NFKD.list ~~ (0x110D, 0x1162, 0x11B2,), 'CA03 -> 110D 1162 11B2';
ok Uni.new(0xCA04).NFKD.list ~~ (0x110D, 0x1162, 0x11B3,), 'CA04 -> 110D 1162 11B3';
ok Uni.new(0xCA05).NFKD.list ~~ (0x110D, 0x1162, 0x11B4,), 'CA05 -> 110D 1162 11B4';
ok Uni.new(0xCA06).NFKD.list ~~ (0x110D, 0x1162, 0x11B5,), 'CA06 -> 110D 1162 11B5';
ok Uni.new(0xCA07).NFKD.list ~~ (0x110D, 0x1162, 0x11B6,), 'CA07 -> 110D 1162 11B6';
ok Uni.new(0xCA08).NFKD.list ~~ (0x110D, 0x1162, 0x11B7,), 'CA08 -> 110D 1162 11B7';
ok Uni.new(0xCA09).NFKD.list ~~ (0x110D, 0x1162, 0x11B8,), 'CA09 -> 110D 1162 11B8';
ok Uni.new(0xCA0A).NFKD.list ~~ (0x110D, 0x1162, 0x11B9,), 'CA0A -> 110D 1162 11B9';
ok Uni.new(0xCA0B).NFKD.list ~~ (0x110D, 0x1162, 0x11BA,), 'CA0B -> 110D 1162 11BA';
ok Uni.new(0xCA0C).NFKD.list ~~ (0x110D, 0x1162, 0x11BB,), 'CA0C -> 110D 1162 11BB';
ok Uni.new(0xCA0D).NFKD.list ~~ (0x110D, 0x1162, 0x11BC,), 'CA0D -> 110D 1162 11BC';
ok Uni.new(0xCA0E).NFKD.list ~~ (0x110D, 0x1162, 0x11BD,), 'CA0E -> 110D 1162 11BD';
ok Uni.new(0xCA0F).NFKD.list ~~ (0x110D, 0x1162, 0x11BE,), 'CA0F -> 110D 1162 11BE';
ok Uni.new(0xCA10).NFKD.list ~~ (0x110D, 0x1162, 0x11BF,), 'CA10 -> 110D 1162 11BF';
ok Uni.new(0xCA11).NFKD.list ~~ (0x110D, 0x1162, 0x11C0,), 'CA11 -> 110D 1162 11C0';
ok Uni.new(0xCA12).NFKD.list ~~ (0x110D, 0x1162, 0x11C1,), 'CA12 -> 110D 1162 11C1';
ok Uni.new(0xCA13).NFKD.list ~~ (0x110D, 0x1162, 0x11C2,), 'CA13 -> 110D 1162 11C2';
ok Uni.new(0xCA14).NFKD.list ~~ (0x110D, 0x1163,), 'CA14 -> 110D 1163';
ok Uni.new(0xCA15).NFKD.list ~~ (0x110D, 0x1163, 0x11A8,), 'CA15 -> 110D 1163 11A8';
ok Uni.new(0xCA16).NFKD.list ~~ (0x110D, 0x1163, 0x11A9,), 'CA16 -> 110D 1163 11A9';
ok Uni.new(0xCA17).NFKD.list ~~ (0x110D, 0x1163, 0x11AA,), 'CA17 -> 110D 1163 11AA';
ok Uni.new(0xCA18).NFKD.list ~~ (0x110D, 0x1163, 0x11AB,), 'CA18 -> 110D 1163 11AB';
ok Uni.new(0xCA19).NFKD.list ~~ (0x110D, 0x1163, 0x11AC,), 'CA19 -> 110D 1163 11AC';
ok Uni.new(0xCA1A).NFKD.list ~~ (0x110D, 0x1163, 0x11AD,), 'CA1A -> 110D 1163 11AD';
ok Uni.new(0xCA1B).NFKD.list ~~ (0x110D, 0x1163, 0x11AE,), 'CA1B -> 110D 1163 11AE';
ok Uni.new(0xCA1C).NFKD.list ~~ (0x110D, 0x1163, 0x11AF,), 'CA1C -> 110D 1163 11AF';
ok Uni.new(0xCA1D).NFKD.list ~~ (0x110D, 0x1163, 0x11B0,), 'CA1D -> 110D 1163 11B0';
ok Uni.new(0xCA1E).NFKD.list ~~ (0x110D, 0x1163, 0x11B1,), 'CA1E -> 110D 1163 11B1';
ok Uni.new(0xCA1F).NFKD.list ~~ (0x110D, 0x1163, 0x11B2,), 'CA1F -> 110D 1163 11B2';
ok Uni.new(0xCA20).NFKD.list ~~ (0x110D, 0x1163, 0x11B3,), 'CA20 -> 110D 1163 11B3';
ok Uni.new(0xCA21).NFKD.list ~~ (0x110D, 0x1163, 0x11B4,), 'CA21 -> 110D 1163 11B4';
ok Uni.new(0xCA22).NFKD.list ~~ (0x110D, 0x1163, 0x11B5,), 'CA22 -> 110D 1163 11B5';
ok Uni.new(0xCA23).NFKD.list ~~ (0x110D, 0x1163, 0x11B6,), 'CA23 -> 110D 1163 11B6';
ok Uni.new(0xCA24).NFKD.list ~~ (0x110D, 0x1163, 0x11B7,), 'CA24 -> 110D 1163 11B7';
ok Uni.new(0xCA25).NFKD.list ~~ (0x110D, 0x1163, 0x11B8,), 'CA25 -> 110D 1163 11B8';
ok Uni.new(0xCA26).NFKD.list ~~ (0x110D, 0x1163, 0x11B9,), 'CA26 -> 110D 1163 11B9';
ok Uni.new(0xCA27).NFKD.list ~~ (0x110D, 0x1163, 0x11BA,), 'CA27 -> 110D 1163 11BA';
ok Uni.new(0xCA28).NFKD.list ~~ (0x110D, 0x1163, 0x11BB,), 'CA28 -> 110D 1163 11BB';
ok Uni.new(0xCA29).NFKD.list ~~ (0x110D, 0x1163, 0x11BC,), 'CA29 -> 110D 1163 11BC';
ok Uni.new(0xCA2A).NFKD.list ~~ (0x110D, 0x1163, 0x11BD,), 'CA2A -> 110D 1163 11BD';
ok Uni.new(0xCA2B).NFKD.list ~~ (0x110D, 0x1163, 0x11BE,), 'CA2B -> 110D 1163 11BE';
ok Uni.new(0xCA2C).NFKD.list ~~ (0x110D, 0x1163, 0x11BF,), 'CA2C -> 110D 1163 11BF';
ok Uni.new(0xCA2D).NFKD.list ~~ (0x110D, 0x1163, 0x11C0,), 'CA2D -> 110D 1163 11C0';
ok Uni.new(0xCA2E).NFKD.list ~~ (0x110D, 0x1163, 0x11C1,), 'CA2E -> 110D 1163 11C1';
ok Uni.new(0xCA2F).NFKD.list ~~ (0x110D, 0x1163, 0x11C2,), 'CA2F -> 110D 1163 11C2';
ok Uni.new(0xCA30).NFKD.list ~~ (0x110D, 0x1164,), 'CA30 -> 110D 1164';
ok Uni.new(0xCA31).NFKD.list ~~ (0x110D, 0x1164, 0x11A8,), 'CA31 -> 110D 1164 11A8';
ok Uni.new(0xCA32).NFKD.list ~~ (0x110D, 0x1164, 0x11A9,), 'CA32 -> 110D 1164 11A9';
ok Uni.new(0xCA33).NFKD.list ~~ (0x110D, 0x1164, 0x11AA,), 'CA33 -> 110D 1164 11AA';
ok Uni.new(0xCA34).NFKD.list ~~ (0x110D, 0x1164, 0x11AB,), 'CA34 -> 110D 1164 11AB';
ok Uni.new(0xCA35).NFKD.list ~~ (0x110D, 0x1164, 0x11AC,), 'CA35 -> 110D 1164 11AC';
ok Uni.new(0xCA36).NFKD.list ~~ (0x110D, 0x1164, 0x11AD,), 'CA36 -> 110D 1164 11AD';
ok Uni.new(0xCA37).NFKD.list ~~ (0x110D, 0x1164, 0x11AE,), 'CA37 -> 110D 1164 11AE';
ok Uni.new(0xCA38).NFKD.list ~~ (0x110D, 0x1164, 0x11AF,), 'CA38 -> 110D 1164 11AF';
ok Uni.new(0xCA39).NFKD.list ~~ (0x110D, 0x1164, 0x11B0,), 'CA39 -> 110D 1164 11B0';
ok Uni.new(0xCA3A).NFKD.list ~~ (0x110D, 0x1164, 0x11B1,), 'CA3A -> 110D 1164 11B1';
ok Uni.new(0xCA3B).NFKD.list ~~ (0x110D, 0x1164, 0x11B2,), 'CA3B -> 110D 1164 11B2';
ok Uni.new(0xCA3C).NFKD.list ~~ (0x110D, 0x1164, 0x11B3,), 'CA3C -> 110D 1164 11B3';
ok Uni.new(0xCA3D).NFKD.list ~~ (0x110D, 0x1164, 0x11B4,), 'CA3D -> 110D 1164 11B4';
ok Uni.new(0xCA3E).NFKD.list ~~ (0x110D, 0x1164, 0x11B5,), 'CA3E -> 110D 1164 11B5';
ok Uni.new(0xCA3F).NFKD.list ~~ (0x110D, 0x1164, 0x11B6,), 'CA3F -> 110D 1164 11B6';
ok Uni.new(0xCA40).NFKD.list ~~ (0x110D, 0x1164, 0x11B7,), 'CA40 -> 110D 1164 11B7';
ok Uni.new(0xCA41).NFKD.list ~~ (0x110D, 0x1164, 0x11B8,), 'CA41 -> 110D 1164 11B8';
ok Uni.new(0xCA42).NFKD.list ~~ (0x110D, 0x1164, 0x11B9,), 'CA42 -> 110D 1164 11B9';
ok Uni.new(0xCA43).NFKD.list ~~ (0x110D, 0x1164, 0x11BA,), 'CA43 -> 110D 1164 11BA';
ok Uni.new(0xCA44).NFKD.list ~~ (0x110D, 0x1164, 0x11BB,), 'CA44 -> 110D 1164 11BB';
ok Uni.new(0xCA45).NFKD.list ~~ (0x110D, 0x1164, 0x11BC,), 'CA45 -> 110D 1164 11BC';
ok Uni.new(0xCA46).NFKD.list ~~ (0x110D, 0x1164, 0x11BD,), 'CA46 -> 110D 1164 11BD';
ok Uni.new(0xCA47).NFKD.list ~~ (0x110D, 0x1164, 0x11BE,), 'CA47 -> 110D 1164 11BE';
ok Uni.new(0xCA48).NFKD.list ~~ (0x110D, 0x1164, 0x11BF,), 'CA48 -> 110D 1164 11BF';
ok Uni.new(0xCA49).NFKD.list ~~ (0x110D, 0x1164, 0x11C0,), 'CA49 -> 110D 1164 11C0';
ok Uni.new(0xCA4A).NFKD.list ~~ (0x110D, 0x1164, 0x11C1,), 'CA4A -> 110D 1164 11C1';
ok Uni.new(0xCA4B).NFKD.list ~~ (0x110D, 0x1164, 0x11C2,), 'CA4B -> 110D 1164 11C2';
ok Uni.new(0xCA4C).NFKD.list ~~ (0x110D, 0x1165,), 'CA4C -> 110D 1165';
ok Uni.new(0xCA4D).NFKD.list ~~ (0x110D, 0x1165, 0x11A8,), 'CA4D -> 110D 1165 11A8';
ok Uni.new(0xCA4E).NFKD.list ~~ (0x110D, 0x1165, 0x11A9,), 'CA4E -> 110D 1165 11A9';
ok Uni.new(0xCA4F).NFKD.list ~~ (0x110D, 0x1165, 0x11AA,), 'CA4F -> 110D 1165 11AA';
ok Uni.new(0xCA50).NFKD.list ~~ (0x110D, 0x1165, 0x11AB,), 'CA50 -> 110D 1165 11AB';
ok Uni.new(0xCA51).NFKD.list ~~ (0x110D, 0x1165, 0x11AC,), 'CA51 -> 110D 1165 11AC';
ok Uni.new(0xCA52).NFKD.list ~~ (0x110D, 0x1165, 0x11AD,), 'CA52 -> 110D 1165 11AD';
ok Uni.new(0xCA53).NFKD.list ~~ (0x110D, 0x1165, 0x11AE,), 'CA53 -> 110D 1165 11AE';
ok Uni.new(0xCA54).NFKD.list ~~ (0x110D, 0x1165, 0x11AF,), 'CA54 -> 110D 1165 11AF';
ok Uni.new(0xCA55).NFKD.list ~~ (0x110D, 0x1165, 0x11B0,), 'CA55 -> 110D 1165 11B0';
ok Uni.new(0xCA56).NFKD.list ~~ (0x110D, 0x1165, 0x11B1,), 'CA56 -> 110D 1165 11B1';
ok Uni.new(0xCA57).NFKD.list ~~ (0x110D, 0x1165, 0x11B2,), 'CA57 -> 110D 1165 11B2';
ok Uni.new(0xCA58).NFKD.list ~~ (0x110D, 0x1165, 0x11B3,), 'CA58 -> 110D 1165 11B3';
ok Uni.new(0xCA59).NFKD.list ~~ (0x110D, 0x1165, 0x11B4,), 'CA59 -> 110D 1165 11B4';
ok Uni.new(0xCA5A).NFKD.list ~~ (0x110D, 0x1165, 0x11B5,), 'CA5A -> 110D 1165 11B5';
ok Uni.new(0xCA5B).NFKD.list ~~ (0x110D, 0x1165, 0x11B6,), 'CA5B -> 110D 1165 11B6';
ok Uni.new(0xCA5C).NFKD.list ~~ (0x110D, 0x1165, 0x11B7,), 'CA5C -> 110D 1165 11B7';
ok Uni.new(0xCA5D).NFKD.list ~~ (0x110D, 0x1165, 0x11B8,), 'CA5D -> 110D 1165 11B8';
ok Uni.new(0xCA5E).NFKD.list ~~ (0x110D, 0x1165, 0x11B9,), 'CA5E -> 110D 1165 11B9';
ok Uni.new(0xCA5F).NFKD.list ~~ (0x110D, 0x1165, 0x11BA,), 'CA5F -> 110D 1165 11BA';
ok Uni.new(0xCA60).NFKD.list ~~ (0x110D, 0x1165, 0x11BB,), 'CA60 -> 110D 1165 11BB';
ok Uni.new(0xCA61).NFKD.list ~~ (0x110D, 0x1165, 0x11BC,), 'CA61 -> 110D 1165 11BC';
ok Uni.new(0xCA62).NFKD.list ~~ (0x110D, 0x1165, 0x11BD,), 'CA62 -> 110D 1165 11BD';
ok Uni.new(0xCA63).NFKD.list ~~ (0x110D, 0x1165, 0x11BE,), 'CA63 -> 110D 1165 11BE';
ok Uni.new(0xCA64).NFKD.list ~~ (0x110D, 0x1165, 0x11BF,), 'CA64 -> 110D 1165 11BF';
ok Uni.new(0xCA65).NFKD.list ~~ (0x110D, 0x1165, 0x11C0,), 'CA65 -> 110D 1165 11C0';
ok Uni.new(0xCA66).NFKD.list ~~ (0x110D, 0x1165, 0x11C1,), 'CA66 -> 110D 1165 11C1';
ok Uni.new(0xCA67).NFKD.list ~~ (0x110D, 0x1165, 0x11C2,), 'CA67 -> 110D 1165 11C2';
ok Uni.new(0xCA68).NFKD.list ~~ (0x110D, 0x1166,), 'CA68 -> 110D 1166';
ok Uni.new(0xCA69).NFKD.list ~~ (0x110D, 0x1166, 0x11A8,), 'CA69 -> 110D 1166 11A8';
ok Uni.new(0xCA6A).NFKD.list ~~ (0x110D, 0x1166, 0x11A9,), 'CA6A -> 110D 1166 11A9';
ok Uni.new(0xCA6B).NFKD.list ~~ (0x110D, 0x1166, 0x11AA,), 'CA6B -> 110D 1166 11AA';
ok Uni.new(0xCA6C).NFKD.list ~~ (0x110D, 0x1166, 0x11AB,), 'CA6C -> 110D 1166 11AB';
ok Uni.new(0xCA6D).NFKD.list ~~ (0x110D, 0x1166, 0x11AC,), 'CA6D -> 110D 1166 11AC';
ok Uni.new(0xCA6E).NFKD.list ~~ (0x110D, 0x1166, 0x11AD,), 'CA6E -> 110D 1166 11AD';
ok Uni.new(0xCA6F).NFKD.list ~~ (0x110D, 0x1166, 0x11AE,), 'CA6F -> 110D 1166 11AE';
ok Uni.new(0xCA70).NFKD.list ~~ (0x110D, 0x1166, 0x11AF,), 'CA70 -> 110D 1166 11AF';
ok Uni.new(0xCA71).NFKD.list ~~ (0x110D, 0x1166, 0x11B0,), 'CA71 -> 110D 1166 11B0';
ok Uni.new(0xCA72).NFKD.list ~~ (0x110D, 0x1166, 0x11B1,), 'CA72 -> 110D 1166 11B1';
ok Uni.new(0xCA73).NFKD.list ~~ (0x110D, 0x1166, 0x11B2,), 'CA73 -> 110D 1166 11B2';
ok Uni.new(0xCA74).NFKD.list ~~ (0x110D, 0x1166, 0x11B3,), 'CA74 -> 110D 1166 11B3';
ok Uni.new(0xCA75).NFKD.list ~~ (0x110D, 0x1166, 0x11B4,), 'CA75 -> 110D 1166 11B4';
ok Uni.new(0xCA76).NFKD.list ~~ (0x110D, 0x1166, 0x11B5,), 'CA76 -> 110D 1166 11B5';
ok Uni.new(0xCA77).NFKD.list ~~ (0x110D, 0x1166, 0x11B6,), 'CA77 -> 110D 1166 11B6';
ok Uni.new(0xCA78).NFKD.list ~~ (0x110D, 0x1166, 0x11B7,), 'CA78 -> 110D 1166 11B7';
ok Uni.new(0xCA79).NFKD.list ~~ (0x110D, 0x1166, 0x11B8,), 'CA79 -> 110D 1166 11B8';
ok Uni.new(0xCA7A).NFKD.list ~~ (0x110D, 0x1166, 0x11B9,), 'CA7A -> 110D 1166 11B9';
ok Uni.new(0xCA7B).NFKD.list ~~ (0x110D, 0x1166, 0x11BA,), 'CA7B -> 110D 1166 11BA';
ok Uni.new(0xCA7C).NFKD.list ~~ (0x110D, 0x1166, 0x11BB,), 'CA7C -> 110D 1166 11BB';
ok Uni.new(0xCA7D).NFKD.list ~~ (0x110D, 0x1166, 0x11BC,), 'CA7D -> 110D 1166 11BC';
ok Uni.new(0xCA7E).NFKD.list ~~ (0x110D, 0x1166, 0x11BD,), 'CA7E -> 110D 1166 11BD';
ok Uni.new(0xCA7F).NFKD.list ~~ (0x110D, 0x1166, 0x11BE,), 'CA7F -> 110D 1166 11BE';
ok Uni.new(0xCA80).NFKD.list ~~ (0x110D, 0x1166, 0x11BF,), 'CA80 -> 110D 1166 11BF';
ok Uni.new(0xCA81).NFKD.list ~~ (0x110D, 0x1166, 0x11C0,), 'CA81 -> 110D 1166 11C0';
ok Uni.new(0xCA82).NFKD.list ~~ (0x110D, 0x1166, 0x11C1,), 'CA82 -> 110D 1166 11C1';
ok Uni.new(0xCA83).NFKD.list ~~ (0x110D, 0x1166, 0x11C2,), 'CA83 -> 110D 1166 11C2';
ok Uni.new(0xCA84).NFKD.list ~~ (0x110D, 0x1167,), 'CA84 -> 110D 1167';
ok Uni.new(0xCA85).NFKD.list ~~ (0x110D, 0x1167, 0x11A8,), 'CA85 -> 110D 1167 11A8';
ok Uni.new(0xCA86).NFKD.list ~~ (0x110D, 0x1167, 0x11A9,), 'CA86 -> 110D 1167 11A9';
ok Uni.new(0xCA87).NFKD.list ~~ (0x110D, 0x1167, 0x11AA,), 'CA87 -> 110D 1167 11AA';
ok Uni.new(0xCA88).NFKD.list ~~ (0x110D, 0x1167, 0x11AB,), 'CA88 -> 110D 1167 11AB';
ok Uni.new(0xCA89).NFKD.list ~~ (0x110D, 0x1167, 0x11AC,), 'CA89 -> 110D 1167 11AC';
ok Uni.new(0xCA8A).NFKD.list ~~ (0x110D, 0x1167, 0x11AD,), 'CA8A -> 110D 1167 11AD';
ok Uni.new(0xCA8B).NFKD.list ~~ (0x110D, 0x1167, 0x11AE,), 'CA8B -> 110D 1167 11AE';
ok Uni.new(0xCA8C).NFKD.list ~~ (0x110D, 0x1167, 0x11AF,), 'CA8C -> 110D 1167 11AF';
ok Uni.new(0xCA8D).NFKD.list ~~ (0x110D, 0x1167, 0x11B0,), 'CA8D -> 110D 1167 11B0';
ok Uni.new(0xCA8E).NFKD.list ~~ (0x110D, 0x1167, 0x11B1,), 'CA8E -> 110D 1167 11B1';
ok Uni.new(0xCA8F).NFKD.list ~~ (0x110D, 0x1167, 0x11B2,), 'CA8F -> 110D 1167 11B2';
ok Uni.new(0xCA90).NFKD.list ~~ (0x110D, 0x1167, 0x11B3,), 'CA90 -> 110D 1167 11B3';
ok Uni.new(0xCA91).NFKD.list ~~ (0x110D, 0x1167, 0x11B4,), 'CA91 -> 110D 1167 11B4';
ok Uni.new(0xCA92).NFKD.list ~~ (0x110D, 0x1167, 0x11B5,), 'CA92 -> 110D 1167 11B5';
ok Uni.new(0xCA93).NFKD.list ~~ (0x110D, 0x1167, 0x11B6,), 'CA93 -> 110D 1167 11B6';
ok Uni.new(0xCA94).NFKD.list ~~ (0x110D, 0x1167, 0x11B7,), 'CA94 -> 110D 1167 11B7';
ok Uni.new(0xCA95).NFKD.list ~~ (0x110D, 0x1167, 0x11B8,), 'CA95 -> 110D 1167 11B8';
ok Uni.new(0xCA96).NFKD.list ~~ (0x110D, 0x1167, 0x11B9,), 'CA96 -> 110D 1167 11B9';
ok Uni.new(0xCA97).NFKD.list ~~ (0x110D, 0x1167, 0x11BA,), 'CA97 -> 110D 1167 11BA';
ok Uni.new(0xCA98).NFKD.list ~~ (0x110D, 0x1167, 0x11BB,), 'CA98 -> 110D 1167 11BB';
ok Uni.new(0xCA99).NFKD.list ~~ (0x110D, 0x1167, 0x11BC,), 'CA99 -> 110D 1167 11BC';
ok Uni.new(0xCA9A).NFKD.list ~~ (0x110D, 0x1167, 0x11BD,), 'CA9A -> 110D 1167 11BD';
ok Uni.new(0xCA9B).NFKD.list ~~ (0x110D, 0x1167, 0x11BE,), 'CA9B -> 110D 1167 11BE';
ok Uni.new(0xCA9C).NFKD.list ~~ (0x110D, 0x1167, 0x11BF,), 'CA9C -> 110D 1167 11BF';
ok Uni.new(0xCA9D).NFKD.list ~~ (0x110D, 0x1167, 0x11C0,), 'CA9D -> 110D 1167 11C0';
ok Uni.new(0xCA9E).NFKD.list ~~ (0x110D, 0x1167, 0x11C1,), 'CA9E -> 110D 1167 11C1';
ok Uni.new(0xCA9F).NFKD.list ~~ (0x110D, 0x1167, 0x11C2,), 'CA9F -> 110D 1167 11C2';
ok Uni.new(0xCAA0).NFKD.list ~~ (0x110D, 0x1168,), 'CAA0 -> 110D 1168';
ok Uni.new(0xCAA1).NFKD.list ~~ (0x110D, 0x1168, 0x11A8,), 'CAA1 -> 110D 1168 11A8';
ok Uni.new(0xCAA2).NFKD.list ~~ (0x110D, 0x1168, 0x11A9,), 'CAA2 -> 110D 1168 11A9';
ok Uni.new(0xCAA3).NFKD.list ~~ (0x110D, 0x1168, 0x11AA,), 'CAA3 -> 110D 1168 11AA';
ok Uni.new(0xCAA4).NFKD.list ~~ (0x110D, 0x1168, 0x11AB,), 'CAA4 -> 110D 1168 11AB';
ok Uni.new(0xCAA5).NFKD.list ~~ (0x110D, 0x1168, 0x11AC,), 'CAA5 -> 110D 1168 11AC';
ok Uni.new(0xCAA6).NFKD.list ~~ (0x110D, 0x1168, 0x11AD,), 'CAA6 -> 110D 1168 11AD';
ok Uni.new(0xCAA7).NFKD.list ~~ (0x110D, 0x1168, 0x11AE,), 'CAA7 -> 110D 1168 11AE';
ok Uni.new(0xCAA8).NFKD.list ~~ (0x110D, 0x1168, 0x11AF,), 'CAA8 -> 110D 1168 11AF';
ok Uni.new(0xCAA9).NFKD.list ~~ (0x110D, 0x1168, 0x11B0,), 'CAA9 -> 110D 1168 11B0';
ok Uni.new(0xCAAA).NFKD.list ~~ (0x110D, 0x1168, 0x11B1,), 'CAAA -> 110D 1168 11B1';
ok Uni.new(0xCAAB).NFKD.list ~~ (0x110D, 0x1168, 0x11B2,), 'CAAB -> 110D 1168 11B2';
ok Uni.new(0xCAAC).NFKD.list ~~ (0x110D, 0x1168, 0x11B3,), 'CAAC -> 110D 1168 11B3';
ok Uni.new(0xCAAD).NFKD.list ~~ (0x110D, 0x1168, 0x11B4,), 'CAAD -> 110D 1168 11B4';
ok Uni.new(0xCAAE).NFKD.list ~~ (0x110D, 0x1168, 0x11B5,), 'CAAE -> 110D 1168 11B5';
ok Uni.new(0xCAAF).NFKD.list ~~ (0x110D, 0x1168, 0x11B6,), 'CAAF -> 110D 1168 11B6';
ok Uni.new(0xCAB0).NFKD.list ~~ (0x110D, 0x1168, 0x11B7,), 'CAB0 -> 110D 1168 11B7';
ok Uni.new(0xCAB1).NFKD.list ~~ (0x110D, 0x1168, 0x11B8,), 'CAB1 -> 110D 1168 11B8';
ok Uni.new(0xCAB2).NFKD.list ~~ (0x110D, 0x1168, 0x11B9,), 'CAB2 -> 110D 1168 11B9';
ok Uni.new(0xCAB3).NFKD.list ~~ (0x110D, 0x1168, 0x11BA,), 'CAB3 -> 110D 1168 11BA';
ok Uni.new(0xCAB4).NFKD.list ~~ (0x110D, 0x1168, 0x11BB,), 'CAB4 -> 110D 1168 11BB';
ok Uni.new(0xCAB5).NFKD.list ~~ (0x110D, 0x1168, 0x11BC,), 'CAB5 -> 110D 1168 11BC';
ok Uni.new(0xCAB6).NFKD.list ~~ (0x110D, 0x1168, 0x11BD,), 'CAB6 -> 110D 1168 11BD';
ok Uni.new(0xCAB7).NFKD.list ~~ (0x110D, 0x1168, 0x11BE,), 'CAB7 -> 110D 1168 11BE';
ok Uni.new(0xCAB8).NFKD.list ~~ (0x110D, 0x1168, 0x11BF,), 'CAB8 -> 110D 1168 11BF';
ok Uni.new(0xCAB9).NFKD.list ~~ (0x110D, 0x1168, 0x11C0,), 'CAB9 -> 110D 1168 11C0';
ok Uni.new(0xCABA).NFKD.list ~~ (0x110D, 0x1168, 0x11C1,), 'CABA -> 110D 1168 11C1';
ok Uni.new(0xCABB).NFKD.list ~~ (0x110D, 0x1168, 0x11C2,), 'CABB -> 110D 1168 11C2';
ok Uni.new(0xCABC).NFKD.list ~~ (0x110D, 0x1169,), 'CABC -> 110D 1169';
ok Uni.new(0xCABD).NFKD.list ~~ (0x110D, 0x1169, 0x11A8,), 'CABD -> 110D 1169 11A8';
ok Uni.new(0xCABE).NFKD.list ~~ (0x110D, 0x1169, 0x11A9,), 'CABE -> 110D 1169 11A9';
ok Uni.new(0xCABF).NFKD.list ~~ (0x110D, 0x1169, 0x11AA,), 'CABF -> 110D 1169 11AA';
ok Uni.new(0xCAC0).NFKD.list ~~ (0x110D, 0x1169, 0x11AB,), 'CAC0 -> 110D 1169 11AB';
ok Uni.new(0xCAC1).NFKD.list ~~ (0x110D, 0x1169, 0x11AC,), 'CAC1 -> 110D 1169 11AC';
ok Uni.new(0xCAC2).NFKD.list ~~ (0x110D, 0x1169, 0x11AD,), 'CAC2 -> 110D 1169 11AD';
ok Uni.new(0xCAC3).NFKD.list ~~ (0x110D, 0x1169, 0x11AE,), 'CAC3 -> 110D 1169 11AE';
ok Uni.new(0xCAC4).NFKD.list ~~ (0x110D, 0x1169, 0x11AF,), 'CAC4 -> 110D 1169 11AF';
ok Uni.new(0xCAC5).NFKD.list ~~ (0x110D, 0x1169, 0x11B0,), 'CAC5 -> 110D 1169 11B0';
ok Uni.new(0xCAC6).NFKD.list ~~ (0x110D, 0x1169, 0x11B1,), 'CAC6 -> 110D 1169 11B1';
ok Uni.new(0xCAC7).NFKD.list ~~ (0x110D, 0x1169, 0x11B2,), 'CAC7 -> 110D 1169 11B2';
ok Uni.new(0xCAC8).NFKD.list ~~ (0x110D, 0x1169, 0x11B3,), 'CAC8 -> 110D 1169 11B3';
ok Uni.new(0xCAC9).NFKD.list ~~ (0x110D, 0x1169, 0x11B4,), 'CAC9 -> 110D 1169 11B4';
ok Uni.new(0xCACA).NFKD.list ~~ (0x110D, 0x1169, 0x11B5,), 'CACA -> 110D 1169 11B5';
ok Uni.new(0xCACB).NFKD.list ~~ (0x110D, 0x1169, 0x11B6,), 'CACB -> 110D 1169 11B6';
ok Uni.new(0xCACC).NFKD.list ~~ (0x110D, 0x1169, 0x11B7,), 'CACC -> 110D 1169 11B7';
ok Uni.new(0xCACD).NFKD.list ~~ (0x110D, 0x1169, 0x11B8,), 'CACD -> 110D 1169 11B8';
ok Uni.new(0xCACE).NFKD.list ~~ (0x110D, 0x1169, 0x11B9,), 'CACE -> 110D 1169 11B9';
ok Uni.new(0xCACF).NFKD.list ~~ (0x110D, 0x1169, 0x11BA,), 'CACF -> 110D 1169 11BA';
ok Uni.new(0xCAD0).NFKD.list ~~ (0x110D, 0x1169, 0x11BB,), 'CAD0 -> 110D 1169 11BB';
ok Uni.new(0xCAD1).NFKD.list ~~ (0x110D, 0x1169, 0x11BC,), 'CAD1 -> 110D 1169 11BC';
ok Uni.new(0xCAD2).NFKD.list ~~ (0x110D, 0x1169, 0x11BD,), 'CAD2 -> 110D 1169 11BD';
ok Uni.new(0xCAD3).NFKD.list ~~ (0x110D, 0x1169, 0x11BE,), 'CAD3 -> 110D 1169 11BE';
ok Uni.new(0xCAD4).NFKD.list ~~ (0x110D, 0x1169, 0x11BF,), 'CAD4 -> 110D 1169 11BF';
ok Uni.new(0xCAD5).NFKD.list ~~ (0x110D, 0x1169, 0x11C0,), 'CAD5 -> 110D 1169 11C0';
ok Uni.new(0xCAD6).NFKD.list ~~ (0x110D, 0x1169, 0x11C1,), 'CAD6 -> 110D 1169 11C1';
ok Uni.new(0xCAD7).NFKD.list ~~ (0x110D, 0x1169, 0x11C2,), 'CAD7 -> 110D 1169 11C2';
ok Uni.new(0xCAD8).NFKD.list ~~ (0x110D, 0x116A,), 'CAD8 -> 110D 116A';
ok Uni.new(0xCAD9).NFKD.list ~~ (0x110D, 0x116A, 0x11A8,), 'CAD9 -> 110D 116A 11A8';
ok Uni.new(0xCADA).NFKD.list ~~ (0x110D, 0x116A, 0x11A9,), 'CADA -> 110D 116A 11A9';
ok Uni.new(0xCADB).NFKD.list ~~ (0x110D, 0x116A, 0x11AA,), 'CADB -> 110D 116A 11AA';
ok Uni.new(0xCADC).NFKD.list ~~ (0x110D, 0x116A, 0x11AB,), 'CADC -> 110D 116A 11AB';
ok Uni.new(0xCADD).NFKD.list ~~ (0x110D, 0x116A, 0x11AC,), 'CADD -> 110D 116A 11AC';
ok Uni.new(0xCADE).NFKD.list ~~ (0x110D, 0x116A, 0x11AD,), 'CADE -> 110D 116A 11AD';
ok Uni.new(0xCADF).NFKD.list ~~ (0x110D, 0x116A, 0x11AE,), 'CADF -> 110D 116A 11AE';
ok Uni.new(0xCAE0).NFKD.list ~~ (0x110D, 0x116A, 0x11AF,), 'CAE0 -> 110D 116A 11AF';
ok Uni.new(0xCAE1).NFKD.list ~~ (0x110D, 0x116A, 0x11B0,), 'CAE1 -> 110D 116A 11B0';
ok Uni.new(0xCAE2).NFKD.list ~~ (0x110D, 0x116A, 0x11B1,), 'CAE2 -> 110D 116A 11B1';
ok Uni.new(0xCAE3).NFKD.list ~~ (0x110D, 0x116A, 0x11B2,), 'CAE3 -> 110D 116A 11B2';
ok Uni.new(0xCAE4).NFKD.list ~~ (0x110D, 0x116A, 0x11B3,), 'CAE4 -> 110D 116A 11B3';
ok Uni.new(0xCAE5).NFKD.list ~~ (0x110D, 0x116A, 0x11B4,), 'CAE5 -> 110D 116A 11B4';
ok Uni.new(0xCAE6).NFKD.list ~~ (0x110D, 0x116A, 0x11B5,), 'CAE6 -> 110D 116A 11B5';
ok Uni.new(0xCAE7).NFKD.list ~~ (0x110D, 0x116A, 0x11B6,), 'CAE7 -> 110D 116A 11B6';
ok Uni.new(0xCAE8).NFKD.list ~~ (0x110D, 0x116A, 0x11B7,), 'CAE8 -> 110D 116A 11B7';
ok Uni.new(0xCAE9).NFKD.list ~~ (0x110D, 0x116A, 0x11B8,), 'CAE9 -> 110D 116A 11B8';
ok Uni.new(0xCAEA).NFKD.list ~~ (0x110D, 0x116A, 0x11B9,), 'CAEA -> 110D 116A 11B9';
ok Uni.new(0xCAEB).NFKD.list ~~ (0x110D, 0x116A, 0x11BA,), 'CAEB -> 110D 116A 11BA';
ok Uni.new(0xCAEC).NFKD.list ~~ (0x110D, 0x116A, 0x11BB,), 'CAEC -> 110D 116A 11BB';
ok Uni.new(0xCAED).NFKD.list ~~ (0x110D, 0x116A, 0x11BC,), 'CAED -> 110D 116A 11BC';
ok Uni.new(0xCAEE).NFKD.list ~~ (0x110D, 0x116A, 0x11BD,), 'CAEE -> 110D 116A 11BD';
ok Uni.new(0xCAEF).NFKD.list ~~ (0x110D, 0x116A, 0x11BE,), 'CAEF -> 110D 116A 11BE';
ok Uni.new(0xCAF0).NFKD.list ~~ (0x110D, 0x116A, 0x11BF,), 'CAF0 -> 110D 116A 11BF';
ok Uni.new(0xCAF1).NFKD.list ~~ (0x110D, 0x116A, 0x11C0,), 'CAF1 -> 110D 116A 11C0';
ok Uni.new(0xCAF2).NFKD.list ~~ (0x110D, 0x116A, 0x11C1,), 'CAF2 -> 110D 116A 11C1';
ok Uni.new(0xCAF3).NFKD.list ~~ (0x110D, 0x116A, 0x11C2,), 'CAF3 -> 110D 116A 11C2';
ok Uni.new(0xCAF4).NFKD.list ~~ (0x110D, 0x116B,), 'CAF4 -> 110D 116B';
ok Uni.new(0xCAF5).NFKD.list ~~ (0x110D, 0x116B, 0x11A8,), 'CAF5 -> 110D 116B 11A8';
ok Uni.new(0xCAF6).NFKD.list ~~ (0x110D, 0x116B, 0x11A9,), 'CAF6 -> 110D 116B 11A9';
ok Uni.new(0xCAF7).NFKD.list ~~ (0x110D, 0x116B, 0x11AA,), 'CAF7 -> 110D 116B 11AA';
ok Uni.new(0xCAF8).NFKD.list ~~ (0x110D, 0x116B, 0x11AB,), 'CAF8 -> 110D 116B 11AB';
ok Uni.new(0xCAF9).NFKD.list ~~ (0x110D, 0x116B, 0x11AC,), 'CAF9 -> 110D 116B 11AC';
ok Uni.new(0xCAFA).NFKD.list ~~ (0x110D, 0x116B, 0x11AD,), 'CAFA -> 110D 116B 11AD';
ok Uni.new(0xCAFB).NFKD.list ~~ (0x110D, 0x116B, 0x11AE,), 'CAFB -> 110D 116B 11AE';
ok Uni.new(0xCAFC).NFKD.list ~~ (0x110D, 0x116B, 0x11AF,), 'CAFC -> 110D 116B 11AF';
ok Uni.new(0xCAFD).NFKD.list ~~ (0x110D, 0x116B, 0x11B0,), 'CAFD -> 110D 116B 11B0';
ok Uni.new(0xCAFE).NFKD.list ~~ (0x110D, 0x116B, 0x11B1,), 'CAFE -> 110D 116B 11B1';
ok Uni.new(0xCAFF).NFKD.list ~~ (0x110D, 0x116B, 0x11B2,), 'CAFF -> 110D 116B 11B2';
ok Uni.new(0xCB00).NFKD.list ~~ (0x110D, 0x116B, 0x11B3,), 'CB00 -> 110D 116B 11B3';
ok Uni.new(0xCB01).NFKD.list ~~ (0x110D, 0x116B, 0x11B4,), 'CB01 -> 110D 116B 11B4';
ok Uni.new(0xCB02).NFKD.list ~~ (0x110D, 0x116B, 0x11B5,), 'CB02 -> 110D 116B 11B5';
ok Uni.new(0xCB03).NFKD.list ~~ (0x110D, 0x116B, 0x11B6,), 'CB03 -> 110D 116B 11B6';
ok Uni.new(0xCB04).NFKD.list ~~ (0x110D, 0x116B, 0x11B7,), 'CB04 -> 110D 116B 11B7';
ok Uni.new(0xCB05).NFKD.list ~~ (0x110D, 0x116B, 0x11B8,), 'CB05 -> 110D 116B 11B8';
ok Uni.new(0xCB06).NFKD.list ~~ (0x110D, 0x116B, 0x11B9,), 'CB06 -> 110D 116B 11B9';
ok Uni.new(0xCB07).NFKD.list ~~ (0x110D, 0x116B, 0x11BA,), 'CB07 -> 110D 116B 11BA';
ok Uni.new(0xCB08).NFKD.list ~~ (0x110D, 0x116B, 0x11BB,), 'CB08 -> 110D 116B 11BB';
ok Uni.new(0xCB09).NFKD.list ~~ (0x110D, 0x116B, 0x11BC,), 'CB09 -> 110D 116B 11BC';
ok Uni.new(0xCB0A).NFKD.list ~~ (0x110D, 0x116B, 0x11BD,), 'CB0A -> 110D 116B 11BD';
ok Uni.new(0xCB0B).NFKD.list ~~ (0x110D, 0x116B, 0x11BE,), 'CB0B -> 110D 116B 11BE';
ok Uni.new(0xCB0C).NFKD.list ~~ (0x110D, 0x116B, 0x11BF,), 'CB0C -> 110D 116B 11BF';
ok Uni.new(0xCB0D).NFKD.list ~~ (0x110D, 0x116B, 0x11C0,), 'CB0D -> 110D 116B 11C0';
ok Uni.new(0xCB0E).NFKD.list ~~ (0x110D, 0x116B, 0x11C1,), 'CB0E -> 110D 116B 11C1';
ok Uni.new(0xCB0F).NFKD.list ~~ (0x110D, 0x116B, 0x11C2,), 'CB0F -> 110D 116B 11C2';
ok Uni.new(0xCB10).NFKD.list ~~ (0x110D, 0x116C,), 'CB10 -> 110D 116C';
ok Uni.new(0xCB11).NFKD.list ~~ (0x110D, 0x116C, 0x11A8,), 'CB11 -> 110D 116C 11A8';
ok Uni.new(0xCB12).NFKD.list ~~ (0x110D, 0x116C, 0x11A9,), 'CB12 -> 110D 116C 11A9';
ok Uni.new(0xCB13).NFKD.list ~~ (0x110D, 0x116C, 0x11AA,), 'CB13 -> 110D 116C 11AA';
ok Uni.new(0xCB14).NFKD.list ~~ (0x110D, 0x116C, 0x11AB,), 'CB14 -> 110D 116C 11AB';
ok Uni.new(0xCB15).NFKD.list ~~ (0x110D, 0x116C, 0x11AC,), 'CB15 -> 110D 116C 11AC';
ok Uni.new(0xCB16).NFKD.list ~~ (0x110D, 0x116C, 0x11AD,), 'CB16 -> 110D 116C 11AD';
ok Uni.new(0xCB17).NFKD.list ~~ (0x110D, 0x116C, 0x11AE,), 'CB17 -> 110D 116C 11AE';
ok Uni.new(0xCB18).NFKD.list ~~ (0x110D, 0x116C, 0x11AF,), 'CB18 -> 110D 116C 11AF';
ok Uni.new(0xCB19).NFKD.list ~~ (0x110D, 0x116C, 0x11B0,), 'CB19 -> 110D 116C 11B0';
ok Uni.new(0xCB1A).NFKD.list ~~ (0x110D, 0x116C, 0x11B1,), 'CB1A -> 110D 116C 11B1';
ok Uni.new(0xCB1B).NFKD.list ~~ (0x110D, 0x116C, 0x11B2,), 'CB1B -> 110D 116C 11B2';
ok Uni.new(0xCB1C).NFKD.list ~~ (0x110D, 0x116C, 0x11B3,), 'CB1C -> 110D 116C 11B3';
ok Uni.new(0xCB1D).NFKD.list ~~ (0x110D, 0x116C, 0x11B4,), 'CB1D -> 110D 116C 11B4';
ok Uni.new(0xCB1E).NFKD.list ~~ (0x110D, 0x116C, 0x11B5,), 'CB1E -> 110D 116C 11B5';
ok Uni.new(0xCB1F).NFKD.list ~~ (0x110D, 0x116C, 0x11B6,), 'CB1F -> 110D 116C 11B6';
ok Uni.new(0xCB20).NFKD.list ~~ (0x110D, 0x116C, 0x11B7,), 'CB20 -> 110D 116C 11B7';
ok Uni.new(0xCB21).NFKD.list ~~ (0x110D, 0x116C, 0x11B8,), 'CB21 -> 110D 116C 11B8';
ok Uni.new(0xCB22).NFKD.list ~~ (0x110D, 0x116C, 0x11B9,), 'CB22 -> 110D 116C 11B9';
ok Uni.new(0xCB23).NFKD.list ~~ (0x110D, 0x116C, 0x11BA,), 'CB23 -> 110D 116C 11BA';
ok Uni.new(0xCB24).NFKD.list ~~ (0x110D, 0x116C, 0x11BB,), 'CB24 -> 110D 116C 11BB';
ok Uni.new(0xCB25).NFKD.list ~~ (0x110D, 0x116C, 0x11BC,), 'CB25 -> 110D 116C 11BC';
ok Uni.new(0xCB26).NFKD.list ~~ (0x110D, 0x116C, 0x11BD,), 'CB26 -> 110D 116C 11BD';
ok Uni.new(0xCB27).NFKD.list ~~ (0x110D, 0x116C, 0x11BE,), 'CB27 -> 110D 116C 11BE';
ok Uni.new(0xCB28).NFKD.list ~~ (0x110D, 0x116C, 0x11BF,), 'CB28 -> 110D 116C 11BF';
ok Uni.new(0xCB29).NFKD.list ~~ (0x110D, 0x116C, 0x11C0,), 'CB29 -> 110D 116C 11C0';
ok Uni.new(0xCB2A).NFKD.list ~~ (0x110D, 0x116C, 0x11C1,), 'CB2A -> 110D 116C 11C1';
ok Uni.new(0xCB2B).NFKD.list ~~ (0x110D, 0x116C, 0x11C2,), 'CB2B -> 110D 116C 11C2';
ok Uni.new(0xCB2C).NFKD.list ~~ (0x110D, 0x116D,), 'CB2C -> 110D 116D';
ok Uni.new(0xCB2D).NFKD.list ~~ (0x110D, 0x116D, 0x11A8,), 'CB2D -> 110D 116D 11A8';
ok Uni.new(0xCB2E).NFKD.list ~~ (0x110D, 0x116D, 0x11A9,), 'CB2E -> 110D 116D 11A9';
ok Uni.new(0xCB2F).NFKD.list ~~ (0x110D, 0x116D, 0x11AA,), 'CB2F -> 110D 116D 11AA';
ok Uni.new(0xCB30).NFKD.list ~~ (0x110D, 0x116D, 0x11AB,), 'CB30 -> 110D 116D 11AB';
ok Uni.new(0xCB31).NFKD.list ~~ (0x110D, 0x116D, 0x11AC,), 'CB31 -> 110D 116D 11AC';
ok Uni.new(0xCB32).NFKD.list ~~ (0x110D, 0x116D, 0x11AD,), 'CB32 -> 110D 116D 11AD';
ok Uni.new(0xCB33).NFKD.list ~~ (0x110D, 0x116D, 0x11AE,), 'CB33 -> 110D 116D 11AE';
ok Uni.new(0xCB34).NFKD.list ~~ (0x110D, 0x116D, 0x11AF,), 'CB34 -> 110D 116D 11AF';
ok Uni.new(0xCB35).NFKD.list ~~ (0x110D, 0x116D, 0x11B0,), 'CB35 -> 110D 116D 11B0';
ok Uni.new(0xCB36).NFKD.list ~~ (0x110D, 0x116D, 0x11B1,), 'CB36 -> 110D 116D 11B1';
ok Uni.new(0xCB37).NFKD.list ~~ (0x110D, 0x116D, 0x11B2,), 'CB37 -> 110D 116D 11B2';
ok Uni.new(0xCB38).NFKD.list ~~ (0x110D, 0x116D, 0x11B3,), 'CB38 -> 110D 116D 11B3';
ok Uni.new(0xCB39).NFKD.list ~~ (0x110D, 0x116D, 0x11B4,), 'CB39 -> 110D 116D 11B4';
ok Uni.new(0xCB3A).NFKD.list ~~ (0x110D, 0x116D, 0x11B5,), 'CB3A -> 110D 116D 11B5';
ok Uni.new(0xCB3B).NFKD.list ~~ (0x110D, 0x116D, 0x11B6,), 'CB3B -> 110D 116D 11B6';
ok Uni.new(0xCB3C).NFKD.list ~~ (0x110D, 0x116D, 0x11B7,), 'CB3C -> 110D 116D 11B7';
ok Uni.new(0xCB3D).NFKD.list ~~ (0x110D, 0x116D, 0x11B8,), 'CB3D -> 110D 116D 11B8';
ok Uni.new(0xCB3E).NFKD.list ~~ (0x110D, 0x116D, 0x11B9,), 'CB3E -> 110D 116D 11B9';
ok Uni.new(0xCB3F).NFKD.list ~~ (0x110D, 0x116D, 0x11BA,), 'CB3F -> 110D 116D 11BA';
ok Uni.new(0xCB40).NFKD.list ~~ (0x110D, 0x116D, 0x11BB,), 'CB40 -> 110D 116D 11BB';
ok Uni.new(0xCB41).NFKD.list ~~ (0x110D, 0x116D, 0x11BC,), 'CB41 -> 110D 116D 11BC';
ok Uni.new(0xCB42).NFKD.list ~~ (0x110D, 0x116D, 0x11BD,), 'CB42 -> 110D 116D 11BD';
ok Uni.new(0xCB43).NFKD.list ~~ (0x110D, 0x116D, 0x11BE,), 'CB43 -> 110D 116D 11BE';
ok Uni.new(0xCB44).NFKD.list ~~ (0x110D, 0x116D, 0x11BF,), 'CB44 -> 110D 116D 11BF';
ok Uni.new(0xCB45).NFKD.list ~~ (0x110D, 0x116D, 0x11C0,), 'CB45 -> 110D 116D 11C0';
ok Uni.new(0xCB46).NFKD.list ~~ (0x110D, 0x116D, 0x11C1,), 'CB46 -> 110D 116D 11C1';
ok Uni.new(0xCB47).NFKD.list ~~ (0x110D, 0x116D, 0x11C2,), 'CB47 -> 110D 116D 11C2';
ok Uni.new(0xCB48).NFKD.list ~~ (0x110D, 0x116E,), 'CB48 -> 110D 116E';
ok Uni.new(0xCB49).NFKD.list ~~ (0x110D, 0x116E, 0x11A8,), 'CB49 -> 110D 116E 11A8';
ok Uni.new(0xCB4A).NFKD.list ~~ (0x110D, 0x116E, 0x11A9,), 'CB4A -> 110D 116E 11A9';
ok Uni.new(0xCB4B).NFKD.list ~~ (0x110D, 0x116E, 0x11AA,), 'CB4B -> 110D 116E 11AA';
ok Uni.new(0xCB4C).NFKD.list ~~ (0x110D, 0x116E, 0x11AB,), 'CB4C -> 110D 116E 11AB';
ok Uni.new(0xCB4D).NFKD.list ~~ (0x110D, 0x116E, 0x11AC,), 'CB4D -> 110D 116E 11AC';
ok Uni.new(0xCB4E).NFKD.list ~~ (0x110D, 0x116E, 0x11AD,), 'CB4E -> 110D 116E 11AD';
ok Uni.new(0xCB4F).NFKD.list ~~ (0x110D, 0x116E, 0x11AE,), 'CB4F -> 110D 116E 11AE';
ok Uni.new(0xCB50).NFKD.list ~~ (0x110D, 0x116E, 0x11AF,), 'CB50 -> 110D 116E 11AF';
ok Uni.new(0xCB51).NFKD.list ~~ (0x110D, 0x116E, 0x11B0,), 'CB51 -> 110D 116E 11B0';
ok Uni.new(0xCB52).NFKD.list ~~ (0x110D, 0x116E, 0x11B1,), 'CB52 -> 110D 116E 11B1';
ok Uni.new(0xCB53).NFKD.list ~~ (0x110D, 0x116E, 0x11B2,), 'CB53 -> 110D 116E 11B2';
ok Uni.new(0xCB54).NFKD.list ~~ (0x110D, 0x116E, 0x11B3,), 'CB54 -> 110D 116E 11B3';
ok Uni.new(0xCB55).NFKD.list ~~ (0x110D, 0x116E, 0x11B4,), 'CB55 -> 110D 116E 11B4';
ok Uni.new(0xCB56).NFKD.list ~~ (0x110D, 0x116E, 0x11B5,), 'CB56 -> 110D 116E 11B5';
ok Uni.new(0xCB57).NFKD.list ~~ (0x110D, 0x116E, 0x11B6,), 'CB57 -> 110D 116E 11B6';
ok Uni.new(0xCB58).NFKD.list ~~ (0x110D, 0x116E, 0x11B7,), 'CB58 -> 110D 116E 11B7';
ok Uni.new(0xCB59).NFKD.list ~~ (0x110D, 0x116E, 0x11B8,), 'CB59 -> 110D 116E 11B8';
ok Uni.new(0xCB5A).NFKD.list ~~ (0x110D, 0x116E, 0x11B9,), 'CB5A -> 110D 116E 11B9';
ok Uni.new(0xCB5B).NFKD.list ~~ (0x110D, 0x116E, 0x11BA,), 'CB5B -> 110D 116E 11BA';
ok Uni.new(0xCB5C).NFKD.list ~~ (0x110D, 0x116E, 0x11BB,), 'CB5C -> 110D 116E 11BB';
ok Uni.new(0xCB5D).NFKD.list ~~ (0x110D, 0x116E, 0x11BC,), 'CB5D -> 110D 116E 11BC';
ok Uni.new(0xCB5E).NFKD.list ~~ (0x110D, 0x116E, 0x11BD,), 'CB5E -> 110D 116E 11BD';
ok Uni.new(0xCB5F).NFKD.list ~~ (0x110D, 0x116E, 0x11BE,), 'CB5F -> 110D 116E 11BE';
ok Uni.new(0xCB60).NFKD.list ~~ (0x110D, 0x116E, 0x11BF,), 'CB60 -> 110D 116E 11BF';
ok Uni.new(0xCB61).NFKD.list ~~ (0x110D, 0x116E, 0x11C0,), 'CB61 -> 110D 116E 11C0';
ok Uni.new(0xCB62).NFKD.list ~~ (0x110D, 0x116E, 0x11C1,), 'CB62 -> 110D 116E 11C1';
ok Uni.new(0xCB63).NFKD.list ~~ (0x110D, 0x116E, 0x11C2,), 'CB63 -> 110D 116E 11C2';
ok Uni.new(0xCB64).NFKD.list ~~ (0x110D, 0x116F,), 'CB64 -> 110D 116F';
ok Uni.new(0xCB65).NFKD.list ~~ (0x110D, 0x116F, 0x11A8,), 'CB65 -> 110D 116F 11A8';
ok Uni.new(0xCB66).NFKD.list ~~ (0x110D, 0x116F, 0x11A9,), 'CB66 -> 110D 116F 11A9';
ok Uni.new(0xCB67).NFKD.list ~~ (0x110D, 0x116F, 0x11AA,), 'CB67 -> 110D 116F 11AA';
ok Uni.new(0xCB68).NFKD.list ~~ (0x110D, 0x116F, 0x11AB,), 'CB68 -> 110D 116F 11AB';
ok Uni.new(0xCB69).NFKD.list ~~ (0x110D, 0x116F, 0x11AC,), 'CB69 -> 110D 116F 11AC';
ok Uni.new(0xCB6A).NFKD.list ~~ (0x110D, 0x116F, 0x11AD,), 'CB6A -> 110D 116F 11AD';
ok Uni.new(0xCB6B).NFKD.list ~~ (0x110D, 0x116F, 0x11AE,), 'CB6B -> 110D 116F 11AE';
ok Uni.new(0xCB6C).NFKD.list ~~ (0x110D, 0x116F, 0x11AF,), 'CB6C -> 110D 116F 11AF';
ok Uni.new(0xCB6D).NFKD.list ~~ (0x110D, 0x116F, 0x11B0,), 'CB6D -> 110D 116F 11B0';
ok Uni.new(0xCB6E).NFKD.list ~~ (0x110D, 0x116F, 0x11B1,), 'CB6E -> 110D 116F 11B1';
ok Uni.new(0xCB6F).NFKD.list ~~ (0x110D, 0x116F, 0x11B2,), 'CB6F -> 110D 116F 11B2';
ok Uni.new(0xCB70).NFKD.list ~~ (0x110D, 0x116F, 0x11B3,), 'CB70 -> 110D 116F 11B3';
ok Uni.new(0xCB71).NFKD.list ~~ (0x110D, 0x116F, 0x11B4,), 'CB71 -> 110D 116F 11B4';
ok Uni.new(0xCB72).NFKD.list ~~ (0x110D, 0x116F, 0x11B5,), 'CB72 -> 110D 116F 11B5';
ok Uni.new(0xCB73).NFKD.list ~~ (0x110D, 0x116F, 0x11B6,), 'CB73 -> 110D 116F 11B6';
ok Uni.new(0xCB74).NFKD.list ~~ (0x110D, 0x116F, 0x11B7,), 'CB74 -> 110D 116F 11B7';
ok Uni.new(0xCB75).NFKD.list ~~ (0x110D, 0x116F, 0x11B8,), 'CB75 -> 110D 116F 11B8';
ok Uni.new(0xCB76).NFKD.list ~~ (0x110D, 0x116F, 0x11B9,), 'CB76 -> 110D 116F 11B9';
ok Uni.new(0xCB77).NFKD.list ~~ (0x110D, 0x116F, 0x11BA,), 'CB77 -> 110D 116F 11BA';
ok Uni.new(0xCB78).NFKD.list ~~ (0x110D, 0x116F, 0x11BB,), 'CB78 -> 110D 116F 11BB';
ok Uni.new(0xCB79).NFKD.list ~~ (0x110D, 0x116F, 0x11BC,), 'CB79 -> 110D 116F 11BC';
ok Uni.new(0xCB7A).NFKD.list ~~ (0x110D, 0x116F, 0x11BD,), 'CB7A -> 110D 116F 11BD';
ok Uni.new(0xCB7B).NFKD.list ~~ (0x110D, 0x116F, 0x11BE,), 'CB7B -> 110D 116F 11BE';
ok Uni.new(0xCB7C).NFKD.list ~~ (0x110D, 0x116F, 0x11BF,), 'CB7C -> 110D 116F 11BF';
ok Uni.new(0xCB7D).NFKD.list ~~ (0x110D, 0x116F, 0x11C0,), 'CB7D -> 110D 116F 11C0';
ok Uni.new(0xCB7E).NFKD.list ~~ (0x110D, 0x116F, 0x11C1,), 'CB7E -> 110D 116F 11C1';
ok Uni.new(0xCB7F).NFKD.list ~~ (0x110D, 0x116F, 0x11C2,), 'CB7F -> 110D 116F 11C2';
ok Uni.new(0xCB80).NFKD.list ~~ (0x110D, 0x1170,), 'CB80 -> 110D 1170';
ok Uni.new(0xCB81).NFKD.list ~~ (0x110D, 0x1170, 0x11A8,), 'CB81 -> 110D 1170 11A8';
ok Uni.new(0xCB82).NFKD.list ~~ (0x110D, 0x1170, 0x11A9,), 'CB82 -> 110D 1170 11A9';
ok Uni.new(0xCB83).NFKD.list ~~ (0x110D, 0x1170, 0x11AA,), 'CB83 -> 110D 1170 11AA';
ok Uni.new(0xCB84).NFKD.list ~~ (0x110D, 0x1170, 0x11AB,), 'CB84 -> 110D 1170 11AB';
ok Uni.new(0xCB85).NFKD.list ~~ (0x110D, 0x1170, 0x11AC,), 'CB85 -> 110D 1170 11AC';
ok Uni.new(0xCB86).NFKD.list ~~ (0x110D, 0x1170, 0x11AD,), 'CB86 -> 110D 1170 11AD';
ok Uni.new(0xCB87).NFKD.list ~~ (0x110D, 0x1170, 0x11AE,), 'CB87 -> 110D 1170 11AE';
ok Uni.new(0xCB88).NFKD.list ~~ (0x110D, 0x1170, 0x11AF,), 'CB88 -> 110D 1170 11AF';
ok Uni.new(0xCB89).NFKD.list ~~ (0x110D, 0x1170, 0x11B0,), 'CB89 -> 110D 1170 11B0';
ok Uni.new(0xCB8A).NFKD.list ~~ (0x110D, 0x1170, 0x11B1,), 'CB8A -> 110D 1170 11B1';
ok Uni.new(0xCB8B).NFKD.list ~~ (0x110D, 0x1170, 0x11B2,), 'CB8B -> 110D 1170 11B2';
ok Uni.new(0xCB8C).NFKD.list ~~ (0x110D, 0x1170, 0x11B3,), 'CB8C -> 110D 1170 11B3';
ok Uni.new(0xCB8D).NFKD.list ~~ (0x110D, 0x1170, 0x11B4,), 'CB8D -> 110D 1170 11B4';
ok Uni.new(0xCB8E).NFKD.list ~~ (0x110D, 0x1170, 0x11B5,), 'CB8E -> 110D 1170 11B5';
ok Uni.new(0xCB8F).NFKD.list ~~ (0x110D, 0x1170, 0x11B6,), 'CB8F -> 110D 1170 11B6';
ok Uni.new(0xCB90).NFKD.list ~~ (0x110D, 0x1170, 0x11B7,), 'CB90 -> 110D 1170 11B7';
ok Uni.new(0xCB91).NFKD.list ~~ (0x110D, 0x1170, 0x11B8,), 'CB91 -> 110D 1170 11B8';
ok Uni.new(0xCB92).NFKD.list ~~ (0x110D, 0x1170, 0x11B9,), 'CB92 -> 110D 1170 11B9';
ok Uni.new(0xCB93).NFKD.list ~~ (0x110D, 0x1170, 0x11BA,), 'CB93 -> 110D 1170 11BA';
ok Uni.new(0xCB94).NFKD.list ~~ (0x110D, 0x1170, 0x11BB,), 'CB94 -> 110D 1170 11BB';
ok Uni.new(0xCB95).NFKD.list ~~ (0x110D, 0x1170, 0x11BC,), 'CB95 -> 110D 1170 11BC';
ok Uni.new(0xCB96).NFKD.list ~~ (0x110D, 0x1170, 0x11BD,), 'CB96 -> 110D 1170 11BD';
ok Uni.new(0xCB97).NFKD.list ~~ (0x110D, 0x1170, 0x11BE,), 'CB97 -> 110D 1170 11BE';
ok Uni.new(0xCB98).NFKD.list ~~ (0x110D, 0x1170, 0x11BF,), 'CB98 -> 110D 1170 11BF';
ok Uni.new(0xCB99).NFKD.list ~~ (0x110D, 0x1170, 0x11C0,), 'CB99 -> 110D 1170 11C0';
ok Uni.new(0xCB9A).NFKD.list ~~ (0x110D, 0x1170, 0x11C1,), 'CB9A -> 110D 1170 11C1';
ok Uni.new(0xCB9B).NFKD.list ~~ (0x110D, 0x1170, 0x11C2,), 'CB9B -> 110D 1170 11C2';
ok Uni.new(0xCB9C).NFKD.list ~~ (0x110D, 0x1171,), 'CB9C -> 110D 1171';
ok Uni.new(0xCB9D).NFKD.list ~~ (0x110D, 0x1171, 0x11A8,), 'CB9D -> 110D 1171 11A8';
ok Uni.new(0xCB9E).NFKD.list ~~ (0x110D, 0x1171, 0x11A9,), 'CB9E -> 110D 1171 11A9';
ok Uni.new(0xCB9F).NFKD.list ~~ (0x110D, 0x1171, 0x11AA,), 'CB9F -> 110D 1171 11AA';
ok Uni.new(0xCBA0).NFKD.list ~~ (0x110D, 0x1171, 0x11AB,), 'CBA0 -> 110D 1171 11AB';
ok Uni.new(0xCBA1).NFKD.list ~~ (0x110D, 0x1171, 0x11AC,), 'CBA1 -> 110D 1171 11AC';
ok Uni.new(0xCBA2).NFKD.list ~~ (0x110D, 0x1171, 0x11AD,), 'CBA2 -> 110D 1171 11AD';
ok Uni.new(0xCBA3).NFKD.list ~~ (0x110D, 0x1171, 0x11AE,), 'CBA3 -> 110D 1171 11AE';
ok Uni.new(0xCBA4).NFKD.list ~~ (0x110D, 0x1171, 0x11AF,), 'CBA4 -> 110D 1171 11AF';
ok Uni.new(0xCBA5).NFKD.list ~~ (0x110D, 0x1171, 0x11B0,), 'CBA5 -> 110D 1171 11B0';
ok Uni.new(0xCBA6).NFKD.list ~~ (0x110D, 0x1171, 0x11B1,), 'CBA6 -> 110D 1171 11B1';
ok Uni.new(0xCBA7).NFKD.list ~~ (0x110D, 0x1171, 0x11B2,), 'CBA7 -> 110D 1171 11B2';
ok Uni.new(0xCBA8).NFKD.list ~~ (0x110D, 0x1171, 0x11B3,), 'CBA8 -> 110D 1171 11B3';
ok Uni.new(0xCBA9).NFKD.list ~~ (0x110D, 0x1171, 0x11B4,), 'CBA9 -> 110D 1171 11B4';
ok Uni.new(0xCBAA).NFKD.list ~~ (0x110D, 0x1171, 0x11B5,), 'CBAA -> 110D 1171 11B5';
ok Uni.new(0xCBAB).NFKD.list ~~ (0x110D, 0x1171, 0x11B6,), 'CBAB -> 110D 1171 11B6';
ok Uni.new(0xCBAC).NFKD.list ~~ (0x110D, 0x1171, 0x11B7,), 'CBAC -> 110D 1171 11B7';
ok Uni.new(0xCBAD).NFKD.list ~~ (0x110D, 0x1171, 0x11B8,), 'CBAD -> 110D 1171 11B8';
ok Uni.new(0xCBAE).NFKD.list ~~ (0x110D, 0x1171, 0x11B9,), 'CBAE -> 110D 1171 11B9';
ok Uni.new(0xCBAF).NFKD.list ~~ (0x110D, 0x1171, 0x11BA,), 'CBAF -> 110D 1171 11BA';
ok Uni.new(0xCBB0).NFKD.list ~~ (0x110D, 0x1171, 0x11BB,), 'CBB0 -> 110D 1171 11BB';
ok Uni.new(0xCBB1).NFKD.list ~~ (0x110D, 0x1171, 0x11BC,), 'CBB1 -> 110D 1171 11BC';
ok Uni.new(0xCBB2).NFKD.list ~~ (0x110D, 0x1171, 0x11BD,), 'CBB2 -> 110D 1171 11BD';
ok Uni.new(0xCBB3).NFKD.list ~~ (0x110D, 0x1171, 0x11BE,), 'CBB3 -> 110D 1171 11BE';
ok Uni.new(0xCBB4).NFKD.list ~~ (0x110D, 0x1171, 0x11BF,), 'CBB4 -> 110D 1171 11BF';
ok Uni.new(0xCBB5).NFKD.list ~~ (0x110D, 0x1171, 0x11C0,), 'CBB5 -> 110D 1171 11C0';
ok Uni.new(0xCBB6).NFKD.list ~~ (0x110D, 0x1171, 0x11C1,), 'CBB6 -> 110D 1171 11C1';
ok Uni.new(0xCBB7).NFKD.list ~~ (0x110D, 0x1171, 0x11C2,), 'CBB7 -> 110D 1171 11C2';
ok Uni.new(0xCBB8).NFKD.list ~~ (0x110D, 0x1172,), 'CBB8 -> 110D 1172';
ok Uni.new(0xCBB9).NFKD.list ~~ (0x110D, 0x1172, 0x11A8,), 'CBB9 -> 110D 1172 11A8';
ok Uni.new(0xCBBA).NFKD.list ~~ (0x110D, 0x1172, 0x11A9,), 'CBBA -> 110D 1172 11A9';
ok Uni.new(0xCBBB).NFKD.list ~~ (0x110D, 0x1172, 0x11AA,), 'CBBB -> 110D 1172 11AA';
ok Uni.new(0xCBBC).NFKD.list ~~ (0x110D, 0x1172, 0x11AB,), 'CBBC -> 110D 1172 11AB';
ok Uni.new(0xCBBD).NFKD.list ~~ (0x110D, 0x1172, 0x11AC,), 'CBBD -> 110D 1172 11AC';
ok Uni.new(0xCBBE).NFKD.list ~~ (0x110D, 0x1172, 0x11AD,), 'CBBE -> 110D 1172 11AD';
ok Uni.new(0xCBBF).NFKD.list ~~ (0x110D, 0x1172, 0x11AE,), 'CBBF -> 110D 1172 11AE';
ok Uni.new(0xCBC0).NFKD.list ~~ (0x110D, 0x1172, 0x11AF,), 'CBC0 -> 110D 1172 11AF';
ok Uni.new(0xCBC1).NFKD.list ~~ (0x110D, 0x1172, 0x11B0,), 'CBC1 -> 110D 1172 11B0';
ok Uni.new(0xCBC2).NFKD.list ~~ (0x110D, 0x1172, 0x11B1,), 'CBC2 -> 110D 1172 11B1';
ok Uni.new(0xCBC3).NFKD.list ~~ (0x110D, 0x1172, 0x11B2,), 'CBC3 -> 110D 1172 11B2';
ok Uni.new(0xCBC4).NFKD.list ~~ (0x110D, 0x1172, 0x11B3,), 'CBC4 -> 110D 1172 11B3';
ok Uni.new(0xCBC5).NFKD.list ~~ (0x110D, 0x1172, 0x11B4,), 'CBC5 -> 110D 1172 11B4';
ok Uni.new(0xCBC6).NFKD.list ~~ (0x110D, 0x1172, 0x11B5,), 'CBC6 -> 110D 1172 11B5';
ok Uni.new(0xCBC7).NFKD.list ~~ (0x110D, 0x1172, 0x11B6,), 'CBC7 -> 110D 1172 11B6';
ok Uni.new(0xCBC8).NFKD.list ~~ (0x110D, 0x1172, 0x11B7,), 'CBC8 -> 110D 1172 11B7';
ok Uni.new(0xCBC9).NFKD.list ~~ (0x110D, 0x1172, 0x11B8,), 'CBC9 -> 110D 1172 11B8';
ok Uni.new(0xCBCA).NFKD.list ~~ (0x110D, 0x1172, 0x11B9,), 'CBCA -> 110D 1172 11B9';
ok Uni.new(0xCBCB).NFKD.list ~~ (0x110D, 0x1172, 0x11BA,), 'CBCB -> 110D 1172 11BA';
ok Uni.new(0xCBCC).NFKD.list ~~ (0x110D, 0x1172, 0x11BB,), 'CBCC -> 110D 1172 11BB';
ok Uni.new(0xCBCD).NFKD.list ~~ (0x110D, 0x1172, 0x11BC,), 'CBCD -> 110D 1172 11BC';
ok Uni.new(0xCBCE).NFKD.list ~~ (0x110D, 0x1172, 0x11BD,), 'CBCE -> 110D 1172 11BD';
ok Uni.new(0xCBCF).NFKD.list ~~ (0x110D, 0x1172, 0x11BE,), 'CBCF -> 110D 1172 11BE';
ok Uni.new(0xCBD0).NFKD.list ~~ (0x110D, 0x1172, 0x11BF,), 'CBD0 -> 110D 1172 11BF';
ok Uni.new(0xCBD1).NFKD.list ~~ (0x110D, 0x1172, 0x11C0,), 'CBD1 -> 110D 1172 11C0';
ok Uni.new(0xCBD2).NFKD.list ~~ (0x110D, 0x1172, 0x11C1,), 'CBD2 -> 110D 1172 11C1';
ok Uni.new(0xCBD3).NFKD.list ~~ (0x110D, 0x1172, 0x11C2,), 'CBD3 -> 110D 1172 11C2';
ok Uni.new(0xCBD4).NFKD.list ~~ (0x110D, 0x1173,), 'CBD4 -> 110D 1173';
ok Uni.new(0xCBD5).NFKD.list ~~ (0x110D, 0x1173, 0x11A8,), 'CBD5 -> 110D 1173 11A8';
ok Uni.new(0xCBD6).NFKD.list ~~ (0x110D, 0x1173, 0x11A9,), 'CBD6 -> 110D 1173 11A9';
ok Uni.new(0xCBD7).NFKD.list ~~ (0x110D, 0x1173, 0x11AA,), 'CBD7 -> 110D 1173 11AA';
ok Uni.new(0xCBD8).NFKD.list ~~ (0x110D, 0x1173, 0x11AB,), 'CBD8 -> 110D 1173 11AB';
ok Uni.new(0xCBD9).NFKD.list ~~ (0x110D, 0x1173, 0x11AC,), 'CBD9 -> 110D 1173 11AC';
ok Uni.new(0xCBDA).NFKD.list ~~ (0x110D, 0x1173, 0x11AD,), 'CBDA -> 110D 1173 11AD';
ok Uni.new(0xCBDB).NFKD.list ~~ (0x110D, 0x1173, 0x11AE,), 'CBDB -> 110D 1173 11AE';
ok Uni.new(0xCBDC).NFKD.list ~~ (0x110D, 0x1173, 0x11AF,), 'CBDC -> 110D 1173 11AF';
ok Uni.new(0xCBDD).NFKD.list ~~ (0x110D, 0x1173, 0x11B0,), 'CBDD -> 110D 1173 11B0';
ok Uni.new(0xCBDE).NFKD.list ~~ (0x110D, 0x1173, 0x11B1,), 'CBDE -> 110D 1173 11B1';
ok Uni.new(0xCBDF).NFKD.list ~~ (0x110D, 0x1173, 0x11B2,), 'CBDF -> 110D 1173 11B2';
ok Uni.new(0xCBE0).NFKD.list ~~ (0x110D, 0x1173, 0x11B3,), 'CBE0 -> 110D 1173 11B3';
ok Uni.new(0xCBE1).NFKD.list ~~ (0x110D, 0x1173, 0x11B4,), 'CBE1 -> 110D 1173 11B4';
ok Uni.new(0xCBE2).NFKD.list ~~ (0x110D, 0x1173, 0x11B5,), 'CBE2 -> 110D 1173 11B5';
ok Uni.new(0xCBE3).NFKD.list ~~ (0x110D, 0x1173, 0x11B6,), 'CBE3 -> 110D 1173 11B6';
ok Uni.new(0xCBE4).NFKD.list ~~ (0x110D, 0x1173, 0x11B7,), 'CBE4 -> 110D 1173 11B7';
ok Uni.new(0xCBE5).NFKD.list ~~ (0x110D, 0x1173, 0x11B8,), 'CBE5 -> 110D 1173 11B8';
ok Uni.new(0xCBE6).NFKD.list ~~ (0x110D, 0x1173, 0x11B9,), 'CBE6 -> 110D 1173 11B9';
ok Uni.new(0xCBE7).NFKD.list ~~ (0x110D, 0x1173, 0x11BA,), 'CBE7 -> 110D 1173 11BA';
ok Uni.new(0xCBE8).NFKD.list ~~ (0x110D, 0x1173, 0x11BB,), 'CBE8 -> 110D 1173 11BB';
ok Uni.new(0xCBE9).NFKD.list ~~ (0x110D, 0x1173, 0x11BC,), 'CBE9 -> 110D 1173 11BC';
ok Uni.new(0xCBEA).NFKD.list ~~ (0x110D, 0x1173, 0x11BD,), 'CBEA -> 110D 1173 11BD';
ok Uni.new(0xCBEB).NFKD.list ~~ (0x110D, 0x1173, 0x11BE,), 'CBEB -> 110D 1173 11BE';
ok Uni.new(0xCBEC).NFKD.list ~~ (0x110D, 0x1173, 0x11BF,), 'CBEC -> 110D 1173 11BF';
ok Uni.new(0xCBED).NFKD.list ~~ (0x110D, 0x1173, 0x11C0,), 'CBED -> 110D 1173 11C0';
ok Uni.new(0xCBEE).NFKD.list ~~ (0x110D, 0x1173, 0x11C1,), 'CBEE -> 110D 1173 11C1';
ok Uni.new(0xCBEF).NFKD.list ~~ (0x110D, 0x1173, 0x11C2,), 'CBEF -> 110D 1173 11C2';
ok Uni.new(0xCBF0).NFKD.list ~~ (0x110D, 0x1174,), 'CBF0 -> 110D 1174';
ok Uni.new(0xCBF1).NFKD.list ~~ (0x110D, 0x1174, 0x11A8,), 'CBF1 -> 110D 1174 11A8';
ok Uni.new(0xCBF2).NFKD.list ~~ (0x110D, 0x1174, 0x11A9,), 'CBF2 -> 110D 1174 11A9';
ok Uni.new(0xCBF3).NFKD.list ~~ (0x110D, 0x1174, 0x11AA,), 'CBF3 -> 110D 1174 11AA';
ok Uni.new(0xCBF4).NFKD.list ~~ (0x110D, 0x1174, 0x11AB,), 'CBF4 -> 110D 1174 11AB';
ok Uni.new(0xCBF5).NFKD.list ~~ (0x110D, 0x1174, 0x11AC,), 'CBF5 -> 110D 1174 11AC';
ok Uni.new(0xCBF6).NFKD.list ~~ (0x110D, 0x1174, 0x11AD,), 'CBF6 -> 110D 1174 11AD';
ok Uni.new(0xCBF7).NFKD.list ~~ (0x110D, 0x1174, 0x11AE,), 'CBF7 -> 110D 1174 11AE';
ok Uni.new(0xCBF8).NFKD.list ~~ (0x110D, 0x1174, 0x11AF,), 'CBF8 -> 110D 1174 11AF';
ok Uni.new(0xCBF9).NFKD.list ~~ (0x110D, 0x1174, 0x11B0,), 'CBF9 -> 110D 1174 11B0';
ok Uni.new(0xCBFA).NFKD.list ~~ (0x110D, 0x1174, 0x11B1,), 'CBFA -> 110D 1174 11B1';
ok Uni.new(0xCBFB).NFKD.list ~~ (0x110D, 0x1174, 0x11B2,), 'CBFB -> 110D 1174 11B2';
ok Uni.new(0xCBFC).NFKD.list ~~ (0x110D, 0x1174, 0x11B3,), 'CBFC -> 110D 1174 11B3';
ok Uni.new(0xCBFD).NFKD.list ~~ (0x110D, 0x1174, 0x11B4,), 'CBFD -> 110D 1174 11B4';
ok Uni.new(0xCBFE).NFKD.list ~~ (0x110D, 0x1174, 0x11B5,), 'CBFE -> 110D 1174 11B5';
ok Uni.new(0xCBFF).NFKD.list ~~ (0x110D, 0x1174, 0x11B6,), 'CBFF -> 110D 1174 11B6';
ok Uni.new(0xCC00).NFKD.list ~~ (0x110D, 0x1174, 0x11B7,), 'CC00 -> 110D 1174 11B7';
ok Uni.new(0xCC01).NFKD.list ~~ (0x110D, 0x1174, 0x11B8,), 'CC01 -> 110D 1174 11B8';
ok Uni.new(0xCC02).NFKD.list ~~ (0x110D, 0x1174, 0x11B9,), 'CC02 -> 110D 1174 11B9';
ok Uni.new(0xCC03).NFKD.list ~~ (0x110D, 0x1174, 0x11BA,), 'CC03 -> 110D 1174 11BA';
ok Uni.new(0xCC04).NFKD.list ~~ (0x110D, 0x1174, 0x11BB,), 'CC04 -> 110D 1174 11BB';
ok Uni.new(0xCC05).NFKD.list ~~ (0x110D, 0x1174, 0x11BC,), 'CC05 -> 110D 1174 11BC';
ok Uni.new(0xCC06).NFKD.list ~~ (0x110D, 0x1174, 0x11BD,), 'CC06 -> 110D 1174 11BD';
ok Uni.new(0xCC07).NFKD.list ~~ (0x110D, 0x1174, 0x11BE,), 'CC07 -> 110D 1174 11BE';
ok Uni.new(0xCC08).NFKD.list ~~ (0x110D, 0x1174, 0x11BF,), 'CC08 -> 110D 1174 11BF';
ok Uni.new(0xCC09).NFKD.list ~~ (0x110D, 0x1174, 0x11C0,), 'CC09 -> 110D 1174 11C0';
ok Uni.new(0xCC0A).NFKD.list ~~ (0x110D, 0x1174, 0x11C1,), 'CC0A -> 110D 1174 11C1';
ok Uni.new(0xCC0B).NFKD.list ~~ (0x110D, 0x1174, 0x11C2,), 'CC0B -> 110D 1174 11C2';
ok Uni.new(0xCC0C).NFKD.list ~~ (0x110D, 0x1175,), 'CC0C -> 110D 1175';
ok Uni.new(0xCC0D).NFKD.list ~~ (0x110D, 0x1175, 0x11A8,), 'CC0D -> 110D 1175 11A8';
ok Uni.new(0xCC0E).NFKD.list ~~ (0x110D, 0x1175, 0x11A9,), 'CC0E -> 110D 1175 11A9';
ok Uni.new(0xCC0F).NFKD.list ~~ (0x110D, 0x1175, 0x11AA,), 'CC0F -> 110D 1175 11AA';
ok Uni.new(0xCC10).NFKD.list ~~ (0x110D, 0x1175, 0x11AB,), 'CC10 -> 110D 1175 11AB';
ok Uni.new(0xCC11).NFKD.list ~~ (0x110D, 0x1175, 0x11AC,), 'CC11 -> 110D 1175 11AC';
ok Uni.new(0xCC12).NFKD.list ~~ (0x110D, 0x1175, 0x11AD,), 'CC12 -> 110D 1175 11AD';
ok Uni.new(0xCC13).NFKD.list ~~ (0x110D, 0x1175, 0x11AE,), 'CC13 -> 110D 1175 11AE';
ok Uni.new(0xCC14).NFKD.list ~~ (0x110D, 0x1175, 0x11AF,), 'CC14 -> 110D 1175 11AF';
ok Uni.new(0xCC15).NFKD.list ~~ (0x110D, 0x1175, 0x11B0,), 'CC15 -> 110D 1175 11B0';
ok Uni.new(0xCC16).NFKD.list ~~ (0x110D, 0x1175, 0x11B1,), 'CC16 -> 110D 1175 11B1';
ok Uni.new(0xCC17).NFKD.list ~~ (0x110D, 0x1175, 0x11B2,), 'CC17 -> 110D 1175 11B2';
ok Uni.new(0xCC18).NFKD.list ~~ (0x110D, 0x1175, 0x11B3,), 'CC18 -> 110D 1175 11B3';
ok Uni.new(0xCC19).NFKD.list ~~ (0x110D, 0x1175, 0x11B4,), 'CC19 -> 110D 1175 11B4';
ok Uni.new(0xCC1A).NFKD.list ~~ (0x110D, 0x1175, 0x11B5,), 'CC1A -> 110D 1175 11B5';
ok Uni.new(0xCC1B).NFKD.list ~~ (0x110D, 0x1175, 0x11B6,), 'CC1B -> 110D 1175 11B6';
ok Uni.new(0xCC1C).NFKD.list ~~ (0x110D, 0x1175, 0x11B7,), 'CC1C -> 110D 1175 11B7';
ok Uni.new(0xCC1D).NFKD.list ~~ (0x110D, 0x1175, 0x11B8,), 'CC1D -> 110D 1175 11B8';
ok Uni.new(0xCC1E).NFKD.list ~~ (0x110D, 0x1175, 0x11B9,), 'CC1E -> 110D 1175 11B9';
ok Uni.new(0xCC1F).NFKD.list ~~ (0x110D, 0x1175, 0x11BA,), 'CC1F -> 110D 1175 11BA';
ok Uni.new(0xCC20).NFKD.list ~~ (0x110D, 0x1175, 0x11BB,), 'CC20 -> 110D 1175 11BB';
ok Uni.new(0xCC21).NFKD.list ~~ (0x110D, 0x1175, 0x11BC,), 'CC21 -> 110D 1175 11BC';
ok Uni.new(0xCC22).NFKD.list ~~ (0x110D, 0x1175, 0x11BD,), 'CC22 -> 110D 1175 11BD';
ok Uni.new(0xCC23).NFKD.list ~~ (0x110D, 0x1175, 0x11BE,), 'CC23 -> 110D 1175 11BE';
ok Uni.new(0xCC24).NFKD.list ~~ (0x110D, 0x1175, 0x11BF,), 'CC24 -> 110D 1175 11BF';
ok Uni.new(0xCC25).NFKD.list ~~ (0x110D, 0x1175, 0x11C0,), 'CC25 -> 110D 1175 11C0';
ok Uni.new(0xCC26).NFKD.list ~~ (0x110D, 0x1175, 0x11C1,), 'CC26 -> 110D 1175 11C1';
ok Uni.new(0xCC27).NFKD.list ~~ (0x110D, 0x1175, 0x11C2,), 'CC27 -> 110D 1175 11C2';
ok Uni.new(0xCC28).NFKD.list ~~ (0x110E, 0x1161,), 'CC28 -> 110E 1161';
ok Uni.new(0xCC29).NFKD.list ~~ (0x110E, 0x1161, 0x11A8,), 'CC29 -> 110E 1161 11A8';
ok Uni.new(0xCC2A).NFKD.list ~~ (0x110E, 0x1161, 0x11A9,), 'CC2A -> 110E 1161 11A9';
ok Uni.new(0xCC2B).NFKD.list ~~ (0x110E, 0x1161, 0x11AA,), 'CC2B -> 110E 1161 11AA';
ok Uni.new(0xCC2C).NFKD.list ~~ (0x110E, 0x1161, 0x11AB,), 'CC2C -> 110E 1161 11AB';
ok Uni.new(0xCC2D).NFKD.list ~~ (0x110E, 0x1161, 0x11AC,), 'CC2D -> 110E 1161 11AC';
ok Uni.new(0xCC2E).NFKD.list ~~ (0x110E, 0x1161, 0x11AD,), 'CC2E -> 110E 1161 11AD';
ok Uni.new(0xCC2F).NFKD.list ~~ (0x110E, 0x1161, 0x11AE,), 'CC2F -> 110E 1161 11AE';
ok Uni.new(0xCC30).NFKD.list ~~ (0x110E, 0x1161, 0x11AF,), 'CC30 -> 110E 1161 11AF';
ok Uni.new(0xCC31).NFKD.list ~~ (0x110E, 0x1161, 0x11B0,), 'CC31 -> 110E 1161 11B0';
ok Uni.new(0xCC32).NFKD.list ~~ (0x110E, 0x1161, 0x11B1,), 'CC32 -> 110E 1161 11B1';
ok Uni.new(0xCC33).NFKD.list ~~ (0x110E, 0x1161, 0x11B2,), 'CC33 -> 110E 1161 11B2';
ok Uni.new(0xCC34).NFKD.list ~~ (0x110E, 0x1161, 0x11B3,), 'CC34 -> 110E 1161 11B3';
ok Uni.new(0xCC35).NFKD.list ~~ (0x110E, 0x1161, 0x11B4,), 'CC35 -> 110E 1161 11B4';
ok Uni.new(0xCC36).NFKD.list ~~ (0x110E, 0x1161, 0x11B5,), 'CC36 -> 110E 1161 11B5';
ok Uni.new(0xCC37).NFKD.list ~~ (0x110E, 0x1161, 0x11B6,), 'CC37 -> 110E 1161 11B6';
ok Uni.new(0xCC38).NFKD.list ~~ (0x110E, 0x1161, 0x11B7,), 'CC38 -> 110E 1161 11B7';
ok Uni.new(0xCC39).NFKD.list ~~ (0x110E, 0x1161, 0x11B8,), 'CC39 -> 110E 1161 11B8';
ok Uni.new(0xCC3A).NFKD.list ~~ (0x110E, 0x1161, 0x11B9,), 'CC3A -> 110E 1161 11B9';
ok Uni.new(0xCC3B).NFKD.list ~~ (0x110E, 0x1161, 0x11BA,), 'CC3B -> 110E 1161 11BA';
ok Uni.new(0xCC3C).NFKD.list ~~ (0x110E, 0x1161, 0x11BB,), 'CC3C -> 110E 1161 11BB';
ok Uni.new(0xCC3D).NFKD.list ~~ (0x110E, 0x1161, 0x11BC,), 'CC3D -> 110E 1161 11BC';
ok Uni.new(0xCC3E).NFKD.list ~~ (0x110E, 0x1161, 0x11BD,), 'CC3E -> 110E 1161 11BD';
ok Uni.new(0xCC3F).NFKD.list ~~ (0x110E, 0x1161, 0x11BE,), 'CC3F -> 110E 1161 11BE';
ok Uni.new(0xCC40).NFKD.list ~~ (0x110E, 0x1161, 0x11BF,), 'CC40 -> 110E 1161 11BF';
ok Uni.new(0xCC41).NFKD.list ~~ (0x110E, 0x1161, 0x11C0,), 'CC41 -> 110E 1161 11C0';
ok Uni.new(0xCC42).NFKD.list ~~ (0x110E, 0x1161, 0x11C1,), 'CC42 -> 110E 1161 11C1';
ok Uni.new(0xCC43).NFKD.list ~~ (0x110E, 0x1161, 0x11C2,), 'CC43 -> 110E 1161 11C2';
ok Uni.new(0xCC44).NFKD.list ~~ (0x110E, 0x1162,), 'CC44 -> 110E 1162';
ok Uni.new(0xCC45).NFKD.list ~~ (0x110E, 0x1162, 0x11A8,), 'CC45 -> 110E 1162 11A8';
ok Uni.new(0xCC46).NFKD.list ~~ (0x110E, 0x1162, 0x11A9,), 'CC46 -> 110E 1162 11A9';
ok Uni.new(0xCC47).NFKD.list ~~ (0x110E, 0x1162, 0x11AA,), 'CC47 -> 110E 1162 11AA';
ok Uni.new(0xCC48).NFKD.list ~~ (0x110E, 0x1162, 0x11AB,), 'CC48 -> 110E 1162 11AB';
ok Uni.new(0xCC49).NFKD.list ~~ (0x110E, 0x1162, 0x11AC,), 'CC49 -> 110E 1162 11AC';
ok Uni.new(0xCC4A).NFKD.list ~~ (0x110E, 0x1162, 0x11AD,), 'CC4A -> 110E 1162 11AD';
ok Uni.new(0xCC4B).NFKD.list ~~ (0x110E, 0x1162, 0x11AE,), 'CC4B -> 110E 1162 11AE';
ok Uni.new(0xCC4C).NFKD.list ~~ (0x110E, 0x1162, 0x11AF,), 'CC4C -> 110E 1162 11AF';
ok Uni.new(0xCC4D).NFKD.list ~~ (0x110E, 0x1162, 0x11B0,), 'CC4D -> 110E 1162 11B0';
ok Uni.new(0xCC4E).NFKD.list ~~ (0x110E, 0x1162, 0x11B1,), 'CC4E -> 110E 1162 11B1';
ok Uni.new(0xCC4F).NFKD.list ~~ (0x110E, 0x1162, 0x11B2,), 'CC4F -> 110E 1162 11B2';
ok Uni.new(0xCC50).NFKD.list ~~ (0x110E, 0x1162, 0x11B3,), 'CC50 -> 110E 1162 11B3';
ok Uni.new(0xCC51).NFKD.list ~~ (0x110E, 0x1162, 0x11B4,), 'CC51 -> 110E 1162 11B4';
ok Uni.new(0xCC52).NFKD.list ~~ (0x110E, 0x1162, 0x11B5,), 'CC52 -> 110E 1162 11B5';
ok Uni.new(0xCC53).NFKD.list ~~ (0x110E, 0x1162, 0x11B6,), 'CC53 -> 110E 1162 11B6';
ok Uni.new(0xCC54).NFKD.list ~~ (0x110E, 0x1162, 0x11B7,), 'CC54 -> 110E 1162 11B7';
ok Uni.new(0xCC55).NFKD.list ~~ (0x110E, 0x1162, 0x11B8,), 'CC55 -> 110E 1162 11B8';
ok Uni.new(0xCC56).NFKD.list ~~ (0x110E, 0x1162, 0x11B9,), 'CC56 -> 110E 1162 11B9';
ok Uni.new(0xCC57).NFKD.list ~~ (0x110E, 0x1162, 0x11BA,), 'CC57 -> 110E 1162 11BA';
ok Uni.new(0xCC58).NFKD.list ~~ (0x110E, 0x1162, 0x11BB,), 'CC58 -> 110E 1162 11BB';
ok Uni.new(0xCC59).NFKD.list ~~ (0x110E, 0x1162, 0x11BC,), 'CC59 -> 110E 1162 11BC';
ok Uni.new(0xCC5A).NFKD.list ~~ (0x110E, 0x1162, 0x11BD,), 'CC5A -> 110E 1162 11BD';
ok Uni.new(0xCC5B).NFKD.list ~~ (0x110E, 0x1162, 0x11BE,), 'CC5B -> 110E 1162 11BE';
ok Uni.new(0xCC5C).NFKD.list ~~ (0x110E, 0x1162, 0x11BF,), 'CC5C -> 110E 1162 11BF';
ok Uni.new(0xCC5D).NFKD.list ~~ (0x110E, 0x1162, 0x11C0,), 'CC5D -> 110E 1162 11C0';
ok Uni.new(0xCC5E).NFKD.list ~~ (0x110E, 0x1162, 0x11C1,), 'CC5E -> 110E 1162 11C1';
ok Uni.new(0xCC5F).NFKD.list ~~ (0x110E, 0x1162, 0x11C2,), 'CC5F -> 110E 1162 11C2';
ok Uni.new(0xCC60).NFKD.list ~~ (0x110E, 0x1163,), 'CC60 -> 110E 1163';
ok Uni.new(0xCC61).NFKD.list ~~ (0x110E, 0x1163, 0x11A8,), 'CC61 -> 110E 1163 11A8';
ok Uni.new(0xCC62).NFKD.list ~~ (0x110E, 0x1163, 0x11A9,), 'CC62 -> 110E 1163 11A9';
ok Uni.new(0xCC63).NFKD.list ~~ (0x110E, 0x1163, 0x11AA,), 'CC63 -> 110E 1163 11AA';
ok Uni.new(0xCC64).NFKD.list ~~ (0x110E, 0x1163, 0x11AB,), 'CC64 -> 110E 1163 11AB';
ok Uni.new(0xCC65).NFKD.list ~~ (0x110E, 0x1163, 0x11AC,), 'CC65 -> 110E 1163 11AC';
ok Uni.new(0xCC66).NFKD.list ~~ (0x110E, 0x1163, 0x11AD,), 'CC66 -> 110E 1163 11AD';
ok Uni.new(0xCC67).NFKD.list ~~ (0x110E, 0x1163, 0x11AE,), 'CC67 -> 110E 1163 11AE';
ok Uni.new(0xCC68).NFKD.list ~~ (0x110E, 0x1163, 0x11AF,), 'CC68 -> 110E 1163 11AF';
ok Uni.new(0xCC69).NFKD.list ~~ (0x110E, 0x1163, 0x11B0,), 'CC69 -> 110E 1163 11B0';
ok Uni.new(0xCC6A).NFKD.list ~~ (0x110E, 0x1163, 0x11B1,), 'CC6A -> 110E 1163 11B1';
ok Uni.new(0xCC6B).NFKD.list ~~ (0x110E, 0x1163, 0x11B2,), 'CC6B -> 110E 1163 11B2';
ok Uni.new(0xCC6C).NFKD.list ~~ (0x110E, 0x1163, 0x11B3,), 'CC6C -> 110E 1163 11B3';
ok Uni.new(0xCC6D).NFKD.list ~~ (0x110E, 0x1163, 0x11B4,), 'CC6D -> 110E 1163 11B4';
ok Uni.new(0xCC6E).NFKD.list ~~ (0x110E, 0x1163, 0x11B5,), 'CC6E -> 110E 1163 11B5';
ok Uni.new(0xCC6F).NFKD.list ~~ (0x110E, 0x1163, 0x11B6,), 'CC6F -> 110E 1163 11B6';
ok Uni.new(0xCC70).NFKD.list ~~ (0x110E, 0x1163, 0x11B7,), 'CC70 -> 110E 1163 11B7';
ok Uni.new(0xCC71).NFKD.list ~~ (0x110E, 0x1163, 0x11B8,), 'CC71 -> 110E 1163 11B8';
ok Uni.new(0xCC72).NFKD.list ~~ (0x110E, 0x1163, 0x11B9,), 'CC72 -> 110E 1163 11B9';
ok Uni.new(0xCC73).NFKD.list ~~ (0x110E, 0x1163, 0x11BA,), 'CC73 -> 110E 1163 11BA';
ok Uni.new(0xCC74).NFKD.list ~~ (0x110E, 0x1163, 0x11BB,), 'CC74 -> 110E 1163 11BB';
ok Uni.new(0xCC75).NFKD.list ~~ (0x110E, 0x1163, 0x11BC,), 'CC75 -> 110E 1163 11BC';
ok Uni.new(0xCC76).NFKD.list ~~ (0x110E, 0x1163, 0x11BD,), 'CC76 -> 110E 1163 11BD';
ok Uni.new(0xCC77).NFKD.list ~~ (0x110E, 0x1163, 0x11BE,), 'CC77 -> 110E 1163 11BE';
ok Uni.new(0xCC78).NFKD.list ~~ (0x110E, 0x1163, 0x11BF,), 'CC78 -> 110E 1163 11BF';
ok Uni.new(0xCC79).NFKD.list ~~ (0x110E, 0x1163, 0x11C0,), 'CC79 -> 110E 1163 11C0';
ok Uni.new(0xCC7A).NFKD.list ~~ (0x110E, 0x1163, 0x11C1,), 'CC7A -> 110E 1163 11C1';
ok Uni.new(0xCC7B).NFKD.list ~~ (0x110E, 0x1163, 0x11C2,), 'CC7B -> 110E 1163 11C2';
ok Uni.new(0xCC7C).NFKD.list ~~ (0x110E, 0x1164,), 'CC7C -> 110E 1164';
ok Uni.new(0xCC7D).NFKD.list ~~ (0x110E, 0x1164, 0x11A8,), 'CC7D -> 110E 1164 11A8';
ok Uni.new(0xCC7E).NFKD.list ~~ (0x110E, 0x1164, 0x11A9,), 'CC7E -> 110E 1164 11A9';
ok Uni.new(0xCC7F).NFKD.list ~~ (0x110E, 0x1164, 0x11AA,), 'CC7F -> 110E 1164 11AA';
ok Uni.new(0xCC80).NFKD.list ~~ (0x110E, 0x1164, 0x11AB,), 'CC80 -> 110E 1164 11AB';
ok Uni.new(0xCC81).NFKD.list ~~ (0x110E, 0x1164, 0x11AC,), 'CC81 -> 110E 1164 11AC';
ok Uni.new(0xCC82).NFKD.list ~~ (0x110E, 0x1164, 0x11AD,), 'CC82 -> 110E 1164 11AD';
ok Uni.new(0xCC83).NFKD.list ~~ (0x110E, 0x1164, 0x11AE,), 'CC83 -> 110E 1164 11AE';
ok Uni.new(0xCC84).NFKD.list ~~ (0x110E, 0x1164, 0x11AF,), 'CC84 -> 110E 1164 11AF';
ok Uni.new(0xCC85).NFKD.list ~~ (0x110E, 0x1164, 0x11B0,), 'CC85 -> 110E 1164 11B0';
ok Uni.new(0xCC86).NFKD.list ~~ (0x110E, 0x1164, 0x11B1,), 'CC86 -> 110E 1164 11B1';
ok Uni.new(0xCC87).NFKD.list ~~ (0x110E, 0x1164, 0x11B2,), 'CC87 -> 110E 1164 11B2';
ok Uni.new(0xCC88).NFKD.list ~~ (0x110E, 0x1164, 0x11B3,), 'CC88 -> 110E 1164 11B3';
ok Uni.new(0xCC89).NFKD.list ~~ (0x110E, 0x1164, 0x11B4,), 'CC89 -> 110E 1164 11B4';
ok Uni.new(0xCC8A).NFKD.list ~~ (0x110E, 0x1164, 0x11B5,), 'CC8A -> 110E 1164 11B5';
ok Uni.new(0xCC8B).NFKD.list ~~ (0x110E, 0x1164, 0x11B6,), 'CC8B -> 110E 1164 11B6';
ok Uni.new(0xCC8C).NFKD.list ~~ (0x110E, 0x1164, 0x11B7,), 'CC8C -> 110E 1164 11B7';
ok Uni.new(0xCC8D).NFKD.list ~~ (0x110E, 0x1164, 0x11B8,), 'CC8D -> 110E 1164 11B8';
ok Uni.new(0xCC8E).NFKD.list ~~ (0x110E, 0x1164, 0x11B9,), 'CC8E -> 110E 1164 11B9';
ok Uni.new(0xCC8F).NFKD.list ~~ (0x110E, 0x1164, 0x11BA,), 'CC8F -> 110E 1164 11BA';
ok Uni.new(0xCC90).NFKD.list ~~ (0x110E, 0x1164, 0x11BB,), 'CC90 -> 110E 1164 11BB';
ok Uni.new(0xCC91).NFKD.list ~~ (0x110E, 0x1164, 0x11BC,), 'CC91 -> 110E 1164 11BC';
ok Uni.new(0xCC92).NFKD.list ~~ (0x110E, 0x1164, 0x11BD,), 'CC92 -> 110E 1164 11BD';
ok Uni.new(0xCC93).NFKD.list ~~ (0x110E, 0x1164, 0x11BE,), 'CC93 -> 110E 1164 11BE';
ok Uni.new(0xCC94).NFKD.list ~~ (0x110E, 0x1164, 0x11BF,), 'CC94 -> 110E 1164 11BF';
ok Uni.new(0xCC95).NFKD.list ~~ (0x110E, 0x1164, 0x11C0,), 'CC95 -> 110E 1164 11C0';
ok Uni.new(0xCC96).NFKD.list ~~ (0x110E, 0x1164, 0x11C1,), 'CC96 -> 110E 1164 11C1';
ok Uni.new(0xCC97).NFKD.list ~~ (0x110E, 0x1164, 0x11C2,), 'CC97 -> 110E 1164 11C2';
ok Uni.new(0xCC98).NFKD.list ~~ (0x110E, 0x1165,), 'CC98 -> 110E 1165';
ok Uni.new(0xCC99).NFKD.list ~~ (0x110E, 0x1165, 0x11A8,), 'CC99 -> 110E 1165 11A8';
ok Uni.new(0xCC9A).NFKD.list ~~ (0x110E, 0x1165, 0x11A9,), 'CC9A -> 110E 1165 11A9';
ok Uni.new(0xCC9B).NFKD.list ~~ (0x110E, 0x1165, 0x11AA,), 'CC9B -> 110E 1165 11AA';
ok Uni.new(0xCC9C).NFKD.list ~~ (0x110E, 0x1165, 0x11AB,), 'CC9C -> 110E 1165 11AB';
ok Uni.new(0xCC9D).NFKD.list ~~ (0x110E, 0x1165, 0x11AC,), 'CC9D -> 110E 1165 11AC';
ok Uni.new(0xCC9E).NFKD.list ~~ (0x110E, 0x1165, 0x11AD,), 'CC9E -> 110E 1165 11AD';
ok Uni.new(0xCC9F).NFKD.list ~~ (0x110E, 0x1165, 0x11AE,), 'CC9F -> 110E 1165 11AE';
ok Uni.new(0xCCA0).NFKD.list ~~ (0x110E, 0x1165, 0x11AF,), 'CCA0 -> 110E 1165 11AF';
ok Uni.new(0xCCA1).NFKD.list ~~ (0x110E, 0x1165, 0x11B0,), 'CCA1 -> 110E 1165 11B0';
ok Uni.new(0xCCA2).NFKD.list ~~ (0x110E, 0x1165, 0x11B1,), 'CCA2 -> 110E 1165 11B1';
ok Uni.new(0xCCA3).NFKD.list ~~ (0x110E, 0x1165, 0x11B2,), 'CCA3 -> 110E 1165 11B2';
ok Uni.new(0xCCA4).NFKD.list ~~ (0x110E, 0x1165, 0x11B3,), 'CCA4 -> 110E 1165 11B3';
ok Uni.new(0xCCA5).NFKD.list ~~ (0x110E, 0x1165, 0x11B4,), 'CCA5 -> 110E 1165 11B4';
ok Uni.new(0xCCA6).NFKD.list ~~ (0x110E, 0x1165, 0x11B5,), 'CCA6 -> 110E 1165 11B5';
ok Uni.new(0xCCA7).NFKD.list ~~ (0x110E, 0x1165, 0x11B6,), 'CCA7 -> 110E 1165 11B6';
ok Uni.new(0xCCA8).NFKD.list ~~ (0x110E, 0x1165, 0x11B7,), 'CCA8 -> 110E 1165 11B7';
ok Uni.new(0xCCA9).NFKD.list ~~ (0x110E, 0x1165, 0x11B8,), 'CCA9 -> 110E 1165 11B8';
ok Uni.new(0xCCAA).NFKD.list ~~ (0x110E, 0x1165, 0x11B9,), 'CCAA -> 110E 1165 11B9';
ok Uni.new(0xCCAB).NFKD.list ~~ (0x110E, 0x1165, 0x11BA,), 'CCAB -> 110E 1165 11BA';
ok Uni.new(0xCCAC).NFKD.list ~~ (0x110E, 0x1165, 0x11BB,), 'CCAC -> 110E 1165 11BB';
ok Uni.new(0xCCAD).NFKD.list ~~ (0x110E, 0x1165, 0x11BC,), 'CCAD -> 110E 1165 11BC';
ok Uni.new(0xCCAE).NFKD.list ~~ (0x110E, 0x1165, 0x11BD,), 'CCAE -> 110E 1165 11BD';
ok Uni.new(0xCCAF).NFKD.list ~~ (0x110E, 0x1165, 0x11BE,), 'CCAF -> 110E 1165 11BE';
ok Uni.new(0xCCB0).NFKD.list ~~ (0x110E, 0x1165, 0x11BF,), 'CCB0 -> 110E 1165 11BF';
ok Uni.new(0xCCB1).NFKD.list ~~ (0x110E, 0x1165, 0x11C0,), 'CCB1 -> 110E 1165 11C0';
ok Uni.new(0xCCB2).NFKD.list ~~ (0x110E, 0x1165, 0x11C1,), 'CCB2 -> 110E 1165 11C1';
ok Uni.new(0xCCB3).NFKD.list ~~ (0x110E, 0x1165, 0x11C2,), 'CCB3 -> 110E 1165 11C2';
ok Uni.new(0xCCB4).NFKD.list ~~ (0x110E, 0x1166,), 'CCB4 -> 110E 1166';
ok Uni.new(0xCCB5).NFKD.list ~~ (0x110E, 0x1166, 0x11A8,), 'CCB5 -> 110E 1166 11A8';
ok Uni.new(0xCCB6).NFKD.list ~~ (0x110E, 0x1166, 0x11A9,), 'CCB6 -> 110E 1166 11A9';
ok Uni.new(0xCCB7).NFKD.list ~~ (0x110E, 0x1166, 0x11AA,), 'CCB7 -> 110E 1166 11AA';
ok Uni.new(0xCCB8).NFKD.list ~~ (0x110E, 0x1166, 0x11AB,), 'CCB8 -> 110E 1166 11AB';
ok Uni.new(0xCCB9).NFKD.list ~~ (0x110E, 0x1166, 0x11AC,), 'CCB9 -> 110E 1166 11AC';
ok Uni.new(0xCCBA).NFKD.list ~~ (0x110E, 0x1166, 0x11AD,), 'CCBA -> 110E 1166 11AD';
ok Uni.new(0xCCBB).NFKD.list ~~ (0x110E, 0x1166, 0x11AE,), 'CCBB -> 110E 1166 11AE';
ok Uni.new(0xCCBC).NFKD.list ~~ (0x110E, 0x1166, 0x11AF,), 'CCBC -> 110E 1166 11AF';
ok Uni.new(0xCCBD).NFKD.list ~~ (0x110E, 0x1166, 0x11B0,), 'CCBD -> 110E 1166 11B0';
ok Uni.new(0xCCBE).NFKD.list ~~ (0x110E, 0x1166, 0x11B1,), 'CCBE -> 110E 1166 11B1';
ok Uni.new(0xCCBF).NFKD.list ~~ (0x110E, 0x1166, 0x11B2,), 'CCBF -> 110E 1166 11B2';
ok Uni.new(0xCCC0).NFKD.list ~~ (0x110E, 0x1166, 0x11B3,), 'CCC0 -> 110E 1166 11B3';
ok Uni.new(0xCCC1).NFKD.list ~~ (0x110E, 0x1166, 0x11B4,), 'CCC1 -> 110E 1166 11B4';
ok Uni.new(0xCCC2).NFKD.list ~~ (0x110E, 0x1166, 0x11B5,), 'CCC2 -> 110E 1166 11B5';
ok Uni.new(0xCCC3).NFKD.list ~~ (0x110E, 0x1166, 0x11B6,), 'CCC3 -> 110E 1166 11B6';
ok Uni.new(0xCCC4).NFKD.list ~~ (0x110E, 0x1166, 0x11B7,), 'CCC4 -> 110E 1166 11B7';
ok Uni.new(0xCCC5).NFKD.list ~~ (0x110E, 0x1166, 0x11B8,), 'CCC5 -> 110E 1166 11B8';
ok Uni.new(0xCCC6).NFKD.list ~~ (0x110E, 0x1166, 0x11B9,), 'CCC6 -> 110E 1166 11B9';
ok Uni.new(0xCCC7).NFKD.list ~~ (0x110E, 0x1166, 0x11BA,), 'CCC7 -> 110E 1166 11BA';
ok Uni.new(0xCCC8).NFKD.list ~~ (0x110E, 0x1166, 0x11BB,), 'CCC8 -> 110E 1166 11BB';
ok Uni.new(0xCCC9).NFKD.list ~~ (0x110E, 0x1166, 0x11BC,), 'CCC9 -> 110E 1166 11BC';
ok Uni.new(0xCCCA).NFKD.list ~~ (0x110E, 0x1166, 0x11BD,), 'CCCA -> 110E 1166 11BD';
ok Uni.new(0xCCCB).NFKD.list ~~ (0x110E, 0x1166, 0x11BE,), 'CCCB -> 110E 1166 11BE';
ok Uni.new(0xCCCC).NFKD.list ~~ (0x110E, 0x1166, 0x11BF,), 'CCCC -> 110E 1166 11BF';
ok Uni.new(0xCCCD).NFKD.list ~~ (0x110E, 0x1166, 0x11C0,), 'CCCD -> 110E 1166 11C0';
ok Uni.new(0xCCCE).NFKD.list ~~ (0x110E, 0x1166, 0x11C1,), 'CCCE -> 110E 1166 11C1';
ok Uni.new(0xCCCF).NFKD.list ~~ (0x110E, 0x1166, 0x11C2,), 'CCCF -> 110E 1166 11C2';
ok Uni.new(0xCCD0).NFKD.list ~~ (0x110E, 0x1167,), 'CCD0 -> 110E 1167';
ok Uni.new(0xCCD1).NFKD.list ~~ (0x110E, 0x1167, 0x11A8,), 'CCD1 -> 110E 1167 11A8';
ok Uni.new(0xCCD2).NFKD.list ~~ (0x110E, 0x1167, 0x11A9,), 'CCD2 -> 110E 1167 11A9';
ok Uni.new(0xCCD3).NFKD.list ~~ (0x110E, 0x1167, 0x11AA,), 'CCD3 -> 110E 1167 11AA';
ok Uni.new(0xCCD4).NFKD.list ~~ (0x110E, 0x1167, 0x11AB,), 'CCD4 -> 110E 1167 11AB';
ok Uni.new(0xCCD5).NFKD.list ~~ (0x110E, 0x1167, 0x11AC,), 'CCD5 -> 110E 1167 11AC';
ok Uni.new(0xCCD6).NFKD.list ~~ (0x110E, 0x1167, 0x11AD,), 'CCD6 -> 110E 1167 11AD';
ok Uni.new(0xCCD7).NFKD.list ~~ (0x110E, 0x1167, 0x11AE,), 'CCD7 -> 110E 1167 11AE';
ok Uni.new(0xCCD8).NFKD.list ~~ (0x110E, 0x1167, 0x11AF,), 'CCD8 -> 110E 1167 11AF';
ok Uni.new(0xCCD9).NFKD.list ~~ (0x110E, 0x1167, 0x11B0,), 'CCD9 -> 110E 1167 11B0';
ok Uni.new(0xCCDA).NFKD.list ~~ (0x110E, 0x1167, 0x11B1,), 'CCDA -> 110E 1167 11B1';
ok Uni.new(0xCCDB).NFKD.list ~~ (0x110E, 0x1167, 0x11B2,), 'CCDB -> 110E 1167 11B2';
ok Uni.new(0xCCDC).NFKD.list ~~ (0x110E, 0x1167, 0x11B3,), 'CCDC -> 110E 1167 11B3';
ok Uni.new(0xCCDD).NFKD.list ~~ (0x110E, 0x1167, 0x11B4,), 'CCDD -> 110E 1167 11B4';
ok Uni.new(0xCCDE).NFKD.list ~~ (0x110E, 0x1167, 0x11B5,), 'CCDE -> 110E 1167 11B5';
ok Uni.new(0xCCDF).NFKD.list ~~ (0x110E, 0x1167, 0x11B6,), 'CCDF -> 110E 1167 11B6';
ok Uni.new(0xCCE0).NFKD.list ~~ (0x110E, 0x1167, 0x11B7,), 'CCE0 -> 110E 1167 11B7';
ok Uni.new(0xCCE1).NFKD.list ~~ (0x110E, 0x1167, 0x11B8,), 'CCE1 -> 110E 1167 11B8';
ok Uni.new(0xCCE2).NFKD.list ~~ (0x110E, 0x1167, 0x11B9,), 'CCE2 -> 110E 1167 11B9';
ok Uni.new(0xCCE3).NFKD.list ~~ (0x110E, 0x1167, 0x11BA,), 'CCE3 -> 110E 1167 11BA';
ok Uni.new(0xCCE4).NFKD.list ~~ (0x110E, 0x1167, 0x11BB,), 'CCE4 -> 110E 1167 11BB';
ok Uni.new(0xCCE5).NFKD.list ~~ (0x110E, 0x1167, 0x11BC,), 'CCE5 -> 110E 1167 11BC';
ok Uni.new(0xCCE6).NFKD.list ~~ (0x110E, 0x1167, 0x11BD,), 'CCE6 -> 110E 1167 11BD';
ok Uni.new(0xCCE7).NFKD.list ~~ (0x110E, 0x1167, 0x11BE,), 'CCE7 -> 110E 1167 11BE';
ok Uni.new(0xCCE8).NFKD.list ~~ (0x110E, 0x1167, 0x11BF,), 'CCE8 -> 110E 1167 11BF';
ok Uni.new(0xCCE9).NFKD.list ~~ (0x110E, 0x1167, 0x11C0,), 'CCE9 -> 110E 1167 11C0';
ok Uni.new(0xCCEA).NFKD.list ~~ (0x110E, 0x1167, 0x11C1,), 'CCEA -> 110E 1167 11C1';
ok Uni.new(0xCCEB).NFKD.list ~~ (0x110E, 0x1167, 0x11C2,), 'CCEB -> 110E 1167 11C2';
ok Uni.new(0xCCEC).NFKD.list ~~ (0x110E, 0x1168,), 'CCEC -> 110E 1168';
ok Uni.new(0xCCED).NFKD.list ~~ (0x110E, 0x1168, 0x11A8,), 'CCED -> 110E 1168 11A8';
ok Uni.new(0xCCEE).NFKD.list ~~ (0x110E, 0x1168, 0x11A9,), 'CCEE -> 110E 1168 11A9';
ok Uni.new(0xCCEF).NFKD.list ~~ (0x110E, 0x1168, 0x11AA,), 'CCEF -> 110E 1168 11AA';
ok Uni.new(0xCCF0).NFKD.list ~~ (0x110E, 0x1168, 0x11AB,), 'CCF0 -> 110E 1168 11AB';
ok Uni.new(0xCCF1).NFKD.list ~~ (0x110E, 0x1168, 0x11AC,), 'CCF1 -> 110E 1168 11AC';
ok Uni.new(0xCCF2).NFKD.list ~~ (0x110E, 0x1168, 0x11AD,), 'CCF2 -> 110E 1168 11AD';
ok Uni.new(0xCCF3).NFKD.list ~~ (0x110E, 0x1168, 0x11AE,), 'CCF3 -> 110E 1168 11AE';
ok Uni.new(0xCCF4).NFKD.list ~~ (0x110E, 0x1168, 0x11AF,), 'CCF4 -> 110E 1168 11AF';
ok Uni.new(0xCCF5).NFKD.list ~~ (0x110E, 0x1168, 0x11B0,), 'CCF5 -> 110E 1168 11B0';
ok Uni.new(0xCCF6).NFKD.list ~~ (0x110E, 0x1168, 0x11B1,), 'CCF6 -> 110E 1168 11B1';
ok Uni.new(0xCCF7).NFKD.list ~~ (0x110E, 0x1168, 0x11B2,), 'CCF7 -> 110E 1168 11B2';
ok Uni.new(0xCCF8).NFKD.list ~~ (0x110E, 0x1168, 0x11B3,), 'CCF8 -> 110E 1168 11B3';
ok Uni.new(0xCCF9).NFKD.list ~~ (0x110E, 0x1168, 0x11B4,), 'CCF9 -> 110E 1168 11B4';
ok Uni.new(0xCCFA).NFKD.list ~~ (0x110E, 0x1168, 0x11B5,), 'CCFA -> 110E 1168 11B5';
ok Uni.new(0xCCFB).NFKD.list ~~ (0x110E, 0x1168, 0x11B6,), 'CCFB -> 110E 1168 11B6';
ok Uni.new(0xCCFC).NFKD.list ~~ (0x110E, 0x1168, 0x11B7,), 'CCFC -> 110E 1168 11B7';
ok Uni.new(0xCCFD).NFKD.list ~~ (0x110E, 0x1168, 0x11B8,), 'CCFD -> 110E 1168 11B8';
ok Uni.new(0xCCFE).NFKD.list ~~ (0x110E, 0x1168, 0x11B9,), 'CCFE -> 110E 1168 11B9';
ok Uni.new(0xCCFF).NFKD.list ~~ (0x110E, 0x1168, 0x11BA,), 'CCFF -> 110E 1168 11BA';
ok Uni.new(0xCD00).NFKD.list ~~ (0x110E, 0x1168, 0x11BB,), 'CD00 -> 110E 1168 11BB';
ok Uni.new(0xCD01).NFKD.list ~~ (0x110E, 0x1168, 0x11BC,), 'CD01 -> 110E 1168 11BC';
ok Uni.new(0xCD02).NFKD.list ~~ (0x110E, 0x1168, 0x11BD,), 'CD02 -> 110E 1168 11BD';
ok Uni.new(0xCD03).NFKD.list ~~ (0x110E, 0x1168, 0x11BE,), 'CD03 -> 110E 1168 11BE';
ok Uni.new(0xCD04).NFKD.list ~~ (0x110E, 0x1168, 0x11BF,), 'CD04 -> 110E 1168 11BF';
ok Uni.new(0xCD05).NFKD.list ~~ (0x110E, 0x1168, 0x11C0,), 'CD05 -> 110E 1168 11C0';
ok Uni.new(0xCD06).NFKD.list ~~ (0x110E, 0x1168, 0x11C1,), 'CD06 -> 110E 1168 11C1';
ok Uni.new(0xCD07).NFKD.list ~~ (0x110E, 0x1168, 0x11C2,), 'CD07 -> 110E 1168 11C2';
ok Uni.new(0xCD08).NFKD.list ~~ (0x110E, 0x1169,), 'CD08 -> 110E 1169';
ok Uni.new(0xCD09).NFKD.list ~~ (0x110E, 0x1169, 0x11A8,), 'CD09 -> 110E 1169 11A8';
ok Uni.new(0xCD0A).NFKD.list ~~ (0x110E, 0x1169, 0x11A9,), 'CD0A -> 110E 1169 11A9';
ok Uni.new(0xCD0B).NFKD.list ~~ (0x110E, 0x1169, 0x11AA,), 'CD0B -> 110E 1169 11AA';
ok Uni.new(0xCD0C).NFKD.list ~~ (0x110E, 0x1169, 0x11AB,), 'CD0C -> 110E 1169 11AB';
ok Uni.new(0xCD0D).NFKD.list ~~ (0x110E, 0x1169, 0x11AC,), 'CD0D -> 110E 1169 11AC';
ok Uni.new(0xCD0E).NFKD.list ~~ (0x110E, 0x1169, 0x11AD,), 'CD0E -> 110E 1169 11AD';
ok Uni.new(0xCD0F).NFKD.list ~~ (0x110E, 0x1169, 0x11AE,), 'CD0F -> 110E 1169 11AE';
ok Uni.new(0xCD10).NFKD.list ~~ (0x110E, 0x1169, 0x11AF,), 'CD10 -> 110E 1169 11AF';
ok Uni.new(0xCD11).NFKD.list ~~ (0x110E, 0x1169, 0x11B0,), 'CD11 -> 110E 1169 11B0';
ok Uni.new(0xCD12).NFKD.list ~~ (0x110E, 0x1169, 0x11B1,), 'CD12 -> 110E 1169 11B1';
ok Uni.new(0xCD13).NFKD.list ~~ (0x110E, 0x1169, 0x11B2,), 'CD13 -> 110E 1169 11B2';
ok Uni.new(0xCD14).NFKD.list ~~ (0x110E, 0x1169, 0x11B3,), 'CD14 -> 110E 1169 11B3';
ok Uni.new(0xCD15).NFKD.list ~~ (0x110E, 0x1169, 0x11B4,), 'CD15 -> 110E 1169 11B4';
ok Uni.new(0xCD16).NFKD.list ~~ (0x110E, 0x1169, 0x11B5,), 'CD16 -> 110E 1169 11B5';
ok Uni.new(0xCD17).NFKD.list ~~ (0x110E, 0x1169, 0x11B6,), 'CD17 -> 110E 1169 11B6';
ok Uni.new(0xCD18).NFKD.list ~~ (0x110E, 0x1169, 0x11B7,), 'CD18 -> 110E 1169 11B7';
ok Uni.new(0xCD19).NFKD.list ~~ (0x110E, 0x1169, 0x11B8,), 'CD19 -> 110E 1169 11B8';
ok Uni.new(0xCD1A).NFKD.list ~~ (0x110E, 0x1169, 0x11B9,), 'CD1A -> 110E 1169 11B9';
ok Uni.new(0xCD1B).NFKD.list ~~ (0x110E, 0x1169, 0x11BA,), 'CD1B -> 110E 1169 11BA';
ok Uni.new(0xCD1C).NFKD.list ~~ (0x110E, 0x1169, 0x11BB,), 'CD1C -> 110E 1169 11BB';
ok Uni.new(0xCD1D).NFKD.list ~~ (0x110E, 0x1169, 0x11BC,), 'CD1D -> 110E 1169 11BC';
ok Uni.new(0xCD1E).NFKD.list ~~ (0x110E, 0x1169, 0x11BD,), 'CD1E -> 110E 1169 11BD';
ok Uni.new(0xCD1F).NFKD.list ~~ (0x110E, 0x1169, 0x11BE,), 'CD1F -> 110E 1169 11BE';
ok Uni.new(0xCD20).NFKD.list ~~ (0x110E, 0x1169, 0x11BF,), 'CD20 -> 110E 1169 11BF';
ok Uni.new(0xCD21).NFKD.list ~~ (0x110E, 0x1169, 0x11C0,), 'CD21 -> 110E 1169 11C0';
ok Uni.new(0xCD22).NFKD.list ~~ (0x110E, 0x1169, 0x11C1,), 'CD22 -> 110E 1169 11C1';
ok Uni.new(0xCD23).NFKD.list ~~ (0x110E, 0x1169, 0x11C2,), 'CD23 -> 110E 1169 11C2';
ok Uni.new(0xCD24).NFKD.list ~~ (0x110E, 0x116A,), 'CD24 -> 110E 116A';
ok Uni.new(0xCD25).NFKD.list ~~ (0x110E, 0x116A, 0x11A8,), 'CD25 -> 110E 116A 11A8';
ok Uni.new(0xCD26).NFKD.list ~~ (0x110E, 0x116A, 0x11A9,), 'CD26 -> 110E 116A 11A9';
ok Uni.new(0xCD27).NFKD.list ~~ (0x110E, 0x116A, 0x11AA,), 'CD27 -> 110E 116A 11AA';
ok Uni.new(0xCD28).NFKD.list ~~ (0x110E, 0x116A, 0x11AB,), 'CD28 -> 110E 116A 11AB';
ok Uni.new(0xCD29).NFKD.list ~~ (0x110E, 0x116A, 0x11AC,), 'CD29 -> 110E 116A 11AC';
ok Uni.new(0xCD2A).NFKD.list ~~ (0x110E, 0x116A, 0x11AD,), 'CD2A -> 110E 116A 11AD';
ok Uni.new(0xCD2B).NFKD.list ~~ (0x110E, 0x116A, 0x11AE,), 'CD2B -> 110E 116A 11AE';
ok Uni.new(0xCD2C).NFKD.list ~~ (0x110E, 0x116A, 0x11AF,), 'CD2C -> 110E 116A 11AF';
ok Uni.new(0xCD2D).NFKD.list ~~ (0x110E, 0x116A, 0x11B0,), 'CD2D -> 110E 116A 11B0';
ok Uni.new(0xCD2E).NFKD.list ~~ (0x110E, 0x116A, 0x11B1,), 'CD2E -> 110E 116A 11B1';
ok Uni.new(0xCD2F).NFKD.list ~~ (0x110E, 0x116A, 0x11B2,), 'CD2F -> 110E 116A 11B2';
ok Uni.new(0xCD30).NFKD.list ~~ (0x110E, 0x116A, 0x11B3,), 'CD30 -> 110E 116A 11B3';
ok Uni.new(0xCD31).NFKD.list ~~ (0x110E, 0x116A, 0x11B4,), 'CD31 -> 110E 116A 11B4';
ok Uni.new(0xCD32).NFKD.list ~~ (0x110E, 0x116A, 0x11B5,), 'CD32 -> 110E 116A 11B5';
ok Uni.new(0xCD33).NFKD.list ~~ (0x110E, 0x116A, 0x11B6,), 'CD33 -> 110E 116A 11B6';
ok Uni.new(0xCD34).NFKD.list ~~ (0x110E, 0x116A, 0x11B7,), 'CD34 -> 110E 116A 11B7';
ok Uni.new(0xCD35).NFKD.list ~~ (0x110E, 0x116A, 0x11B8,), 'CD35 -> 110E 116A 11B8';
ok Uni.new(0xCD36).NFKD.list ~~ (0x110E, 0x116A, 0x11B9,), 'CD36 -> 110E 116A 11B9';
ok Uni.new(0xCD37).NFKD.list ~~ (0x110E, 0x116A, 0x11BA,), 'CD37 -> 110E 116A 11BA';
ok Uni.new(0xCD38).NFKD.list ~~ (0x110E, 0x116A, 0x11BB,), 'CD38 -> 110E 116A 11BB';
ok Uni.new(0xCD39).NFKD.list ~~ (0x110E, 0x116A, 0x11BC,), 'CD39 -> 110E 116A 11BC';
ok Uni.new(0xCD3A).NFKD.list ~~ (0x110E, 0x116A, 0x11BD,), 'CD3A -> 110E 116A 11BD';
ok Uni.new(0xCD3B).NFKD.list ~~ (0x110E, 0x116A, 0x11BE,), 'CD3B -> 110E 116A 11BE';
ok Uni.new(0xCD3C).NFKD.list ~~ (0x110E, 0x116A, 0x11BF,), 'CD3C -> 110E 116A 11BF';
ok Uni.new(0xCD3D).NFKD.list ~~ (0x110E, 0x116A, 0x11C0,), 'CD3D -> 110E 116A 11C0';
ok Uni.new(0xCD3E).NFKD.list ~~ (0x110E, 0x116A, 0x11C1,), 'CD3E -> 110E 116A 11C1';
ok Uni.new(0xCD3F).NFKD.list ~~ (0x110E, 0x116A, 0x11C2,), 'CD3F -> 110E 116A 11C2';
ok Uni.new(0xCD40).NFKD.list ~~ (0x110E, 0x116B,), 'CD40 -> 110E 116B';
ok Uni.new(0xCD41).NFKD.list ~~ (0x110E, 0x116B, 0x11A8,), 'CD41 -> 110E 116B 11A8';
ok Uni.new(0xCD42).NFKD.list ~~ (0x110E, 0x116B, 0x11A9,), 'CD42 -> 110E 116B 11A9';
ok Uni.new(0xCD43).NFKD.list ~~ (0x110E, 0x116B, 0x11AA,), 'CD43 -> 110E 116B 11AA';
ok Uni.new(0xCD44).NFKD.list ~~ (0x110E, 0x116B, 0x11AB,), 'CD44 -> 110E 116B 11AB';
ok Uni.new(0xCD45).NFKD.list ~~ (0x110E, 0x116B, 0x11AC,), 'CD45 -> 110E 116B 11AC';
ok Uni.new(0xCD46).NFKD.list ~~ (0x110E, 0x116B, 0x11AD,), 'CD46 -> 110E 116B 11AD';
ok Uni.new(0xCD47).NFKD.list ~~ (0x110E, 0x116B, 0x11AE,), 'CD47 -> 110E 116B 11AE';
ok Uni.new(0xCD48).NFKD.list ~~ (0x110E, 0x116B, 0x11AF,), 'CD48 -> 110E 116B 11AF';
ok Uni.new(0xCD49).NFKD.list ~~ (0x110E, 0x116B, 0x11B0,), 'CD49 -> 110E 116B 11B0';
ok Uni.new(0xCD4A).NFKD.list ~~ (0x110E, 0x116B, 0x11B1,), 'CD4A -> 110E 116B 11B1';
ok Uni.new(0xCD4B).NFKD.list ~~ (0x110E, 0x116B, 0x11B2,), 'CD4B -> 110E 116B 11B2';
ok Uni.new(0xCD4C).NFKD.list ~~ (0x110E, 0x116B, 0x11B3,), 'CD4C -> 110E 116B 11B3';
ok Uni.new(0xCD4D).NFKD.list ~~ (0x110E, 0x116B, 0x11B4,), 'CD4D -> 110E 116B 11B4';
ok Uni.new(0xCD4E).NFKD.list ~~ (0x110E, 0x116B, 0x11B5,), 'CD4E -> 110E 116B 11B5';
ok Uni.new(0xCD4F).NFKD.list ~~ (0x110E, 0x116B, 0x11B6,), 'CD4F -> 110E 116B 11B6';
ok Uni.new(0xCD50).NFKD.list ~~ (0x110E, 0x116B, 0x11B7,), 'CD50 -> 110E 116B 11B7';
ok Uni.new(0xCD51).NFKD.list ~~ (0x110E, 0x116B, 0x11B8,), 'CD51 -> 110E 116B 11B8';
ok Uni.new(0xCD52).NFKD.list ~~ (0x110E, 0x116B, 0x11B9,), 'CD52 -> 110E 116B 11B9';
ok Uni.new(0xCD53).NFKD.list ~~ (0x110E, 0x116B, 0x11BA,), 'CD53 -> 110E 116B 11BA';
ok Uni.new(0xCD54).NFKD.list ~~ (0x110E, 0x116B, 0x11BB,), 'CD54 -> 110E 116B 11BB';
ok Uni.new(0xCD55).NFKD.list ~~ (0x110E, 0x116B, 0x11BC,), 'CD55 -> 110E 116B 11BC';
ok Uni.new(0xCD56).NFKD.list ~~ (0x110E, 0x116B, 0x11BD,), 'CD56 -> 110E 116B 11BD';
ok Uni.new(0xCD57).NFKD.list ~~ (0x110E, 0x116B, 0x11BE,), 'CD57 -> 110E 116B 11BE';
ok Uni.new(0xCD58).NFKD.list ~~ (0x110E, 0x116B, 0x11BF,), 'CD58 -> 110E 116B 11BF';
ok Uni.new(0xCD59).NFKD.list ~~ (0x110E, 0x116B, 0x11C0,), 'CD59 -> 110E 116B 11C0';
ok Uni.new(0xCD5A).NFKD.list ~~ (0x110E, 0x116B, 0x11C1,), 'CD5A -> 110E 116B 11C1';
ok Uni.new(0xCD5B).NFKD.list ~~ (0x110E, 0x116B, 0x11C2,), 'CD5B -> 110E 116B 11C2';
ok Uni.new(0xCD5C).NFKD.list ~~ (0x110E, 0x116C,), 'CD5C -> 110E 116C';
ok Uni.new(0xCD5D).NFKD.list ~~ (0x110E, 0x116C, 0x11A8,), 'CD5D -> 110E 116C 11A8';
ok Uni.new(0xCD5E).NFKD.list ~~ (0x110E, 0x116C, 0x11A9,), 'CD5E -> 110E 116C 11A9';
ok Uni.new(0xCD5F).NFKD.list ~~ (0x110E, 0x116C, 0x11AA,), 'CD5F -> 110E 116C 11AA';
ok Uni.new(0xCD60).NFKD.list ~~ (0x110E, 0x116C, 0x11AB,), 'CD60 -> 110E 116C 11AB';
ok Uni.new(0xCD61).NFKD.list ~~ (0x110E, 0x116C, 0x11AC,), 'CD61 -> 110E 116C 11AC';
ok Uni.new(0xCD62).NFKD.list ~~ (0x110E, 0x116C, 0x11AD,), 'CD62 -> 110E 116C 11AD';
ok Uni.new(0xCD63).NFKD.list ~~ (0x110E, 0x116C, 0x11AE,), 'CD63 -> 110E 116C 11AE';
ok Uni.new(0xCD64).NFKD.list ~~ (0x110E, 0x116C, 0x11AF,), 'CD64 -> 110E 116C 11AF';
ok Uni.new(0xCD65).NFKD.list ~~ (0x110E, 0x116C, 0x11B0,), 'CD65 -> 110E 116C 11B0';
ok Uni.new(0xCD66).NFKD.list ~~ (0x110E, 0x116C, 0x11B1,), 'CD66 -> 110E 116C 11B1';
ok Uni.new(0xCD67).NFKD.list ~~ (0x110E, 0x116C, 0x11B2,), 'CD67 -> 110E 116C 11B2';
ok Uni.new(0xCD68).NFKD.list ~~ (0x110E, 0x116C, 0x11B3,), 'CD68 -> 110E 116C 11B3';
ok Uni.new(0xCD69).NFKD.list ~~ (0x110E, 0x116C, 0x11B4,), 'CD69 -> 110E 116C 11B4';
ok Uni.new(0xCD6A).NFKD.list ~~ (0x110E, 0x116C, 0x11B5,), 'CD6A -> 110E 116C 11B5';
ok Uni.new(0xCD6B).NFKD.list ~~ (0x110E, 0x116C, 0x11B6,), 'CD6B -> 110E 116C 11B6';
ok Uni.new(0xCD6C).NFKD.list ~~ (0x110E, 0x116C, 0x11B7,), 'CD6C -> 110E 116C 11B7';
ok Uni.new(0xCD6D).NFKD.list ~~ (0x110E, 0x116C, 0x11B8,), 'CD6D -> 110E 116C 11B8';
ok Uni.new(0xCD6E).NFKD.list ~~ (0x110E, 0x116C, 0x11B9,), 'CD6E -> 110E 116C 11B9';
ok Uni.new(0xCD6F).NFKD.list ~~ (0x110E, 0x116C, 0x11BA,), 'CD6F -> 110E 116C 11BA';
ok Uni.new(0xCD70).NFKD.list ~~ (0x110E, 0x116C, 0x11BB,), 'CD70 -> 110E 116C 11BB';
ok Uni.new(0xCD71).NFKD.list ~~ (0x110E, 0x116C, 0x11BC,), 'CD71 -> 110E 116C 11BC';
ok Uni.new(0xCD72).NFKD.list ~~ (0x110E, 0x116C, 0x11BD,), 'CD72 -> 110E 116C 11BD';
ok Uni.new(0xCD73).NFKD.list ~~ (0x110E, 0x116C, 0x11BE,), 'CD73 -> 110E 116C 11BE';
ok Uni.new(0xCD74).NFKD.list ~~ (0x110E, 0x116C, 0x11BF,), 'CD74 -> 110E 116C 11BF';
ok Uni.new(0xCD75).NFKD.list ~~ (0x110E, 0x116C, 0x11C0,), 'CD75 -> 110E 116C 11C0';
ok Uni.new(0xCD76).NFKD.list ~~ (0x110E, 0x116C, 0x11C1,), 'CD76 -> 110E 116C 11C1';
ok Uni.new(0xCD77).NFKD.list ~~ (0x110E, 0x116C, 0x11C2,), 'CD77 -> 110E 116C 11C2';
ok Uni.new(0xCD78).NFKD.list ~~ (0x110E, 0x116D,), 'CD78 -> 110E 116D';
ok Uni.new(0xCD79).NFKD.list ~~ (0x110E, 0x116D, 0x11A8,), 'CD79 -> 110E 116D 11A8';
ok Uni.new(0xCD7A).NFKD.list ~~ (0x110E, 0x116D, 0x11A9,), 'CD7A -> 110E 116D 11A9';
ok Uni.new(0xCD7B).NFKD.list ~~ (0x110E, 0x116D, 0x11AA,), 'CD7B -> 110E 116D 11AA';
ok Uni.new(0xCD7C).NFKD.list ~~ (0x110E, 0x116D, 0x11AB,), 'CD7C -> 110E 116D 11AB';
ok Uni.new(0xCD7D).NFKD.list ~~ (0x110E, 0x116D, 0x11AC,), 'CD7D -> 110E 116D 11AC';
ok Uni.new(0xCD7E).NFKD.list ~~ (0x110E, 0x116D, 0x11AD,), 'CD7E -> 110E 116D 11AD';
ok Uni.new(0xCD7F).NFKD.list ~~ (0x110E, 0x116D, 0x11AE,), 'CD7F -> 110E 116D 11AE';
ok Uni.new(0xCD80).NFKD.list ~~ (0x110E, 0x116D, 0x11AF,), 'CD80 -> 110E 116D 11AF';
ok Uni.new(0xCD81).NFKD.list ~~ (0x110E, 0x116D, 0x11B0,), 'CD81 -> 110E 116D 11B0';
ok Uni.new(0xCD82).NFKD.list ~~ (0x110E, 0x116D, 0x11B1,), 'CD82 -> 110E 116D 11B1';
ok Uni.new(0xCD83).NFKD.list ~~ (0x110E, 0x116D, 0x11B2,), 'CD83 -> 110E 116D 11B2';
ok Uni.new(0xCD84).NFKD.list ~~ (0x110E, 0x116D, 0x11B3,), 'CD84 -> 110E 116D 11B3';
ok Uni.new(0xCD85).NFKD.list ~~ (0x110E, 0x116D, 0x11B4,), 'CD85 -> 110E 116D 11B4';
ok Uni.new(0xCD86).NFKD.list ~~ (0x110E, 0x116D, 0x11B5,), 'CD86 -> 110E 116D 11B5';
ok Uni.new(0xCD87).NFKD.list ~~ (0x110E, 0x116D, 0x11B6,), 'CD87 -> 110E 116D 11B6';
ok Uni.new(0xCD88).NFKD.list ~~ (0x110E, 0x116D, 0x11B7,), 'CD88 -> 110E 116D 11B7';
ok Uni.new(0xCD89).NFKD.list ~~ (0x110E, 0x116D, 0x11B8,), 'CD89 -> 110E 116D 11B8';
ok Uni.new(0xCD8A).NFKD.list ~~ (0x110E, 0x116D, 0x11B9,), 'CD8A -> 110E 116D 11B9';
ok Uni.new(0xCD8B).NFKD.list ~~ (0x110E, 0x116D, 0x11BA,), 'CD8B -> 110E 116D 11BA';
ok Uni.new(0xCD8C).NFKD.list ~~ (0x110E, 0x116D, 0x11BB,), 'CD8C -> 110E 116D 11BB';
ok Uni.new(0xCD8D).NFKD.list ~~ (0x110E, 0x116D, 0x11BC,), 'CD8D -> 110E 116D 11BC';
ok Uni.new(0xCD8E).NFKD.list ~~ (0x110E, 0x116D, 0x11BD,), 'CD8E -> 110E 116D 11BD';
ok Uni.new(0xCD8F).NFKD.list ~~ (0x110E, 0x116D, 0x11BE,), 'CD8F -> 110E 116D 11BE';
ok Uni.new(0xCD90).NFKD.list ~~ (0x110E, 0x116D, 0x11BF,), 'CD90 -> 110E 116D 11BF';
ok Uni.new(0xCD91).NFKD.list ~~ (0x110E, 0x116D, 0x11C0,), 'CD91 -> 110E 116D 11C0';
ok Uni.new(0xCD92).NFKD.list ~~ (0x110E, 0x116D, 0x11C1,), 'CD92 -> 110E 116D 11C1';
ok Uni.new(0xCD93).NFKD.list ~~ (0x110E, 0x116D, 0x11C2,), 'CD93 -> 110E 116D 11C2';
ok Uni.new(0xCD94).NFKD.list ~~ (0x110E, 0x116E,), 'CD94 -> 110E 116E';
ok Uni.new(0xCD95).NFKD.list ~~ (0x110E, 0x116E, 0x11A8,), 'CD95 -> 110E 116E 11A8';
ok Uni.new(0xCD96).NFKD.list ~~ (0x110E, 0x116E, 0x11A9,), 'CD96 -> 110E 116E 11A9';
ok Uni.new(0xCD97).NFKD.list ~~ (0x110E, 0x116E, 0x11AA,), 'CD97 -> 110E 116E 11AA';
ok Uni.new(0xCD98).NFKD.list ~~ (0x110E, 0x116E, 0x11AB,), 'CD98 -> 110E 116E 11AB';
ok Uni.new(0xCD99).NFKD.list ~~ (0x110E, 0x116E, 0x11AC,), 'CD99 -> 110E 116E 11AC';
ok Uni.new(0xCD9A).NFKD.list ~~ (0x110E, 0x116E, 0x11AD,), 'CD9A -> 110E 116E 11AD';
ok Uni.new(0xCD9B).NFKD.list ~~ (0x110E, 0x116E, 0x11AE,), 'CD9B -> 110E 116E 11AE';
ok Uni.new(0xCD9C).NFKD.list ~~ (0x110E, 0x116E, 0x11AF,), 'CD9C -> 110E 116E 11AF';
ok Uni.new(0xCD9D).NFKD.list ~~ (0x110E, 0x116E, 0x11B0,), 'CD9D -> 110E 116E 11B0';
ok Uni.new(0xCD9E).NFKD.list ~~ (0x110E, 0x116E, 0x11B1,), 'CD9E -> 110E 116E 11B1';
ok Uni.new(0xCD9F).NFKD.list ~~ (0x110E, 0x116E, 0x11B2,), 'CD9F -> 110E 116E 11B2';
ok Uni.new(0xCDA0).NFKD.list ~~ (0x110E, 0x116E, 0x11B3,), 'CDA0 -> 110E 116E 11B3';
ok Uni.new(0xCDA1).NFKD.list ~~ (0x110E, 0x116E, 0x11B4,), 'CDA1 -> 110E 116E 11B4';
ok Uni.new(0xCDA2).NFKD.list ~~ (0x110E, 0x116E, 0x11B5,), 'CDA2 -> 110E 116E 11B5';
ok Uni.new(0xCDA3).NFKD.list ~~ (0x110E, 0x116E, 0x11B6,), 'CDA3 -> 110E 116E 11B6';
ok Uni.new(0xCDA4).NFKD.list ~~ (0x110E, 0x116E, 0x11B7,), 'CDA4 -> 110E 116E 11B7';
ok Uni.new(0xCDA5).NFKD.list ~~ (0x110E, 0x116E, 0x11B8,), 'CDA5 -> 110E 116E 11B8';
ok Uni.new(0xCDA6).NFKD.list ~~ (0x110E, 0x116E, 0x11B9,), 'CDA6 -> 110E 116E 11B9';
ok Uni.new(0xCDA7).NFKD.list ~~ (0x110E, 0x116E, 0x11BA,), 'CDA7 -> 110E 116E 11BA';
ok Uni.new(0xCDA8).NFKD.list ~~ (0x110E, 0x116E, 0x11BB,), 'CDA8 -> 110E 116E 11BB';
ok Uni.new(0xCDA9).NFKD.list ~~ (0x110E, 0x116E, 0x11BC,), 'CDA9 -> 110E 116E 11BC';
ok Uni.new(0xCDAA).NFKD.list ~~ (0x110E, 0x116E, 0x11BD,), 'CDAA -> 110E 116E 11BD';
ok Uni.new(0xCDAB).NFKD.list ~~ (0x110E, 0x116E, 0x11BE,), 'CDAB -> 110E 116E 11BE';
ok Uni.new(0xCDAC).NFKD.list ~~ (0x110E, 0x116E, 0x11BF,), 'CDAC -> 110E 116E 11BF';
ok Uni.new(0xCDAD).NFKD.list ~~ (0x110E, 0x116E, 0x11C0,), 'CDAD -> 110E 116E 11C0';
ok Uni.new(0xCDAE).NFKD.list ~~ (0x110E, 0x116E, 0x11C1,), 'CDAE -> 110E 116E 11C1';
ok Uni.new(0xCDAF).NFKD.list ~~ (0x110E, 0x116E, 0x11C2,), 'CDAF -> 110E 116E 11C2';
ok Uni.new(0xCDB0).NFKD.list ~~ (0x110E, 0x116F,), 'CDB0 -> 110E 116F';
ok Uni.new(0xCDB1).NFKD.list ~~ (0x110E, 0x116F, 0x11A8,), 'CDB1 -> 110E 116F 11A8';
ok Uni.new(0xCDB2).NFKD.list ~~ (0x110E, 0x116F, 0x11A9,), 'CDB2 -> 110E 116F 11A9';
ok Uni.new(0xCDB3).NFKD.list ~~ (0x110E, 0x116F, 0x11AA,), 'CDB3 -> 110E 116F 11AA';
ok Uni.new(0xCDB4).NFKD.list ~~ (0x110E, 0x116F, 0x11AB,), 'CDB4 -> 110E 116F 11AB';
ok Uni.new(0xCDB5).NFKD.list ~~ (0x110E, 0x116F, 0x11AC,), 'CDB5 -> 110E 116F 11AC';
ok Uni.new(0xCDB6).NFKD.list ~~ (0x110E, 0x116F, 0x11AD,), 'CDB6 -> 110E 116F 11AD';
ok Uni.new(0xCDB7).NFKD.list ~~ (0x110E, 0x116F, 0x11AE,), 'CDB7 -> 110E 116F 11AE';
ok Uni.new(0xCDB8).NFKD.list ~~ (0x110E, 0x116F, 0x11AF,), 'CDB8 -> 110E 116F 11AF';
ok Uni.new(0xCDB9).NFKD.list ~~ (0x110E, 0x116F, 0x11B0,), 'CDB9 -> 110E 116F 11B0';
ok Uni.new(0xCDBA).NFKD.list ~~ (0x110E, 0x116F, 0x11B1,), 'CDBA -> 110E 116F 11B1';
ok Uni.new(0xCDBB).NFKD.list ~~ (0x110E, 0x116F, 0x11B2,), 'CDBB -> 110E 116F 11B2';
ok Uni.new(0xCDBC).NFKD.list ~~ (0x110E, 0x116F, 0x11B3,), 'CDBC -> 110E 116F 11B3';
ok Uni.new(0xCDBD).NFKD.list ~~ (0x110E, 0x116F, 0x11B4,), 'CDBD -> 110E 116F 11B4';
ok Uni.new(0xCDBE).NFKD.list ~~ (0x110E, 0x116F, 0x11B5,), 'CDBE -> 110E 116F 11B5';
ok Uni.new(0xCDBF).NFKD.list ~~ (0x110E, 0x116F, 0x11B6,), 'CDBF -> 110E 116F 11B6';
ok Uni.new(0xCDC0).NFKD.list ~~ (0x110E, 0x116F, 0x11B7,), 'CDC0 -> 110E 116F 11B7';
ok Uni.new(0xCDC1).NFKD.list ~~ (0x110E, 0x116F, 0x11B8,), 'CDC1 -> 110E 116F 11B8';
ok Uni.new(0xCDC2).NFKD.list ~~ (0x110E, 0x116F, 0x11B9,), 'CDC2 -> 110E 116F 11B9';
ok Uni.new(0xCDC3).NFKD.list ~~ (0x110E, 0x116F, 0x11BA,), 'CDC3 -> 110E 116F 11BA';
ok Uni.new(0xCDC4).NFKD.list ~~ (0x110E, 0x116F, 0x11BB,), 'CDC4 -> 110E 116F 11BB';
ok Uni.new(0xCDC5).NFKD.list ~~ (0x110E, 0x116F, 0x11BC,), 'CDC5 -> 110E 116F 11BC';
ok Uni.new(0xCDC6).NFKD.list ~~ (0x110E, 0x116F, 0x11BD,), 'CDC6 -> 110E 116F 11BD';
ok Uni.new(0xCDC7).NFKD.list ~~ (0x110E, 0x116F, 0x11BE,), 'CDC7 -> 110E 116F 11BE';
ok Uni.new(0xCDC8).NFKD.list ~~ (0x110E, 0x116F, 0x11BF,), 'CDC8 -> 110E 116F 11BF';
ok Uni.new(0xCDC9).NFKD.list ~~ (0x110E, 0x116F, 0x11C0,), 'CDC9 -> 110E 116F 11C0';
ok Uni.new(0xCDCA).NFKD.list ~~ (0x110E, 0x116F, 0x11C1,), 'CDCA -> 110E 116F 11C1';
ok Uni.new(0xCDCB).NFKD.list ~~ (0x110E, 0x116F, 0x11C2,), 'CDCB -> 110E 116F 11C2';
ok Uni.new(0xCDCC).NFKD.list ~~ (0x110E, 0x1170,), 'CDCC -> 110E 1170';
ok Uni.new(0xCDCD).NFKD.list ~~ (0x110E, 0x1170, 0x11A8,), 'CDCD -> 110E 1170 11A8';
ok Uni.new(0xCDCE).NFKD.list ~~ (0x110E, 0x1170, 0x11A9,), 'CDCE -> 110E 1170 11A9';
ok Uni.new(0xCDCF).NFKD.list ~~ (0x110E, 0x1170, 0x11AA,), 'CDCF -> 110E 1170 11AA';
ok Uni.new(0xCDD0).NFKD.list ~~ (0x110E, 0x1170, 0x11AB,), 'CDD0 -> 110E 1170 11AB';
ok Uni.new(0xCDD1).NFKD.list ~~ (0x110E, 0x1170, 0x11AC,), 'CDD1 -> 110E 1170 11AC';
ok Uni.new(0xCDD2).NFKD.list ~~ (0x110E, 0x1170, 0x11AD,), 'CDD2 -> 110E 1170 11AD';
ok Uni.new(0xCDD3).NFKD.list ~~ (0x110E, 0x1170, 0x11AE,), 'CDD3 -> 110E 1170 11AE';
ok Uni.new(0xCDD4).NFKD.list ~~ (0x110E, 0x1170, 0x11AF,), 'CDD4 -> 110E 1170 11AF';
ok Uni.new(0xCDD5).NFKD.list ~~ (0x110E, 0x1170, 0x11B0,), 'CDD5 -> 110E 1170 11B0';
ok Uni.new(0xCDD6).NFKD.list ~~ (0x110E, 0x1170, 0x11B1,), 'CDD6 -> 110E 1170 11B1';
ok Uni.new(0xCDD7).NFKD.list ~~ (0x110E, 0x1170, 0x11B2,), 'CDD7 -> 110E 1170 11B2';
ok Uni.new(0xCDD8).NFKD.list ~~ (0x110E, 0x1170, 0x11B3,), 'CDD8 -> 110E 1170 11B3';
ok Uni.new(0xCDD9).NFKD.list ~~ (0x110E, 0x1170, 0x11B4,), 'CDD9 -> 110E 1170 11B4';
ok Uni.new(0xCDDA).NFKD.list ~~ (0x110E, 0x1170, 0x11B5,), 'CDDA -> 110E 1170 11B5';
ok Uni.new(0xCDDB).NFKD.list ~~ (0x110E, 0x1170, 0x11B6,), 'CDDB -> 110E 1170 11B6';
ok Uni.new(0xCDDC).NFKD.list ~~ (0x110E, 0x1170, 0x11B7,), 'CDDC -> 110E 1170 11B7';
ok Uni.new(0xCDDD).NFKD.list ~~ (0x110E, 0x1170, 0x11B8,), 'CDDD -> 110E 1170 11B8';
ok Uni.new(0xCDDE).NFKD.list ~~ (0x110E, 0x1170, 0x11B9,), 'CDDE -> 110E 1170 11B9';
ok Uni.new(0xCDDF).NFKD.list ~~ (0x110E, 0x1170, 0x11BA,), 'CDDF -> 110E 1170 11BA';
ok Uni.new(0xCDE0).NFKD.list ~~ (0x110E, 0x1170, 0x11BB,), 'CDE0 -> 110E 1170 11BB';
ok Uni.new(0xCDE1).NFKD.list ~~ (0x110E, 0x1170, 0x11BC,), 'CDE1 -> 110E 1170 11BC';
ok Uni.new(0xCDE2).NFKD.list ~~ (0x110E, 0x1170, 0x11BD,), 'CDE2 -> 110E 1170 11BD';
ok Uni.new(0xCDE3).NFKD.list ~~ (0x110E, 0x1170, 0x11BE,), 'CDE3 -> 110E 1170 11BE';
ok Uni.new(0xCDE4).NFKD.list ~~ (0x110E, 0x1170, 0x11BF,), 'CDE4 -> 110E 1170 11BF';
ok Uni.new(0xCDE5).NFKD.list ~~ (0x110E, 0x1170, 0x11C0,), 'CDE5 -> 110E 1170 11C0';
ok Uni.new(0xCDE6).NFKD.list ~~ (0x110E, 0x1170, 0x11C1,), 'CDE6 -> 110E 1170 11C1';
ok Uni.new(0xCDE7).NFKD.list ~~ (0x110E, 0x1170, 0x11C2,), 'CDE7 -> 110E 1170 11C2';
ok Uni.new(0xCDE8).NFKD.list ~~ (0x110E, 0x1171,), 'CDE8 -> 110E 1171';
ok Uni.new(0xCDE9).NFKD.list ~~ (0x110E, 0x1171, 0x11A8,), 'CDE9 -> 110E 1171 11A8';
ok Uni.new(0xCDEA).NFKD.list ~~ (0x110E, 0x1171, 0x11A9,), 'CDEA -> 110E 1171 11A9';
ok Uni.new(0xCDEB).NFKD.list ~~ (0x110E, 0x1171, 0x11AA,), 'CDEB -> 110E 1171 11AA';
ok Uni.new(0xCDEC).NFKD.list ~~ (0x110E, 0x1171, 0x11AB,), 'CDEC -> 110E 1171 11AB';
ok Uni.new(0xCDED).NFKD.list ~~ (0x110E, 0x1171, 0x11AC,), 'CDED -> 110E 1171 11AC';
ok Uni.new(0xCDEE).NFKD.list ~~ (0x110E, 0x1171, 0x11AD,), 'CDEE -> 110E 1171 11AD';
ok Uni.new(0xCDEF).NFKD.list ~~ (0x110E, 0x1171, 0x11AE,), 'CDEF -> 110E 1171 11AE';
ok Uni.new(0xCDF0).NFKD.list ~~ (0x110E, 0x1171, 0x11AF,), 'CDF0 -> 110E 1171 11AF';
ok Uni.new(0xCDF1).NFKD.list ~~ (0x110E, 0x1171, 0x11B0,), 'CDF1 -> 110E 1171 11B0';
ok Uni.new(0xCDF2).NFKD.list ~~ (0x110E, 0x1171, 0x11B1,), 'CDF2 -> 110E 1171 11B1';
ok Uni.new(0xCDF3).NFKD.list ~~ (0x110E, 0x1171, 0x11B2,), 'CDF3 -> 110E 1171 11B2';
ok Uni.new(0xCDF4).NFKD.list ~~ (0x110E, 0x1171, 0x11B3,), 'CDF4 -> 110E 1171 11B3';
ok Uni.new(0xCDF5).NFKD.list ~~ (0x110E, 0x1171, 0x11B4,), 'CDF5 -> 110E 1171 11B4';
ok Uni.new(0xCDF6).NFKD.list ~~ (0x110E, 0x1171, 0x11B5,), 'CDF6 -> 110E 1171 11B5';
ok Uni.new(0xCDF7).NFKD.list ~~ (0x110E, 0x1171, 0x11B6,), 'CDF7 -> 110E 1171 11B6';
ok Uni.new(0xCDF8).NFKD.list ~~ (0x110E, 0x1171, 0x11B7,), 'CDF8 -> 110E 1171 11B7';
ok Uni.new(0xCDF9).NFKD.list ~~ (0x110E, 0x1171, 0x11B8,), 'CDF9 -> 110E 1171 11B8';
ok Uni.new(0xCDFA).NFKD.list ~~ (0x110E, 0x1171, 0x11B9,), 'CDFA -> 110E 1171 11B9';
ok Uni.new(0xCDFB).NFKD.list ~~ (0x110E, 0x1171, 0x11BA,), 'CDFB -> 110E 1171 11BA';
ok Uni.new(0xCDFC).NFKD.list ~~ (0x110E, 0x1171, 0x11BB,), 'CDFC -> 110E 1171 11BB';
ok Uni.new(0xCDFD).NFKD.list ~~ (0x110E, 0x1171, 0x11BC,), 'CDFD -> 110E 1171 11BC';
ok Uni.new(0xCDFE).NFKD.list ~~ (0x110E, 0x1171, 0x11BD,), 'CDFE -> 110E 1171 11BD';
ok Uni.new(0xCDFF).NFKD.list ~~ (0x110E, 0x1171, 0x11BE,), 'CDFF -> 110E 1171 11BE';
ok Uni.new(0xCE00).NFKD.list ~~ (0x110E, 0x1171, 0x11BF,), 'CE00 -> 110E 1171 11BF';
ok Uni.new(0xCE01).NFKD.list ~~ (0x110E, 0x1171, 0x11C0,), 'CE01 -> 110E 1171 11C0';
ok Uni.new(0xCE02).NFKD.list ~~ (0x110E, 0x1171, 0x11C1,), 'CE02 -> 110E 1171 11C1';
ok Uni.new(0xCE03).NFKD.list ~~ (0x110E, 0x1171, 0x11C2,), 'CE03 -> 110E 1171 11C2';
ok Uni.new(0xCE04).NFKD.list ~~ (0x110E, 0x1172,), 'CE04 -> 110E 1172';
ok Uni.new(0xCE05).NFKD.list ~~ (0x110E, 0x1172, 0x11A8,), 'CE05 -> 110E 1172 11A8';
ok Uni.new(0xCE06).NFKD.list ~~ (0x110E, 0x1172, 0x11A9,), 'CE06 -> 110E 1172 11A9';
ok Uni.new(0xCE07).NFKD.list ~~ (0x110E, 0x1172, 0x11AA,), 'CE07 -> 110E 1172 11AA';
ok Uni.new(0xCE08).NFKD.list ~~ (0x110E, 0x1172, 0x11AB,), 'CE08 -> 110E 1172 11AB';
ok Uni.new(0xCE09).NFKD.list ~~ (0x110E, 0x1172, 0x11AC,), 'CE09 -> 110E 1172 11AC';
ok Uni.new(0xCE0A).NFKD.list ~~ (0x110E, 0x1172, 0x11AD,), 'CE0A -> 110E 1172 11AD';
ok Uni.new(0xCE0B).NFKD.list ~~ (0x110E, 0x1172, 0x11AE,), 'CE0B -> 110E 1172 11AE';
ok Uni.new(0xCE0C).NFKD.list ~~ (0x110E, 0x1172, 0x11AF,), 'CE0C -> 110E 1172 11AF';
ok Uni.new(0xCE0D).NFKD.list ~~ (0x110E, 0x1172, 0x11B0,), 'CE0D -> 110E 1172 11B0';
ok Uni.new(0xCE0E).NFKD.list ~~ (0x110E, 0x1172, 0x11B1,), 'CE0E -> 110E 1172 11B1';
ok Uni.new(0xCE0F).NFKD.list ~~ (0x110E, 0x1172, 0x11B2,), 'CE0F -> 110E 1172 11B2';
ok Uni.new(0xCE10).NFKD.list ~~ (0x110E, 0x1172, 0x11B3,), 'CE10 -> 110E 1172 11B3';
ok Uni.new(0xCE11).NFKD.list ~~ (0x110E, 0x1172, 0x11B4,), 'CE11 -> 110E 1172 11B4';
ok Uni.new(0xCE12).NFKD.list ~~ (0x110E, 0x1172, 0x11B5,), 'CE12 -> 110E 1172 11B5';
ok Uni.new(0xCE13).NFKD.list ~~ (0x110E, 0x1172, 0x11B6,), 'CE13 -> 110E 1172 11B6';
ok Uni.new(0xCE14).NFKD.list ~~ (0x110E, 0x1172, 0x11B7,), 'CE14 -> 110E 1172 11B7';
ok Uni.new(0xCE15).NFKD.list ~~ (0x110E, 0x1172, 0x11B8,), 'CE15 -> 110E 1172 11B8';
ok Uni.new(0xCE16).NFKD.list ~~ (0x110E, 0x1172, 0x11B9,), 'CE16 -> 110E 1172 11B9';
ok Uni.new(0xCE17).NFKD.list ~~ (0x110E, 0x1172, 0x11BA,), 'CE17 -> 110E 1172 11BA';
ok Uni.new(0xCE18).NFKD.list ~~ (0x110E, 0x1172, 0x11BB,), 'CE18 -> 110E 1172 11BB';
ok Uni.new(0xCE19).NFKD.list ~~ (0x110E, 0x1172, 0x11BC,), 'CE19 -> 110E 1172 11BC';
ok Uni.new(0xCE1A).NFKD.list ~~ (0x110E, 0x1172, 0x11BD,), 'CE1A -> 110E 1172 11BD';
ok Uni.new(0xCE1B).NFKD.list ~~ (0x110E, 0x1172, 0x11BE,), 'CE1B -> 110E 1172 11BE';
ok Uni.new(0xCE1C).NFKD.list ~~ (0x110E, 0x1172, 0x11BF,), 'CE1C -> 110E 1172 11BF';
ok Uni.new(0xCE1D).NFKD.list ~~ (0x110E, 0x1172, 0x11C0,), 'CE1D -> 110E 1172 11C0';
ok Uni.new(0xCE1E).NFKD.list ~~ (0x110E, 0x1172, 0x11C1,), 'CE1E -> 110E 1172 11C1';
ok Uni.new(0xCE1F).NFKD.list ~~ (0x110E, 0x1172, 0x11C2,), 'CE1F -> 110E 1172 11C2';
ok Uni.new(0xCE20).NFKD.list ~~ (0x110E, 0x1173,), 'CE20 -> 110E 1173';
ok Uni.new(0xCE21).NFKD.list ~~ (0x110E, 0x1173, 0x11A8,), 'CE21 -> 110E 1173 11A8';
ok Uni.new(0xCE22).NFKD.list ~~ (0x110E, 0x1173, 0x11A9,), 'CE22 -> 110E 1173 11A9';
ok Uni.new(0xCE23).NFKD.list ~~ (0x110E, 0x1173, 0x11AA,), 'CE23 -> 110E 1173 11AA';
ok Uni.new(0xCE24).NFKD.list ~~ (0x110E, 0x1173, 0x11AB,), 'CE24 -> 110E 1173 11AB';
ok Uni.new(0xCE25).NFKD.list ~~ (0x110E, 0x1173, 0x11AC,), 'CE25 -> 110E 1173 11AC';
ok Uni.new(0xCE26).NFKD.list ~~ (0x110E, 0x1173, 0x11AD,), 'CE26 -> 110E 1173 11AD';
ok Uni.new(0xCE27).NFKD.list ~~ (0x110E, 0x1173, 0x11AE,), 'CE27 -> 110E 1173 11AE';
ok Uni.new(0xCE28).NFKD.list ~~ (0x110E, 0x1173, 0x11AF,), 'CE28 -> 110E 1173 11AF';
ok Uni.new(0xCE29).NFKD.list ~~ (0x110E, 0x1173, 0x11B0,), 'CE29 -> 110E 1173 11B0';
ok Uni.new(0xCE2A).NFKD.list ~~ (0x110E, 0x1173, 0x11B1,), 'CE2A -> 110E 1173 11B1';
ok Uni.new(0xCE2B).NFKD.list ~~ (0x110E, 0x1173, 0x11B2,), 'CE2B -> 110E 1173 11B2';
ok Uni.new(0xCE2C).NFKD.list ~~ (0x110E, 0x1173, 0x11B3,), 'CE2C -> 110E 1173 11B3';
ok Uni.new(0xCE2D).NFKD.list ~~ (0x110E, 0x1173, 0x11B4,), 'CE2D -> 110E 1173 11B4';
ok Uni.new(0xCE2E).NFKD.list ~~ (0x110E, 0x1173, 0x11B5,), 'CE2E -> 110E 1173 11B5';
ok Uni.new(0xCE2F).NFKD.list ~~ (0x110E, 0x1173, 0x11B6,), 'CE2F -> 110E 1173 11B6';
ok Uni.new(0xCE30).NFKD.list ~~ (0x110E, 0x1173, 0x11B7,), 'CE30 -> 110E 1173 11B7';
ok Uni.new(0xCE31).NFKD.list ~~ (0x110E, 0x1173, 0x11B8,), 'CE31 -> 110E 1173 11B8';
ok Uni.new(0xCE32).NFKD.list ~~ (0x110E, 0x1173, 0x11B9,), 'CE32 -> 110E 1173 11B9';
ok Uni.new(0xCE33).NFKD.list ~~ (0x110E, 0x1173, 0x11BA,), 'CE33 -> 110E 1173 11BA';
ok Uni.new(0xCE34).NFKD.list ~~ (0x110E, 0x1173, 0x11BB,), 'CE34 -> 110E 1173 11BB';
ok Uni.new(0xCE35).NFKD.list ~~ (0x110E, 0x1173, 0x11BC,), 'CE35 -> 110E 1173 11BC';
ok Uni.new(0xCE36).NFKD.list ~~ (0x110E, 0x1173, 0x11BD,), 'CE36 -> 110E 1173 11BD';
ok Uni.new(0xCE37).NFKD.list ~~ (0x110E, 0x1173, 0x11BE,), 'CE37 -> 110E 1173 11BE';
ok Uni.new(0xCE38).NFKD.list ~~ (0x110E, 0x1173, 0x11BF,), 'CE38 -> 110E 1173 11BF';
ok Uni.new(0xCE39).NFKD.list ~~ (0x110E, 0x1173, 0x11C0,), 'CE39 -> 110E 1173 11C0';
ok Uni.new(0xCE3A).NFKD.list ~~ (0x110E, 0x1173, 0x11C1,), 'CE3A -> 110E 1173 11C1';
ok Uni.new(0xCE3B).NFKD.list ~~ (0x110E, 0x1173, 0x11C2,), 'CE3B -> 110E 1173 11C2';
ok Uni.new(0xCE3C).NFKD.list ~~ (0x110E, 0x1174,), 'CE3C -> 110E 1174';
ok Uni.new(0xCE3D).NFKD.list ~~ (0x110E, 0x1174, 0x11A8,), 'CE3D -> 110E 1174 11A8';
ok Uni.new(0xCE3E).NFKD.list ~~ (0x110E, 0x1174, 0x11A9,), 'CE3E -> 110E 1174 11A9';
ok Uni.new(0xCE3F).NFKD.list ~~ (0x110E, 0x1174, 0x11AA,), 'CE3F -> 110E 1174 11AA';
ok Uni.new(0xCE40).NFKD.list ~~ (0x110E, 0x1174, 0x11AB,), 'CE40 -> 110E 1174 11AB';
ok Uni.new(0xCE41).NFKD.list ~~ (0x110E, 0x1174, 0x11AC,), 'CE41 -> 110E 1174 11AC';
ok Uni.new(0xCE42).NFKD.list ~~ (0x110E, 0x1174, 0x11AD,), 'CE42 -> 110E 1174 11AD';
ok Uni.new(0xCE43).NFKD.list ~~ (0x110E, 0x1174, 0x11AE,), 'CE43 -> 110E 1174 11AE';
ok Uni.new(0xCE44).NFKD.list ~~ (0x110E, 0x1174, 0x11AF,), 'CE44 -> 110E 1174 11AF';
ok Uni.new(0xCE45).NFKD.list ~~ (0x110E, 0x1174, 0x11B0,), 'CE45 -> 110E 1174 11B0';
ok Uni.new(0xCE46).NFKD.list ~~ (0x110E, 0x1174, 0x11B1,), 'CE46 -> 110E 1174 11B1';
ok Uni.new(0xCE47).NFKD.list ~~ (0x110E, 0x1174, 0x11B2,), 'CE47 -> 110E 1174 11B2';
ok Uni.new(0xCE48).NFKD.list ~~ (0x110E, 0x1174, 0x11B3,), 'CE48 -> 110E 1174 11B3';
ok Uni.new(0xCE49).NFKD.list ~~ (0x110E, 0x1174, 0x11B4,), 'CE49 -> 110E 1174 11B4';
ok Uni.new(0xCE4A).NFKD.list ~~ (0x110E, 0x1174, 0x11B5,), 'CE4A -> 110E 1174 11B5';
ok Uni.new(0xCE4B).NFKD.list ~~ (0x110E, 0x1174, 0x11B6,), 'CE4B -> 110E 1174 11B6';
ok Uni.new(0xCE4C).NFKD.list ~~ (0x110E, 0x1174, 0x11B7,), 'CE4C -> 110E 1174 11B7';
ok Uni.new(0xCE4D).NFKD.list ~~ (0x110E, 0x1174, 0x11B8,), 'CE4D -> 110E 1174 11B8';
ok Uni.new(0xCE4E).NFKD.list ~~ (0x110E, 0x1174, 0x11B9,), 'CE4E -> 110E 1174 11B9';
ok Uni.new(0xCE4F).NFKD.list ~~ (0x110E, 0x1174, 0x11BA,), 'CE4F -> 110E 1174 11BA';
ok Uni.new(0xCE50).NFKD.list ~~ (0x110E, 0x1174, 0x11BB,), 'CE50 -> 110E 1174 11BB';
ok Uni.new(0xCE51).NFKD.list ~~ (0x110E, 0x1174, 0x11BC,), 'CE51 -> 110E 1174 11BC';
ok Uni.new(0xCE52).NFKD.list ~~ (0x110E, 0x1174, 0x11BD,), 'CE52 -> 110E 1174 11BD';
ok Uni.new(0xCE53).NFKD.list ~~ (0x110E, 0x1174, 0x11BE,), 'CE53 -> 110E 1174 11BE';
ok Uni.new(0xCE54).NFKD.list ~~ (0x110E, 0x1174, 0x11BF,), 'CE54 -> 110E 1174 11BF';
ok Uni.new(0xCE55).NFKD.list ~~ (0x110E, 0x1174, 0x11C0,), 'CE55 -> 110E 1174 11C0';
ok Uni.new(0xCE56).NFKD.list ~~ (0x110E, 0x1174, 0x11C1,), 'CE56 -> 110E 1174 11C1';
ok Uni.new(0xCE57).NFKD.list ~~ (0x110E, 0x1174, 0x11C2,), 'CE57 -> 110E 1174 11C2';
ok Uni.new(0xCE58).NFKD.list ~~ (0x110E, 0x1175,), 'CE58 -> 110E 1175';
ok Uni.new(0xCE59).NFKD.list ~~ (0x110E, 0x1175, 0x11A8,), 'CE59 -> 110E 1175 11A8';
ok Uni.new(0xCE5A).NFKD.list ~~ (0x110E, 0x1175, 0x11A9,), 'CE5A -> 110E 1175 11A9';
ok Uni.new(0xCE5B).NFKD.list ~~ (0x110E, 0x1175, 0x11AA,), 'CE5B -> 110E 1175 11AA';
ok Uni.new(0xCE5C).NFKD.list ~~ (0x110E, 0x1175, 0x11AB,), 'CE5C -> 110E 1175 11AB';
ok Uni.new(0xCE5D).NFKD.list ~~ (0x110E, 0x1175, 0x11AC,), 'CE5D -> 110E 1175 11AC';
ok Uni.new(0xCE5E).NFKD.list ~~ (0x110E, 0x1175, 0x11AD,), 'CE5E -> 110E 1175 11AD';
ok Uni.new(0xCE5F).NFKD.list ~~ (0x110E, 0x1175, 0x11AE,), 'CE5F -> 110E 1175 11AE';
ok Uni.new(0xCE60).NFKD.list ~~ (0x110E, 0x1175, 0x11AF,), 'CE60 -> 110E 1175 11AF';
ok Uni.new(0xCE61).NFKD.list ~~ (0x110E, 0x1175, 0x11B0,), 'CE61 -> 110E 1175 11B0';
ok Uni.new(0xCE62).NFKD.list ~~ (0x110E, 0x1175, 0x11B1,), 'CE62 -> 110E 1175 11B1';
ok Uni.new(0xCE63).NFKD.list ~~ (0x110E, 0x1175, 0x11B2,), 'CE63 -> 110E 1175 11B2';
ok Uni.new(0xCE64).NFKD.list ~~ (0x110E, 0x1175, 0x11B3,), 'CE64 -> 110E 1175 11B3';
ok Uni.new(0xCE65).NFKD.list ~~ (0x110E, 0x1175, 0x11B4,), 'CE65 -> 110E 1175 11B4';
ok Uni.new(0xCE66).NFKD.list ~~ (0x110E, 0x1175, 0x11B5,), 'CE66 -> 110E 1175 11B5';
ok Uni.new(0xCE67).NFKD.list ~~ (0x110E, 0x1175, 0x11B6,), 'CE67 -> 110E 1175 11B6';
ok Uni.new(0xCE68).NFKD.list ~~ (0x110E, 0x1175, 0x11B7,), 'CE68 -> 110E 1175 11B7';
ok Uni.new(0xCE69).NFKD.list ~~ (0x110E, 0x1175, 0x11B8,), 'CE69 -> 110E 1175 11B8';
ok Uni.new(0xCE6A).NFKD.list ~~ (0x110E, 0x1175, 0x11B9,), 'CE6A -> 110E 1175 11B9';
ok Uni.new(0xCE6B).NFKD.list ~~ (0x110E, 0x1175, 0x11BA,), 'CE6B -> 110E 1175 11BA';
ok Uni.new(0xCE6C).NFKD.list ~~ (0x110E, 0x1175, 0x11BB,), 'CE6C -> 110E 1175 11BB';
ok Uni.new(0xCE6D).NFKD.list ~~ (0x110E, 0x1175, 0x11BC,), 'CE6D -> 110E 1175 11BC';
ok Uni.new(0xCE6E).NFKD.list ~~ (0x110E, 0x1175, 0x11BD,), 'CE6E -> 110E 1175 11BD';
ok Uni.new(0xCE6F).NFKD.list ~~ (0x110E, 0x1175, 0x11BE,), 'CE6F -> 110E 1175 11BE';
ok Uni.new(0xCE70).NFKD.list ~~ (0x110E, 0x1175, 0x11BF,), 'CE70 -> 110E 1175 11BF';
ok Uni.new(0xCE71).NFKD.list ~~ (0x110E, 0x1175, 0x11C0,), 'CE71 -> 110E 1175 11C0';
ok Uni.new(0xCE72).NFKD.list ~~ (0x110E, 0x1175, 0x11C1,), 'CE72 -> 110E 1175 11C1';
ok Uni.new(0xCE73).NFKD.list ~~ (0x110E, 0x1175, 0x11C2,), 'CE73 -> 110E 1175 11C2';
ok Uni.new(0xCE74).NFKD.list ~~ (0x110F, 0x1161,), 'CE74 -> 110F 1161';
ok Uni.new(0xCE75).NFKD.list ~~ (0x110F, 0x1161, 0x11A8,), 'CE75 -> 110F 1161 11A8';
ok Uni.new(0xCE76).NFKD.list ~~ (0x110F, 0x1161, 0x11A9,), 'CE76 -> 110F 1161 11A9';
ok Uni.new(0xCE77).NFKD.list ~~ (0x110F, 0x1161, 0x11AA,), 'CE77 -> 110F 1161 11AA';
ok Uni.new(0xCE78).NFKD.list ~~ (0x110F, 0x1161, 0x11AB,), 'CE78 -> 110F 1161 11AB';
ok Uni.new(0xCE79).NFKD.list ~~ (0x110F, 0x1161, 0x11AC,), 'CE79 -> 110F 1161 11AC';
ok Uni.new(0xCE7A).NFKD.list ~~ (0x110F, 0x1161, 0x11AD,), 'CE7A -> 110F 1161 11AD';
ok Uni.new(0xCE7B).NFKD.list ~~ (0x110F, 0x1161, 0x11AE,), 'CE7B -> 110F 1161 11AE';
ok Uni.new(0xCE7C).NFKD.list ~~ (0x110F, 0x1161, 0x11AF,), 'CE7C -> 110F 1161 11AF';
ok Uni.new(0xCE7D).NFKD.list ~~ (0x110F, 0x1161, 0x11B0,), 'CE7D -> 110F 1161 11B0';
ok Uni.new(0xCE7E).NFKD.list ~~ (0x110F, 0x1161, 0x11B1,), 'CE7E -> 110F 1161 11B1';
ok Uni.new(0xCE7F).NFKD.list ~~ (0x110F, 0x1161, 0x11B2,), 'CE7F -> 110F 1161 11B2';
ok Uni.new(0xCE80).NFKD.list ~~ (0x110F, 0x1161, 0x11B3,), 'CE80 -> 110F 1161 11B3';
ok Uni.new(0xCE81).NFKD.list ~~ (0x110F, 0x1161, 0x11B4,), 'CE81 -> 110F 1161 11B4';
ok Uni.new(0xCE82).NFKD.list ~~ (0x110F, 0x1161, 0x11B5,), 'CE82 -> 110F 1161 11B5';
ok Uni.new(0xCE83).NFKD.list ~~ (0x110F, 0x1161, 0x11B6,), 'CE83 -> 110F 1161 11B6';
ok Uni.new(0xCE84).NFKD.list ~~ (0x110F, 0x1161, 0x11B7,), 'CE84 -> 110F 1161 11B7';
ok Uni.new(0xCE85).NFKD.list ~~ (0x110F, 0x1161, 0x11B8,), 'CE85 -> 110F 1161 11B8';
ok Uni.new(0xCE86).NFKD.list ~~ (0x110F, 0x1161, 0x11B9,), 'CE86 -> 110F 1161 11B9';
ok Uni.new(0xCE87).NFKD.list ~~ (0x110F, 0x1161, 0x11BA,), 'CE87 -> 110F 1161 11BA';
ok Uni.new(0xCE88).NFKD.list ~~ (0x110F, 0x1161, 0x11BB,), 'CE88 -> 110F 1161 11BB';
ok Uni.new(0xCE89).NFKD.list ~~ (0x110F, 0x1161, 0x11BC,), 'CE89 -> 110F 1161 11BC';
ok Uni.new(0xCE8A).NFKD.list ~~ (0x110F, 0x1161, 0x11BD,), 'CE8A -> 110F 1161 11BD';
ok Uni.new(0xCE8B).NFKD.list ~~ (0x110F, 0x1161, 0x11BE,), 'CE8B -> 110F 1161 11BE';
ok Uni.new(0xCE8C).NFKD.list ~~ (0x110F, 0x1161, 0x11BF,), 'CE8C -> 110F 1161 11BF';
ok Uni.new(0xCE8D).NFKD.list ~~ (0x110F, 0x1161, 0x11C0,), 'CE8D -> 110F 1161 11C0';
ok Uni.new(0xCE8E).NFKD.list ~~ (0x110F, 0x1161, 0x11C1,), 'CE8E -> 110F 1161 11C1';
ok Uni.new(0xCE8F).NFKD.list ~~ (0x110F, 0x1161, 0x11C2,), 'CE8F -> 110F 1161 11C2';
ok Uni.new(0xCE90).NFKD.list ~~ (0x110F, 0x1162,), 'CE90 -> 110F 1162';
ok Uni.new(0xCE91).NFKD.list ~~ (0x110F, 0x1162, 0x11A8,), 'CE91 -> 110F 1162 11A8';
ok Uni.new(0xCE92).NFKD.list ~~ (0x110F, 0x1162, 0x11A9,), 'CE92 -> 110F 1162 11A9';
ok Uni.new(0xCE93).NFKD.list ~~ (0x110F, 0x1162, 0x11AA,), 'CE93 -> 110F 1162 11AA';
ok Uni.new(0xCE94).NFKD.list ~~ (0x110F, 0x1162, 0x11AB,), 'CE94 -> 110F 1162 11AB';
ok Uni.new(0xCE95).NFKD.list ~~ (0x110F, 0x1162, 0x11AC,), 'CE95 -> 110F 1162 11AC';
ok Uni.new(0xCE96).NFKD.list ~~ (0x110F, 0x1162, 0x11AD,), 'CE96 -> 110F 1162 11AD';
ok Uni.new(0xCE97).NFKD.list ~~ (0x110F, 0x1162, 0x11AE,), 'CE97 -> 110F 1162 11AE';
ok Uni.new(0xCE98).NFKD.list ~~ (0x110F, 0x1162, 0x11AF,), 'CE98 -> 110F 1162 11AF';
ok Uni.new(0xCE99).NFKD.list ~~ (0x110F, 0x1162, 0x11B0,), 'CE99 -> 110F 1162 11B0';
ok Uni.new(0xCE9A).NFKD.list ~~ (0x110F, 0x1162, 0x11B1,), 'CE9A -> 110F 1162 11B1';
ok Uni.new(0xCE9B).NFKD.list ~~ (0x110F, 0x1162, 0x11B2,), 'CE9B -> 110F 1162 11B2';
ok Uni.new(0xCE9C).NFKD.list ~~ (0x110F, 0x1162, 0x11B3,), 'CE9C -> 110F 1162 11B3';
ok Uni.new(0xCE9D).NFKD.list ~~ (0x110F, 0x1162, 0x11B4,), 'CE9D -> 110F 1162 11B4';
ok Uni.new(0xCE9E).NFKD.list ~~ (0x110F, 0x1162, 0x11B5,), 'CE9E -> 110F 1162 11B5';
ok Uni.new(0xCE9F).NFKD.list ~~ (0x110F, 0x1162, 0x11B6,), 'CE9F -> 110F 1162 11B6';
ok Uni.new(0xCEA0).NFKD.list ~~ (0x110F, 0x1162, 0x11B7,), 'CEA0 -> 110F 1162 11B7';
ok Uni.new(0xCEA1).NFKD.list ~~ (0x110F, 0x1162, 0x11B8,), 'CEA1 -> 110F 1162 11B8';
ok Uni.new(0xCEA2).NFKD.list ~~ (0x110F, 0x1162, 0x11B9,), 'CEA2 -> 110F 1162 11B9';
ok Uni.new(0xCEA3).NFKD.list ~~ (0x110F, 0x1162, 0x11BA,), 'CEA3 -> 110F 1162 11BA';
ok Uni.new(0xCEA4).NFKD.list ~~ (0x110F, 0x1162, 0x11BB,), 'CEA4 -> 110F 1162 11BB';
ok Uni.new(0xCEA5).NFKD.list ~~ (0x110F, 0x1162, 0x11BC,), 'CEA5 -> 110F 1162 11BC';
ok Uni.new(0xCEA6).NFKD.list ~~ (0x110F, 0x1162, 0x11BD,), 'CEA6 -> 110F 1162 11BD';
ok Uni.new(0xCEA7).NFKD.list ~~ (0x110F, 0x1162, 0x11BE,), 'CEA7 -> 110F 1162 11BE';
ok Uni.new(0xCEA8).NFKD.list ~~ (0x110F, 0x1162, 0x11BF,), 'CEA8 -> 110F 1162 11BF';
ok Uni.new(0xCEA9).NFKD.list ~~ (0x110F, 0x1162, 0x11C0,), 'CEA9 -> 110F 1162 11C0';
ok Uni.new(0xCEAA).NFKD.list ~~ (0x110F, 0x1162, 0x11C1,), 'CEAA -> 110F 1162 11C1';
ok Uni.new(0xCEAB).NFKD.list ~~ (0x110F, 0x1162, 0x11C2,), 'CEAB -> 110F 1162 11C2';
ok Uni.new(0xCEAC).NFKD.list ~~ (0x110F, 0x1163,), 'CEAC -> 110F 1163';
ok Uni.new(0xCEAD).NFKD.list ~~ (0x110F, 0x1163, 0x11A8,), 'CEAD -> 110F 1163 11A8';
ok Uni.new(0xCEAE).NFKD.list ~~ (0x110F, 0x1163, 0x11A9,), 'CEAE -> 110F 1163 11A9';
ok Uni.new(0xCEAF).NFKD.list ~~ (0x110F, 0x1163, 0x11AA,), 'CEAF -> 110F 1163 11AA';
ok Uni.new(0xCEB0).NFKD.list ~~ (0x110F, 0x1163, 0x11AB,), 'CEB0 -> 110F 1163 11AB';
ok Uni.new(0xCEB1).NFKD.list ~~ (0x110F, 0x1163, 0x11AC,), 'CEB1 -> 110F 1163 11AC';
ok Uni.new(0xCEB2).NFKD.list ~~ (0x110F, 0x1163, 0x11AD,), 'CEB2 -> 110F 1163 11AD';
ok Uni.new(0xCEB3).NFKD.list ~~ (0x110F, 0x1163, 0x11AE,), 'CEB3 -> 110F 1163 11AE';
ok Uni.new(0xCEB4).NFKD.list ~~ (0x110F, 0x1163, 0x11AF,), 'CEB4 -> 110F 1163 11AF';
ok Uni.new(0xCEB5).NFKD.list ~~ (0x110F, 0x1163, 0x11B0,), 'CEB5 -> 110F 1163 11B0';
ok Uni.new(0xCEB6).NFKD.list ~~ (0x110F, 0x1163, 0x11B1,), 'CEB6 -> 110F 1163 11B1';
ok Uni.new(0xCEB7).NFKD.list ~~ (0x110F, 0x1163, 0x11B2,), 'CEB7 -> 110F 1163 11B2';
ok Uni.new(0xCEB8).NFKD.list ~~ (0x110F, 0x1163, 0x11B3,), 'CEB8 -> 110F 1163 11B3';
ok Uni.new(0xCEB9).NFKD.list ~~ (0x110F, 0x1163, 0x11B4,), 'CEB9 -> 110F 1163 11B4';
ok Uni.new(0xCEBA).NFKD.list ~~ (0x110F, 0x1163, 0x11B5,), 'CEBA -> 110F 1163 11B5';
ok Uni.new(0xCEBB).NFKD.list ~~ (0x110F, 0x1163, 0x11B6,), 'CEBB -> 110F 1163 11B6';
ok Uni.new(0xCEBC).NFKD.list ~~ (0x110F, 0x1163, 0x11B7,), 'CEBC -> 110F 1163 11B7';
ok Uni.new(0xCEBD).NFKD.list ~~ (0x110F, 0x1163, 0x11B8,), 'CEBD -> 110F 1163 11B8';
ok Uni.new(0xCEBE).NFKD.list ~~ (0x110F, 0x1163, 0x11B9,), 'CEBE -> 110F 1163 11B9';
ok Uni.new(0xCEBF).NFKD.list ~~ (0x110F, 0x1163, 0x11BA,), 'CEBF -> 110F 1163 11BA';
ok Uni.new(0xCEC0).NFKD.list ~~ (0x110F, 0x1163, 0x11BB,), 'CEC0 -> 110F 1163 11BB';
ok Uni.new(0xCEC1).NFKD.list ~~ (0x110F, 0x1163, 0x11BC,), 'CEC1 -> 110F 1163 11BC';
ok Uni.new(0xCEC2).NFKD.list ~~ (0x110F, 0x1163, 0x11BD,), 'CEC2 -> 110F 1163 11BD';
ok Uni.new(0xCEC3).NFKD.list ~~ (0x110F, 0x1163, 0x11BE,), 'CEC3 -> 110F 1163 11BE';
ok Uni.new(0xCEC4).NFKD.list ~~ (0x110F, 0x1163, 0x11BF,), 'CEC4 -> 110F 1163 11BF';
ok Uni.new(0xCEC5).NFKD.list ~~ (0x110F, 0x1163, 0x11C0,), 'CEC5 -> 110F 1163 11C0';
ok Uni.new(0xCEC6).NFKD.list ~~ (0x110F, 0x1163, 0x11C1,), 'CEC6 -> 110F 1163 11C1';
ok Uni.new(0xCEC7).NFKD.list ~~ (0x110F, 0x1163, 0x11C2,), 'CEC7 -> 110F 1163 11C2';
ok Uni.new(0xCEC8).NFKD.list ~~ (0x110F, 0x1164,), 'CEC8 -> 110F 1164';
ok Uni.new(0xCEC9).NFKD.list ~~ (0x110F, 0x1164, 0x11A8,), 'CEC9 -> 110F 1164 11A8';
ok Uni.new(0xCECA).NFKD.list ~~ (0x110F, 0x1164, 0x11A9,), 'CECA -> 110F 1164 11A9';
ok Uni.new(0xCECB).NFKD.list ~~ (0x110F, 0x1164, 0x11AA,), 'CECB -> 110F 1164 11AA';
ok Uni.new(0xCECC).NFKD.list ~~ (0x110F, 0x1164, 0x11AB,), 'CECC -> 110F 1164 11AB';
ok Uni.new(0xCECD).NFKD.list ~~ (0x110F, 0x1164, 0x11AC,), 'CECD -> 110F 1164 11AC';
ok Uni.new(0xCECE).NFKD.list ~~ (0x110F, 0x1164, 0x11AD,), 'CECE -> 110F 1164 11AD';
ok Uni.new(0xCECF).NFKD.list ~~ (0x110F, 0x1164, 0x11AE,), 'CECF -> 110F 1164 11AE';
ok Uni.new(0xCED0).NFKD.list ~~ (0x110F, 0x1164, 0x11AF,), 'CED0 -> 110F 1164 11AF';
ok Uni.new(0xCED1).NFKD.list ~~ (0x110F, 0x1164, 0x11B0,), 'CED1 -> 110F 1164 11B0';
ok Uni.new(0xCED2).NFKD.list ~~ (0x110F, 0x1164, 0x11B1,), 'CED2 -> 110F 1164 11B1';
ok Uni.new(0xCED3).NFKD.list ~~ (0x110F, 0x1164, 0x11B2,), 'CED3 -> 110F 1164 11B2';
ok Uni.new(0xCED4).NFKD.list ~~ (0x110F, 0x1164, 0x11B3,), 'CED4 -> 110F 1164 11B3';
ok Uni.new(0xCED5).NFKD.list ~~ (0x110F, 0x1164, 0x11B4,), 'CED5 -> 110F 1164 11B4';
ok Uni.new(0xCED6).NFKD.list ~~ (0x110F, 0x1164, 0x11B5,), 'CED6 -> 110F 1164 11B5';
ok Uni.new(0xCED7).NFKD.list ~~ (0x110F, 0x1164, 0x11B6,), 'CED7 -> 110F 1164 11B6';
ok Uni.new(0xCED8).NFKD.list ~~ (0x110F, 0x1164, 0x11B7,), 'CED8 -> 110F 1164 11B7';
ok Uni.new(0xCED9).NFKD.list ~~ (0x110F, 0x1164, 0x11B8,), 'CED9 -> 110F 1164 11B8';
ok Uni.new(0xCEDA).NFKD.list ~~ (0x110F, 0x1164, 0x11B9,), 'CEDA -> 110F 1164 11B9';
ok Uni.new(0xCEDB).NFKD.list ~~ (0x110F, 0x1164, 0x11BA,), 'CEDB -> 110F 1164 11BA';
ok Uni.new(0xCEDC).NFKD.list ~~ (0x110F, 0x1164, 0x11BB,), 'CEDC -> 110F 1164 11BB';
ok Uni.new(0xCEDD).NFKD.list ~~ (0x110F, 0x1164, 0x11BC,), 'CEDD -> 110F 1164 11BC';
ok Uni.new(0xCEDE).NFKD.list ~~ (0x110F, 0x1164, 0x11BD,), 'CEDE -> 110F 1164 11BD';
ok Uni.new(0xCEDF).NFKD.list ~~ (0x110F, 0x1164, 0x11BE,), 'CEDF -> 110F 1164 11BE';
ok Uni.new(0xCEE0).NFKD.list ~~ (0x110F, 0x1164, 0x11BF,), 'CEE0 -> 110F 1164 11BF';
ok Uni.new(0xCEE1).NFKD.list ~~ (0x110F, 0x1164, 0x11C0,), 'CEE1 -> 110F 1164 11C0';
ok Uni.new(0xCEE2).NFKD.list ~~ (0x110F, 0x1164, 0x11C1,), 'CEE2 -> 110F 1164 11C1';
ok Uni.new(0xCEE3).NFKD.list ~~ (0x110F, 0x1164, 0x11C2,), 'CEE3 -> 110F 1164 11C2';
ok Uni.new(0xCEE4).NFKD.list ~~ (0x110F, 0x1165,), 'CEE4 -> 110F 1165';
ok Uni.new(0xCEE5).NFKD.list ~~ (0x110F, 0x1165, 0x11A8,), 'CEE5 -> 110F 1165 11A8';
ok Uni.new(0xCEE6).NFKD.list ~~ (0x110F, 0x1165, 0x11A9,), 'CEE6 -> 110F 1165 11A9';
ok Uni.new(0xCEE7).NFKD.list ~~ (0x110F, 0x1165, 0x11AA,), 'CEE7 -> 110F 1165 11AA';
ok Uni.new(0xCEE8).NFKD.list ~~ (0x110F, 0x1165, 0x11AB,), 'CEE8 -> 110F 1165 11AB';
ok Uni.new(0xCEE9).NFKD.list ~~ (0x110F, 0x1165, 0x11AC,), 'CEE9 -> 110F 1165 11AC';
ok Uni.new(0xCEEA).NFKD.list ~~ (0x110F, 0x1165, 0x11AD,), 'CEEA -> 110F 1165 11AD';
ok Uni.new(0xCEEB).NFKD.list ~~ (0x110F, 0x1165, 0x11AE,), 'CEEB -> 110F 1165 11AE';
ok Uni.new(0xCEEC).NFKD.list ~~ (0x110F, 0x1165, 0x11AF,), 'CEEC -> 110F 1165 11AF';
ok Uni.new(0xCEED).NFKD.list ~~ (0x110F, 0x1165, 0x11B0,), 'CEED -> 110F 1165 11B0';
ok Uni.new(0xCEEE).NFKD.list ~~ (0x110F, 0x1165, 0x11B1,), 'CEEE -> 110F 1165 11B1';
ok Uni.new(0xCEEF).NFKD.list ~~ (0x110F, 0x1165, 0x11B2,), 'CEEF -> 110F 1165 11B2';
ok Uni.new(0xCEF0).NFKD.list ~~ (0x110F, 0x1165, 0x11B3,), 'CEF0 -> 110F 1165 11B3';
ok Uni.new(0xCEF1).NFKD.list ~~ (0x110F, 0x1165, 0x11B4,), 'CEF1 -> 110F 1165 11B4';
ok Uni.new(0xCEF2).NFKD.list ~~ (0x110F, 0x1165, 0x11B5,), 'CEF2 -> 110F 1165 11B5';
ok Uni.new(0xCEF3).NFKD.list ~~ (0x110F, 0x1165, 0x11B6,), 'CEF3 -> 110F 1165 11B6';
ok Uni.new(0xCEF4).NFKD.list ~~ (0x110F, 0x1165, 0x11B7,), 'CEF4 -> 110F 1165 11B7';
ok Uni.new(0xCEF5).NFKD.list ~~ (0x110F, 0x1165, 0x11B8,), 'CEF5 -> 110F 1165 11B8';
ok Uni.new(0xCEF6).NFKD.list ~~ (0x110F, 0x1165, 0x11B9,), 'CEF6 -> 110F 1165 11B9';
ok Uni.new(0xCEF7).NFKD.list ~~ (0x110F, 0x1165, 0x11BA,), 'CEF7 -> 110F 1165 11BA';
ok Uni.new(0xCEF8).NFKD.list ~~ (0x110F, 0x1165, 0x11BB,), 'CEF8 -> 110F 1165 11BB';
ok Uni.new(0xCEF9).NFKD.list ~~ (0x110F, 0x1165, 0x11BC,), 'CEF9 -> 110F 1165 11BC';
ok Uni.new(0xCEFA).NFKD.list ~~ (0x110F, 0x1165, 0x11BD,), 'CEFA -> 110F 1165 11BD';
ok Uni.new(0xCEFB).NFKD.list ~~ (0x110F, 0x1165, 0x11BE,), 'CEFB -> 110F 1165 11BE';
ok Uni.new(0xCEFC).NFKD.list ~~ (0x110F, 0x1165, 0x11BF,), 'CEFC -> 110F 1165 11BF';
ok Uni.new(0xCEFD).NFKD.list ~~ (0x110F, 0x1165, 0x11C0,), 'CEFD -> 110F 1165 11C0';
ok Uni.new(0xCEFE).NFKD.list ~~ (0x110F, 0x1165, 0x11C1,), 'CEFE -> 110F 1165 11C1';
ok Uni.new(0xCEFF).NFKD.list ~~ (0x110F, 0x1165, 0x11C2,), 'CEFF -> 110F 1165 11C2';
ok Uni.new(0xCF00).NFKD.list ~~ (0x110F, 0x1166,), 'CF00 -> 110F 1166';
ok Uni.new(0xCF01).NFKD.list ~~ (0x110F, 0x1166, 0x11A8,), 'CF01 -> 110F 1166 11A8';
ok Uni.new(0xCF02).NFKD.list ~~ (0x110F, 0x1166, 0x11A9,), 'CF02 -> 110F 1166 11A9';
ok Uni.new(0xCF03).NFKD.list ~~ (0x110F, 0x1166, 0x11AA,), 'CF03 -> 110F 1166 11AA';
ok Uni.new(0xCF04).NFKD.list ~~ (0x110F, 0x1166, 0x11AB,), 'CF04 -> 110F 1166 11AB';
ok Uni.new(0xCF05).NFKD.list ~~ (0x110F, 0x1166, 0x11AC,), 'CF05 -> 110F 1166 11AC';
ok Uni.new(0xCF06).NFKD.list ~~ (0x110F, 0x1166, 0x11AD,), 'CF06 -> 110F 1166 11AD';
ok Uni.new(0xCF07).NFKD.list ~~ (0x110F, 0x1166, 0x11AE,), 'CF07 -> 110F 1166 11AE';
ok Uni.new(0xCF08).NFKD.list ~~ (0x110F, 0x1166, 0x11AF,), 'CF08 -> 110F 1166 11AF';
ok Uni.new(0xCF09).NFKD.list ~~ (0x110F, 0x1166, 0x11B0,), 'CF09 -> 110F 1166 11B0';
ok Uni.new(0xCF0A).NFKD.list ~~ (0x110F, 0x1166, 0x11B1,), 'CF0A -> 110F 1166 11B1';
ok Uni.new(0xCF0B).NFKD.list ~~ (0x110F, 0x1166, 0x11B2,), 'CF0B -> 110F 1166 11B2';
ok Uni.new(0xCF0C).NFKD.list ~~ (0x110F, 0x1166, 0x11B3,), 'CF0C -> 110F 1166 11B3';
ok Uni.new(0xCF0D).NFKD.list ~~ (0x110F, 0x1166, 0x11B4,), 'CF0D -> 110F 1166 11B4';
ok Uni.new(0xCF0E).NFKD.list ~~ (0x110F, 0x1166, 0x11B5,), 'CF0E -> 110F 1166 11B5';
ok Uni.new(0xCF0F).NFKD.list ~~ (0x110F, 0x1166, 0x11B6,), 'CF0F -> 110F 1166 11B6';
ok Uni.new(0xCF10).NFKD.list ~~ (0x110F, 0x1166, 0x11B7,), 'CF10 -> 110F 1166 11B7';
ok Uni.new(0xCF11).NFKD.list ~~ (0x110F, 0x1166, 0x11B8,), 'CF11 -> 110F 1166 11B8';
ok Uni.new(0xCF12).NFKD.list ~~ (0x110F, 0x1166, 0x11B9,), 'CF12 -> 110F 1166 11B9';
ok Uni.new(0xCF13).NFKD.list ~~ (0x110F, 0x1166, 0x11BA,), 'CF13 -> 110F 1166 11BA';
ok Uni.new(0xCF14).NFKD.list ~~ (0x110F, 0x1166, 0x11BB,), 'CF14 -> 110F 1166 11BB';
ok Uni.new(0xCF15).NFKD.list ~~ (0x110F, 0x1166, 0x11BC,), 'CF15 -> 110F 1166 11BC';
ok Uni.new(0xCF16).NFKD.list ~~ (0x110F, 0x1166, 0x11BD,), 'CF16 -> 110F 1166 11BD';
ok Uni.new(0xCF17).NFKD.list ~~ (0x110F, 0x1166, 0x11BE,), 'CF17 -> 110F 1166 11BE';
ok Uni.new(0xCF18).NFKD.list ~~ (0x110F, 0x1166, 0x11BF,), 'CF18 -> 110F 1166 11BF';
ok Uni.new(0xCF19).NFKD.list ~~ (0x110F, 0x1166, 0x11C0,), 'CF19 -> 110F 1166 11C0';
ok Uni.new(0xCF1A).NFKD.list ~~ (0x110F, 0x1166, 0x11C1,), 'CF1A -> 110F 1166 11C1';
ok Uni.new(0xCF1B).NFKD.list ~~ (0x110F, 0x1166, 0x11C2,), 'CF1B -> 110F 1166 11C2';
ok Uni.new(0xCF1C).NFKD.list ~~ (0x110F, 0x1167,), 'CF1C -> 110F 1167';
ok Uni.new(0xCF1D).NFKD.list ~~ (0x110F, 0x1167, 0x11A8,), 'CF1D -> 110F 1167 11A8';
ok Uni.new(0xCF1E).NFKD.list ~~ (0x110F, 0x1167, 0x11A9,), 'CF1E -> 110F 1167 11A9';
ok Uni.new(0xCF1F).NFKD.list ~~ (0x110F, 0x1167, 0x11AA,), 'CF1F -> 110F 1167 11AA';
ok Uni.new(0xCF20).NFKD.list ~~ (0x110F, 0x1167, 0x11AB,), 'CF20 -> 110F 1167 11AB';
ok Uni.new(0xCF21).NFKD.list ~~ (0x110F, 0x1167, 0x11AC,), 'CF21 -> 110F 1167 11AC';
ok Uni.new(0xCF22).NFKD.list ~~ (0x110F, 0x1167, 0x11AD,), 'CF22 -> 110F 1167 11AD';
ok Uni.new(0xCF23).NFKD.list ~~ (0x110F, 0x1167, 0x11AE,), 'CF23 -> 110F 1167 11AE';
ok Uni.new(0xCF24).NFKD.list ~~ (0x110F, 0x1167, 0x11AF,), 'CF24 -> 110F 1167 11AF';
ok Uni.new(0xCF25).NFKD.list ~~ (0x110F, 0x1167, 0x11B0,), 'CF25 -> 110F 1167 11B0';
ok Uni.new(0xCF26).NFKD.list ~~ (0x110F, 0x1167, 0x11B1,), 'CF26 -> 110F 1167 11B1';
ok Uni.new(0xCF27).NFKD.list ~~ (0x110F, 0x1167, 0x11B2,), 'CF27 -> 110F 1167 11B2';
ok Uni.new(0xCF28).NFKD.list ~~ (0x110F, 0x1167, 0x11B3,), 'CF28 -> 110F 1167 11B3';
ok Uni.new(0xCF29).NFKD.list ~~ (0x110F, 0x1167, 0x11B4,), 'CF29 -> 110F 1167 11B4';
ok Uni.new(0xCF2A).NFKD.list ~~ (0x110F, 0x1167, 0x11B5,), 'CF2A -> 110F 1167 11B5';
ok Uni.new(0xCF2B).NFKD.list ~~ (0x110F, 0x1167, 0x11B6,), 'CF2B -> 110F 1167 11B6';
ok Uni.new(0xCF2C).NFKD.list ~~ (0x110F, 0x1167, 0x11B7,), 'CF2C -> 110F 1167 11B7';
ok Uni.new(0xCF2D).NFKD.list ~~ (0x110F, 0x1167, 0x11B8,), 'CF2D -> 110F 1167 11B8';
ok Uni.new(0xCF2E).NFKD.list ~~ (0x110F, 0x1167, 0x11B9,), 'CF2E -> 110F 1167 11B9';
ok Uni.new(0xCF2F).NFKD.list ~~ (0x110F, 0x1167, 0x11BA,), 'CF2F -> 110F 1167 11BA';
ok Uni.new(0xCF30).NFKD.list ~~ (0x110F, 0x1167, 0x11BB,), 'CF30 -> 110F 1167 11BB';
ok Uni.new(0xCF31).NFKD.list ~~ (0x110F, 0x1167, 0x11BC,), 'CF31 -> 110F 1167 11BC';
ok Uni.new(0xCF32).NFKD.list ~~ (0x110F, 0x1167, 0x11BD,), 'CF32 -> 110F 1167 11BD';
ok Uni.new(0xCF33).NFKD.list ~~ (0x110F, 0x1167, 0x11BE,), 'CF33 -> 110F 1167 11BE';
ok Uni.new(0xCF34).NFKD.list ~~ (0x110F, 0x1167, 0x11BF,), 'CF34 -> 110F 1167 11BF';
ok Uni.new(0xCF35).NFKD.list ~~ (0x110F, 0x1167, 0x11C0,), 'CF35 -> 110F 1167 11C0';
ok Uni.new(0xCF36).NFKD.list ~~ (0x110F, 0x1167, 0x11C1,), 'CF36 -> 110F 1167 11C1';
ok Uni.new(0xCF37).NFKD.list ~~ (0x110F, 0x1167, 0x11C2,), 'CF37 -> 110F 1167 11C2';
ok Uni.new(0xCF38).NFKD.list ~~ (0x110F, 0x1168,), 'CF38 -> 110F 1168';
ok Uni.new(0xCF39).NFKD.list ~~ (0x110F, 0x1168, 0x11A8,), 'CF39 -> 110F 1168 11A8';
ok Uni.new(0xCF3A).NFKD.list ~~ (0x110F, 0x1168, 0x11A9,), 'CF3A -> 110F 1168 11A9';
ok Uni.new(0xCF3B).NFKD.list ~~ (0x110F, 0x1168, 0x11AA,), 'CF3B -> 110F 1168 11AA';
ok Uni.new(0xCF3C).NFKD.list ~~ (0x110F, 0x1168, 0x11AB,), 'CF3C -> 110F 1168 11AB';
ok Uni.new(0xCF3D).NFKD.list ~~ (0x110F, 0x1168, 0x11AC,), 'CF3D -> 110F 1168 11AC';
ok Uni.new(0xCF3E).NFKD.list ~~ (0x110F, 0x1168, 0x11AD,), 'CF3E -> 110F 1168 11AD';
ok Uni.new(0xCF3F).NFKD.list ~~ (0x110F, 0x1168, 0x11AE,), 'CF3F -> 110F 1168 11AE';
ok Uni.new(0xCF40).NFKD.list ~~ (0x110F, 0x1168, 0x11AF,), 'CF40 -> 110F 1168 11AF';
ok Uni.new(0xCF41).NFKD.list ~~ (0x110F, 0x1168, 0x11B0,), 'CF41 -> 110F 1168 11B0';
ok Uni.new(0xCF42).NFKD.list ~~ (0x110F, 0x1168, 0x11B1,), 'CF42 -> 110F 1168 11B1';
ok Uni.new(0xCF43).NFKD.list ~~ (0x110F, 0x1168, 0x11B2,), 'CF43 -> 110F 1168 11B2';
ok Uni.new(0xCF44).NFKD.list ~~ (0x110F, 0x1168, 0x11B3,), 'CF44 -> 110F 1168 11B3';
ok Uni.new(0xCF45).NFKD.list ~~ (0x110F, 0x1168, 0x11B4,), 'CF45 -> 110F 1168 11B4';
ok Uni.new(0xCF46).NFKD.list ~~ (0x110F, 0x1168, 0x11B5,), 'CF46 -> 110F 1168 11B5';
ok Uni.new(0xCF47).NFKD.list ~~ (0x110F, 0x1168, 0x11B6,), 'CF47 -> 110F 1168 11B6';
ok Uni.new(0xCF48).NFKD.list ~~ (0x110F, 0x1168, 0x11B7,), 'CF48 -> 110F 1168 11B7';
ok Uni.new(0xCF49).NFKD.list ~~ (0x110F, 0x1168, 0x11B8,), 'CF49 -> 110F 1168 11B8';
ok Uni.new(0xCF4A).NFKD.list ~~ (0x110F, 0x1168, 0x11B9,), 'CF4A -> 110F 1168 11B9';
ok Uni.new(0xCF4B).NFKD.list ~~ (0x110F, 0x1168, 0x11BA,), 'CF4B -> 110F 1168 11BA';
ok Uni.new(0xCF4C).NFKD.list ~~ (0x110F, 0x1168, 0x11BB,), 'CF4C -> 110F 1168 11BB';
ok Uni.new(0xCF4D).NFKD.list ~~ (0x110F, 0x1168, 0x11BC,), 'CF4D -> 110F 1168 11BC';
ok Uni.new(0xCF4E).NFKD.list ~~ (0x110F, 0x1168, 0x11BD,), 'CF4E -> 110F 1168 11BD';
ok Uni.new(0xCF4F).NFKD.list ~~ (0x110F, 0x1168, 0x11BE,), 'CF4F -> 110F 1168 11BE';
ok Uni.new(0xCF50).NFKD.list ~~ (0x110F, 0x1168, 0x11BF,), 'CF50 -> 110F 1168 11BF';
ok Uni.new(0xCF51).NFKD.list ~~ (0x110F, 0x1168, 0x11C0,), 'CF51 -> 110F 1168 11C0';
ok Uni.new(0xCF52).NFKD.list ~~ (0x110F, 0x1168, 0x11C1,), 'CF52 -> 110F 1168 11C1';
ok Uni.new(0xCF53).NFKD.list ~~ (0x110F, 0x1168, 0x11C2,), 'CF53 -> 110F 1168 11C2';
ok Uni.new(0xCF54).NFKD.list ~~ (0x110F, 0x1169,), 'CF54 -> 110F 1169';
ok Uni.new(0xCF55).NFKD.list ~~ (0x110F, 0x1169, 0x11A8,), 'CF55 -> 110F 1169 11A8';
ok Uni.new(0xCF56).NFKD.list ~~ (0x110F, 0x1169, 0x11A9,), 'CF56 -> 110F 1169 11A9';
ok Uni.new(0xCF57).NFKD.list ~~ (0x110F, 0x1169, 0x11AA,), 'CF57 -> 110F 1169 11AA';
ok Uni.new(0xCF58).NFKD.list ~~ (0x110F, 0x1169, 0x11AB,), 'CF58 -> 110F 1169 11AB';
ok Uni.new(0xCF59).NFKD.list ~~ (0x110F, 0x1169, 0x11AC,), 'CF59 -> 110F 1169 11AC';
ok Uni.new(0xCF5A).NFKD.list ~~ (0x110F, 0x1169, 0x11AD,), 'CF5A -> 110F 1169 11AD';
ok Uni.new(0xCF5B).NFKD.list ~~ (0x110F, 0x1169, 0x11AE,), 'CF5B -> 110F 1169 11AE';
ok Uni.new(0xCF5C).NFKD.list ~~ (0x110F, 0x1169, 0x11AF,), 'CF5C -> 110F 1169 11AF';
ok Uni.new(0xCF5D).NFKD.list ~~ (0x110F, 0x1169, 0x11B0,), 'CF5D -> 110F 1169 11B0';
ok Uni.new(0xCF5E).NFKD.list ~~ (0x110F, 0x1169, 0x11B1,), 'CF5E -> 110F 1169 11B1';
ok Uni.new(0xCF5F).NFKD.list ~~ (0x110F, 0x1169, 0x11B2,), 'CF5F -> 110F 1169 11B2';
ok Uni.new(0xCF60).NFKD.list ~~ (0x110F, 0x1169, 0x11B3,), 'CF60 -> 110F 1169 11B3';
ok Uni.new(0xCF61).NFKD.list ~~ (0x110F, 0x1169, 0x11B4,), 'CF61 -> 110F 1169 11B4';
ok Uni.new(0xCF62).NFKD.list ~~ (0x110F, 0x1169, 0x11B5,), 'CF62 -> 110F 1169 11B5';
ok Uni.new(0xCF63).NFKD.list ~~ (0x110F, 0x1169, 0x11B6,), 'CF63 -> 110F 1169 11B6';
ok Uni.new(0xCF64).NFKD.list ~~ (0x110F, 0x1169, 0x11B7,), 'CF64 -> 110F 1169 11B7';
ok Uni.new(0xCF65).NFKD.list ~~ (0x110F, 0x1169, 0x11B8,), 'CF65 -> 110F 1169 11B8';
ok Uni.new(0xCF66).NFKD.list ~~ (0x110F, 0x1169, 0x11B9,), 'CF66 -> 110F 1169 11B9';
ok Uni.new(0xCF67).NFKD.list ~~ (0x110F, 0x1169, 0x11BA,), 'CF67 -> 110F 1169 11BA';
ok Uni.new(0xCF68).NFKD.list ~~ (0x110F, 0x1169, 0x11BB,), 'CF68 -> 110F 1169 11BB';
ok Uni.new(0xCF69).NFKD.list ~~ (0x110F, 0x1169, 0x11BC,), 'CF69 -> 110F 1169 11BC';
ok Uni.new(0xCF6A).NFKD.list ~~ (0x110F, 0x1169, 0x11BD,), 'CF6A -> 110F 1169 11BD';
ok Uni.new(0xCF6B).NFKD.list ~~ (0x110F, 0x1169, 0x11BE,), 'CF6B -> 110F 1169 11BE';
ok Uni.new(0xCF6C).NFKD.list ~~ (0x110F, 0x1169, 0x11BF,), 'CF6C -> 110F 1169 11BF';
ok Uni.new(0xCF6D).NFKD.list ~~ (0x110F, 0x1169, 0x11C0,), 'CF6D -> 110F 1169 11C0';
ok Uni.new(0xCF6E).NFKD.list ~~ (0x110F, 0x1169, 0x11C1,), 'CF6E -> 110F 1169 11C1';
ok Uni.new(0xCF6F).NFKD.list ~~ (0x110F, 0x1169, 0x11C2,), 'CF6F -> 110F 1169 11C2';
ok Uni.new(0xCF70).NFKD.list ~~ (0x110F, 0x116A,), 'CF70 -> 110F 116A';
ok Uni.new(0xCF71).NFKD.list ~~ (0x110F, 0x116A, 0x11A8,), 'CF71 -> 110F 116A 11A8';
ok Uni.new(0xCF72).NFKD.list ~~ (0x110F, 0x116A, 0x11A9,), 'CF72 -> 110F 116A 11A9';
ok Uni.new(0xCF73).NFKD.list ~~ (0x110F, 0x116A, 0x11AA,), 'CF73 -> 110F 116A 11AA';
ok Uni.new(0xCF74).NFKD.list ~~ (0x110F, 0x116A, 0x11AB,), 'CF74 -> 110F 116A 11AB';
ok Uni.new(0xCF75).NFKD.list ~~ (0x110F, 0x116A, 0x11AC,), 'CF75 -> 110F 116A 11AC';
ok Uni.new(0xCF76).NFKD.list ~~ (0x110F, 0x116A, 0x11AD,), 'CF76 -> 110F 116A 11AD';
ok Uni.new(0xCF77).NFKD.list ~~ (0x110F, 0x116A, 0x11AE,), 'CF77 -> 110F 116A 11AE';
ok Uni.new(0xCF78).NFKD.list ~~ (0x110F, 0x116A, 0x11AF,), 'CF78 -> 110F 116A 11AF';
ok Uni.new(0xCF79).NFKD.list ~~ (0x110F, 0x116A, 0x11B0,), 'CF79 -> 110F 116A 11B0';
ok Uni.new(0xCF7A).NFKD.list ~~ (0x110F, 0x116A, 0x11B1,), 'CF7A -> 110F 116A 11B1';
ok Uni.new(0xCF7B).NFKD.list ~~ (0x110F, 0x116A, 0x11B2,), 'CF7B -> 110F 116A 11B2';
ok Uni.new(0xCF7C).NFKD.list ~~ (0x110F, 0x116A, 0x11B3,), 'CF7C -> 110F 116A 11B3';
ok Uni.new(0xCF7D).NFKD.list ~~ (0x110F, 0x116A, 0x11B4,), 'CF7D -> 110F 116A 11B4';
ok Uni.new(0xCF7E).NFKD.list ~~ (0x110F, 0x116A, 0x11B5,), 'CF7E -> 110F 116A 11B5';
ok Uni.new(0xCF7F).NFKD.list ~~ (0x110F, 0x116A, 0x11B6,), 'CF7F -> 110F 116A 11B6';
ok Uni.new(0xCF80).NFKD.list ~~ (0x110F, 0x116A, 0x11B7,), 'CF80 -> 110F 116A 11B7';
ok Uni.new(0xCF81).NFKD.list ~~ (0x110F, 0x116A, 0x11B8,), 'CF81 -> 110F 116A 11B8';
ok Uni.new(0xCF82).NFKD.list ~~ (0x110F, 0x116A, 0x11B9,), 'CF82 -> 110F 116A 11B9';
ok Uni.new(0xCF83).NFKD.list ~~ (0x110F, 0x116A, 0x11BA,), 'CF83 -> 110F 116A 11BA';
ok Uni.new(0xCF84).NFKD.list ~~ (0x110F, 0x116A, 0x11BB,), 'CF84 -> 110F 116A 11BB';
ok Uni.new(0xCF85).NFKD.list ~~ (0x110F, 0x116A, 0x11BC,), 'CF85 -> 110F 116A 11BC';
ok Uni.new(0xCF86).NFKD.list ~~ (0x110F, 0x116A, 0x11BD,), 'CF86 -> 110F 116A 11BD';
ok Uni.new(0xCF87).NFKD.list ~~ (0x110F, 0x116A, 0x11BE,), 'CF87 -> 110F 116A 11BE';
ok Uni.new(0xCF88).NFKD.list ~~ (0x110F, 0x116A, 0x11BF,), 'CF88 -> 110F 116A 11BF';
ok Uni.new(0xCF89).NFKD.list ~~ (0x110F, 0x116A, 0x11C0,), 'CF89 -> 110F 116A 11C0';
ok Uni.new(0xCF8A).NFKD.list ~~ (0x110F, 0x116A, 0x11C1,), 'CF8A -> 110F 116A 11C1';
ok Uni.new(0xCF8B).NFKD.list ~~ (0x110F, 0x116A, 0x11C2,), 'CF8B -> 110F 116A 11C2';
ok Uni.new(0xCF8C).NFKD.list ~~ (0x110F, 0x116B,), 'CF8C -> 110F 116B';
ok Uni.new(0xCF8D).NFKD.list ~~ (0x110F, 0x116B, 0x11A8,), 'CF8D -> 110F 116B 11A8';
ok Uni.new(0xCF8E).NFKD.list ~~ (0x110F, 0x116B, 0x11A9,), 'CF8E -> 110F 116B 11A9';
ok Uni.new(0xCF8F).NFKD.list ~~ (0x110F, 0x116B, 0x11AA,), 'CF8F -> 110F 116B 11AA';
ok Uni.new(0xCF90).NFKD.list ~~ (0x110F, 0x116B, 0x11AB,), 'CF90 -> 110F 116B 11AB';
ok Uni.new(0xCF91).NFKD.list ~~ (0x110F, 0x116B, 0x11AC,), 'CF91 -> 110F 116B 11AC';
ok Uni.new(0xCF92).NFKD.list ~~ (0x110F, 0x116B, 0x11AD,), 'CF92 -> 110F 116B 11AD';
ok Uni.new(0xCF93).NFKD.list ~~ (0x110F, 0x116B, 0x11AE,), 'CF93 -> 110F 116B 11AE';
ok Uni.new(0xCF94).NFKD.list ~~ (0x110F, 0x116B, 0x11AF,), 'CF94 -> 110F 116B 11AF';
ok Uni.new(0xCF95).NFKD.list ~~ (0x110F, 0x116B, 0x11B0,), 'CF95 -> 110F 116B 11B0';
ok Uni.new(0xCF96).NFKD.list ~~ (0x110F, 0x116B, 0x11B1,), 'CF96 -> 110F 116B 11B1';
ok Uni.new(0xCF97).NFKD.list ~~ (0x110F, 0x116B, 0x11B2,), 'CF97 -> 110F 116B 11B2';
ok Uni.new(0xCF98).NFKD.list ~~ (0x110F, 0x116B, 0x11B3,), 'CF98 -> 110F 116B 11B3';
ok Uni.new(0xCF99).NFKD.list ~~ (0x110F, 0x116B, 0x11B4,), 'CF99 -> 110F 116B 11B4';
ok Uni.new(0xCF9A).NFKD.list ~~ (0x110F, 0x116B, 0x11B5,), 'CF9A -> 110F 116B 11B5';
ok Uni.new(0xCF9B).NFKD.list ~~ (0x110F, 0x116B, 0x11B6,), 'CF9B -> 110F 116B 11B6';
ok Uni.new(0xCF9C).NFKD.list ~~ (0x110F, 0x116B, 0x11B7,), 'CF9C -> 110F 116B 11B7';
ok Uni.new(0xCF9D).NFKD.list ~~ (0x110F, 0x116B, 0x11B8,), 'CF9D -> 110F 116B 11B8';
ok Uni.new(0xCF9E).NFKD.list ~~ (0x110F, 0x116B, 0x11B9,), 'CF9E -> 110F 116B 11B9';
ok Uni.new(0xCF9F).NFKD.list ~~ (0x110F, 0x116B, 0x11BA,), 'CF9F -> 110F 116B 11BA';
ok Uni.new(0xCFA0).NFKD.list ~~ (0x110F, 0x116B, 0x11BB,), 'CFA0 -> 110F 116B 11BB';
ok Uni.new(0xCFA1).NFKD.list ~~ (0x110F, 0x116B, 0x11BC,), 'CFA1 -> 110F 116B 11BC';
ok Uni.new(0xCFA2).NFKD.list ~~ (0x110F, 0x116B, 0x11BD,), 'CFA2 -> 110F 116B 11BD';
ok Uni.new(0xCFA3).NFKD.list ~~ (0x110F, 0x116B, 0x11BE,), 'CFA3 -> 110F 116B 11BE';
ok Uni.new(0xCFA4).NFKD.list ~~ (0x110F, 0x116B, 0x11BF,), 'CFA4 -> 110F 116B 11BF';
ok Uni.new(0xCFA5).NFKD.list ~~ (0x110F, 0x116B, 0x11C0,), 'CFA5 -> 110F 116B 11C0';
ok Uni.new(0xCFA6).NFKD.list ~~ (0x110F, 0x116B, 0x11C1,), 'CFA6 -> 110F 116B 11C1';
ok Uni.new(0xCFA7).NFKD.list ~~ (0x110F, 0x116B, 0x11C2,), 'CFA7 -> 110F 116B 11C2';
ok Uni.new(0xCFA8).NFKD.list ~~ (0x110F, 0x116C,), 'CFA8 -> 110F 116C';
ok Uni.new(0xCFA9).NFKD.list ~~ (0x110F, 0x116C, 0x11A8,), 'CFA9 -> 110F 116C 11A8';
ok Uni.new(0xCFAA).NFKD.list ~~ (0x110F, 0x116C, 0x11A9,), 'CFAA -> 110F 116C 11A9';
ok Uni.new(0xCFAB).NFKD.list ~~ (0x110F, 0x116C, 0x11AA,), 'CFAB -> 110F 116C 11AA';
ok Uni.new(0xCFAC).NFKD.list ~~ (0x110F, 0x116C, 0x11AB,), 'CFAC -> 110F 116C 11AB';
ok Uni.new(0xCFAD).NFKD.list ~~ (0x110F, 0x116C, 0x11AC,), 'CFAD -> 110F 116C 11AC';
ok Uni.new(0xCFAE).NFKD.list ~~ (0x110F, 0x116C, 0x11AD,), 'CFAE -> 110F 116C 11AD';
ok Uni.new(0xCFAF).NFKD.list ~~ (0x110F, 0x116C, 0x11AE,), 'CFAF -> 110F 116C 11AE';
ok Uni.new(0xCFB0).NFKD.list ~~ (0x110F, 0x116C, 0x11AF,), 'CFB0 -> 110F 116C 11AF';
ok Uni.new(0xCFB1).NFKD.list ~~ (0x110F, 0x116C, 0x11B0,), 'CFB1 -> 110F 116C 11B0';
ok Uni.new(0xCFB2).NFKD.list ~~ (0x110F, 0x116C, 0x11B1,), 'CFB2 -> 110F 116C 11B1';
ok Uni.new(0xCFB3).NFKD.list ~~ (0x110F, 0x116C, 0x11B2,), 'CFB3 -> 110F 116C 11B2';
ok Uni.new(0xCFB4).NFKD.list ~~ (0x110F, 0x116C, 0x11B3,), 'CFB4 -> 110F 116C 11B3';
ok Uni.new(0xCFB5).NFKD.list ~~ (0x110F, 0x116C, 0x11B4,), 'CFB5 -> 110F 116C 11B4';
ok Uni.new(0xCFB6).NFKD.list ~~ (0x110F, 0x116C, 0x11B5,), 'CFB6 -> 110F 116C 11B5';
ok Uni.new(0xCFB7).NFKD.list ~~ (0x110F, 0x116C, 0x11B6,), 'CFB7 -> 110F 116C 11B6';
ok Uni.new(0xCFB8).NFKD.list ~~ (0x110F, 0x116C, 0x11B7,), 'CFB8 -> 110F 116C 11B7';
ok Uni.new(0xCFB9).NFKD.list ~~ (0x110F, 0x116C, 0x11B8,), 'CFB9 -> 110F 116C 11B8';
ok Uni.new(0xCFBA).NFKD.list ~~ (0x110F, 0x116C, 0x11B9,), 'CFBA -> 110F 116C 11B9';
ok Uni.new(0xCFBB).NFKD.list ~~ (0x110F, 0x116C, 0x11BA,), 'CFBB -> 110F 116C 11BA';
ok Uni.new(0xCFBC).NFKD.list ~~ (0x110F, 0x116C, 0x11BB,), 'CFBC -> 110F 116C 11BB';
ok Uni.new(0xCFBD).NFKD.list ~~ (0x110F, 0x116C, 0x11BC,), 'CFBD -> 110F 116C 11BC';
ok Uni.new(0xCFBE).NFKD.list ~~ (0x110F, 0x116C, 0x11BD,), 'CFBE -> 110F 116C 11BD';
ok Uni.new(0xCFBF).NFKD.list ~~ (0x110F, 0x116C, 0x11BE,), 'CFBF -> 110F 116C 11BE';
ok Uni.new(0xCFC0).NFKD.list ~~ (0x110F, 0x116C, 0x11BF,), 'CFC0 -> 110F 116C 11BF';
ok Uni.new(0xCFC1).NFKD.list ~~ (0x110F, 0x116C, 0x11C0,), 'CFC1 -> 110F 116C 11C0';
ok Uni.new(0xCFC2).NFKD.list ~~ (0x110F, 0x116C, 0x11C1,), 'CFC2 -> 110F 116C 11C1';
ok Uni.new(0xCFC3).NFKD.list ~~ (0x110F, 0x116C, 0x11C2,), 'CFC3 -> 110F 116C 11C2';
ok Uni.new(0xCFC4).NFKD.list ~~ (0x110F, 0x116D,), 'CFC4 -> 110F 116D';
ok Uni.new(0xCFC5).NFKD.list ~~ (0x110F, 0x116D, 0x11A8,), 'CFC5 -> 110F 116D 11A8';
ok Uni.new(0xCFC6).NFKD.list ~~ (0x110F, 0x116D, 0x11A9,), 'CFC6 -> 110F 116D 11A9';
ok Uni.new(0xCFC7).NFKD.list ~~ (0x110F, 0x116D, 0x11AA,), 'CFC7 -> 110F 116D 11AA';
ok Uni.new(0xCFC8).NFKD.list ~~ (0x110F, 0x116D, 0x11AB,), 'CFC8 -> 110F 116D 11AB';
ok Uni.new(0xCFC9).NFKD.list ~~ (0x110F, 0x116D, 0x11AC,), 'CFC9 -> 110F 116D 11AC';
ok Uni.new(0xCFCA).NFKD.list ~~ (0x110F, 0x116D, 0x11AD,), 'CFCA -> 110F 116D 11AD';
ok Uni.new(0xCFCB).NFKD.list ~~ (0x110F, 0x116D, 0x11AE,), 'CFCB -> 110F 116D 11AE';
ok Uni.new(0xCFCC).NFKD.list ~~ (0x110F, 0x116D, 0x11AF,), 'CFCC -> 110F 116D 11AF';
ok Uni.new(0xCFCD).NFKD.list ~~ (0x110F, 0x116D, 0x11B0,), 'CFCD -> 110F 116D 11B0';
ok Uni.new(0xCFCE).NFKD.list ~~ (0x110F, 0x116D, 0x11B1,), 'CFCE -> 110F 116D 11B1';
ok Uni.new(0xCFCF).NFKD.list ~~ (0x110F, 0x116D, 0x11B2,), 'CFCF -> 110F 116D 11B2';
ok Uni.new(0xCFD0).NFKD.list ~~ (0x110F, 0x116D, 0x11B3,), 'CFD0 -> 110F 116D 11B3';
ok Uni.new(0xCFD1).NFKD.list ~~ (0x110F, 0x116D, 0x11B4,), 'CFD1 -> 110F 116D 11B4';
ok Uni.new(0xCFD2).NFKD.list ~~ (0x110F, 0x116D, 0x11B5,), 'CFD2 -> 110F 116D 11B5';
ok Uni.new(0xCFD3).NFKD.list ~~ (0x110F, 0x116D, 0x11B6,), 'CFD3 -> 110F 116D 11B6';
ok Uni.new(0xCFD4).NFKD.list ~~ (0x110F, 0x116D, 0x11B7,), 'CFD4 -> 110F 116D 11B7';
ok Uni.new(0xCFD5).NFKD.list ~~ (0x110F, 0x116D, 0x11B8,), 'CFD5 -> 110F 116D 11B8';
ok Uni.new(0xCFD6).NFKD.list ~~ (0x110F, 0x116D, 0x11B9,), 'CFD6 -> 110F 116D 11B9';
ok Uni.new(0xCFD7).NFKD.list ~~ (0x110F, 0x116D, 0x11BA,), 'CFD7 -> 110F 116D 11BA';
ok Uni.new(0xCFD8).NFKD.list ~~ (0x110F, 0x116D, 0x11BB,), 'CFD8 -> 110F 116D 11BB';
ok Uni.new(0xCFD9).NFKD.list ~~ (0x110F, 0x116D, 0x11BC,), 'CFD9 -> 110F 116D 11BC';
ok Uni.new(0xCFDA).NFKD.list ~~ (0x110F, 0x116D, 0x11BD,), 'CFDA -> 110F 116D 11BD';
ok Uni.new(0xCFDB).NFKD.list ~~ (0x110F, 0x116D, 0x11BE,), 'CFDB -> 110F 116D 11BE';
ok Uni.new(0xCFDC).NFKD.list ~~ (0x110F, 0x116D, 0x11BF,), 'CFDC -> 110F 116D 11BF';
ok Uni.new(0xCFDD).NFKD.list ~~ (0x110F, 0x116D, 0x11C0,), 'CFDD -> 110F 116D 11C0';
ok Uni.new(0xCFDE).NFKD.list ~~ (0x110F, 0x116D, 0x11C1,), 'CFDE -> 110F 116D 11C1';
ok Uni.new(0xCFDF).NFKD.list ~~ (0x110F, 0x116D, 0x11C2,), 'CFDF -> 110F 116D 11C2';
ok Uni.new(0xCFE0).NFKD.list ~~ (0x110F, 0x116E,), 'CFE0 -> 110F 116E';
ok Uni.new(0xCFE1).NFKD.list ~~ (0x110F, 0x116E, 0x11A8,), 'CFE1 -> 110F 116E 11A8';
ok Uni.new(0xCFE2).NFKD.list ~~ (0x110F, 0x116E, 0x11A9,), 'CFE2 -> 110F 116E 11A9';
ok Uni.new(0xCFE3).NFKD.list ~~ (0x110F, 0x116E, 0x11AA,), 'CFE3 -> 110F 116E 11AA';
ok Uni.new(0xCFE4).NFKD.list ~~ (0x110F, 0x116E, 0x11AB,), 'CFE4 -> 110F 116E 11AB';
ok Uni.new(0xCFE5).NFKD.list ~~ (0x110F, 0x116E, 0x11AC,), 'CFE5 -> 110F 116E 11AC';
ok Uni.new(0xCFE6).NFKD.list ~~ (0x110F, 0x116E, 0x11AD,), 'CFE6 -> 110F 116E 11AD';
ok Uni.new(0xCFE7).NFKD.list ~~ (0x110F, 0x116E, 0x11AE,), 'CFE7 -> 110F 116E 11AE';
ok Uni.new(0xCFE8).NFKD.list ~~ (0x110F, 0x116E, 0x11AF,), 'CFE8 -> 110F 116E 11AF';
ok Uni.new(0xCFE9).NFKD.list ~~ (0x110F, 0x116E, 0x11B0,), 'CFE9 -> 110F 116E 11B0';
ok Uni.new(0xCFEA).NFKD.list ~~ (0x110F, 0x116E, 0x11B1,), 'CFEA -> 110F 116E 11B1';
ok Uni.new(0xCFEB).NFKD.list ~~ (0x110F, 0x116E, 0x11B2,), 'CFEB -> 110F 116E 11B2';
ok Uni.new(0xCFEC).NFKD.list ~~ (0x110F, 0x116E, 0x11B3,), 'CFEC -> 110F 116E 11B3';
ok Uni.new(0xCFED).NFKD.list ~~ (0x110F, 0x116E, 0x11B4,), 'CFED -> 110F 116E 11B4';
ok Uni.new(0xCFEE).NFKD.list ~~ (0x110F, 0x116E, 0x11B5,), 'CFEE -> 110F 116E 11B5';
ok Uni.new(0xCFEF).NFKD.list ~~ (0x110F, 0x116E, 0x11B6,), 'CFEF -> 110F 116E 11B6';
ok Uni.new(0xCFF0).NFKD.list ~~ (0x110F, 0x116E, 0x11B7,), 'CFF0 -> 110F 116E 11B7';
ok Uni.new(0xCFF1).NFKD.list ~~ (0x110F, 0x116E, 0x11B8,), 'CFF1 -> 110F 116E 11B8';
ok Uni.new(0xCFF2).NFKD.list ~~ (0x110F, 0x116E, 0x11B9,), 'CFF2 -> 110F 116E 11B9';
ok Uni.new(0xCFF3).NFKD.list ~~ (0x110F, 0x116E, 0x11BA,), 'CFF3 -> 110F 116E 11BA';
ok Uni.new(0xCFF4).NFKD.list ~~ (0x110F, 0x116E, 0x11BB,), 'CFF4 -> 110F 116E 11BB';
ok Uni.new(0xCFF5).NFKD.list ~~ (0x110F, 0x116E, 0x11BC,), 'CFF5 -> 110F 116E 11BC';
ok Uni.new(0xCFF6).NFKD.list ~~ (0x110F, 0x116E, 0x11BD,), 'CFF6 -> 110F 116E 11BD';
ok Uni.new(0xCFF7).NFKD.list ~~ (0x110F, 0x116E, 0x11BE,), 'CFF7 -> 110F 116E 11BE';
ok Uni.new(0xCFF8).NFKD.list ~~ (0x110F, 0x116E, 0x11BF,), 'CFF8 -> 110F 116E 11BF';
ok Uni.new(0xCFF9).NFKD.list ~~ (0x110F, 0x116E, 0x11C0,), 'CFF9 -> 110F 116E 11C0';
ok Uni.new(0xCFFA).NFKD.list ~~ (0x110F, 0x116E, 0x11C1,), 'CFFA -> 110F 116E 11C1';
ok Uni.new(0xCFFB).NFKD.list ~~ (0x110F, 0x116E, 0x11C2,), 'CFFB -> 110F 116E 11C2';
ok Uni.new(0xCFFC).NFKD.list ~~ (0x110F, 0x116F,), 'CFFC -> 110F 116F';
ok Uni.new(0xCFFD).NFKD.list ~~ (0x110F, 0x116F, 0x11A8,), 'CFFD -> 110F 116F 11A8';
ok Uni.new(0xCFFE).NFKD.list ~~ (0x110F, 0x116F, 0x11A9,), 'CFFE -> 110F 116F 11A9';
ok Uni.new(0xCFFF).NFKD.list ~~ (0x110F, 0x116F, 0x11AA,), 'CFFF -> 110F 116F 11AA';
ok Uni.new(0xD000).NFKD.list ~~ (0x110F, 0x116F, 0x11AB,), 'D000 -> 110F 116F 11AB';
ok Uni.new(0xD001).NFKD.list ~~ (0x110F, 0x116F, 0x11AC,), 'D001 -> 110F 116F 11AC';
ok Uni.new(0xD002).NFKD.list ~~ (0x110F, 0x116F, 0x11AD,), 'D002 -> 110F 116F 11AD';
ok Uni.new(0xD003).NFKD.list ~~ (0x110F, 0x116F, 0x11AE,), 'D003 -> 110F 116F 11AE';
ok Uni.new(0xD004).NFKD.list ~~ (0x110F, 0x116F, 0x11AF,), 'D004 -> 110F 116F 11AF';
ok Uni.new(0xD005).NFKD.list ~~ (0x110F, 0x116F, 0x11B0,), 'D005 -> 110F 116F 11B0';
ok Uni.new(0xD006).NFKD.list ~~ (0x110F, 0x116F, 0x11B1,), 'D006 -> 110F 116F 11B1';
ok Uni.new(0xD007).NFKD.list ~~ (0x110F, 0x116F, 0x11B2,), 'D007 -> 110F 116F 11B2';
ok Uni.new(0xD008).NFKD.list ~~ (0x110F, 0x116F, 0x11B3,), 'D008 -> 110F 116F 11B3';
ok Uni.new(0xD009).NFKD.list ~~ (0x110F, 0x116F, 0x11B4,), 'D009 -> 110F 116F 11B4';
ok Uni.new(0xD00A).NFKD.list ~~ (0x110F, 0x116F, 0x11B5,), 'D00A -> 110F 116F 11B5';
ok Uni.new(0xD00B).NFKD.list ~~ (0x110F, 0x116F, 0x11B6,), 'D00B -> 110F 116F 11B6';
ok Uni.new(0xD00C).NFKD.list ~~ (0x110F, 0x116F, 0x11B7,), 'D00C -> 110F 116F 11B7';
ok Uni.new(0xD00D).NFKD.list ~~ (0x110F, 0x116F, 0x11B8,), 'D00D -> 110F 116F 11B8';
ok Uni.new(0xD00E).NFKD.list ~~ (0x110F, 0x116F, 0x11B9,), 'D00E -> 110F 116F 11B9';
ok Uni.new(0xD00F).NFKD.list ~~ (0x110F, 0x116F, 0x11BA,), 'D00F -> 110F 116F 11BA';
ok Uni.new(0xD010).NFKD.list ~~ (0x110F, 0x116F, 0x11BB,), 'D010 -> 110F 116F 11BB';
ok Uni.new(0xD011).NFKD.list ~~ (0x110F, 0x116F, 0x11BC,), 'D011 -> 110F 116F 11BC';
ok Uni.new(0xD012).NFKD.list ~~ (0x110F, 0x116F, 0x11BD,), 'D012 -> 110F 116F 11BD';
ok Uni.new(0xD013).NFKD.list ~~ (0x110F, 0x116F, 0x11BE,), 'D013 -> 110F 116F 11BE';
ok Uni.new(0xD014).NFKD.list ~~ (0x110F, 0x116F, 0x11BF,), 'D014 -> 110F 116F 11BF';
ok Uni.new(0xD015).NFKD.list ~~ (0x110F, 0x116F, 0x11C0,), 'D015 -> 110F 116F 11C0';
ok Uni.new(0xD016).NFKD.list ~~ (0x110F, 0x116F, 0x11C1,), 'D016 -> 110F 116F 11C1';
ok Uni.new(0xD017).NFKD.list ~~ (0x110F, 0x116F, 0x11C2,), 'D017 -> 110F 116F 11C2';
ok Uni.new(0xD018).NFKD.list ~~ (0x110F, 0x1170,), 'D018 -> 110F 1170';
ok Uni.new(0xD019).NFKD.list ~~ (0x110F, 0x1170, 0x11A8,), 'D019 -> 110F 1170 11A8';
ok Uni.new(0xD01A).NFKD.list ~~ (0x110F, 0x1170, 0x11A9,), 'D01A -> 110F 1170 11A9';
ok Uni.new(0xD01B).NFKD.list ~~ (0x110F, 0x1170, 0x11AA,), 'D01B -> 110F 1170 11AA';
ok Uni.new(0xD01C).NFKD.list ~~ (0x110F, 0x1170, 0x11AB,), 'D01C -> 110F 1170 11AB';
ok Uni.new(0xD01D).NFKD.list ~~ (0x110F, 0x1170, 0x11AC,), 'D01D -> 110F 1170 11AC';
ok Uni.new(0xD01E).NFKD.list ~~ (0x110F, 0x1170, 0x11AD,), 'D01E -> 110F 1170 11AD';
ok Uni.new(0xD01F).NFKD.list ~~ (0x110F, 0x1170, 0x11AE,), 'D01F -> 110F 1170 11AE';
ok Uni.new(0xD020).NFKD.list ~~ (0x110F, 0x1170, 0x11AF,), 'D020 -> 110F 1170 11AF';
ok Uni.new(0xD021).NFKD.list ~~ (0x110F, 0x1170, 0x11B0,), 'D021 -> 110F 1170 11B0';
ok Uni.new(0xD022).NFKD.list ~~ (0x110F, 0x1170, 0x11B1,), 'D022 -> 110F 1170 11B1';
ok Uni.new(0xD023).NFKD.list ~~ (0x110F, 0x1170, 0x11B2,), 'D023 -> 110F 1170 11B2';
ok Uni.new(0xD024).NFKD.list ~~ (0x110F, 0x1170, 0x11B3,), 'D024 -> 110F 1170 11B3';
ok Uni.new(0xD025).NFKD.list ~~ (0x110F, 0x1170, 0x11B4,), 'D025 -> 110F 1170 11B4';
ok Uni.new(0xD026).NFKD.list ~~ (0x110F, 0x1170, 0x11B5,), 'D026 -> 110F 1170 11B5';
ok Uni.new(0xD027).NFKD.list ~~ (0x110F, 0x1170, 0x11B6,), 'D027 -> 110F 1170 11B6';
ok Uni.new(0xD028).NFKD.list ~~ (0x110F, 0x1170, 0x11B7,), 'D028 -> 110F 1170 11B7';
ok Uni.new(0xD029).NFKD.list ~~ (0x110F, 0x1170, 0x11B8,), 'D029 -> 110F 1170 11B8';
ok Uni.new(0xD02A).NFKD.list ~~ (0x110F, 0x1170, 0x11B9,), 'D02A -> 110F 1170 11B9';
ok Uni.new(0xD02B).NFKD.list ~~ (0x110F, 0x1170, 0x11BA,), 'D02B -> 110F 1170 11BA';
ok Uni.new(0xD02C).NFKD.list ~~ (0x110F, 0x1170, 0x11BB,), 'D02C -> 110F 1170 11BB';
ok Uni.new(0xD02D).NFKD.list ~~ (0x110F, 0x1170, 0x11BC,), 'D02D -> 110F 1170 11BC';
ok Uni.new(0xD02E).NFKD.list ~~ (0x110F, 0x1170, 0x11BD,), 'D02E -> 110F 1170 11BD';
ok Uni.new(0xD02F).NFKD.list ~~ (0x110F, 0x1170, 0x11BE,), 'D02F -> 110F 1170 11BE';
ok Uni.new(0xD030).NFKD.list ~~ (0x110F, 0x1170, 0x11BF,), 'D030 -> 110F 1170 11BF';
ok Uni.new(0xD031).NFKD.list ~~ (0x110F, 0x1170, 0x11C0,), 'D031 -> 110F 1170 11C0';
ok Uni.new(0xD032).NFKD.list ~~ (0x110F, 0x1170, 0x11C1,), 'D032 -> 110F 1170 11C1';
ok Uni.new(0xD033).NFKD.list ~~ (0x110F, 0x1170, 0x11C2,), 'D033 -> 110F 1170 11C2';
ok Uni.new(0xD034).NFKD.list ~~ (0x110F, 0x1171,), 'D034 -> 110F 1171';
ok Uni.new(0xD035).NFKD.list ~~ (0x110F, 0x1171, 0x11A8,), 'D035 -> 110F 1171 11A8';
ok Uni.new(0xD036).NFKD.list ~~ (0x110F, 0x1171, 0x11A9,), 'D036 -> 110F 1171 11A9';
ok Uni.new(0xD037).NFKD.list ~~ (0x110F, 0x1171, 0x11AA,), 'D037 -> 110F 1171 11AA';
ok Uni.new(0xD038).NFKD.list ~~ (0x110F, 0x1171, 0x11AB,), 'D038 -> 110F 1171 11AB';
ok Uni.new(0xD039).NFKD.list ~~ (0x110F, 0x1171, 0x11AC,), 'D039 -> 110F 1171 11AC';
ok Uni.new(0xD03A).NFKD.list ~~ (0x110F, 0x1171, 0x11AD,), 'D03A -> 110F 1171 11AD';
ok Uni.new(0xD03B).NFKD.list ~~ (0x110F, 0x1171, 0x11AE,), 'D03B -> 110F 1171 11AE';
ok Uni.new(0xD03C).NFKD.list ~~ (0x110F, 0x1171, 0x11AF,), 'D03C -> 110F 1171 11AF';
ok Uni.new(0xD03D).NFKD.list ~~ (0x110F, 0x1171, 0x11B0,), 'D03D -> 110F 1171 11B0';
ok Uni.new(0xD03E).NFKD.list ~~ (0x110F, 0x1171, 0x11B1,), 'D03E -> 110F 1171 11B1';
ok Uni.new(0xD03F).NFKD.list ~~ (0x110F, 0x1171, 0x11B2,), 'D03F -> 110F 1171 11B2';
ok Uni.new(0xD040).NFKD.list ~~ (0x110F, 0x1171, 0x11B3,), 'D040 -> 110F 1171 11B3';
ok Uni.new(0xD041).NFKD.list ~~ (0x110F, 0x1171, 0x11B4,), 'D041 -> 110F 1171 11B4';
ok Uni.new(0xD042).NFKD.list ~~ (0x110F, 0x1171, 0x11B5,), 'D042 -> 110F 1171 11B5';
ok Uni.new(0xD043).NFKD.list ~~ (0x110F, 0x1171, 0x11B6,), 'D043 -> 110F 1171 11B6';
ok Uni.new(0xD044).NFKD.list ~~ (0x110F, 0x1171, 0x11B7,), 'D044 -> 110F 1171 11B7';
ok Uni.new(0xD045).NFKD.list ~~ (0x110F, 0x1171, 0x11B8,), 'D045 -> 110F 1171 11B8';
ok Uni.new(0xD046).NFKD.list ~~ (0x110F, 0x1171, 0x11B9,), 'D046 -> 110F 1171 11B9';
ok Uni.new(0xD047).NFKD.list ~~ (0x110F, 0x1171, 0x11BA,), 'D047 -> 110F 1171 11BA';
ok Uni.new(0xD048).NFKD.list ~~ (0x110F, 0x1171, 0x11BB,), 'D048 -> 110F 1171 11BB';
ok Uni.new(0xD049).NFKD.list ~~ (0x110F, 0x1171, 0x11BC,), 'D049 -> 110F 1171 11BC';
ok Uni.new(0xD04A).NFKD.list ~~ (0x110F, 0x1171, 0x11BD,), 'D04A -> 110F 1171 11BD';
ok Uni.new(0xD04B).NFKD.list ~~ (0x110F, 0x1171, 0x11BE,), 'D04B -> 110F 1171 11BE';
ok Uni.new(0xD04C).NFKD.list ~~ (0x110F, 0x1171, 0x11BF,), 'D04C -> 110F 1171 11BF';
ok Uni.new(0xD04D).NFKD.list ~~ (0x110F, 0x1171, 0x11C0,), 'D04D -> 110F 1171 11C0';
ok Uni.new(0xD04E).NFKD.list ~~ (0x110F, 0x1171, 0x11C1,), 'D04E -> 110F 1171 11C1';
ok Uni.new(0xD04F).NFKD.list ~~ (0x110F, 0x1171, 0x11C2,), 'D04F -> 110F 1171 11C2';
ok Uni.new(0xD050).NFKD.list ~~ (0x110F, 0x1172,), 'D050 -> 110F 1172';
ok Uni.new(0xD051).NFKD.list ~~ (0x110F, 0x1172, 0x11A8,), 'D051 -> 110F 1172 11A8';
ok Uni.new(0xD052).NFKD.list ~~ (0x110F, 0x1172, 0x11A9,), 'D052 -> 110F 1172 11A9';
ok Uni.new(0xD053).NFKD.list ~~ (0x110F, 0x1172, 0x11AA,), 'D053 -> 110F 1172 11AA';
ok Uni.new(0xD054).NFKD.list ~~ (0x110F, 0x1172, 0x11AB,), 'D054 -> 110F 1172 11AB';
ok Uni.new(0xD055).NFKD.list ~~ (0x110F, 0x1172, 0x11AC,), 'D055 -> 110F 1172 11AC';
ok Uni.new(0xD056).NFKD.list ~~ (0x110F, 0x1172, 0x11AD,), 'D056 -> 110F 1172 11AD';
ok Uni.new(0xD057).NFKD.list ~~ (0x110F, 0x1172, 0x11AE,), 'D057 -> 110F 1172 11AE';
ok Uni.new(0xD058).NFKD.list ~~ (0x110F, 0x1172, 0x11AF,), 'D058 -> 110F 1172 11AF';
ok Uni.new(0xD059).NFKD.list ~~ (0x110F, 0x1172, 0x11B0,), 'D059 -> 110F 1172 11B0';
ok Uni.new(0xD05A).NFKD.list ~~ (0x110F, 0x1172, 0x11B1,), 'D05A -> 110F 1172 11B1';
ok Uni.new(0xD05B).NFKD.list ~~ (0x110F, 0x1172, 0x11B2,), 'D05B -> 110F 1172 11B2';
ok Uni.new(0xD05C).NFKD.list ~~ (0x110F, 0x1172, 0x11B3,), 'D05C -> 110F 1172 11B3';
ok Uni.new(0xD05D).NFKD.list ~~ (0x110F, 0x1172, 0x11B4,), 'D05D -> 110F 1172 11B4';
ok Uni.new(0xD05E).NFKD.list ~~ (0x110F, 0x1172, 0x11B5,), 'D05E -> 110F 1172 11B5';
ok Uni.new(0xD05F).NFKD.list ~~ (0x110F, 0x1172, 0x11B6,), 'D05F -> 110F 1172 11B6';
ok Uni.new(0xD060).NFKD.list ~~ (0x110F, 0x1172, 0x11B7,), 'D060 -> 110F 1172 11B7';
ok Uni.new(0xD061).NFKD.list ~~ (0x110F, 0x1172, 0x11B8,), 'D061 -> 110F 1172 11B8';
ok Uni.new(0xD062).NFKD.list ~~ (0x110F, 0x1172, 0x11B9,), 'D062 -> 110F 1172 11B9';
ok Uni.new(0xD063).NFKD.list ~~ (0x110F, 0x1172, 0x11BA,), 'D063 -> 110F 1172 11BA';
ok Uni.new(0xD064).NFKD.list ~~ (0x110F, 0x1172, 0x11BB,), 'D064 -> 110F 1172 11BB';
ok Uni.new(0xD065).NFKD.list ~~ (0x110F, 0x1172, 0x11BC,), 'D065 -> 110F 1172 11BC';
ok Uni.new(0xD066).NFKD.list ~~ (0x110F, 0x1172, 0x11BD,), 'D066 -> 110F 1172 11BD';
ok Uni.new(0xD067).NFKD.list ~~ (0x110F, 0x1172, 0x11BE,), 'D067 -> 110F 1172 11BE';
ok Uni.new(0xD068).NFKD.list ~~ (0x110F, 0x1172, 0x11BF,), 'D068 -> 110F 1172 11BF';
ok Uni.new(0xD069).NFKD.list ~~ (0x110F, 0x1172, 0x11C0,), 'D069 -> 110F 1172 11C0';
ok Uni.new(0xD06A).NFKD.list ~~ (0x110F, 0x1172, 0x11C1,), 'D06A -> 110F 1172 11C1';
ok Uni.new(0xD06B).NFKD.list ~~ (0x110F, 0x1172, 0x11C2,), 'D06B -> 110F 1172 11C2';
ok Uni.new(0xD06C).NFKD.list ~~ (0x110F, 0x1173,), 'D06C -> 110F 1173';
ok Uni.new(0xD06D).NFKD.list ~~ (0x110F, 0x1173, 0x11A8,), 'D06D -> 110F 1173 11A8';
ok Uni.new(0xD06E).NFKD.list ~~ (0x110F, 0x1173, 0x11A9,), 'D06E -> 110F 1173 11A9';
ok Uni.new(0xD06F).NFKD.list ~~ (0x110F, 0x1173, 0x11AA,), 'D06F -> 110F 1173 11AA';
ok Uni.new(0xD070).NFKD.list ~~ (0x110F, 0x1173, 0x11AB,), 'D070 -> 110F 1173 11AB';
ok Uni.new(0xD071).NFKD.list ~~ (0x110F, 0x1173, 0x11AC,), 'D071 -> 110F 1173 11AC';
ok Uni.new(0xD072).NFKD.list ~~ (0x110F, 0x1173, 0x11AD,), 'D072 -> 110F 1173 11AD';
ok Uni.new(0xD073).NFKD.list ~~ (0x110F, 0x1173, 0x11AE,), 'D073 -> 110F 1173 11AE';
ok Uni.new(0xD074).NFKD.list ~~ (0x110F, 0x1173, 0x11AF,), 'D074 -> 110F 1173 11AF';
ok Uni.new(0xD075).NFKD.list ~~ (0x110F, 0x1173, 0x11B0,), 'D075 -> 110F 1173 11B0';
ok Uni.new(0xD076).NFKD.list ~~ (0x110F, 0x1173, 0x11B1,), 'D076 -> 110F 1173 11B1';
ok Uni.new(0xD077).NFKD.list ~~ (0x110F, 0x1173, 0x11B2,), 'D077 -> 110F 1173 11B2';
ok Uni.new(0xD078).NFKD.list ~~ (0x110F, 0x1173, 0x11B3,), 'D078 -> 110F 1173 11B3';
ok Uni.new(0xD079).NFKD.list ~~ (0x110F, 0x1173, 0x11B4,), 'D079 -> 110F 1173 11B4';
ok Uni.new(0xD07A).NFKD.list ~~ (0x110F, 0x1173, 0x11B5,), 'D07A -> 110F 1173 11B5';
ok Uni.new(0xD07B).NFKD.list ~~ (0x110F, 0x1173, 0x11B6,), 'D07B -> 110F 1173 11B6';
ok Uni.new(0xD07C).NFKD.list ~~ (0x110F, 0x1173, 0x11B7,), 'D07C -> 110F 1173 11B7';
ok Uni.new(0xD07D).NFKD.list ~~ (0x110F, 0x1173, 0x11B8,), 'D07D -> 110F 1173 11B8';
ok Uni.new(0xD07E).NFKD.list ~~ (0x110F, 0x1173, 0x11B9,), 'D07E -> 110F 1173 11B9';
ok Uni.new(0xD07F).NFKD.list ~~ (0x110F, 0x1173, 0x11BA,), 'D07F -> 110F 1173 11BA';
ok Uni.new(0xD080).NFKD.list ~~ (0x110F, 0x1173, 0x11BB,), 'D080 -> 110F 1173 11BB';
ok Uni.new(0xD081).NFKD.list ~~ (0x110F, 0x1173, 0x11BC,), 'D081 -> 110F 1173 11BC';
ok Uni.new(0xD082).NFKD.list ~~ (0x110F, 0x1173, 0x11BD,), 'D082 -> 110F 1173 11BD';
ok Uni.new(0xD083).NFKD.list ~~ (0x110F, 0x1173, 0x11BE,), 'D083 -> 110F 1173 11BE';
ok Uni.new(0xD084).NFKD.list ~~ (0x110F, 0x1173, 0x11BF,), 'D084 -> 110F 1173 11BF';
ok Uni.new(0xD085).NFKD.list ~~ (0x110F, 0x1173, 0x11C0,), 'D085 -> 110F 1173 11C0';
ok Uni.new(0xD086).NFKD.list ~~ (0x110F, 0x1173, 0x11C1,), 'D086 -> 110F 1173 11C1';
ok Uni.new(0xD087).NFKD.list ~~ (0x110F, 0x1173, 0x11C2,), 'D087 -> 110F 1173 11C2';
ok Uni.new(0xD088).NFKD.list ~~ (0x110F, 0x1174,), 'D088 -> 110F 1174';
ok Uni.new(0xD089).NFKD.list ~~ (0x110F, 0x1174, 0x11A8,), 'D089 -> 110F 1174 11A8';
ok Uni.new(0xD08A).NFKD.list ~~ (0x110F, 0x1174, 0x11A9,), 'D08A -> 110F 1174 11A9';
ok Uni.new(0xD08B).NFKD.list ~~ (0x110F, 0x1174, 0x11AA,), 'D08B -> 110F 1174 11AA';
ok Uni.new(0xD08C).NFKD.list ~~ (0x110F, 0x1174, 0x11AB,), 'D08C -> 110F 1174 11AB';
ok Uni.new(0xD08D).NFKD.list ~~ (0x110F, 0x1174, 0x11AC,), 'D08D -> 110F 1174 11AC';
ok Uni.new(0xD08E).NFKD.list ~~ (0x110F, 0x1174, 0x11AD,), 'D08E -> 110F 1174 11AD';
ok Uni.new(0xD08F).NFKD.list ~~ (0x110F, 0x1174, 0x11AE,), 'D08F -> 110F 1174 11AE';
ok Uni.new(0xD090).NFKD.list ~~ (0x110F, 0x1174, 0x11AF,), 'D090 -> 110F 1174 11AF';
ok Uni.new(0xD091).NFKD.list ~~ (0x110F, 0x1174, 0x11B0,), 'D091 -> 110F 1174 11B0';
ok Uni.new(0xD092).NFKD.list ~~ (0x110F, 0x1174, 0x11B1,), 'D092 -> 110F 1174 11B1';
ok Uni.new(0xD093).NFKD.list ~~ (0x110F, 0x1174, 0x11B2,), 'D093 -> 110F 1174 11B2';
ok Uni.new(0xD094).NFKD.list ~~ (0x110F, 0x1174, 0x11B3,), 'D094 -> 110F 1174 11B3';
ok Uni.new(0xD095).NFKD.list ~~ (0x110F, 0x1174, 0x11B4,), 'D095 -> 110F 1174 11B4';
ok Uni.new(0xD096).NFKD.list ~~ (0x110F, 0x1174, 0x11B5,), 'D096 -> 110F 1174 11B5';
ok Uni.new(0xD097).NFKD.list ~~ (0x110F, 0x1174, 0x11B6,), 'D097 -> 110F 1174 11B6';
ok Uni.new(0xD098).NFKD.list ~~ (0x110F, 0x1174, 0x11B7,), 'D098 -> 110F 1174 11B7';
ok Uni.new(0xD099).NFKD.list ~~ (0x110F, 0x1174, 0x11B8,), 'D099 -> 110F 1174 11B8';
ok Uni.new(0xD09A).NFKD.list ~~ (0x110F, 0x1174, 0x11B9,), 'D09A -> 110F 1174 11B9';
ok Uni.new(0xD09B).NFKD.list ~~ (0x110F, 0x1174, 0x11BA,), 'D09B -> 110F 1174 11BA';
ok Uni.new(0xD09C).NFKD.list ~~ (0x110F, 0x1174, 0x11BB,), 'D09C -> 110F 1174 11BB';
ok Uni.new(0xD09D).NFKD.list ~~ (0x110F, 0x1174, 0x11BC,), 'D09D -> 110F 1174 11BC';
ok Uni.new(0xD09E).NFKD.list ~~ (0x110F, 0x1174, 0x11BD,), 'D09E -> 110F 1174 11BD';
ok Uni.new(0xD09F).NFKD.list ~~ (0x110F, 0x1174, 0x11BE,), 'D09F -> 110F 1174 11BE';
ok Uni.new(0xD0A0).NFKD.list ~~ (0x110F, 0x1174, 0x11BF,), 'D0A0 -> 110F 1174 11BF';
ok Uni.new(0xD0A1).NFKD.list ~~ (0x110F, 0x1174, 0x11C0,), 'D0A1 -> 110F 1174 11C0';
ok Uni.new(0xD0A2).NFKD.list ~~ (0x110F, 0x1174, 0x11C1,), 'D0A2 -> 110F 1174 11C1';
ok Uni.new(0xD0A3).NFKD.list ~~ (0x110F, 0x1174, 0x11C2,), 'D0A3 -> 110F 1174 11C2';
ok Uni.new(0xD0A4).NFKD.list ~~ (0x110F, 0x1175,), 'D0A4 -> 110F 1175';
ok Uni.new(0xD0A5).NFKD.list ~~ (0x110F, 0x1175, 0x11A8,), 'D0A5 -> 110F 1175 11A8';
ok Uni.new(0xD0A6).NFKD.list ~~ (0x110F, 0x1175, 0x11A9,), 'D0A6 -> 110F 1175 11A9';
ok Uni.new(0xD0A7).NFKD.list ~~ (0x110F, 0x1175, 0x11AA,), 'D0A7 -> 110F 1175 11AA';
ok Uni.new(0xD0A8).NFKD.list ~~ (0x110F, 0x1175, 0x11AB,), 'D0A8 -> 110F 1175 11AB';
ok Uni.new(0xD0A9).NFKD.list ~~ (0x110F, 0x1175, 0x11AC,), 'D0A9 -> 110F 1175 11AC';
ok Uni.new(0xD0AA).NFKD.list ~~ (0x110F, 0x1175, 0x11AD,), 'D0AA -> 110F 1175 11AD';
ok Uni.new(0xD0AB).NFKD.list ~~ (0x110F, 0x1175, 0x11AE,), 'D0AB -> 110F 1175 11AE';
ok Uni.new(0xD0AC).NFKD.list ~~ (0x110F, 0x1175, 0x11AF,), 'D0AC -> 110F 1175 11AF';
ok Uni.new(0xD0AD).NFKD.list ~~ (0x110F, 0x1175, 0x11B0,), 'D0AD -> 110F 1175 11B0';
ok Uni.new(0xD0AE).NFKD.list ~~ (0x110F, 0x1175, 0x11B1,), 'D0AE -> 110F 1175 11B1';
ok Uni.new(0xD0AF).NFKD.list ~~ (0x110F, 0x1175, 0x11B2,), 'D0AF -> 110F 1175 11B2';
ok Uni.new(0xD0B0).NFKD.list ~~ (0x110F, 0x1175, 0x11B3,), 'D0B0 -> 110F 1175 11B3';
ok Uni.new(0xD0B1).NFKD.list ~~ (0x110F, 0x1175, 0x11B4,), 'D0B1 -> 110F 1175 11B4';
ok Uni.new(0xD0B2).NFKD.list ~~ (0x110F, 0x1175, 0x11B5,), 'D0B2 -> 110F 1175 11B5';
ok Uni.new(0xD0B3).NFKD.list ~~ (0x110F, 0x1175, 0x11B6,), 'D0B3 -> 110F 1175 11B6';
ok Uni.new(0xD0B4).NFKD.list ~~ (0x110F, 0x1175, 0x11B7,), 'D0B4 -> 110F 1175 11B7';
ok Uni.new(0xD0B5).NFKD.list ~~ (0x110F, 0x1175, 0x11B8,), 'D0B5 -> 110F 1175 11B8';
ok Uni.new(0xD0B6).NFKD.list ~~ (0x110F, 0x1175, 0x11B9,), 'D0B6 -> 110F 1175 11B9';
ok Uni.new(0xD0B7).NFKD.list ~~ (0x110F, 0x1175, 0x11BA,), 'D0B7 -> 110F 1175 11BA';
ok Uni.new(0xD0B8).NFKD.list ~~ (0x110F, 0x1175, 0x11BB,), 'D0B8 -> 110F 1175 11BB';
ok Uni.new(0xD0B9).NFKD.list ~~ (0x110F, 0x1175, 0x11BC,), 'D0B9 -> 110F 1175 11BC';
ok Uni.new(0xD0BA).NFKD.list ~~ (0x110F, 0x1175, 0x11BD,), 'D0BA -> 110F 1175 11BD';
ok Uni.new(0xD0BB).NFKD.list ~~ (0x110F, 0x1175, 0x11BE,), 'D0BB -> 110F 1175 11BE';
ok Uni.new(0xD0BC).NFKD.list ~~ (0x110F, 0x1175, 0x11BF,), 'D0BC -> 110F 1175 11BF';
ok Uni.new(0xD0BD).NFKD.list ~~ (0x110F, 0x1175, 0x11C0,), 'D0BD -> 110F 1175 11C0';
ok Uni.new(0xD0BE).NFKD.list ~~ (0x110F, 0x1175, 0x11C1,), 'D0BE -> 110F 1175 11C1';
ok Uni.new(0xD0BF).NFKD.list ~~ (0x110F, 0x1175, 0x11C2,), 'D0BF -> 110F 1175 11C2';
ok Uni.new(0xD0C0).NFKD.list ~~ (0x1110, 0x1161,), 'D0C0 -> 1110 1161';
ok Uni.new(0xD0C1).NFKD.list ~~ (0x1110, 0x1161, 0x11A8,), 'D0C1 -> 1110 1161 11A8';
ok Uni.new(0xD0C2).NFKD.list ~~ (0x1110, 0x1161, 0x11A9,), 'D0C2 -> 1110 1161 11A9';
ok Uni.new(0xD0C3).NFKD.list ~~ (0x1110, 0x1161, 0x11AA,), 'D0C3 -> 1110 1161 11AA';
ok Uni.new(0xD0C4).NFKD.list ~~ (0x1110, 0x1161, 0x11AB,), 'D0C4 -> 1110 1161 11AB';
ok Uni.new(0xD0C5).NFKD.list ~~ (0x1110, 0x1161, 0x11AC,), 'D0C5 -> 1110 1161 11AC';
ok Uni.new(0xD0C6).NFKD.list ~~ (0x1110, 0x1161, 0x11AD,), 'D0C6 -> 1110 1161 11AD';
ok Uni.new(0xD0C7).NFKD.list ~~ (0x1110, 0x1161, 0x11AE,), 'D0C7 -> 1110 1161 11AE';
ok Uni.new(0xD0C8).NFKD.list ~~ (0x1110, 0x1161, 0x11AF,), 'D0C8 -> 1110 1161 11AF';
ok Uni.new(0xD0C9).NFKD.list ~~ (0x1110, 0x1161, 0x11B0,), 'D0C9 -> 1110 1161 11B0';
ok Uni.new(0xD0CA).NFKD.list ~~ (0x1110, 0x1161, 0x11B1,), 'D0CA -> 1110 1161 11B1';
ok Uni.new(0xD0CB).NFKD.list ~~ (0x1110, 0x1161, 0x11B2,), 'D0CB -> 1110 1161 11B2';
ok Uni.new(0xD0CC).NFKD.list ~~ (0x1110, 0x1161, 0x11B3,), 'D0CC -> 1110 1161 11B3';
ok Uni.new(0xD0CD).NFKD.list ~~ (0x1110, 0x1161, 0x11B4,), 'D0CD -> 1110 1161 11B4';
ok Uni.new(0xD0CE).NFKD.list ~~ (0x1110, 0x1161, 0x11B5,), 'D0CE -> 1110 1161 11B5';
ok Uni.new(0xD0CF).NFKD.list ~~ (0x1110, 0x1161, 0x11B6,), 'D0CF -> 1110 1161 11B6';
ok Uni.new(0xD0D0).NFKD.list ~~ (0x1110, 0x1161, 0x11B7,), 'D0D0 -> 1110 1161 11B7';
ok Uni.new(0xD0D1).NFKD.list ~~ (0x1110, 0x1161, 0x11B8,), 'D0D1 -> 1110 1161 11B8';
ok Uni.new(0xD0D2).NFKD.list ~~ (0x1110, 0x1161, 0x11B9,), 'D0D2 -> 1110 1161 11B9';
ok Uni.new(0xD0D3).NFKD.list ~~ (0x1110, 0x1161, 0x11BA,), 'D0D3 -> 1110 1161 11BA';
ok Uni.new(0xD0D4).NFKD.list ~~ (0x1110, 0x1161, 0x11BB,), 'D0D4 -> 1110 1161 11BB';
ok Uni.new(0xD0D5).NFKD.list ~~ (0x1110, 0x1161, 0x11BC,), 'D0D5 -> 1110 1161 11BC';
ok Uni.new(0xD0D6).NFKD.list ~~ (0x1110, 0x1161, 0x11BD,), 'D0D6 -> 1110 1161 11BD';
ok Uni.new(0xD0D7).NFKD.list ~~ (0x1110, 0x1161, 0x11BE,), 'D0D7 -> 1110 1161 11BE';
ok Uni.new(0xD0D8).NFKD.list ~~ (0x1110, 0x1161, 0x11BF,), 'D0D8 -> 1110 1161 11BF';
ok Uni.new(0xD0D9).NFKD.list ~~ (0x1110, 0x1161, 0x11C0,), 'D0D9 -> 1110 1161 11C0';
ok Uni.new(0xD0DA).NFKD.list ~~ (0x1110, 0x1161, 0x11C1,), 'D0DA -> 1110 1161 11C1';
ok Uni.new(0xD0DB).NFKD.list ~~ (0x1110, 0x1161, 0x11C2,), 'D0DB -> 1110 1161 11C2';
ok Uni.new(0xD0DC).NFKD.list ~~ (0x1110, 0x1162,), 'D0DC -> 1110 1162';
ok Uni.new(0xD0DD).NFKD.list ~~ (0x1110, 0x1162, 0x11A8,), 'D0DD -> 1110 1162 11A8';
ok Uni.new(0xD0DE).NFKD.list ~~ (0x1110, 0x1162, 0x11A9,), 'D0DE -> 1110 1162 11A9';
ok Uni.new(0xD0DF).NFKD.list ~~ (0x1110, 0x1162, 0x11AA,), 'D0DF -> 1110 1162 11AA';
ok Uni.new(0xD0E0).NFKD.list ~~ (0x1110, 0x1162, 0x11AB,), 'D0E0 -> 1110 1162 11AB';
ok Uni.new(0xD0E1).NFKD.list ~~ (0x1110, 0x1162, 0x11AC,), 'D0E1 -> 1110 1162 11AC';
ok Uni.new(0xD0E2).NFKD.list ~~ (0x1110, 0x1162, 0x11AD,), 'D0E2 -> 1110 1162 11AD';
ok Uni.new(0xD0E3).NFKD.list ~~ (0x1110, 0x1162, 0x11AE,), 'D0E3 -> 1110 1162 11AE';
ok Uni.new(0xD0E4).NFKD.list ~~ (0x1110, 0x1162, 0x11AF,), 'D0E4 -> 1110 1162 11AF';
ok Uni.new(0xD0E5).NFKD.list ~~ (0x1110, 0x1162, 0x11B0,), 'D0E5 -> 1110 1162 11B0';
ok Uni.new(0xD0E6).NFKD.list ~~ (0x1110, 0x1162, 0x11B1,), 'D0E6 -> 1110 1162 11B1';
ok Uni.new(0xD0E7).NFKD.list ~~ (0x1110, 0x1162, 0x11B2,), 'D0E7 -> 1110 1162 11B2';
ok Uni.new(0xD0E8).NFKD.list ~~ (0x1110, 0x1162, 0x11B3,), 'D0E8 -> 1110 1162 11B3';
ok Uni.new(0xD0E9).NFKD.list ~~ (0x1110, 0x1162, 0x11B4,), 'D0E9 -> 1110 1162 11B4';
ok Uni.new(0xD0EA).NFKD.list ~~ (0x1110, 0x1162, 0x11B5,), 'D0EA -> 1110 1162 11B5';
ok Uni.new(0xD0EB).NFKD.list ~~ (0x1110, 0x1162, 0x11B6,), 'D0EB -> 1110 1162 11B6';
ok Uni.new(0xD0EC).NFKD.list ~~ (0x1110, 0x1162, 0x11B7,), 'D0EC -> 1110 1162 11B7';
ok Uni.new(0xD0ED).NFKD.list ~~ (0x1110, 0x1162, 0x11B8,), 'D0ED -> 1110 1162 11B8';
ok Uni.new(0xD0EE).NFKD.list ~~ (0x1110, 0x1162, 0x11B9,), 'D0EE -> 1110 1162 11B9';
ok Uni.new(0xD0EF).NFKD.list ~~ (0x1110, 0x1162, 0x11BA,), 'D0EF -> 1110 1162 11BA';
ok Uni.new(0xD0F0).NFKD.list ~~ (0x1110, 0x1162, 0x11BB,), 'D0F0 -> 1110 1162 11BB';
ok Uni.new(0xD0F1).NFKD.list ~~ (0x1110, 0x1162, 0x11BC,), 'D0F1 -> 1110 1162 11BC';
ok Uni.new(0xD0F2).NFKD.list ~~ (0x1110, 0x1162, 0x11BD,), 'D0F2 -> 1110 1162 11BD';
ok Uni.new(0xD0F3).NFKD.list ~~ (0x1110, 0x1162, 0x11BE,), 'D0F3 -> 1110 1162 11BE';
ok Uni.new(0xD0F4).NFKD.list ~~ (0x1110, 0x1162, 0x11BF,), 'D0F4 -> 1110 1162 11BF';
ok Uni.new(0xD0F5).NFKD.list ~~ (0x1110, 0x1162, 0x11C0,), 'D0F5 -> 1110 1162 11C0';
ok Uni.new(0xD0F6).NFKD.list ~~ (0x1110, 0x1162, 0x11C1,), 'D0F6 -> 1110 1162 11C1';
ok Uni.new(0xD0F7).NFKD.list ~~ (0x1110, 0x1162, 0x11C2,), 'D0F7 -> 1110 1162 11C2';
ok Uni.new(0xD0F8).NFKD.list ~~ (0x1110, 0x1163,), 'D0F8 -> 1110 1163';
ok Uni.new(0xD0F9).NFKD.list ~~ (0x1110, 0x1163, 0x11A8,), 'D0F9 -> 1110 1163 11A8';
ok Uni.new(0xD0FA).NFKD.list ~~ (0x1110, 0x1163, 0x11A9,), 'D0FA -> 1110 1163 11A9';
ok Uni.new(0xD0FB).NFKD.list ~~ (0x1110, 0x1163, 0x11AA,), 'D0FB -> 1110 1163 11AA';
ok Uni.new(0xD0FC).NFKD.list ~~ (0x1110, 0x1163, 0x11AB,), 'D0FC -> 1110 1163 11AB';
ok Uni.new(0xD0FD).NFKD.list ~~ (0x1110, 0x1163, 0x11AC,), 'D0FD -> 1110 1163 11AC';
ok Uni.new(0xD0FE).NFKD.list ~~ (0x1110, 0x1163, 0x11AD,), 'D0FE -> 1110 1163 11AD';
ok Uni.new(0xD0FF).NFKD.list ~~ (0x1110, 0x1163, 0x11AE,), 'D0FF -> 1110 1163 11AE';
ok Uni.new(0xD100).NFKD.list ~~ (0x1110, 0x1163, 0x11AF,), 'D100 -> 1110 1163 11AF';
ok Uni.new(0xD101).NFKD.list ~~ (0x1110, 0x1163, 0x11B0,), 'D101 -> 1110 1163 11B0';
ok Uni.new(0xD102).NFKD.list ~~ (0x1110, 0x1163, 0x11B1,), 'D102 -> 1110 1163 11B1';
ok Uni.new(0xD103).NFKD.list ~~ (0x1110, 0x1163, 0x11B2,), 'D103 -> 1110 1163 11B2';
ok Uni.new(0xD104).NFKD.list ~~ (0x1110, 0x1163, 0x11B3,), 'D104 -> 1110 1163 11B3';
ok Uni.new(0xD105).NFKD.list ~~ (0x1110, 0x1163, 0x11B4,), 'D105 -> 1110 1163 11B4';
ok Uni.new(0xD106).NFKD.list ~~ (0x1110, 0x1163, 0x11B5,), 'D106 -> 1110 1163 11B5';
ok Uni.new(0xD107).NFKD.list ~~ (0x1110, 0x1163, 0x11B6,), 'D107 -> 1110 1163 11B6';
ok Uni.new(0xD108).NFKD.list ~~ (0x1110, 0x1163, 0x11B7,), 'D108 -> 1110 1163 11B7';
ok Uni.new(0xD109).NFKD.list ~~ (0x1110, 0x1163, 0x11B8,), 'D109 -> 1110 1163 11B8';
ok Uni.new(0xD10A).NFKD.list ~~ (0x1110, 0x1163, 0x11B9,), 'D10A -> 1110 1163 11B9';
ok Uni.new(0xD10B).NFKD.list ~~ (0x1110, 0x1163, 0x11BA,), 'D10B -> 1110 1163 11BA';
ok Uni.new(0xD10C).NFKD.list ~~ (0x1110, 0x1163, 0x11BB,), 'D10C -> 1110 1163 11BB';
ok Uni.new(0xD10D).NFKD.list ~~ (0x1110, 0x1163, 0x11BC,), 'D10D -> 1110 1163 11BC';
ok Uni.new(0xD10E).NFKD.list ~~ (0x1110, 0x1163, 0x11BD,), 'D10E -> 1110 1163 11BD';
ok Uni.new(0xD10F).NFKD.list ~~ (0x1110, 0x1163, 0x11BE,), 'D10F -> 1110 1163 11BE';
ok Uni.new(0xD110).NFKD.list ~~ (0x1110, 0x1163, 0x11BF,), 'D110 -> 1110 1163 11BF';
ok Uni.new(0xD111).NFKD.list ~~ (0x1110, 0x1163, 0x11C0,), 'D111 -> 1110 1163 11C0';
ok Uni.new(0xD112).NFKD.list ~~ (0x1110, 0x1163, 0x11C1,), 'D112 -> 1110 1163 11C1';
ok Uni.new(0xD113).NFKD.list ~~ (0x1110, 0x1163, 0x11C2,), 'D113 -> 1110 1163 11C2';
ok Uni.new(0xD114).NFKD.list ~~ (0x1110, 0x1164,), 'D114 -> 1110 1164';
ok Uni.new(0xD115).NFKD.list ~~ (0x1110, 0x1164, 0x11A8,), 'D115 -> 1110 1164 11A8';
ok Uni.new(0xD116).NFKD.list ~~ (0x1110, 0x1164, 0x11A9,), 'D116 -> 1110 1164 11A9';
ok Uni.new(0xD117).NFKD.list ~~ (0x1110, 0x1164, 0x11AA,), 'D117 -> 1110 1164 11AA';
ok Uni.new(0xD118).NFKD.list ~~ (0x1110, 0x1164, 0x11AB,), 'D118 -> 1110 1164 11AB';
ok Uni.new(0xD119).NFKD.list ~~ (0x1110, 0x1164, 0x11AC,), 'D119 -> 1110 1164 11AC';
ok Uni.new(0xD11A).NFKD.list ~~ (0x1110, 0x1164, 0x11AD,), 'D11A -> 1110 1164 11AD';
ok Uni.new(0xD11B).NFKD.list ~~ (0x1110, 0x1164, 0x11AE,), 'D11B -> 1110 1164 11AE';
ok Uni.new(0xD11C).NFKD.list ~~ (0x1110, 0x1164, 0x11AF,), 'D11C -> 1110 1164 11AF';
ok Uni.new(0xD11D).NFKD.list ~~ (0x1110, 0x1164, 0x11B0,), 'D11D -> 1110 1164 11B0';
ok Uni.new(0xD11E).NFKD.list ~~ (0x1110, 0x1164, 0x11B1,), 'D11E -> 1110 1164 11B1';
ok Uni.new(0xD11F).NFKD.list ~~ (0x1110, 0x1164, 0x11B2,), 'D11F -> 1110 1164 11B2';
ok Uni.new(0xD120).NFKD.list ~~ (0x1110, 0x1164, 0x11B3,), 'D120 -> 1110 1164 11B3';
ok Uni.new(0xD121).NFKD.list ~~ (0x1110, 0x1164, 0x11B4,), 'D121 -> 1110 1164 11B4';
ok Uni.new(0xD122).NFKD.list ~~ (0x1110, 0x1164, 0x11B5,), 'D122 -> 1110 1164 11B5';
ok Uni.new(0xD123).NFKD.list ~~ (0x1110, 0x1164, 0x11B6,), 'D123 -> 1110 1164 11B6';
ok Uni.new(0xD124).NFKD.list ~~ (0x1110, 0x1164, 0x11B7,), 'D124 -> 1110 1164 11B7';
ok Uni.new(0xD125).NFKD.list ~~ (0x1110, 0x1164, 0x11B8,), 'D125 -> 1110 1164 11B8';
ok Uni.new(0xD126).NFKD.list ~~ (0x1110, 0x1164, 0x11B9,), 'D126 -> 1110 1164 11B9';
ok Uni.new(0xD127).NFKD.list ~~ (0x1110, 0x1164, 0x11BA,), 'D127 -> 1110 1164 11BA';
ok Uni.new(0xD128).NFKD.list ~~ (0x1110, 0x1164, 0x11BB,), 'D128 -> 1110 1164 11BB';
ok Uni.new(0xD129).NFKD.list ~~ (0x1110, 0x1164, 0x11BC,), 'D129 -> 1110 1164 11BC';
ok Uni.new(0xD12A).NFKD.list ~~ (0x1110, 0x1164, 0x11BD,), 'D12A -> 1110 1164 11BD';
ok Uni.new(0xD12B).NFKD.list ~~ (0x1110, 0x1164, 0x11BE,), 'D12B -> 1110 1164 11BE';
ok Uni.new(0xD12C).NFKD.list ~~ (0x1110, 0x1164, 0x11BF,), 'D12C -> 1110 1164 11BF';
ok Uni.new(0xD12D).NFKD.list ~~ (0x1110, 0x1164, 0x11C0,), 'D12D -> 1110 1164 11C0';
ok Uni.new(0xD12E).NFKD.list ~~ (0x1110, 0x1164, 0x11C1,), 'D12E -> 1110 1164 11C1';
ok Uni.new(0xD12F).NFKD.list ~~ (0x1110, 0x1164, 0x11C2,), 'D12F -> 1110 1164 11C2';
ok Uni.new(0xD130).NFKD.list ~~ (0x1110, 0x1165,), 'D130 -> 1110 1165';
ok Uni.new(0xD131).NFKD.list ~~ (0x1110, 0x1165, 0x11A8,), 'D131 -> 1110 1165 11A8';
ok Uni.new(0xD132).NFKD.list ~~ (0x1110, 0x1165, 0x11A9,), 'D132 -> 1110 1165 11A9';
ok Uni.new(0xD133).NFKD.list ~~ (0x1110, 0x1165, 0x11AA,), 'D133 -> 1110 1165 11AA';
ok Uni.new(0xD134).NFKD.list ~~ (0x1110, 0x1165, 0x11AB,), 'D134 -> 1110 1165 11AB';
ok Uni.new(0xD135).NFKD.list ~~ (0x1110, 0x1165, 0x11AC,), 'D135 -> 1110 1165 11AC';
ok Uni.new(0xD136).NFKD.list ~~ (0x1110, 0x1165, 0x11AD,), 'D136 -> 1110 1165 11AD';
ok Uni.new(0xD137).NFKD.list ~~ (0x1110, 0x1165, 0x11AE,), 'D137 -> 1110 1165 11AE';
ok Uni.new(0xD138).NFKD.list ~~ (0x1110, 0x1165, 0x11AF,), 'D138 -> 1110 1165 11AF';
ok Uni.new(0xD139).NFKD.list ~~ (0x1110, 0x1165, 0x11B0,), 'D139 -> 1110 1165 11B0';
ok Uni.new(0xD13A).NFKD.list ~~ (0x1110, 0x1165, 0x11B1,), 'D13A -> 1110 1165 11B1';
ok Uni.new(0xD13B).NFKD.list ~~ (0x1110, 0x1165, 0x11B2,), 'D13B -> 1110 1165 11B2';
ok Uni.new(0xD13C).NFKD.list ~~ (0x1110, 0x1165, 0x11B3,), 'D13C -> 1110 1165 11B3';
ok Uni.new(0xD13D).NFKD.list ~~ (0x1110, 0x1165, 0x11B4,), 'D13D -> 1110 1165 11B4';
ok Uni.new(0xD13E).NFKD.list ~~ (0x1110, 0x1165, 0x11B5,), 'D13E -> 1110 1165 11B5';
ok Uni.new(0xD13F).NFKD.list ~~ (0x1110, 0x1165, 0x11B6,), 'D13F -> 1110 1165 11B6';
ok Uni.new(0xD140).NFKD.list ~~ (0x1110, 0x1165, 0x11B7,), 'D140 -> 1110 1165 11B7';
ok Uni.new(0xD141).NFKD.list ~~ (0x1110, 0x1165, 0x11B8,), 'D141 -> 1110 1165 11B8';
ok Uni.new(0xD142).NFKD.list ~~ (0x1110, 0x1165, 0x11B9,), 'D142 -> 1110 1165 11B9';
ok Uni.new(0xD143).NFKD.list ~~ (0x1110, 0x1165, 0x11BA,), 'D143 -> 1110 1165 11BA';
ok Uni.new(0xD144).NFKD.list ~~ (0x1110, 0x1165, 0x11BB,), 'D144 -> 1110 1165 11BB';
ok Uni.new(0xD145).NFKD.list ~~ (0x1110, 0x1165, 0x11BC,), 'D145 -> 1110 1165 11BC';
ok Uni.new(0xD146).NFKD.list ~~ (0x1110, 0x1165, 0x11BD,), 'D146 -> 1110 1165 11BD';
ok Uni.new(0xD147).NFKD.list ~~ (0x1110, 0x1165, 0x11BE,), 'D147 -> 1110 1165 11BE';
ok Uni.new(0xD148).NFKD.list ~~ (0x1110, 0x1165, 0x11BF,), 'D148 -> 1110 1165 11BF';
ok Uni.new(0xD149).NFKD.list ~~ (0x1110, 0x1165, 0x11C0,), 'D149 -> 1110 1165 11C0';
ok Uni.new(0xD14A).NFKD.list ~~ (0x1110, 0x1165, 0x11C1,), 'D14A -> 1110 1165 11C1';
ok Uni.new(0xD14B).NFKD.list ~~ (0x1110, 0x1165, 0x11C2,), 'D14B -> 1110 1165 11C2';
ok Uni.new(0xD14C).NFKD.list ~~ (0x1110, 0x1166,), 'D14C -> 1110 1166';
ok Uni.new(0xD14D).NFKD.list ~~ (0x1110, 0x1166, 0x11A8,), 'D14D -> 1110 1166 11A8';
ok Uni.new(0xD14E).NFKD.list ~~ (0x1110, 0x1166, 0x11A9,), 'D14E -> 1110 1166 11A9';
ok Uni.new(0xD14F).NFKD.list ~~ (0x1110, 0x1166, 0x11AA,), 'D14F -> 1110 1166 11AA';
ok Uni.new(0xD150).NFKD.list ~~ (0x1110, 0x1166, 0x11AB,), 'D150 -> 1110 1166 11AB';
ok Uni.new(0xD151).NFKD.list ~~ (0x1110, 0x1166, 0x11AC,), 'D151 -> 1110 1166 11AC';
ok Uni.new(0xD152).NFKD.list ~~ (0x1110, 0x1166, 0x11AD,), 'D152 -> 1110 1166 11AD';
ok Uni.new(0xD153).NFKD.list ~~ (0x1110, 0x1166, 0x11AE,), 'D153 -> 1110 1166 11AE';
ok Uni.new(0xD154).NFKD.list ~~ (0x1110, 0x1166, 0x11AF,), 'D154 -> 1110 1166 11AF';
ok Uni.new(0xD155).NFKD.list ~~ (0x1110, 0x1166, 0x11B0,), 'D155 -> 1110 1166 11B0';
ok Uni.new(0xD156).NFKD.list ~~ (0x1110, 0x1166, 0x11B1,), 'D156 -> 1110 1166 11B1';
ok Uni.new(0xD157).NFKD.list ~~ (0x1110, 0x1166, 0x11B2,), 'D157 -> 1110 1166 11B2';
ok Uni.new(0xD158).NFKD.list ~~ (0x1110, 0x1166, 0x11B3,), 'D158 -> 1110 1166 11B3';
ok Uni.new(0xD159).NFKD.list ~~ (0x1110, 0x1166, 0x11B4,), 'D159 -> 1110 1166 11B4';
ok Uni.new(0xD15A).NFKD.list ~~ (0x1110, 0x1166, 0x11B5,), 'D15A -> 1110 1166 11B5';
ok Uni.new(0xD15B).NFKD.list ~~ (0x1110, 0x1166, 0x11B6,), 'D15B -> 1110 1166 11B6';
ok Uni.new(0xD15C).NFKD.list ~~ (0x1110, 0x1166, 0x11B7,), 'D15C -> 1110 1166 11B7';
ok Uni.new(0xD15D).NFKD.list ~~ (0x1110, 0x1166, 0x11B8,), 'D15D -> 1110 1166 11B8';
ok Uni.new(0xD15E).NFKD.list ~~ (0x1110, 0x1166, 0x11B9,), 'D15E -> 1110 1166 11B9';
ok Uni.new(0xD15F).NFKD.list ~~ (0x1110, 0x1166, 0x11BA,), 'D15F -> 1110 1166 11BA';
ok Uni.new(0xD160).NFKD.list ~~ (0x1110, 0x1166, 0x11BB,), 'D160 -> 1110 1166 11BB';
ok Uni.new(0xD161).NFKD.list ~~ (0x1110, 0x1166, 0x11BC,), 'D161 -> 1110 1166 11BC';
ok Uni.new(0xD162).NFKD.list ~~ (0x1110, 0x1166, 0x11BD,), 'D162 -> 1110 1166 11BD';
ok Uni.new(0xD163).NFKD.list ~~ (0x1110, 0x1166, 0x11BE,), 'D163 -> 1110 1166 11BE';
ok Uni.new(0xD164).NFKD.list ~~ (0x1110, 0x1166, 0x11BF,), 'D164 -> 1110 1166 11BF';
ok Uni.new(0xD165).NFKD.list ~~ (0x1110, 0x1166, 0x11C0,), 'D165 -> 1110 1166 11C0';
ok Uni.new(0xD166).NFKD.list ~~ (0x1110, 0x1166, 0x11C1,), 'D166 -> 1110 1166 11C1';
ok Uni.new(0xD167).NFKD.list ~~ (0x1110, 0x1166, 0x11C2,), 'D167 -> 1110 1166 11C2';
ok Uni.new(0xD168).NFKD.list ~~ (0x1110, 0x1167,), 'D168 -> 1110 1167';
ok Uni.new(0xD169).NFKD.list ~~ (0x1110, 0x1167, 0x11A8,), 'D169 -> 1110 1167 11A8';
ok Uni.new(0xD16A).NFKD.list ~~ (0x1110, 0x1167, 0x11A9,), 'D16A -> 1110 1167 11A9';
ok Uni.new(0xD16B).NFKD.list ~~ (0x1110, 0x1167, 0x11AA,), 'D16B -> 1110 1167 11AA';
ok Uni.new(0xD16C).NFKD.list ~~ (0x1110, 0x1167, 0x11AB,), 'D16C -> 1110 1167 11AB';
ok Uni.new(0xD16D).NFKD.list ~~ (0x1110, 0x1167, 0x11AC,), 'D16D -> 1110 1167 11AC';
ok Uni.new(0xD16E).NFKD.list ~~ (0x1110, 0x1167, 0x11AD,), 'D16E -> 1110 1167 11AD';
ok Uni.new(0xD16F).NFKD.list ~~ (0x1110, 0x1167, 0x11AE,), 'D16F -> 1110 1167 11AE';
ok Uni.new(0xD170).NFKD.list ~~ (0x1110, 0x1167, 0x11AF,), 'D170 -> 1110 1167 11AF';
ok Uni.new(0xD171).NFKD.list ~~ (0x1110, 0x1167, 0x11B0,), 'D171 -> 1110 1167 11B0';
ok Uni.new(0xD172).NFKD.list ~~ (0x1110, 0x1167, 0x11B1,), 'D172 -> 1110 1167 11B1';
ok Uni.new(0xD173).NFKD.list ~~ (0x1110, 0x1167, 0x11B2,), 'D173 -> 1110 1167 11B2';
ok Uni.new(0xD174).NFKD.list ~~ (0x1110, 0x1167, 0x11B3,), 'D174 -> 1110 1167 11B3';
ok Uni.new(0xD175).NFKD.list ~~ (0x1110, 0x1167, 0x11B4,), 'D175 -> 1110 1167 11B4';
ok Uni.new(0xD176).NFKD.list ~~ (0x1110, 0x1167, 0x11B5,), 'D176 -> 1110 1167 11B5';
ok Uni.new(0xD177).NFKD.list ~~ (0x1110, 0x1167, 0x11B6,), 'D177 -> 1110 1167 11B6';
ok Uni.new(0xD178).NFKD.list ~~ (0x1110, 0x1167, 0x11B7,), 'D178 -> 1110 1167 11B7';
ok Uni.new(0xD179).NFKD.list ~~ (0x1110, 0x1167, 0x11B8,), 'D179 -> 1110 1167 11B8';
ok Uni.new(0xD17A).NFKD.list ~~ (0x1110, 0x1167, 0x11B9,), 'D17A -> 1110 1167 11B9';
ok Uni.new(0xD17B).NFKD.list ~~ (0x1110, 0x1167, 0x11BA,), 'D17B -> 1110 1167 11BA';
ok Uni.new(0xD17C).NFKD.list ~~ (0x1110, 0x1167, 0x11BB,), 'D17C -> 1110 1167 11BB';
ok Uni.new(0xD17D).NFKD.list ~~ (0x1110, 0x1167, 0x11BC,), 'D17D -> 1110 1167 11BC';
ok Uni.new(0xD17E).NFKD.list ~~ (0x1110, 0x1167, 0x11BD,), 'D17E -> 1110 1167 11BD';
ok Uni.new(0xD17F).NFKD.list ~~ (0x1110, 0x1167, 0x11BE,), 'D17F -> 1110 1167 11BE';
ok Uni.new(0xD180).NFKD.list ~~ (0x1110, 0x1167, 0x11BF,), 'D180 -> 1110 1167 11BF';
ok Uni.new(0xD181).NFKD.list ~~ (0x1110, 0x1167, 0x11C0,), 'D181 -> 1110 1167 11C0';
ok Uni.new(0xD182).NFKD.list ~~ (0x1110, 0x1167, 0x11C1,), 'D182 -> 1110 1167 11C1';
ok Uni.new(0xD183).NFKD.list ~~ (0x1110, 0x1167, 0x11C2,), 'D183 -> 1110 1167 11C2';
ok Uni.new(0xD184).NFKD.list ~~ (0x1110, 0x1168,), 'D184 -> 1110 1168';
ok Uni.new(0xD185).NFKD.list ~~ (0x1110, 0x1168, 0x11A8,), 'D185 -> 1110 1168 11A8';
ok Uni.new(0xD186).NFKD.list ~~ (0x1110, 0x1168, 0x11A9,), 'D186 -> 1110 1168 11A9';
ok Uni.new(0xD187).NFKD.list ~~ (0x1110, 0x1168, 0x11AA,), 'D187 -> 1110 1168 11AA';
ok Uni.new(0xD188).NFKD.list ~~ (0x1110, 0x1168, 0x11AB,), 'D188 -> 1110 1168 11AB';
ok Uni.new(0xD189).NFKD.list ~~ (0x1110, 0x1168, 0x11AC,), 'D189 -> 1110 1168 11AC';
ok Uni.new(0xD18A).NFKD.list ~~ (0x1110, 0x1168, 0x11AD,), 'D18A -> 1110 1168 11AD';
ok Uni.new(0xD18B).NFKD.list ~~ (0x1110, 0x1168, 0x11AE,), 'D18B -> 1110 1168 11AE';
ok Uni.new(0xD18C).NFKD.list ~~ (0x1110, 0x1168, 0x11AF,), 'D18C -> 1110 1168 11AF';
ok Uni.new(0xD18D).NFKD.list ~~ (0x1110, 0x1168, 0x11B0,), 'D18D -> 1110 1168 11B0';
ok Uni.new(0xD18E).NFKD.list ~~ (0x1110, 0x1168, 0x11B1,), 'D18E -> 1110 1168 11B1';
ok Uni.new(0xD18F).NFKD.list ~~ (0x1110, 0x1168, 0x11B2,), 'D18F -> 1110 1168 11B2';
ok Uni.new(0xD190).NFKD.list ~~ (0x1110, 0x1168, 0x11B3,), 'D190 -> 1110 1168 11B3';
ok Uni.new(0xD191).NFKD.list ~~ (0x1110, 0x1168, 0x11B4,), 'D191 -> 1110 1168 11B4';
ok Uni.new(0xD192).NFKD.list ~~ (0x1110, 0x1168, 0x11B5,), 'D192 -> 1110 1168 11B5';
ok Uni.new(0xD193).NFKD.list ~~ (0x1110, 0x1168, 0x11B6,), 'D193 -> 1110 1168 11B6';
ok Uni.new(0xD194).NFKD.list ~~ (0x1110, 0x1168, 0x11B7,), 'D194 -> 1110 1168 11B7';
ok Uni.new(0xD195).NFKD.list ~~ (0x1110, 0x1168, 0x11B8,), 'D195 -> 1110 1168 11B8';
ok Uni.new(0xD196).NFKD.list ~~ (0x1110, 0x1168, 0x11B9,), 'D196 -> 1110 1168 11B9';
ok Uni.new(0xD197).NFKD.list ~~ (0x1110, 0x1168, 0x11BA,), 'D197 -> 1110 1168 11BA';
ok Uni.new(0xD198).NFKD.list ~~ (0x1110, 0x1168, 0x11BB,), 'D198 -> 1110 1168 11BB';
ok Uni.new(0xD199).NFKD.list ~~ (0x1110, 0x1168, 0x11BC,), 'D199 -> 1110 1168 11BC';
ok Uni.new(0xD19A).NFKD.list ~~ (0x1110, 0x1168, 0x11BD,), 'D19A -> 1110 1168 11BD';
ok Uni.new(0xD19B).NFKD.list ~~ (0x1110, 0x1168, 0x11BE,), 'D19B -> 1110 1168 11BE';
ok Uni.new(0xD19C).NFKD.list ~~ (0x1110, 0x1168, 0x11BF,), 'D19C -> 1110 1168 11BF';
ok Uni.new(0xD19D).NFKD.list ~~ (0x1110, 0x1168, 0x11C0,), 'D19D -> 1110 1168 11C0';
ok Uni.new(0xD19E).NFKD.list ~~ (0x1110, 0x1168, 0x11C1,), 'D19E -> 1110 1168 11C1';
ok Uni.new(0xD19F).NFKD.list ~~ (0x1110, 0x1168, 0x11C2,), 'D19F -> 1110 1168 11C2';
ok Uni.new(0xD1A0).NFKD.list ~~ (0x1110, 0x1169,), 'D1A0 -> 1110 1169';
