#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "poiseuille.h"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo  omega (argv[1]);
  string sys_coord = omega.coordinate_system_name();
  Float c = omega.xmax()[1];
  space X1h (omega, "P1", "vector");
  space Bh  (omega, "bubble", "vector");
  X1h.block ("wall");
  X1h.block ("upstream");
  X1h[1].block ("axis");
  X1h[1].block ("downstream");
  space Xh = X1h * Bh;
  space Qh  (omega, "P1");
  space Wh  (omega["upstream"], "P1");
  trial u1 (X1h), ub (Bh), p (Qh);
  test  v1 (X1h), vb (Bh), q (Qh);
  form a1 = integrate (2*ddot(D(u1),D(v1)));
  form ab = integrate (2*ddot(D(ub),D(vb)));
  form b1 = integrate (-div(u1)*q);
  form bb = integrate (-div(ub)*q);
  form mp = integrate (p*q);
  form a = {{a1,  0},
            { 0, ab}};
  form b =  {b1, bb};
  field uh (Xh, 0);
  field ph (Qh, 0);
  uh[0][0]["upstream"] = interpolate (Wh, u_poiseuille(c,sys_coord));
  solver_abtb stokes (a.uu(), b.uu(), mp.uu());
  stokes.solve (-(a.ub()*uh.b()), -(b.ub()*uh.b()),
                uh.set_u(),       ph.set_u());
  dout << catchmark("inv_lambda") << 0 << endl
       << catchmark("u")  << uh[0]
       << catchmark("ub") << uh[1]
       << catchmark("p")  << ph;
}
