///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P1d_numbering.h"
namespace rheolef {
using namespace std;

std::string
numbering_P1d::name() const
{
  return "P1d";
}
numbering_P1d::size_type
numbering_P1d::idof (
	const size_type*      mesh_n_geo,
	const size_type*      mesh_n_element,
	const geo_element&    K, 
	size_type             i_dof_local) const
{
  /*
   * WARNING:  mixed mesh with t+q or T+P+H not supported too
   *           or mixtures or e+t, e+t+T etc...
   *           This requires ordered K_idx : all "e" and then all "t",
   *           and then all "q" ... => geo format version 3 ?
   */
  switch (K.variant()) {
    case reference_element::p: return   K.index() + i_dof_local;
    case reference_element::e: return 2*K.index() + i_dof_local;
    case reference_element::t: return 3*K.index() + i_dof_local;
    case reference_element::q: return 4*K.index() + i_dof_local;
    case reference_element::T: return 4*K.index() + i_dof_local;
    case reference_element::P: return 6*K.index() + i_dof_local;
    case reference_element::H: return 8*K.index() + i_dof_local;
    default : {
        error_macro ("unexpected element type `" << K.variant() << "'");
        return 0;
    }
  }
}
void
numbering_P1d::idof (
	const size_type*      mesh_n_geo,
	const size_type*      mesh_n_element,
	const geo_element&    K, 
	vector<size_type>&    i_dof) const
{
  for (size_type i_dof_local = 0; i_dof_local < K.size(); i_dof_local++)
    i_dof[i_dof_local] 
     = numbering_P1d::idof (mesh_n_geo, mesh_n_element, K, i_dof_local);
}
numbering_P1d::size_type
numbering_P1d::ndof (
              size_type  mesh_map_dimension,
        const size_type* mesh_n_geo,
        const size_type* mesh_n_element) const
{
    switch (mesh_map_dimension) {
      case 0: return   mesh_n_element[reference_element::p];
      case 1: return 2*mesh_n_element[reference_element::e];
      case 2: return 3*mesh_n_element[reference_element::t]
                   + 4*mesh_n_element[reference_element::q];
      case 3: return 4*mesh_n_element[reference_element::T]
                   + 6*mesh_n_element[reference_element::P]
                   + 8*mesh_n_element[reference_element::H];
      default : {
        error_macro ("unexpected dimension" << mesh_map_dimension);
        return 0;
      }
    }
}
bool
numbering_P1d::is_continuous () const
{
  	return false;
}

} // namespace rheolef
